/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.valuemgmt;

public class DecimalFormatManager {
    static DecimalFormatManager s_instance = new DecimalFormatManager();

    public static DecimalFormatManager instance() {
        return s_instance;
    }

    public static void initialize(DecimalFormatManager instance) {
        s_instance = instance;
    }

    public String generateRegularExpression(int digitsBefore, int digitsAfter, String thousandsSeparator, String decimalSeparator, boolean withNegativeNumbers) {
        String s = "(@@negativeNumbers@@([0-9]{1}[@@thousandsSeparator@@]*){1,@@digitsBefore@@}){1}";
        if (digitsAfter > 0) {
            s = s + "([@@decimalSeparator@@]{1}[0-9]{0,@@digitsAfter@@}){0,1}";
        }
        s = s.replace("@@digitsAfter@@", "" + digitsAfter);
        s = s.replace("@@digitsBefore@@", "" + digitsBefore);
        if (thousandsSeparator != null) {
            s = s.replace("@@thousandsSeparator@@", thousandsSeparator);
        }
        if (decimalSeparator != null) {
            s = s.replace("@@decimalSeparator@@", decimalSeparator);
        }
        s = withNegativeNumbers ? s.replace("@@negativeNumbers@@", "[-]{0,1}") : s.replace("@@negativeNumbers@@", "");
        return s;
    }
}

