/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.valuemgmt;

import java.io.StringWriter;
import java.util.HashMap;

public class HtmlStringDecoder {
    private static final String[][] ESCAPES = new String[][]{{"\"", "quot"}, {"&", "amp"}, {"<", "lt"}, {">", "gt"}, {"\u00a0", "nbsp"}, {"\u00a1", "iexcl"}, {"\u00a2", "cent"}, {"\u00a3", "pound"}, {"\u00a4", "curren"}, {"\u00a5", "yen"}, {"\u00a6", "brvbar"}, {"\u00a7", "sect"}, {"\u00a8", "uml"}, {"\u00a9", "copy"}, {"\u00aa", "ordf"}, {"\u00ab", "laquo"}, {"\u00ac", "not"}, {"\u00ad", "shy"}, {"\u00ae", "reg"}, {"\u00af", "macr"}, {"\u00b0", "deg"}, {"\u00b1", "plusmn"}, {"\u00b2", "sup2"}, {"\u00b3", "sup3"}, {"\u00b4", "acute"}, {"\u00b5", "micro"}, {"\u00b6", "para"}, {"\u00b7", "middot"}, {"\u00b8", "cedil"}, {"\u00b9", "sup1"}, {"\u00ba", "ordm"}, {"\u00bb", "raquo"}, {"\u00bc", "frac14"}, {"\u00bd", "frac12"}, {"\u00be", "frac34"}, {"\u00bf", "iquest"}, {"\u00c0", "Agrave"}, {"\u00c1", "Aacute"}, {"\u00c2", "Acirc"}, {"\u00c3", "Atilde"}, {"\u00c4", "Auml"}, {"\u00c5", "Aring"}, {"\u00c6", "AElig"}, {"\u00c7", "Ccedil"}, {"\u00c8", "Egrave"}, {"\u00c9", "Eacute"}, {"\u00ca", "Ecirc"}, {"\u00cb", "Euml"}, {"\u00cc", "Igrave"}, {"\u00cd", "Iacute"}, {"\u00ce", "Icirc"}, {"\u00cf", "Iuml"}, {"\u00d0", "ETH"}, {"\u00d1", "Ntilde"}, {"\u00d2", "Ograve"}, {"\u00d3", "Oacute"}, {"\u00d4", "Ocirc"}, {"\u00d5", "Otilde"}, {"\u00d6", "Ouml"}, {"\u00d7", "times"}, {"\u00d8", "Oslash"}, {"\u00d9", "Ugrave"}, {"\u00da", "Uacute"}, {"\u00db", "Ucirc"}, {"\u00dc", "Uuml"}, {"\u00dd", "Yacute"}, {"\u00de", "THORN"}, {"\u00df", "szlig"}, {"\u00e0", "agrave"}, {"\u00e1", "aacute"}, {"\u00e2", "acirc"}, {"\u00e3", "atilde"}, {"\u00e4", "auml"}, {"\u00e5", "aring"}, {"\u00e6", "aelig"}, {"\u00e7", "ccedil"}, {"\u00e8", "egrave"}, {"\u00e9", "eacute"}, {"\u00ea", "ecirc"}, {"\u00eb", "euml"}, {"\u00ec", "igrave"}, {"\u00ed", "iacute"}, {"\u00ee", "icirc"}, {"\u00ef", "iuml"}, {"\u00f0", "eth"}, {"\u00f1", "ntilde"}, {"\u00f2", "ograve"}, {"\u00f3", "oacute"}, {"\u00f4", "ocirc"}, {"\u00f5", "otilde"}, {"\u00f6", "ouml"}, {"\u00f7", "divide"}, {"\u00f8", "oslash"}, {"\u00f9", "ugrave"}, {"\u00fa", "uacute"}, {"\u00fb", "ucirc"}, {"\u00fc", "uuml"}, {"\u00fd", "yacute"}, {"\u00fe", "thorn"}, {"\u00ff", "yuml"}};
    private static final int MIN_ESCAPE = 2;
    private static final int MAX_ESCAPE = 6;
    private static final HashMap<String, CharSequence> lookupMap = new HashMap();

    public static final String decode(String input) {
        if (input == null) {
            return null;
        }
        StringWriter writer = null;
        int len = input.length();
        int i = 1;
        int st = 0;
        while (true) {
            int j;
            block15: {
                if (i < len && input.charAt(i - 1) != '&') {
                    ++i;
                    continue;
                }
                if (i >= len) break;
                for (j = i; j < len && j < i + 6 + 1 && input.charAt(j) != ';'; ++j) {
                }
                if (j == len || j < i + 2 || j == i + 6 + 1) {
                    ++i;
                    continue;
                }
                if (input.charAt(i) == '#') {
                    int k = i + 1;
                    int radix = 10;
                    char firstChar = input.charAt(k);
                    if (firstChar == 'x' || firstChar == 'X') {
                        ++k;
                        radix = 16;
                    }
                    try {
                        int entityValue = Integer.parseInt(input.substring(k, j), radix);
                        if (writer == null) {
                            writer = new StringWriter(input.length());
                        }
                        writer.append(input.substring(st, i - 1));
                        if (entityValue > 65535) {
                            char[] chrs = Character.toChars(entityValue);
                            writer.write(chrs[0]);
                            writer.write(chrs[1]);
                        } else {
                            writer.write(entityValue);
                        }
                        break block15;
                    }
                    catch (NumberFormatException ex) {
                        ++i;
                        continue;
                    }
                }
                CharSequence value = lookupMap.get(input.substring(i, j));
                if (value == null) {
                    ++i;
                    continue;
                }
                if (writer == null) {
                    writer = new StringWriter(input.length());
                }
                writer.append(input.substring(st, i - 1));
                writer.append(value);
            }
            i = st = j + 1;
        }
        if (writer != null) {
            writer.append(input.substring(st, len));
            return writer.toString();
        }
        return input;
    }

    static {
        for (String[] seq : ESCAPES) {
            lookupMap.put(seq[1].toString(), seq[0]);
        }
    }
}

