/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.valuemgmt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclnt.jsfserver.util.BeanIntrospector;
import org.eclnt.util.log.ULog;
import org.eclnt.util.valuemgmt.ValueManager;

public class PojoManager {
    public static String calculateHashForPojo(Object bean) {
        return PojoManager.calculateHashForPojo(bean, true);
    }

    public static String calculateHashForPojo(Object bean, boolean withDrillDown) {
        try {
            if (bean == null) {
                return "" + Objects.hashCode(null);
            }
            if (ValueManager.checkIfSimpleDataType(bean.getClass())) {
                return "" + bean.hashCode();
            }
            List<BeanIntrospector.PropertyIntrospectionInfo> piis = BeanIntrospector.readPropertiesAsList(bean.getClass());
            ArrayList<Object> values = new ArrayList<Object>();
            for (BeanIntrospector.PropertyIntrospectionInfo pii : piis) {
                Object value;
                if (pii.getGetter() == null) continue;
                Class<?> returnType = pii.getGetter().getReturnType();
                if (ValueManager.checkIfSimpleDataType(returnType)) {
                    if (!returnType.isArray()) {
                        value = pii.getGetter().invoke(bean, new Object[0]);
                        values.add(value);
                        continue;
                    }
                    if (returnType.isArray() && returnType.getComponentType() == Byte.TYPE) {
                        value = pii.getGetter().invoke(bean, new Object[0]);
                        if (value != null) {
                            value = Arrays.hashCode((byte[])value);
                        }
                        values.add(value);
                        continue;
                    }
                    throw new Error("Should never happen");
                }
                if (!withDrillDown) continue;
                value = pii.getGetter().invoke(bean, new Object[0]);
                if (value == null) {
                    values.add("" + Objects.hashCode(null));
                    continue;
                }
                if (value instanceof List) {
                    String hashList = PojoManager.calculateHashForListOfPojos((List)value);
                    values.add(hashList);
                    continue;
                }
                String hashBean = PojoManager.calculateHashForPojo(value, true);
                values.add(hashBean);
            }
            Object[] valuesArray = values.toArray();
            return "" + Objects.hash(valuesArray);
        }
        catch (Throwable t) {
            throw new Error("Problem calculating hashcode for instance: " + bean.getClass().getName(), t);
        }
    }

    public static String calculateHashForListOfPojos(List<?> beanList) {
        if (beanList == null) {
            return "" + Objects.hashCode(null);
        }
        StringBuffer sb = new StringBuffer();
        for (Object bean : beanList) {
            if (bean != null && ValueManager.checkIfSimpleDataType(bean.getClass())) {
                sb.append("/" + bean.hashCode());
                continue;
            }
            String hashBean = PojoManager.calculateHashForPojo(bean, true);
            sb.append("/" + hashBean);
        }
        String s = sb.toString();
        return "" + s.hashCode();
    }

    public static Map<String, Object> transferPojoIntoMap(Object bean) {
        try {
            if (bean == null) {
                return null;
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            List<BeanIntrospector.PropertyIntrospectionInfo> piis = BeanIntrospector.readPropertiesAsList(bean.getClass());
            ArrayList values = new ArrayList();
            for (BeanIntrospector.PropertyIntrospectionInfo pii : piis) {
                Class<?> returnType;
                if (pii.getGetter() == null || !ValueManager.checkIfSimpleDataType(returnType = pii.getGetter().getReturnType())) continue;
                Object value = pii.getGetter().invoke(bean, new Object[0]);
                result.put(pii.getPropertyName(), value);
            }
            return result;
        }
        catch (Throwable t) {
            throw new Error("Problem building map for instance: " + bean.getClass().getName(), t);
        }
    }

    public static void transferPojoIntoPojo(Object fromBean, Object bean, boolean withError) {
        PojoManager.transferPojoIntoPojo(fromBean, bean, false, false, withError);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void transferPojoIntoPojo(Object fromBean, Object bean, boolean simpleDataTypesOnly, boolean notNullOnly, boolean withError) {
        if (fromBean == null) {
            return;
        }
        if (bean == null) {
            return;
        }
        try {
            Map<String, BeanIntrospector.PropertyIntrospectionInfo> fromPiis = BeanIntrospector.readProperties(fromBean.getClass());
            for (BeanIntrospector.PropertyIntrospectionInfo pii : fromPiis.values()) {
                BeanIntrospector.PropertyIntrospectionInfo beanPii;
                if (pii.getGetter() == null || simpleDataTypesOnly && !ValueManager.checkIfSimpleDataType(pii.getGetter().getReturnType())) continue;
                Object value = pii.getGetter().invoke(fromBean, new Object[0]);
                if (notNullOnly && value == null || (beanPii = BeanIntrospector.readProperty(bean.getClass(), pii.getPropertyName())) == null || beanPii.getSetter() == null) continue;
                Class<?> clGetter = pii.getGetter().getReturnType();
                Class<?> clSetter = beanPii.getSetter().getParameterTypes()[0];
                if (!clSetter.isAssignableFrom(clGetter)) continue;
                try {
                    beanPii.getSetter().invoke(bean, value);
                }
                catch (Throwable t) {
                    ULog.logINF("Problem transferring fromBean into bean object, " + pii.getPropertyName(), t);
                    if (!withError) continue;
                    throw new Error("Problem transferring fromBean into bean object, " + pii.getPropertyName(), t);
                    return;
                }
            }
        }
        catch (Throwable t) {
            if (!withError) return;
            throw new Error("Problem transferring Pojo: " + fromBean.getClass().getName() + ", " + bean.getClass().getName());
        }
    }

    public static <OBJTYPE> OBJTYPE createPojoFromMapData(Class<OBJTYPE> clazz, Map<String, ?> map, boolean withError) {
        try {
            OBJTYPE bean = clazz.newInstance();
            PojoManager.transferObjectMapDataIntoPojo(map, bean, withError);
            return bean;
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Problem in createPojoFromStringMapData: " + clazz.getName(), t);
            }
            return null;
        }
    }

    public static void transferObjectMapDataIntoPojo(Map<String, ?> map, Object bean, boolean withError) {
        if (map == null) {
            return;
        }
        if (bean == null) {
            return;
        }
        Class<?> cl = bean.getClass();
        for (String key : map.keySet()) {
            try {
                Object value = map.get(key);
                BeanIntrospector.PropertyIntrospectionInfo pii = BeanIntrospector.readProperty(cl, key);
                if (pii == null) {
                    if (!withError) continue;
                    throw new Exception("Property not available: " + key + ", " + bean.getClass().getName());
                }
                pii.getSetter().invoke(bean, value);
            }
            catch (Throwable t) {
                if (!withError) continue;
                throw new Error("Problem setting value in bean object: " + key, t);
            }
        }
    }

    public static <OBJTYPE> OBJTYPE createPojoFromStringMapData(Class<OBJTYPE> clazz, Map<String, String> map, boolean withError) {
        try {
            OBJTYPE bean = clazz.newInstance();
            PojoManager.transferStringMapDataIntoPojo(map, bean, withError);
            return bean;
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Problem in createPojoFromStringMapData: " + clazz.getName(), t);
            }
            return null;
        }
    }

    public static void transferStringMapDataIntoPojo(Map<String, String> map, Object bean, boolean withError) {
        PojoManager.transferStringMapDataIntoPojo(map, bean, false, withError);
    }

    public static void transferStringMapDataIntoPojoChangesOnly(Map<String, String> map, Object bean, boolean withError) {
        PojoManager.transferStringMapDataIntoPojo(map, bean, true, withError);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void transferPojoIntoPojo(Object fromBean, Object bean, boolean simpleDataTypesOnly, ICheckIfToTransferPropertyValue checker, boolean withError) {
        if (fromBean == null) {
            return;
        }
        if (bean == null) {
            return;
        }
        try {
            Map<String, BeanIntrospector.PropertyIntrospectionInfo> fromPiis = BeanIntrospector.readProperties(fromBean.getClass());
            for (BeanIntrospector.PropertyIntrospectionInfo pii : fromPiis.values()) {
                if (pii.getGetter() == null || simpleDataTypesOnly && !ValueManager.checkIfSimpleDataType(pii.getGetter().getReturnType())) continue;
                Object value = pii.getGetter().invoke(fromBean, new Object[0]);
                BeanIntrospector.PropertyIntrospectionInfo beanPii = BeanIntrospector.readProperty(bean.getClass(), pii.getPropertyName());
                if (beanPii == null || beanPii.getGetter() == null || beanPii.getSetter() == null) continue;
                Class<?> clGetter = pii.getGetter().getReturnType();
                Class<?> clSetter = beanPii.getSetter().getParameterTypes()[0];
                if (!clSetter.isAssignableFrom(clGetter)) continue;
                try {
                    Object beanValue = beanPii.getGetter().invoke(bean, new Object[0]);
                    if (!checker.check(fromBean, bean, pii.getPropertyName(), value, beanValue)) continue;
                    beanPii.getSetter().invoke(bean, value);
                }
                catch (Throwable t) {
                    ULog.logINF("Problem transferring fromBean into bean object, " + pii.getPropertyName(), t);
                    if (!withError) continue;
                    throw new Error("Problem transferring fromBean into bean object, " + pii.getPropertyName(), t);
                    return;
                }
            }
        }
        catch (Throwable t) {
            if (!withError) return;
            throw new Error("Problem transferring Pojo: " + fromBean.getClass() + ", " + bean.getClass(), t);
        }
    }

    public static void setPropertyValue(Object bean, String propertyName, Object value) {
        PojoManager.setPropertyValue(bean, propertyName, value, true);
    }

    public static void setPropertyValue(Object bean, String propertyName, Object value, boolean withError) {
        block3: {
            try {
                if (bean == null) {
                    return;
                }
                BeanIntrospector.PropertyIntrospectionInfo pii = BeanIntrospector.readProperty(bean.getClass(), propertyName);
                pii.getSetter().invoke(bean, value);
            }
            catch (Throwable t) {
                if (!withError) break block3;
                throw new Error("Problem setting: " + bean.getClass().getName() + ", " + propertyName + ", " + value, t);
            }
        }
    }

    public static Object getPropertyValue(Object bean, String propertyName) {
        return PojoManager.getPropertyValue(bean, propertyName, true);
    }

    public static Object getPropertyValue(Object bean, String propertyName, boolean withError) {
        try {
            if (bean == null) {
                return null;
            }
            BeanIntrospector.PropertyIntrospectionInfo pii = BeanIntrospector.readProperty(bean.getClass(), propertyName);
            return pii.getGetter().invoke(bean, new Object[0]);
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Problem getting bean value: " + bean.getClass().getName() + ", " + propertyName, t);
            }
            return null;
        }
    }

    public static List<PojoPropertyChangeInfo> comparePojosOfSameClass(Object fromBean, Object toBean) {
        if (fromBean == null) {
            throw new Error("fromBean is null");
        }
        if (toBean == null) {
            throw new Error("toBean is null");
        }
        if (fromBean.getClass() != toBean.getClass()) {
            throw new Error("Objects for comparison need to be of same class: " + fromBean.getClass() + ", " + toBean.getClass());
        }
        ArrayList<PojoPropertyChangeInfo> result = new ArrayList<PojoPropertyChangeInfo>();
        if (fromBean != toBean) {
            try {
                Map<String, BeanIntrospector.PropertyIntrospectionInfo> fromPiis = BeanIntrospector.readProperties(fromBean.getClass());
                for (BeanIntrospector.PropertyIntrospectionInfo pii : fromPiis.values()) {
                    if (pii.getGetter() == null || !ValueManager.checkIfSimpleDataType(pii.getGetter().getReturnType())) continue;
                    Object valueFrom = pii.getGetter().invoke(fromBean, new Object[0]);
                    Object valueTo = pii.getGetter().invoke(toBean, new Object[0]);
                    if (!(valueFrom == null && valueTo != null || valueFrom != null && valueTo == null) && (valueFrom == null || valueTo == null || valueFrom.equals(valueTo))) continue;
                    result.add(new PojoPropertyChangeInfo(pii.getPropertyName(), valueFrom, valueTo));
                }
            }
            catch (Throwable t) {
                throw new Error("Problem comparing Pojos: " + fromBean.getClass(), t);
            }
        }
        return result;
    }

    public static void sortPojoList(List l, String[] propertyNames, final boolean[] ascendings) {
        try {
            if (l == null || l.size() == 0) {
                return;
            }
            if (propertyNames == null || propertyNames.length == 0) {
                throw new Exception("Parameter propertyNames not defined - must be not null and contain at least on item");
            }
            if (propertyNames.length != ascendings.length) {
                throw new Exception("Parameters wrong: propertyNames must have same array size than ascendings-size");
            }
            final BeanIntrospector.PropertyIntrospectionInfo[] piis = new BeanIntrospector.PropertyIntrospectionInfo[propertyNames.length];
            int counter = 0;
            for (String propertyName : propertyNames) {
                piis[counter] = BeanIntrospector.readProperty(l.get(0).getClass(), propertyName);
                ++counter;
            }
            Collections.sort(l, new Comparator(){

                public int compare(Object o1, Object o2) {
                    try {
                        int counter = -1;
                        for (BeanIntrospector.PropertyIntrospectionInfo pii : piis) {
                            ++counter;
                            Object v1 = pii.getGetter().invoke(o1, new Object[0]);
                            Object v2 = pii.getGetter().invoke(o2, new Object[0]);
                            v1 = PojoManager.convertNullValueForSorting(pii, v1);
                            v2 = PojoManager.convertNullValueForSorting(pii, v2);
                            if (v1 == null && v2 == null) continue;
                            if (v1 == null) {
                                return ascendings[counter] ? 1 : -1;
                            }
                            if (v2 == null) {
                                return ascendings[counter] ? -1 : 1;
                            }
                            int result = ((Comparable)v1).compareTo(v2);
                            if (result == 0) continue;
                            return ascendings[counter] ? result : -1 * result;
                        }
                        return 0;
                    }
                    catch (Throwable t) {
                        throw new Error("Problem when comparing objects", t);
                    }
                }
            });
        }
        catch (Throwable t) {
            throw new Error("Problem sorting pojo-list", t);
        }
    }

    protected static Object convertNullValueForSorting(BeanIntrospector.PropertyIntrospectionInfo pii, Object v) {
        if (v != null) {
            return v;
        }
        if (pii.getGetter().getReturnType() == Boolean.class) {
            return false;
        }
        return null;
    }

    private static void transferStringMapDataIntoPojo(Map<String, String> map, Object bean, boolean changesOnly, boolean withError) {
        if (map == null) {
            return;
        }
        if (bean == null) {
            return;
        }
        Class<?> cl = bean.getClass();
        for (String key : map.keySet()) {
            try {
                Object existingValue;
                String value = map.get(key);
                BeanIntrospector.PropertyIntrospectionInfo pii = BeanIntrospector.readProperty(cl, key);
                Object valueObj = null;
                if (value != null) {
                    valueObj = ValueManager.convertStringIntoObject(value, pii.getSetter().getParameterTypes()[0]);
                }
                if (changesOnly && ValueManager.checkIfObjectsAreEqual(valueObj, existingValue = pii.getGetter().invoke(bean, new Object[0]))) continue;
                pii.getSetter().invoke(bean, valueObj);
            }
            catch (Throwable t) {
                if (!withError) continue;
                throw new Error("Problem setting value in bean object: " + key, t);
            }
        }
    }

    public static interface ICheckIfToTransferPropertyValue {
        public boolean check(Object var1, Object var2, String var3, Object var4, Object var5);
    }

    public static class PojoPropertyChangeInfo {
        String i_property;
        Object i_fromValue;
        Object i_toValue;

        public PojoPropertyChangeInfo(String property, Object fromValue, Object toValue) {
            this.i_property = property;
            this.i_fromValue = fromValue;
            this.i_toValue = toValue;
        }

        public String getProperty() {
            return this.i_property;
        }

        public Object getFromValue() {
            return this.i_fromValue;
        }

        public Object getToValue() {
            return this.i_toValue;
        }

        public String toString() {
            return this.i_property + "/" + this.i_fromValue + "/" + this.i_toValue;
        }
    }
}

