/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Hashtable;
import java.util.Map;
import org.eclnt.jsfserver.elements.polling.UNIFIEDPOLLINGBinding;
import org.eclnt.jsfserver.elements.util.Trigger;
import org.eclnt.jsfserver.messages.CrossDialogMessage;
import org.eclnt.jsfserver.messages.DialogMessageBus;
import org.eclnt.jsfserver.messages.IDialogMessageBusListener;
import org.eclnt.util.valuemgmt.JAXBManager;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.IMultiWorkplaceListener;
import org.eclnt.workplace.IWorkpage;
import org.eclnt.workplace.IWorkpageContainer;
import org.eclnt.workplace.IWorkpageDispatcher;
import org.eclnt.workplace.MultiWorkplaceConnector;
import org.eclnt.workplace.WorkpageStartInfo;
import org.eclnt.workplace.WorkpageStarterFactory;
import org.eclnt.workplace.eximport.WorkpageStartInfoExtensionAdapter;
import org.eclnt.workplace.eximport.WorkplacePageBeanStateExtractor;

public class WorkpageContainerMultiWorkplaceManager {
    static final String DRAGDROP_TYPE_WORKPAGE = "cchtml5_workpage";
    boolean m_active = false;
    IWorkpageDispatcher m_owningDispatcher;
    IWorkpageContainer m_owningWorkpageContainer;
    UNIFIEDPOLLINGBinding m_polling;
    MyMultiWorkplaceListener m_listener = new MyMultiWorkplaceListener();
    String m_name = null;
    String m_startURL;
    Trigger m_startURLTrigger = new Trigger();
    String m_startURLFeatures;
    Map<String, IWorkpageDispatcher> m_connectedWorkplaces = new Hashtable<String, IWorkpageDispatcher>();

    public WorkpageContainerMultiWorkplaceManager(IWorkpageDispatcher owningDispatcher) {
        this.m_owningDispatcher = owningDispatcher;
        this.m_owningWorkpageContainer = owningDispatcher.getWorkpageContainer();
        DialogMessageBus.instance().addListener(new IDialogMessageBusListener(){

            @Override
            public boolean checkIfMessageIsRelevant(Object o) {
                return WorkpageContainerMultiWorkplaceManager.this.checkRelevantOfDialogMessage(o);
            }

            @Override
            public void reactOnMessage(Object message) {
                WorkpageContainerMultiWorkplaceManager.this.processDialogMessage(message);
            }
        });
    }

    public boolean getActive() {
        return this.m_active;
    }

    public void activate() {
        this.m_active = true;
    }

    public void deactivate() {
        if (!this.m_active) {
            return;
        }
        this.m_active = false;
        if (this.m_polling != null) {
            this.m_polling.close();
            this.m_polling = null;
        }
    }

    public String getStartURL() {
        return this.m_startURL;
    }

    public Trigger getStartURLTrigger() {
        return this.m_startURLTrigger;
    }

    public String getStartURLFeatures() {
        return this.m_startURLFeatures;
    }

    public void startURL(String url, String features) {
        this.m_startURL = url;
        this.m_startURLFeatures = features;
        this.m_startURLTrigger.trigger();
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public UNIFIEDPOLLINGBinding getPolling() {
        if (!this.m_active) {
            return null;
        }
        if (this.m_polling == null) {
            this.m_polling = new UNIFIEDPOLLINGBinding();
        }
        return this.m_polling;
    }

    public Map<String, IWorkpageDispatcher> getConnectedWorkplaces() {
        return this.m_connectedWorkplaces;
    }

    public IWorkpageDispatcher getConnectedWorkplace(String workplaceName) {
        return this.m_connectedWorkplaces.get(workplaceName);
    }

    void addConnectedWorkplace(IWorkpageDispatcher dependentDispatcher, String workplaceName) {
        this.m_connectedWorkplaces.put(workplaceName, dependentDispatcher);
    }

    void removeConnectedWorkplace(String workplaceName) {
        this.m_connectedWorkplaces.remove(workplaceName);
    }

    void removeConnectedWorkplace(IWorkpageDispatcher dependentDispatcher) {
        for (String key : this.m_connectedWorkplaces.keySet()) {
            IWorkpageDispatcher workplace = this.m_connectedWorkplaces.get(key);
            if (workplace != dependentDispatcher) continue;
            this.m_connectedWorkplaces.remove(key);
            break;
        }
    }

    void destroy() {
        if (this.m_polling != null) {
            this.m_polling.close();
            this.m_polling = null;
            this.m_connectedWorkplaces = null;
        }
    }

    private boolean checkRelevantOfDialogMessage(Object message) {
        if (CrossDialogMessage.checkIfMessageMatches(message, "CCSTARTWORKPAGE")) {
            CrossDialogMessage cdm = (CrossDialogMessage)message;
            MultiWorkplaceConnector.MessageContentStartWorkpageInWorkplace m = MultiWorkplaceConnector.MessageContentStartWorkpageInWorkplace.fromXML(cdm.getMessageContent());
            if (ValueManager.checkIfStringsAreEqual(m.getTargetWorkplaceName(), this.m_name)) {
                return true;
            }
        } else if (CrossDialogMessage.checkIfMessageMatches(message, MessageRequestWorkpage.class.getName())) {
            CrossDialogMessage cdm = (CrossDialogMessage)message;
            MessageRequestWorkpage m = (MessageRequestWorkpage)JAXBManager.unmarshal(cdm.getMessageContent(), MessageRequestWorkpage.class);
            IWorkpage wp = this.m_owningWorkpageContainer.getWorkpageForUniqueTechnicalId(m.workpageTechnicalUniqueId);
            if (wp != null) {
                return true;
            }
        } else if (CrossDialogMessage.checkIfMessageMatches(message, MessageOpenWorkpage.class.getName())) {
            CrossDialogMessage cdm = (CrossDialogMessage)message;
            MessageOpenWorkpage m = (MessageOpenWorkpage)JAXBManager.unmarshal(cdm.getMessageContent(), MessageOpenWorkpage.class);
            if (ValueManager.checkIfStringsAreEqual(m.workpageContainerUniqueId, this.m_owningWorkpageContainer.getUniqueId())) {
                return true;
            }
        }
        return false;
    }

    private void processDialogMessage(Object message) {
        if (CrossDialogMessage.checkIfMessageMatches(message, "CCSTARTWORKPAGE")) {
            CrossDialogMessage cdm = (CrossDialogMessage)message;
            MultiWorkplaceConnector.MessageContentStartWorkpageInWorkplace m = MultiWorkplaceConnector.MessageContentStartWorkpageInWorkplace.fromXML(cdm.getMessageContent());
            if (ValueManager.checkIfStringsAreEqual(m.getTargetWorkplaceName(), this.m_name)) {
                WorkpageStartInfo wpsi = WorkpageStartInfoExtensionAdapter.instance().transferDefaultIntoExtension(m.getWpsi());
                this.startWorkpage(wpsi);
            }
        } else if (CrossDialogMessage.checkIfMessageMatches(message, MessageRequestWorkpage.class.getName())) {
            CrossDialogMessage cdm = (CrossDialogMessage)message;
            MessageRequestWorkpage m = (MessageRequestWorkpage)JAXBManager.unmarshal(cdm.getMessageContent(), MessageRequestWorkpage.class);
            IWorkpage wp = this.m_owningWorkpageContainer.getWorkpageForUniqueTechnicalId(m.workpageTechnicalUniqueId);
            if (wp != null) {
                this.transferWorkpageToOtherWorkplace(wp, m.workpageContainerUniqueId);
            }
        } else if (CrossDialogMessage.checkIfMessageMatches(message, MessageOpenWorkpage.class.getName())) {
            CrossDialogMessage cdm = (CrossDialogMessage)message;
            MessageOpenWorkpage m = (MessageOpenWorkpage)JAXBManager.unmarshal(cdm.getMessageContent(), MessageOpenWorkpage.class);
            if (ValueManager.checkIfStringsAreEqual(m.workpageContainerUniqueId, this.m_owningWorkpageContainer.getUniqueId())) {
                WorkpageStartInfo wpsi = WorkpageStartInfoExtensionAdapter.instance().transferDefaultIntoExtension(m.wpsi);
                WorkpageStarterFactory.getWorkpageStarter().startWorkpage(this.m_owningDispatcher, this.m_owningWorkpageContainer, wpsi);
            }
        }
    }

    private void transferWorkpageToOtherWorkplace(IWorkpage wp, String workpageContainerUniqueId) {
        WorkpageStartInfo wpsi = WorkplacePageBeanStateExtractor.instance().extractWorkpageStartInfo(wp);
        MessageOpenWorkpage m = new MessageOpenWorkpage(workpageContainerUniqueId, wpsi);
        CrossDialogMessage cdm = new CrossDialogMessage(m.getClass().getName(), JAXBManager.marshal(m));
        DialogMessageBus.instance().publishMessageToAllClientDialogs(cdm);
        this.m_owningWorkpageContainer.closeWorkpage(wp);
    }

    private void startWorkpage(WorkpageStartInfo wpsi) {
        WorkpageStarterFactory.getWorkpageStarter().startWorkpage(this.m_owningDispatcher, this.m_owningDispatcher.getWorkpageContainer(), wpsi);
    }

    public void processWorkpageDragDrop(String dragInfo) {
        if (dragInfo.startsWith(DRAGDROP_TYPE_WORKPAGE)) {
            String workpageUniqueTechnicalId = dragInfo.substring(DRAGDROP_TYPE_WORKPAGE.length() + 1);
            IWorkpage wp = this.m_owningDispatcher.getWorkpageContainer().getWorkpageForUniqueTechnicalId(workpageUniqueTechnicalId);
            if (wp == null) {
                MessageRequestWorkpage m = new MessageRequestWorkpage(this.m_owningDispatcher.getWorkpageContainer().getUniqueId(), workpageUniqueTechnicalId);
                CrossDialogMessage cdm = new CrossDialogMessage(m.getClass().getName(), JAXBManager.marshal(m));
                DialogMessageBus.instance().publishMessageToAllClientDialogs(cdm);
            }
        }
    }

    public class MyMultiWorkplaceListener
    implements IMultiWorkplaceListener {
        @Override
        public void reactOnRefreshRequired(IWorkpageDispatcher wpc) {
            if (WorkpageContainerMultiWorkplaceManager.this.m_polling != null) {
                WorkpageContainerMultiWorkplaceManager.this.m_polling.wakeup(true);
            }
        }
    }

    @XmlRootElement
    public static class MessageRequestWorkpage {
        @XmlAttribute
        public String workpageContainerUniqueId;
        @XmlAttribute
        public String workpageTechnicalUniqueId;

        public MessageRequestWorkpage() {
        }

        public MessageRequestWorkpage(String workpageContainerUniqueId, String workpageTechnicalUniqueId) {
            this.workpageContainerUniqueId = workpageContainerUniqueId;
            this.workpageTechnicalUniqueId = workpageTechnicalUniqueId;
        }
    }

    @XmlRootElement
    public static class MessageOpenWorkpage {
        @XmlAttribute
        public String workpageContainerUniqueId;
        @XmlElement
        public WorkpageStartInfo wpsi;

        public MessageOpenWorkpage() {
        }

        public MessageOpenWorkpage(String workpageContainerUniqueId, WorkpageStartInfo wpsi) {
            this.workpageContainerUniqueId = workpageContainerUniqueId;
            this.wpsi = wpsi;
        }
    }
}

