/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import org.eclnt.jsfserver.configuration.CCConfigurationObjectLoader;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;
import org.eclnt.workplace.IWorkpageStarter;
import org.eclnt.workplace.WorkpageDefaultStarter;

public class WorkpageStarterFactory {
    static IWorkpageStarter s_wps = null;
    static boolean s_wpsIsExplicitlySet = false;
    static ClassLoader s_wpsClassLoader = null;
    static final Object SYNCHER = new Object();

    public static void setWorkpageStarter(IWorkpageStarter wps) {
        s_wps = wps;
        s_wpsIsExplicitlySet = s_wps != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IWorkpageStarter getWorkpageStarter() {
        if (s_wpsIsExplicitlySet) {
            return s_wps;
        }
        ClassLoader classLoader = HotDeployManager.currentClassLoader();
        if (classLoader != s_wpsClassLoader) {
            s_wpsClassLoader = classLoader;
            s_wps = null;
        }
        if (s_wps == null) {
            Object object = SYNCHER;
            synchronized (object) {
                if (s_wps == null) {
                    s_wps = WorkpageStarterFactory.createStarter();
                }
            }
        }
        return s_wps;
    }

    private static IWorkpageStarter createStarter() {
        IWorkpageStarter result = null;
        try {
            String cn = SystemXml.getWorkpageStarter();
            if (cn != null) {
                IWorkpageStarter s = (IWorkpageStarter)CCConfigurationObjectLoader.instance().loadInstance(cn, true);
                result = s;
            } else {
                result = new WorkpageDefaultStarter();
            }
        }
        catch (Throwable t) {
            result = new WorkpageDefaultStarter();
            CLog.L.log(CLog.LL_ERR, "Problem creating IWorkpageStarter", t);
        }
        return result;
    }
}

