/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.DefaultScreens;
import org.eclnt.jsfserver.defaultscreens.ImageSelection;
import org.eclnt.jsfserver.defaultscreens.ModalPopup;
import org.eclnt.jsfserver.elements.BaseActionEvent;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.BaseComponentTag;
import org.eclnt.jsfserver.elements.events.BaseActionEventDrop;
import org.eclnt.jsfserver.elements.events.BaseActionEventInvoke;
import org.eclnt.jsfserver.elements.impl.BUTTONComponentTag;
import org.eclnt.jsfserver.elements.impl.PANEComponent;
import org.eclnt.jsfserver.elements.impl.ROWComponentTag;
import org.eclnt.jsfserver.elements.impl.ROWDISTANCEComponentTag;
import org.eclnt.jsfserver.managedbean.DefaultDispatchedBean;
import org.eclnt.jsfserver.managedbean.IDispatcher;
import org.eclnt.jsfserver.util.StyleManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.IFavoritesListener;
import org.eclnt.workplace.IWorkpageDispatcher;
import org.eclnt.workplace.WorkpageStartInfo;
import org.eclnt.workplace.WorkpageStarterFactory;
import org.eclnt.workplace.WorkplaceFavoritesInfo;
import org.eclnt.workplace.WorkplaceUtil;

public class WorkplaceFavorites
extends DefaultDispatchedBean
implements Serializable {
    PANEComponent m_pane;
    List<WorkpageStartInfo> m_favorites = new ArrayList<WorkpageStartInfo>();
    List<FavoriteInternalInfo> m_favoritesInternals = new ArrayList<FavoriteInternalInfo>();
    String m_iconDirectoryPath = "/eclntjsfserver/images/";
    List<IFavoritesListener> m_favoritesListeners = new ArrayList<IFavoritesListener>();
    boolean m_withIconTexts;
    int m_imagewidth = 0;
    int m_imageheight = 0;
    String m_objectBinding = null;
    String m_rowAlignmentY = "bottom";
    protected String m_defaultImage = StyleManager.getStyleValue("ccWpFavoriteImage");
    String m_ownDragsendType = "DS_" + UniqueIdCreator.createId();
    String m_persistId = null;

    public WorkplaceFavorites(IDispatcher dispatcher) {
        super(dispatcher);
    }

    public WorkplaceFavorites(IDispatcher dispatcher, String persistId) {
        this(dispatcher);
        this.m_persistId = persistId;
        this.loadFromPersistId(this.m_persistId);
    }

    public void setDefaultImage(String value) {
        this.m_defaultImage = value;
    }

    public String getDefaultImage() {
        return this.m_defaultImage;
    }

    public void setWithIconTexts(boolean value) {
        this.m_withIconTexts = value;
    }

    public boolean getWithIconTexts() {
        return this.m_withIconTexts;
    }

    public void addFavoritesListener(IFavoritesListener listener) {
        this.m_favoritesListeners.add(listener);
    }

    public void removeFavoritesListener(IFavoritesListener listener) {
        this.m_favoritesListeners.remove(listener);
    }

    public void setImageWidthStr(String value) {
        int iValue;
        if ("IMAGEWIDTH".equals(value)) {
            return;
        }
        this.m_imagewidth = iValue = ValueManager.decodeInt(value, -1);
    }

    public void setImageHeightStr(String value) {
        int iValue;
        if ("IMAGEHEIGHT".equals(value)) {
            return;
        }
        this.m_imageheight = iValue = ValueManager.decodeInt(value, -1);
    }

    public void setWithIconTextStr(String value) {
        if ("WITHICONTEXT".equals(value)) {
            return;
        }
        boolean bValue = ValueManager.decodeBoolean(value, false);
        this.setWithIconTexts(bValue);
    }

    public void setRowAlignmentYStr(String value) {
        if ("ROWALIGNMENTY".equals(value)) {
            return;
        }
        this.m_rowAlignmentY = value;
    }

    public void setObjectBinding(String value) {
        this.m_objectBinding = value;
        if (this.m_objectBinding != null && !this.m_objectBinding.startsWith("#")) {
            this.m_objectBinding = "#{" + this.m_objectBinding + "}";
        }
    }

    public String getObjectBinding() {
        return this.m_objectBinding;
    }

    public void setPane(PANEComponent pane) {
        if (this.m_pane == pane) {
            return;
        }
        this.m_pane = pane;
        this.updatePane();
    }

    public void setIconDirectoryPath(String path) {
        this.m_iconDirectoryPath = path;
    }

    public void addFavorite(WorkpageStartInfo favoriteInfo) {
        this.m_favorites.add(favoriteInfo);
        this.updatePane();
    }

    public List<FavoriteInternalInfo> getFis() {
        return this.m_favoritesInternals;
    }

    public List<WorkpageStartInfo> getFavorites() {
        return this.m_favorites;
    }

    public void onPaneAction(ActionEvent event) {
        BaseActionEventDrop baed;
        WorkpageStartInfo dpi;
        if (event instanceof BaseActionEventDrop && (dpi = WorkplaceUtil.decodeDroppedWorkpage((baed = (BaseActionEventDrop)event).getDragInfo())) != null) {
            if ("bottom".equals(this.m_rowAlignmentY)) {
                this.m_favorites.add(0, dpi);
            } else {
                this.m_favorites.add(dpi);
            }
            this.updatePane();
            this.notifyFavoritesListeners();
        }
    }

    public List<WorkpageStartInfo> getFaovriteInfos() {
        ArrayList<WorkpageStartInfo> result = new ArrayList<WorkpageStartInfo>();
        for (FavoriteInternalInfo fi : this.m_favoritesInternals) {
            result.add(fi.i_favoriteInfo);
        }
        return result;
    }

    public void loadFromPersistence(String persistId) {
        this.m_persistId = persistId;
        this.loadFromPersistId(persistId);
    }

    protected void updateButtonTagBeforeComponentCreation(BaseComponentTag buttonTag) {
    }

    protected void updatePane() {
        if (this.m_pane == null) {
            return;
        }
        this.m_pane.getChildren().clear();
        this.m_favoritesInternals.clear();
        if (!"top".equals(this.m_rowAlignmentY)) {
            ROWDISTANCEComponentTag rdt = new ROWDISTANCEComponentTag();
            rdt.setHeight("100%");
            this.m_pane.getChildren().add(rdt.createBaseComponent());
        }
        int count = 0;
        for (WorkpageStartInfo favorite : this.m_favorites) {
            FavoriteInternalInfo fi = new FavoriteInternalInfo(favorite);
            this.m_favoritesInternals.add(fi);
            ROWComponentTag rt = new ROWComponentTag();
            BaseComponent rc = rt.createBaseComponent();
            this.m_pane.getChildren().add(rc);
            BUTTONComponentTag bt = new BUTTONComponentTag();
            bt.setStylevariant("WP_FAVORITE");
            bt.setContentareafilled("false");
            if (this.m_withIconTexts) {
                bt.setText(favorite.getText());
            }
            bt.setTooltip(favorite.getText());
            if (favorite.getImage() != null) {
                bt.setImage(favorite.getImage());
            } else {
                bt.setImage(this.m_defaultImage);
            }
            bt.setDragsend(this.m_ownDragsendType + ":" + count + ";" + WorkplaceUtil.encodePageInfo(favorite));
            bt.setDropreceive(this.m_ownDragsendType + ":verticalsplit;workpage:verticalsplit");
            bt.setPopupmenu("FAVORITEICON");
            bt.setImageheight("" + this.m_imageheight);
            bt.setImagewidth("" + this.m_imagewidth);
            String al = this.m_objectBinding;
            al = al.replace("}", ".fis[" + count + "].onFavoriteAction}");
            bt.setActionListener(al);
            this.updateButtonTagBeforeComponentCreation(bt);
            BaseComponent bc = bt.createBaseComponent();
            rc.getChildren().add(bc);
            ++count;
        }
        if ("top".equals(this.m_rowAlignmentY)) {
            ROWDISTANCEComponentTag rdt = new ROWDISTANCEComponentTag();
            rdt.setHeight("100%");
            this.m_pane.getChildren().add(rdt.createBaseComponent());
        }
    }

    private void configureIcon(WorkpageStartInfo fi) {
        ModalPopup popup = ModalPopup.createInstance();
        ImageSelectionListener isl = new ImageSelectionListener(popup, fi);
        popup.open("/eclntjsfserver/popups/imageselection.jsp", "Favorite Icon", 300, 300, isl);
        ImageSelection is = DefaultScreens.getSessionAccess().getImageSelection();
        is.prepare(isl, this.m_iconDirectoryPath);
    }

    protected void notifyFavoritesListeners() {
        this.save(this.m_persistId);
        for (IFavoritesListener listener : this.m_favoritesListeners) {
            listener.notifyFavoritesUpdate();
        }
    }

    protected void loadFromPersistId(String persistId) {
        this.m_favorites.clear();
        try {
            WorkplaceFavoritesInfo wfi = WorkplaceFavoritesInfo.read(persistId);
            if (wfi == null) {
                return;
            }
            for (WorkpageStartInfo wpsi : wfi.getFavorites()) {
                this.m_favorites.add(wpsi);
            }
            this.updatePane();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void save(String persistId) {
        if (this.m_persistId == null) {
            return;
        }
        try {
            WorkplaceFavoritesInfo wfi = new WorkplaceFavoritesInfo();
            for (WorkpageStartInfo wpsi : this.m_favorites) {
                wfi.getFavorites().add(wpsi);
            }
            WorkplaceFavoritesInfo.save(persistId, wfi);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem saving workplace favorites: " + t.toString());
        }
    }

    public class FavoriteInternalInfo
    implements Serializable {
        WorkpageStartInfo i_favoriteInfo;

        public FavoriteInternalInfo(WorkpageStartInfo favoriteInfo) {
            this.i_favoriteInfo = favoriteInfo;
        }

        public WorkpageStartInfo getFi() {
            return this.i_favoriteInfo;
        }

        public void onFavoriteAction(ActionEvent event) {
            BaseActionEvent bae = (BaseActionEvent)event;
            if (event instanceof BaseActionEventInvoke) {
                IWorkpageDispatcher wpd = (IWorkpageDispatcher)WorkplaceFavorites.this.getOwningDispatcher();
                WorkpageStarterFactory.getWorkpageStarter().startWorkpage(wpd, wpd.getWorkpageContainer(), this.i_favoriteInfo);
            } else if (event instanceof BaseActionEventDrop) {
                BaseActionEventDrop baed = (BaseActionEventDrop)event;
                if (baed.getDragInfo().startsWith("workpage:")) {
                    WorkpageStartInfo dpi = WorkplaceUtil.decodeDroppedWorkpage(baed.getDragInfo());
                    if (dpi != null) {
                        int percVertical = baed.getPercentageVertical();
                        int myIndex = WorkplaceFavorites.this.m_favorites.indexOf(this.i_favoriteInfo);
                        if (percVertical >= 50) {
                            ++myIndex;
                        }
                        WorkplaceFavorites.this.m_favorites.add(myIndex, dpi);
                        WorkplaceFavorites.this.updatePane();
                        WorkplaceFavorites.this.notifyFavoritesListeners();
                    }
                } else if (baed.getDragInfo().startsWith(WorkplaceFavorites.this.m_ownDragsendType + ":")) {
                    WorkpageStartInfo from;
                    String dragFromIndexString = baed.getDragInfo().substring((WorkplaceFavorites.this.m_ownDragsendType + ":").length());
                    int dragFromIndex = ValueManager.decodeInt(dragFromIndexString, -1);
                    if (dragFromIndex == -1) {
                        return;
                    }
                    int percVertical = baed.getPercentageVertical();
                    int newIndex = WorkplaceFavorites.this.m_favorites.indexOf(this.i_favoriteInfo);
                    if (percVertical >= 50) {
                        ++newIndex;
                    }
                    if ((from = WorkplaceFavorites.this.m_favorites.get(dragFromIndex)) == this.i_favoriteInfo) {
                        return;
                    }
                    WorkplaceFavorites.this.m_favorites.remove(dragFromIndex);
                    if (dragFromIndex <= WorkplaceFavorites.this.m_favorites.indexOf(this.i_favoriteInfo)) {
                        --newIndex;
                    }
                    WorkplaceFavorites.this.m_favorites.add(newIndex, from);
                    WorkplaceFavorites.this.updatePane();
                    WorkplaceFavorites.this.notifyFavoritesListeners();
                }
            } else if (bae.getCommand().equals("cmdRemoveFavorite")) {
                WorkplaceFavorites.this.m_favorites.remove(this.i_favoriteInfo);
                WorkplaceFavorites.this.updatePane();
                WorkplaceFavorites.this.notifyFavoritesListeners();
            } else if (bae.getCommand().equals("cmdConfigureIcon")) {
                WorkplaceFavorites.this.configureIcon(this.i_favoriteInfo);
            }
        }
    }

    public class ImageSelectionListener
    implements ModalPopup.IModalPopupListener,
    ImageSelection.IImageSelectionListener,
    Serializable {
        ModalPopup i_popup;
        WorkpageStartInfo i_favoriteInfo;

        public ImageSelectionListener(ModalPopup popup, WorkpageStartInfo favoriteInfo) {
            this.i_favoriteInfo = favoriteInfo;
            this.i_popup = popup;
        }

        @Override
        public void reactOnPopupClosedByUser() {
            this.i_popup.close();
        }

        @Override
        public void imageSelected(String image) {
            this.i_popup.close();
            this.i_favoriteInfo.setImage(image);
            WorkplaceFavorites.this.updatePane();
            WorkplaceFavorites.this.notifyFavoritesListeners();
        }
    }
}

