/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Source;
import org.eclnt.jsfserver.streamstore.StreamStore;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.WorkpageStartInfo;
import org.eclnt.workplace.WorkplaceFunctionTreeInfoNode;

public class WorkplaceFunctionTreeInfoManager
implements Serializable {
    static JAXBContext s_jaxbContext;

    public static WorkplaceFunctionTreeInfoNode loadFunctionTreeInfo(String treeName) {
        WorkplaceFunctionTreeInfoNode result = null;
        if (treeName.contains("/")) {
            result = WorkplaceFunctionTreeInfoManager.loadFunctionTreeInfoFromResources(treeName);
        }
        if (result == null) {
            result = WorkplaceFunctionTreeInfoManager.loadFunctionTreeInfoFromStreamStore(treeName);
        }
        return result;
    }

    private static WorkplaceFunctionTreeInfoNode loadFunctionTreeInfoFromResources(String treeName) {
        try {
            String xml = new ClassloaderReader(true).readUTF8File(treeName, true);
            return WorkplaceFunctionTreeInfoManager.unmarshalFunctionTreeInfo(xml);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "checked tree to be available at: " + treeName + ", did not find it");
            return null;
        }
    }

    public static WorkplaceFunctionTreeInfoNode loadFunctionTreeInfoFromStreamStore(String treeName) {
        try {
            String streamStoreName = WorkplaceFunctionTreeInfoManager.buildStreamStoreName(treeName);
            String xml = StreamStore.getInstance().readUTF8(streamStoreName, true);
            return WorkplaceFunctionTreeInfoManager.unmarshalFunctionTreeInfo(xml);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Error when reading tree with name: " + treeName + ", " + t.toString());
            throw new Error("Error when reading tree: " + treeName, t);
        }
    }

    public static WorkplaceFunctionTreeInfoNode loadFunctionTreeInfo(String treeName, boolean resolveEmbeddedTrees) {
        try {
            WorkplaceFunctionTreeInfoNode result = WorkplaceFunctionTreeInfoManager.loadFunctionTreeInfo(treeName);
            if (resolveEmbeddedTrees) {
                WorkplaceFunctionTreeInfoManager.resolveEmbeddedTrees(result);
            }
            return result;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Error when reading tree with name: " + treeName + ", " + t.toString());
            throw new Error("Error when reading tree: " + treeName, t);
        }
    }

    public static WorkplaceFunctionTreeInfoNode unmarshalFunctionTreeInfo(String xml) {
        try {
            Source r = ValueManager.convertStringIntoXMLSource(xml);
            Unmarshaller um = s_jaxbContext.createUnmarshaller();
            WorkplaceFunctionTreeInfoNode result = (WorkplaceFunctionTreeInfoNode)um.unmarshal(r);
            return result;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error when reading tree: " + xml, t);
            throw new Error(t);
        }
    }

    public static void storeFunctionTreeInfo(String treeName, WorkplaceFunctionTreeInfoNode wfti) {
        try {
            String xml = WorkplaceFunctionTreeInfoManager.marshalFunctionTreeInfo(wfti);
            String streamStoreName = WorkplaceFunctionTreeInfoManager.buildStreamStoreName(treeName);
            StreamStore.getInstance().writeUTF8(streamStoreName, xml, true);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error when storing tree with name: " + treeName);
            throw new Error(t);
        }
    }

    public static String marshalFunctionTreeInfo(WorkplaceFunctionTreeInfoNode wfti) {
        try {
            Marshaller m = s_jaxbContext.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("jaxb.encoding", (Object)"UTF-8");
            StringWriter writer = new StringWriter();
            m.marshal((Object)wfti, (Writer)writer);
            String xml = ((Object)writer).toString();
            return xml;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error when marshalling tree");
            throw new Error(t);
        }
    }

    private static String buildStreamStoreName(String treeName) {
        return "ccworkplace/functiontrees/" + treeName + ".xml";
    }

    public static void main(String[] args) {
        WorkplaceFunctionTreeInfoNode top = new WorkplaceFunctionTreeInfoNode();
        top.setText("Demo Applications");
        WorkpageStartInfo wpsi = new WorkpageStartInfo();
        WorkplaceFunctionTreeInfoNode sub = new WorkplaceFunctionTreeInfoNode();
        top.getSubNodes().add(sub);
        sub.setText("Hello world!");
        sub.setWorkpageStartInfo(wpsi);
        wpsi.setJspPage("/workplace/demohelloworld.jsp");
        wpsi.getParamMap().put("param1", "value1");
        wpsi.getParamMap().put("param2", "value2");
        String xml = WorkplaceFunctionTreeInfoManager.marshalFunctionTreeInfo(top);
        System.out.println(xml);
    }

    private static void resolveEmbeddedTrees(WorkplaceFunctionTreeInfoNode node) {
        for (WorkplaceFunctionTreeInfoNode subNode : node.getSubNodes()) {
            if (subNode.getEmbeddedTreeName() != null) {
                WorkplaceFunctionTreeInfoNode newSubNode = WorkplaceFunctionTreeInfoManager.loadFunctionTreeInfo(subNode.getEmbeddedTreeName(), true);
                int index = node.getSubNodes().indexOf(subNode);
                node.getSubNodes().set(index, newSubNode);
                subNode = newSubNode;
            }
            WorkplaceFunctionTreeInfoManager.resolveEmbeddedTrees(subNode);
        }
    }

    static {
        try {
            s_jaxbContext = JAXBContext.newInstance((Class[])new Class[]{WorkplaceFunctionTreeInfoNode.class});
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }
}

