/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.zzzzz.test;

import org.eclnt.jsfserver.resources.ResourceManager;
import org.eclnt.jsfserver.session.UsageWithoutSessionContext;
import org.junit.Assert;
import org.junit.Test;

public class TestResourceManager {
    @Test
    public void test() {
        try {
            UsageWithoutSessionContext.initUsageWithoutSessionContext();
            ResourceManager.initForJUnitTest();
            ResourceManager rm = ResourceManager.getRuntimeInstance();
            rm.addResourceConfiguration("test", "org.eclnt.zzzzz.test.resources", null);
            rm.addResourceConfiguration("test2", "org.eclnt.zzzzz.test.resources", "defaultValue");
            String result = rm.readProperty("test", "aaa", false);
            System.out.println(result);
            Assert.assertEquals((Object)"value aaa", (Object)result);
            result = rm.readProperty("test", "xxx", false);
            System.out.println(result);
            Assert.assertEquals((Object)"{test.xxx}", (Object)result);
            result = rm.readProperty("test", "aaa", true);
            System.out.println("No exception is processed - correct!");
            try {
                result = rm.readProperty("test", "xxx", true);
                throw new Exception("Missing exception! Exception should be thrown in case of non-existing value");
            }
            catch (Throwable t) {
                System.out.println("Exception is processed - correct!");
                try {
                    result = ResourceManager.findLiteral("test", "xxx", true);
                    throw new Exception("Missing exception! Exception should be thrown in case of non-existing value");
                }
                catch (Throwable t2) {
                    System.out.println("Exception is processed - correct!");
                    result = rm.readProperty("test2", "aaa", true);
                    System.out.println(result + " (test2)");
                    Assert.assertEquals((Object)"value aaa", (Object)result);
                    result = rm.readProperty("test", "ccc", true);
                    System.out.println("ccc: " + result);
                    Assert.assertEquals((Object)"value aaa", (Object)result);
                    result = rm.readProperty("test", "ddd", true);
                    System.out.println("ddd: " + result);
                    Assert.assertEquals((Object)"value aaa", (Object)result);
                    result = rm.readProperty("test", "eee", false);
                    System.out.println("eee: " + result);
                    result = rm.readProperty("test", "fff", false);
                    System.out.println("fff: " + result);
                    result = rm.readProperty("test2", "xxx", true);
                    System.out.println(result + " (test2)");
                    Assert.assertEquals((Object)"defaultValue", (Object)result);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }
}

