/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.zzzzz.test;

import org.eclnt.util.valuemgmt.ValueManager;
import org.junit.Assert;
import org.junit.Test;

public class ValueManagerTest {
    @Test
    public void test() {
        Object o = ValueManager.convertStringIntoObject("2", Integer.class);
        Assert.assertTrue((boolean)(o instanceof Integer));
        Assert.assertTrue(((Integer)o == 2 ? 1 : 0) != 0);
        o = ValueManager.convertStringIntoObject("2.2", Integer.class);
        Assert.assertTrue((boolean)(o instanceof Integer));
        Assert.assertTrue(((Integer)o == 2 ? 1 : 0) != 0);
        o = ValueManager.convertStringIntoObject("2.7", Integer.class);
        Assert.assertTrue((boolean)(o instanceof Integer));
        Assert.assertTrue(((Integer)o == 3 ? 1 : 0) != 0);
        o = ValueManager.convertStringIntoObject("2", Long.class);
        Assert.assertTrue((boolean)(o instanceof Long));
        Assert.assertTrue(((Long)o == 2L ? 1 : 0) != 0);
        o = ValueManager.convertStringIntoObject("2.2", Long.class);
        Assert.assertTrue((boolean)(o instanceof Long));
        Assert.assertTrue(((Long)o == 2L ? 1 : 0) != 0);
        o = ValueManager.convertStringIntoObject("2.7", Long.class);
        Assert.assertTrue((boolean)(o instanceof Long));
        Assert.assertTrue(((Long)o == 3L ? 1 : 0) != 0);
    }

    @Test
    public void testEncoding() {
        String s = "This is a <b>bold text</b>";
        s = ValueManager.encodeIntoValidXMLString(s);
        System.out.println(s);
        Assert.assertTrue((boolean)s.equals("This is a &lt;b&gt;bold text&lt;/b&gt;"));
        s = "This is a <b>bold 'text'</b>";
        s = ValueManager.encodeIntoValidXMLValueString(s);
        System.out.println(s);
        Assert.assertTrue((boolean)s.equals("This is a <b>bold &#39;text&#39;</b>"));
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            String s2 = "This is a <b>bold text</b>";
            s2 = ValueManager.encodeIntoValidXMLString(s2);
        }
        long t2 = System.currentTimeMillis();
        long diff = t2 - t1;
        System.out.println("duration of 1.000.000 conversions: " + diff);
    }

    @Test
    public void testFileName() {
        String[] names = new String[]{"c:\\hallo\\captain.txt", "\\\\testshared\\hallo\\captain.txt", "//Hallo/Karl///und\\\\/Klaus.txt"};
        StringBuffer sb = new StringBuffer();
        for (String name : names) {
            String s = ValueManager.encodeIntoValidFileName(name, false);
            System.out.println(s);
            sb.append(s);
            sb.append("#");
        }
        System.out.println(sb.toString());
        Assert.assertEquals((Object)"c:/hallo/captain.txt#//testshared/hallo/captain.txt#//Hallo/Karl/und/Klaus.txt#", (Object)sb.toString());
    }

    @Test
    public void testCSV() {
        int i;
        String[] values = new String[]{"A", "B", "C", "D"};
        String csv = ValueManager.encodeCSV(values);
        System.out.println(csv);
        Assert.assertTrue((boolean)csv.equals("A;B;C;D"));
        String[] backValues = ValueManager.decodeCSV(csv);
        for (i = 0; i < values.length; ++i) {
            Assert.assertTrue((boolean)values[i].equals(backValues[i]));
        }
        values = new String[]{"A", "B", "C", "D;E"};
        csv = ValueManager.encodeCSV(values);
        System.out.println(csv);
        Assert.assertTrue((boolean)csv.equals("A;B;C;D\\x3BE"));
        backValues = ValueManager.decodeCSV(csv);
        for (i = 0; i < values.length; ++i) {
            Assert.assertTrue((boolean)values[i].equals(backValues[i]));
        }
    }

    @Test
    public void testObjectEquals() {
        String s1 = "A";
        String s2 = "B";
        boolean e = ValueManager.checkIfObjectsAreEqual(s1, s2);
        Assert.assertFalse((boolean)e);
        s1 = "A";
        s2 = null;
        e = ValueManager.checkIfObjectsAreEqual(s1, s2);
        Assert.assertFalse((boolean)e);
        s1 = null;
        s2 = "B";
        e = ValueManager.checkIfObjectsAreEqual(s1, s2);
        Assert.assertFalse((boolean)e);
        s1 = "B";
        s2 = "B";
        e = ValueManager.checkIfObjectsAreEqual(s1, s2);
        Assert.assertTrue((boolean)e);
    }

    @Test
    public void testTimeStamp() {
        String s = ValueManager.buildTimeStamp();
        System.out.println(s);
    }
}

