/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.defaultscreens;

import java.io.Serializable;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.DefaultScreens;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDListBinding;
import org.eclnt.jsfserver.i18n.I18N;
import org.eclnt.util.log.CLog;

public class Wizard
implements Serializable {
    IWizardLogicProvider m_logic;
    IWizardPageInfo[] m_logicPageInfos;
    int m_currentIndex;
    FIXGRIDListBinding<MyRow> m_rows = new FIXGRIDListBinding();

    public static Wizard getInstance() {
        return DefaultScreens.getSessionAccess().getWizard();
    }

    public String getPageName() {
        return this.m_logicPageInfos[this.m_currentIndex].getPage();
    }

    public String getContentReplace() {
        return this.m_logicPageInfos[this.m_currentIndex].getContentReplace();
    }

    public FIXGRIDListBinding<MyRow> getRows() {
        return this.m_rows;
    }

    public boolean getAvoidGridNavigation() {
        if (this.m_logic == null) {
            return false;
        }
        return !this.m_logic.checkIfGridNavigationIsEnabled();
    }

    public boolean getEnabledPrevious() {
        if (this.m_logic == null) {
            return false;
        }
        IWizardPageInfo wpi = this.findPreviousPage();
        return wpi != null;
    }

    public boolean getEnabledNext() {
        if (this.m_logic == null) {
            return false;
        }
        IWizardPageInfo wpi = this.findNextPage();
        return wpi != null;
    }

    public boolean getEnabledFinish() {
        if (this.m_logic == null) {
            return false;
        }
        return this.m_logicPageInfos[this.m_currentIndex].checkIfFinishIsEnabled();
    }

    public boolean getRenderedPrevious() {
        return this.getEnabledPrevious() || this.getCurrentPageInfo() == null || !this.getCurrentPageInfo().checkIfDisabledMeansInvisibleWithPrevious();
    }

    public boolean getRenderedNext() {
        return this.getEnabledNext() || this.getCurrentPageInfo() == null || !this.getCurrentPageInfo().checkIfDisabledMeansInvisibleWithNext();
    }

    public boolean getRenderedFinish() {
        return this.getEnabledFinish() || this.getCurrentPageInfo() == null || !this.getCurrentPageInfo().checkIfDisabledMeansInvisibleWithFinish();
    }

    public boolean getRenderedDistance() {
        if (this.getCurrentPageInfo() != null) {
            return this.getCurrentPageInfo().getRenderedDistance();
        }
        return true;
    }

    public void prepare(IWizardLogicProvider logic) {
        this.m_logic = logic;
        this.m_currentIndex = 0;
        this.m_logicPageInfos = logic.getWizardPageInfos();
        this.m_rows.getItems().clear();
        for (int i = 0; i < this.m_logicPageInfos.length; ++i) {
            MyRow row = new MyRow();
            row.setLink(this.m_logicPageInfos[i].getStep());
            this.m_rows.getItems().add(row);
        }
        this.m_rows.deselectCurrentSelection();
        if (this.m_rows.getItems().size() > 0) {
            this.m_rows.selectItem(this.m_rows.getItems().get(0));
        }
    }

    public void onNext(ActionEvent ae) {
        if (this.m_logic == null) {
            return;
        }
        IWizardPageInfo wpi = this.findNextPage();
        if (wpi != null) {
            int newIndex = this.findPageInfoIndex(wpi);
            this.processRowSelect(newIndex);
        }
    }

    public void onPrevious(ActionEvent ae) {
        if (this.m_logic == null) {
            return;
        }
        IWizardPageInfo wpi = this.findPreviousPage();
        if (wpi != null) {
            int newIndex = this.findPageInfoIndex(wpi);
            this.processRowSelect(newIndex);
        }
    }

    public void onCancel(ActionEvent ae) {
        if (this.m_logic == null) {
            return;
        }
        this.m_logic.cancel();
    }

    public void onFinish(ActionEvent ae) {
        if (this.m_logic == null) {
            return;
        }
        this.m_logic.finish();
    }

    public IWizardPageInfo getCurrentPageInfo() {
        try {
            return this.m_logicPageInfos[this.m_currentIndex];
        }
        catch (Throwable t) {
            return null;
        }
    }

    public String getTextPrevious() {
        if (this.getCurrentPageInfo() != null && this.getCurrentPageInfo().getTextPrevious() != null) {
            return this.getCurrentPageInfo().getTextPrevious();
        }
        return I18N.getBundle().getString("WIZARD_back");
    }

    public String getTextNext() {
        if (this.getCurrentPageInfo() != null && this.getCurrentPageInfo().getTextNext() != null) {
            return this.getCurrentPageInfo().getTextNext();
        }
        return I18N.getBundle().getString("WIZARD_next");
    }

    public String getTextFinish() {
        if (this.getCurrentPageInfo() != null && this.getCurrentPageInfo().getTextFinish() != null) {
            return this.getCurrentPageInfo().getTextFinish();
        }
        return I18N.getBundle().getString("WIZARD_exit");
    }

    public String getTextCancel() {
        if (this.getCurrentPageInfo() != null && this.getCurrentPageInfo().getTextCancel() != null) {
            return this.getCurrentPageInfo().getTextCancel();
        }
        return I18N.getBundle().getString("WIZARD_cancel");
    }

    public String getIconPrevious() {
        if (this.getCurrentPageInfo() != null && this.getCurrentPageInfo().getIconPrevious() != null) {
            return this.getCurrentPageInfo().getIconPrevious();
        }
        return "/eclntjsfserver/images/control_playbackwards.png";
    }

    public String getIconNext() {
        if (this.getCurrentPageInfo() != null && this.getCurrentPageInfo().getIconNext() != null) {
            return this.getCurrentPageInfo().getIconNext();
        }
        return "/eclntjsfserver/images/control_play.png";
    }

    public String getIconFinish() {
        if (this.getCurrentPageInfo() != null && this.getCurrentPageInfo().getIconFinish() != null) {
            return this.getCurrentPageInfo().getIconFinish();
        }
        return "/eclntjsfserver/images/control_end.png";
    }

    public String getIconCancel() {
        if (this.getCurrentPageInfo() != null && this.getCurrentPageInfo().getIconCancel() != null) {
            return this.getCurrentPageInfo().getIconCancel();
        }
        return null;
    }

    public String getIconDisabled() {
        if (this.getCurrentPageInfo() != null && this.getCurrentPageInfo().getIconDisabled() != null) {
            return this.getCurrentPageInfo().getIconDisabled();
        }
        return "/eclntjsfserver/images/control_empty.png";
    }

    private void processRowSelect(MyRow row) {
        int newIndex = this.m_rows.getItems().indexOf(row);
        if (newIndex == this.m_currentIndex) {
            return;
        }
        if (this.checkNavigation(this.m_currentIndex, newIndex)) {
            int direction = this.findDirection(this.m_currentIndex, newIndex);
            this.m_currentIndex = newIndex;
            this.prepareNextPage(this.m_currentIndex, direction);
        } else {
            this.m_rows.deselectCurrentSelection();
            this.m_rows.selectItem(this.m_rows.getItems().get(this.m_currentIndex));
        }
    }

    private void processRowSelect(int index) {
        if (index < 0) {
            return;
        }
        if (this.checkNavigation(this.m_currentIndex, index)) {
            int direction = this.findDirection(this.m_currentIndex, index);
            this.m_currentIndex = index;
            this.m_rows.deselectCurrentSelection();
            this.m_rows.selectItem(this.m_rows.getItems().get(index));
            this.prepareNextPage(this.m_currentIndex, direction);
        }
    }

    private boolean checkNavigation(int fromIndex, int toIndex) {
        try {
            return this.m_logic.checkIfNavigationIsPossible(this.m_logicPageInfos[fromIndex], this.m_logicPageInfos[toIndex], this.findDirection(fromIndex, toIndex));
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "", t);
            return true;
        }
    }

    private void prepareNextPage(int pageIndex, int direction) {
        this.m_logic.prepareNextPage(this.m_logicPageInfos[pageIndex], direction);
    }

    private IWizardPageInfo findNextPage() {
        for (int i = this.m_currentIndex + 1; i < this.m_logicPageInfos.length; ++i) {
            if (!this.m_logicPageInfos[i].checkIfPageIsEnabled()) continue;
            return this.m_logicPageInfos[i];
        }
        return null;
    }

    private IWizardPageInfo findPreviousPage() {
        for (int i = this.m_currentIndex - 1; i >= 0; --i) {
            if (!this.m_logicPageInfos[i].checkIfPageIsEnabled()) continue;
            return this.m_logicPageInfos[i];
        }
        return null;
    }

    private int findPageInfoIndex(IWizardPageInfo pageInfo) {
        IWizardPageInfo[] pages = this.m_logicPageInfos;
        for (int i = 0; i < pages.length; ++i) {
            if (pages[i] != pageInfo) continue;
            return i;
        }
        return -1;
    }

    private int findDirection(int fromIndex, int toIndex) {
        int direction = toIndex < fromIndex ? 1 : 0;
        return direction;
    }

    public class MyRow
    extends FIXGRIDItem
    implements Serializable {
        String i_link;

        public void setLink(String value) {
            this.i_link = value;
        }

        public String getLink() {
            return this.i_link;
        }

        public String getFont() {
            if (Wizard.this.m_rows.getItems().indexOf(this) == Wizard.this.m_currentIndex) {
                return "weight:bold";
            }
            return "";
        }

        @Override
        public void onRowSelect() {
            Wizard.this.processRowSelect(this);
        }
    }

    public static interface IWizardPageInfo {
        public String getStep();

        public String getPage();

        public String getContentReplace();

        public boolean checkIfFinishIsEnabled();

        public boolean checkIfPageIsEnabled();

        public boolean checkIfDisabledMeansInvisibleWithPrevious();

        public boolean checkIfDisabledMeansInvisibleWithNext();

        public boolean checkIfDisabledMeansInvisibleWithFinish();

        public String getTextPrevious();

        public String getTextNext();

        public String getTextFinish();

        public String getTextCancel();

        public String getIconPrevious();

        public String getIconNext();

        public String getIconFinish();

        public String getIconCancel();

        public String getIconDisabled();

        public boolean getRenderedDistance();
    }

    public static interface IWizardLogicProvider {
        public static final int DIRECTION_NEXT = 0;
        public static final int DIRECTION_PREVIOUS = 1;

        public IWizardPageInfo[] getWizardPageInfos();

        public boolean checkIfNavigationIsPossible(IWizardPageInfo var1, IWizardPageInfo var2, int var3);

        public void prepareNextPage(IWizardPageInfo var1, int var2);

        public void finish();

        public void cancel();

        public boolean checkIfGridNavigationIsEnabled();
    }

    public static class WizardPageInfo
    implements IWizardPageInfo,
    Serializable {
        String i_step;
        String i_page;
        boolean i_finishIsEnabled = true;
        boolean i_pageIsEnabled = true;

        public WizardPageInfo(String step, String page) {
            this.i_step = step;
            this.i_page = page;
        }

        public WizardPageInfo(String step, String page, boolean finishIsEnabled, boolean pageIsEnabled) {
            this.i_step = step;
            this.i_page = page;
            this.i_finishIsEnabled = finishIsEnabled;
            this.i_pageIsEnabled = pageIsEnabled;
        }

        public void setStep(String value) {
            this.i_step = value;
        }

        @Override
        public String getStep() {
            return this.i_step;
        }

        public void setPage(String value) {
            this.i_page = value;
        }

        @Override
        public String getPage() {
            return this.i_page;
        }

        @Override
        public String getContentReplace() {
            return null;
        }

        public void setFinishIsEnabled(boolean value) {
            this.i_finishIsEnabled = value;
        }

        public void setPageIsEnabled(boolean value) {
            this.i_pageIsEnabled = value;
        }

        @Override
        public boolean checkIfFinishIsEnabled() {
            return this.i_finishIsEnabled;
        }

        @Override
        public boolean checkIfPageIsEnabled() {
            return this.i_pageIsEnabled;
        }

        @Override
        public boolean checkIfDisabledMeansInvisibleWithFinish() {
            return false;
        }

        @Override
        public boolean checkIfDisabledMeansInvisibleWithNext() {
            return false;
        }

        @Override
        public boolean checkIfDisabledMeansInvisibleWithPrevious() {
            return false;
        }

        @Override
        public String getTextCancel() {
            return null;
        }

        @Override
        public String getTextFinish() {
            return null;
        }

        @Override
        public String getTextNext() {
            return null;
        }

        @Override
        public String getTextPrevious() {
            return null;
        }

        @Override
        public String getIconPrevious() {
            return null;
        }

        @Override
        public String getIconNext() {
            return null;
        }

        @Override
        public String getIconFinish() {
            return null;
        }

        @Override
        public String getIconCancel() {
            return null;
        }

        @Override
        public String getIconDisabled() {
            return null;
        }

        @Override
        public boolean getRenderedDistance() {
            return true;
        }
    }
}

