/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.eclnt.jsfserver.base.faces.component.UIComponent;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.base.faces.context.ResponseWriter;
import org.eclnt.jsfserver.elements.BaseActionComponent;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.BaseComponentTagBase;
import org.eclnt.jsfserver.elements.ComponentDump;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class HOTKEYBARComponent
extends BaseActionComponent {
    boolean m_dumpCleared = false;

    public HOTKEYBARComponent() {
        this.setRendersChildren(true);
    }

    @Override
    public void encodeChildren(FacesContext context) throws IOException {
        boolean hidden;
        if (CLog.L.isLoggable(CLog.LL_DBG)) {
            CLog.L.log(CLog.LL_DBG, "HIDEABLEPANE - encoding sub components: " + this.getId());
        }
        if (!(hidden = this.findHiddenValue())) {
            boolean updateRequired;
            boolean didSetUpdateAllAreas = false;
            if (this.m_dumpCleared && !(updateRequired = ThreadData.getInstance().getUpdateAllAreasIsRequired())) {
                ThreadData.getInstance().registerChangeUpdatingAllAreas();
                didSetUpdateAllAreas = true;
            }
            super.encodeChildren(context);
            if (didSetUpdateAllAreas) {
                ThreadData.getInstance().unregisterChangeUpdatingAllAreas();
            }
            this.m_dumpCleared = false;
        } else {
            if (CLog.L.isLoggable(CLog.LL_DBG)) {
                CLog.L.log(CLog.LL_DBG, "HIDEABLEPANE - no rendering of components below: " + this.getId());
            }
            ThreadData threadData = ThreadData.getInstance();
            ResponseWriter writer = context.getResponseWriter();
            HttpSession session = HttpSessionAccess.getCurrentHttpSession(context);
            ComponentDump currentDump = (ComponentDump)session.getAttribute(threadData.getSubpageId() + "/" + "org.eclnt.jsfserver/currentDump");
            for (UIComponent childObj : this.getChildren()) {
                BaseComponent child = (BaseComponent)childObj;
                child.renderComponentNoChange(context, writer, currentDump);
            }
        }
    }

    private boolean findHiddenValue() {
        boolean hidden = false;
        try {
            Object ho = this.getAttributesGet(BaseComponentTagBase.ATT_hidden);
            if (ho != null && ho instanceof Boolean) {
                hidden = (Boolean)ho;
            } else {
                String hs = "" + ho;
                hidden = ValueManager.decodeBoolean(hs, false);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Could not retrieve hidden-value");
        }
        return hidden;
    }

    @Override
    protected void indicateEncodeBeginWithClearedDump() {
        this.m_dumpCleared = true;
    }
}

