/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.util.FIXGRIDPivotListBinding;

public class FIXGRIDPivotItem<R>
extends FIXGRIDItem
implements Serializable {
    boolean m_folded = false;
    boolean m_marked = false;
    String m_foldedKey;
    R m_reference;
    FIXGRIDPivotListBinding m_pivotList;
    List<FIXGRIDPivotItem> m_hiddens = new ArrayList<FIXGRIDPivotItem>();
    Map<String, String> m_keyValues = new HashMap<String, String>();
    ItemCallMap m_itemCallMap = new ItemCallMap();
    Map<String, String> m_iconValues = new HashMap<String, String>();
    SortValueMap m_sortValueMap = new SortValueMap();
    int m_containedItemsCount = 1;

    private FIXGRIDPivotItem findPivotItemBeforeWithFilledKey(String key) {
        int myIndex = this.m_pivotList.getItems().indexOf(this);
        for (int i = myIndex - 1; i >= 0; --i) {
            FIXGRIDPivotItem item = (FIXGRIDPivotItem)this.m_pivotList.getItems().get(i);
            String keyValue = item.getK().get(key);
            if (keyValue == null || keyValue.length() <= 0) continue;
            return item;
        }
        return null;
    }

    public FIXGRIDPivotItem(FIXGRIDPivotListBinding pivotList, R reference) {
        this.m_pivotList = pivotList;
        this.m_reference = reference;
    }

    public void addKeyValue(String key, String value) {
        if (value == null) {
            value = "";
        }
        this.m_keyValues.put(key, value);
    }

    public void togglePivot(String pivotKey) {
        if (!this.m_folded) {
            this.foldPivot(pivotKey);
        } else {
            int index2;
            int index1 = this.indexOfKey(pivotKey);
            if (index1 >= (index2 = this.indexOfKey(this.m_foldedKey))) {
                this.unfoldPivot();
            } else {
                this.foldPivot(pivotKey);
            }
        }
    }

    public R getR() {
        return this.m_reference;
    }

    public Map<String, String> getKeys() {
        return this.m_keyValues;
    }

    public Map<String, String> getK() {
        HashMap<String, String> result = new HashMap<String, String>();
        int myIndex = this.m_pivotList.getItems().indexOf(this);
        if (myIndex == 0) {
            return this.m_keyValues;
        }
        FIXGRIDPivotItem previousItem = (FIXGRIDPivotItem)this.m_pivotList.getItems().get(myIndex - 1);
        boolean firstDifferenceOccurred = false;
        for (int i = 0; i < this.m_pivotList.getPivotKeys().size(); ++i) {
            String key = this.m_pivotList.getPivotKeys().get(i);
            String myValue = this.m_keyValues.get(key);
            String previousValue = previousItem.m_keyValues.get(key);
            if (!firstDifferenceOccurred && myValue.equals(previousValue) && !myValue.startsWith("(...")) {
                result.put(key, "");
                continue;
            }
            result.put(key, myValue);
            firstDifferenceOccurred = true;
        }
        return result;
    }

    public SortValueMap getSv() {
        return this.m_sortValueMap;
    }

    public Map<String, String> getI() {
        Map<String, String> ks = this.getK();
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < this.m_pivotList.getPivotKeys().size() - 1; ++i) {
            String key = this.m_pivotList.getPivotKeys().get(i);
            String nkey = this.m_pivotList.getPivotKeys().get(i + 1);
            String kText = ks.get(key);
            if (kText == null || "".equals(kText)) continue;
            String nkText = ks.get(nkey);
            if (nkText != null && nkText.startsWith("(...")) {
                result.put(key, "/eclntjsfserver/images/tree_closed.png");
                continue;
            }
            result.put(key, "/eclntjsfserver/images/tree_opened.png");
        }
        return result;
    }

    public Map<String, String> getB() {
        Map<String, String> ks = this.getK();
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : ks.keySet()) {
            String kText = ks.get(key);
            if (kText == null || "".equals(kText)) {
                result.put(key, "rectangle(0,0,1,100%," + this.m_pivotList.getLineSeparatorColor() + ")");
                continue;
            }
            if (kText.startsWith("(...")) {
                result.put(key, "rectangle(0,0,100%,1," + this.m_pivotList.getLineSeparatorColor() + ")");
                continue;
            }
            result.put(key, "rectangle(0,0,1,100%," + this.m_pivotList.getLineSeparatorColor() + ");rectangle(1,0,100%,1," + this.m_pivotList.getLineSeparatorColor() + ")");
        }
        return result;
    }

    public ItemCallMap getM() {
        return this.m_itemCallMap;
    }

    public boolean getFolded() {
        return this.m_folded;
    }

    public List<FIXGRIDPivotItem> getHiddenItems() {
        return this.m_hiddens;
    }

    public Boolean getMarked() {
        if (!this.m_folded) {
            return new Boolean(this.m_marked);
        }
        int markedItemsCount = 0;
        int nullmarkedItemsCount = 0;
        int unmarkedItemsCount = 0;
        for (FIXGRIDPivotItem item : this.m_hiddens) {
            if (item.getMarked() == null) {
                ++nullmarkedItemsCount;
                continue;
            }
            if (item.getMarked().booleanValue()) {
                ++markedItemsCount;
                continue;
            }
            ++unmarkedItemsCount;
        }
        if (nullmarkedItemsCount == 0 && unmarkedItemsCount == 0) {
            return new Boolean(true);
        }
        if (markedItemsCount == 0 && nullmarkedItemsCount == 0) {
            return new Boolean(false);
        }
        return null;
    }

    public void setMarked(Boolean value) {
        if (!this.m_folded) {
            this.m_marked = value;
        } else {
            for (FIXGRIDPivotItem item : this.m_hiddens) {
                item.setMarked(value);
            }
        }
    }

    void addItemToSelectedItems(List list) {
        if (!this.m_folded) {
            if (this.getSelected()) {
                list.add(this);
            }
        } else {
            for (int i = 0; i < this.m_hiddens.size(); ++i) {
                this.m_hiddens.get(i).addItemToSelectedItems(list);
            }
        }
    }

    protected void foldPivot(String pivotKey) {
        FIXGRIDPivotItem pitem;
        String itemsKeyString;
        int itemIndex;
        int beforeSbvalue = this.m_pivotList.getSbvalue();
        int index = this.m_pivotList.getItems().indexOf(this);
        String compareKeyString = this.buildKeyString(this, pivotKey);
        FIXGRIDPivotItem<R> foldedItem = this.createNewFoldedItem();
        foldedItem.m_folded = true;
        foldedItem.m_foldedKey = pivotKey;
        foldedItem.m_containedItemsCount = 0;
        boolean allContainedItemsAreSelected = true;
        boolean oneContainedItemsIsSelected = false;
        while ((itemIndex = index) < this.m_pivotList.getItems().size() && compareKeyString.equals(itemsKeyString = this.buildKeyString(pitem = (FIXGRIDPivotItem)this.m_pivotList.getItems().get(itemIndex), pivotKey))) {
            foldedItem.m_hiddens.add(pitem);
            if (!pitem.getSelected()) {
                allContainedItemsAreSelected = false;
            } else {
                oneContainedItemsIsSelected = true;
            }
            this.m_pivotList.getItems().remove(itemIndex);
            foldedItem.m_containedItemsCount += pitem.m_containedItemsCount;
        }
        boolean noKey = false;
        for (int i = 0; i < this.m_pivotList.getPivotKeys().size(); ++i) {
            String key = this.m_pivotList.getPivotKeys().get(i);
            if (noKey) {
                foldedItem.m_keyValues.put(key, "(..." + foldedItem.m_containedItemsCount + "...)");
            } else {
                foldedItem.m_keyValues.put(key, this.m_keyValues.get(key));
            }
            if (!key.equals(pivotKey)) continue;
            noKey = true;
        }
        this.m_pivotList.getItems().add(index, foldedItem);
        int nowSbvalue = this.m_pivotList.getSbvalue();
        if (beforeSbvalue != nowSbvalue) {
            this.m_pivotList.setSbvalue(beforeSbvalue);
        }
    }

    protected FIXGRIDPivotItem<R> createNewFoldedItem() {
        return new FIXGRIDPivotItem<Object>(this.m_pivotList, null);
    }

    protected void unfoldPivot() {
        int insertIndex = this.m_pivotList.getItems().indexOf(this) + 1;
        for (int i = this.m_hiddens.size() - 1; i >= 0; --i) {
            this.m_pivotList.getItems().add(insertIndex, this.m_hiddens.get(i));
        }
        this.m_pivotList.getItems().remove(this);
    }

    private String buildKeyString(FIXGRIDPivotItem item, String upToKey) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.m_pivotList.getPivotKeys().size(); ++i) {
            String key = this.m_pivotList.getPivotKeys().get(i);
            String value = item.m_keyValues.get(key);
            result.append("/" + value);
            if (key.equals(upToKey)) break;
        }
        return result.toString();
    }

    private int indexOfKey(String key) {
        for (int i = 0; i < this.m_pivotList.getPivotKeys().size(); ++i) {
            if (!this.m_pivotList.getPivotKeys().get(i).equals(key)) continue;
            return i;
        }
        throw new Error("Should never happen!");
    }

    public class ItemCallMap
    extends HashMap<String, ItemCall>
    implements Serializable {
        @Override
        public ItemCall get(Object key) {
            ItemCall result = new ItemCall();
            result.i_key = key.toString();
            return result;
        }
    }

    public class SortValueMap
    extends HashMap<String, String> {
        @Override
        public String get(Object key) {
            String k = key.toString();
            StringBuffer concatenatedValue = new StringBuffer();
            for (String kn : FIXGRIDPivotItem.this.m_pivotList.getPivotKeys()) {
                String value = FIXGRIDPivotItem.this.m_keyValues.get(kn);
                concatenatedValue.append("////");
                concatenatedValue.append(value);
                if (!k.equals(kn)) continue;
                break;
            }
            return concatenatedValue.toString();
        }
    }

    public class ItemCall
    implements Serializable {
        String i_key;

        public void onToggle(ActionEvent ae) {
            String s = FIXGRIDPivotItem.this.getK().get(this.i_key);
            if (s == null || s.equals("")) {
                FIXGRIDPivotItem prevItem;
                if (FIXGRIDPivotItem.this.m_pivotList.getDelegeateToggleToUpperNode() && (prevItem = FIXGRIDPivotItem.this.findPivotItemBeforeWithFilledKey(this.i_key)) != null) {
                    prevItem.togglePivot(this.i_key);
                }
            } else {
                FIXGRIDPivotItem.this.togglePivot(this.i_key);
            }
        }
    }
}

