/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.messages;

import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.eclnt.jsfserver.cluster.ClusterMessageBus;
import org.eclnt.jsfserver.cluster.IClusterMessageQueueListener;
import org.eclnt.jsfserver.defaultscreens.CentralPolling;
import org.eclnt.jsfserver.messages.ClientMessageBus;
import org.eclnt.jsfserver.messages.CrossDialogMessage;
import org.eclnt.jsfserver.messages.IDialogMessageBusListener;
import org.eclnt.jsfserver.session.UsageWithoutSessionContext;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ISessionAbstraction;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.JAXBManager;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;

public class DialogMessageBus {
    static final String s_nodeId = UniqueIdCreator.createUUID();
    Set<IDialogMessageBusListener> m_listeners = new HashSet<IDialogMessageBusListener>();
    String m_httpSessionId = null;
    String m_dialogSessionId = null;
    String m_clientId = null;
    Vector<Object> m_bufferedMessages = new Vector();
    CentralPolling m_centralPolling;
    CentralPolling.IListener m_centralPollingListener;
    MyClusterMessageQueueListener m_clusterMessageQueueListener;
    String m_explicitClusterClientId;

    public static DialogMessageBus instance() {
        return DialogMessageBus.instance(true);
    }

    public static DialogMessageBus instance(boolean createIfNotExists) {
        if (!HttpSessionAccess.checkIfJustProcessingRequest() && !UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            throw new Error("You may only access the DialogMessageBus instsance within the context of a request / response processing.");
        }
        return DialogMessageBus.instance(HttpSessionAccess.getCurrentHttpSession(), HttpSessionAccess.getCurrentDialogSession(), createIfNotExists);
    }

    public static DialogMessageBus instance(HttpSession httpSession, ISessionAbstraction dialogSession, boolean createIfNotExists) {
        DialogMessageBus result = (DialogMessageBus)dialogSession.getAttribute(DialogMessageBus.class.getName());
        if (result == null && createIfNotExists) {
            result = new DialogMessageBus(httpSession, dialogSession);
            dialogSession.setAttribute(DialogMessageBus.class.getName(), result);
        }
        return result;
    }

    DialogMessageBus(HttpSession httpSession, ISessionAbstraction dialogSession) {
        this.m_dialogSessionId = dialogSession.getId();
        this.m_httpSessionId = httpSession.getId();
        this.m_clientId = HttpSessionAccess.getCurrentClientId(true);
        this.m_centralPolling = CentralPolling.instance();
        this.register(dialogSession);
        this.registerInClusterMessaging();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IDialogMessageBusListener listener) {
        if (listener == null) {
            return;
        }
        Set<IDialogMessageBusListener> set = this.m_listeners;
        synchronized (set) {
            this.m_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IDialogMessageBusListener listenerToRemove) {
        if (listenerToRemove == null) {
            return;
        }
        Set<IDialogMessageBusListener> set = this.m_listeners;
        synchronized (set) {
            this.m_listeners.remove(listenerToRemove);
        }
    }

    public void publishMessage(Object message) {
        CrossDialogMessage cdm;
        if (message == null) {
            return;
        }
        if (message instanceof CrossDialogMessage && !(cdm = (CrossDialogMessage)message).getSendingDialogSessionId().equals(this.m_dialogSessionId)) {
            CLog.L.log(CLog.LL_INF, "Message is addressed to different session and is buffered " + cdm.getMessageType());
            boolean relevant = this.checkIfMessageIsRelevantForOneListener(message);
            if (relevant) {
                this.outputLogIfNoUnifiedPolling();
                this.bufferMessageForClientPolling(cdm);
            }
            return;
        }
        if (HttpSessionAccess.checkIfRunningInUIThread()) {
            CLog.L.log(CLog.LL_INF, "Message is published immediately " + message.getClass().getName());
            this.publishMessageLocally(message);
        } else {
            this.publishMessageForAsynchronousPickup(message);
        }
    }

    private void publishMessageForAsynchronousPickup(Object message) {
        boolean relevant = this.checkIfMessageIsRelevantForOneListener(message);
        if (relevant) {
            this.outputLogIfNoUnifiedPolling();
            if (!SystemXml.getDialogMessageBusAsynchronous()) {
                return;
            }
            CLog.L.log(CLog.LL_INF, "DialogMessageBus: Message is buffered to be asynchronously called by polling " + message.getClass().getName());
            this.bufferMessageForClientPolling(message);
        }
    }

    public void publishMessageToAllClientDialogs(CrossDialogMessage message) {
        if (message == null) {
            return;
        }
        message.initializeForPublishing(s_nodeId, this.m_clientId, this.m_dialogSessionId, this.m_httpSessionId);
        ClientMessageBus.instance(this.m_clientId, true).publishMessage(message);
        ClusterMessageBus.instance().publishMessageToAllClusterClientDialogs(message);
    }

    public String getExplicitClusterClientId() {
        return this.m_explicitClusterClientId;
    }

    public void setExplicitClusterClientId(String explicitClusterClientId) {
        this.m_explicitClusterClientId = explicitClusterClientId;
    }

    private void registerInClusterMessaging() {
        if (!ClusterMessageBus.instance().isActive()) {
            return;
        }
        this.m_clusterMessageQueueListener = new MyClusterMessageQueueListener();
        ClusterMessageBus.instance().getClusterMessageQueue().addMessageListener(ClusterMessageBus.instance().getTopicForCluster(), this.m_clusterMessageQueueListener);
    }

    private void register(ISessionAbstraction dialogSession) {
        this.m_centralPollingListener = new CentralPolling.IListener(){

            @Override
            public void reactOnPollingAction() {
                DialogMessageBus.this.processMessageQueue();
            }
        };
        this.m_centralPolling.addListener(this.m_centralPollingListener);
        ClientMessageBus cb = ClientMessageBus.instance(this.m_clientId, true);
        cb.registerDialogMessageBus(this);
    }

    public void destroy() {
        this.m_centralPolling.removeListener(this.m_centralPollingListener);
        try {
            if (ClusterMessageBus.instance().isActive()) {
                ClusterMessageBus.instance().getClusterMessageQueue().removeMessageListener(ClusterMessageBus.instance().getTopicForCluster(), this.m_clusterMessageQueueListener);
                this.m_clusterMessageQueueListener = null;
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem de-registering from cluster message bus", t);
        }
        try {
            ClientMessageBus cmb = ClientMessageBus.instance(this.m_clientId, false);
            if (cmb != null) {
                cmb.unregisterDialogMessageBus(this);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem de-registering from client message bus", t);
        }
        this.m_listeners.clear();
    }

    private void bufferMessageForClientPolling(Object cdm) {
        this.m_bufferedMessages.add(cdm);
        this.m_centralPolling.wakeup();
    }

    protected void processMessageQueue() {
        ArrayList<Object> messages = new ArrayList<Object>(this.m_bufferedMessages);
        this.m_bufferedMessages.clear();
        CLog.L.log(CLog.LL_INF, "DialogMessageBus: processMessageQueue is called, number of messages: " + messages.size());
        for (Object e : messages) {
            this.publishMessageLocally(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfMessageIsRelevantForOneListener(Object message) {
        HashSet<IDialogMessageBusListener> listeners = null;
        Set<IDialogMessageBusListener> set = this.m_listeners;
        synchronized (set) {
            listeners = new HashSet<IDialogMessageBusListener>(this.m_listeners);
        }
        for (IDialogMessageBusListener listener : listeners) {
            try {
                boolean relevant = listener.checkIfMessageIsRelevant(message);
                if (!relevant) continue;
                return true;
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem during checking relevance of message: " + t, t);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishMessageLocally(Object message) {
        HashSet<IDialogMessageBusListener> listeners = null;
        Set<IDialogMessageBusListener> set = this.m_listeners;
        synchronized (set) {
            listeners = new HashSet<IDialogMessageBusListener>(this.m_listeners);
        }
        for (IDialogMessageBusListener listener : listeners) {
            try {
                boolean relevant = listener.checkIfMessageIsRelevant(message);
                if (!relevant) continue;
                CLog.L.log(CLog.LL_INF, "DialogMessageBus: processing message in listener: " + listener.getClass().getName());
                listener.reactOnMessage(message);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem executing message: " + t, t);
            }
        }
    }

    private void outputLogIfNoUnifiedPolling() {
        if (!SystemXml.getDialogMessageBusAsynchronous()) {
            CLog.L.log(CLog.LL_ERR, "Problem during message processing: the message requires the central polling to be switched on.\nsystem.xml: ...<dialogmessagebus crossclient=\"true\".../>");
        }
    }

    protected void processClusterMessage(String topic, String message) {
        if (ValueManager.checkIfStringsAreEqual(topic, ClusterMessageBus.instance().getTopicForCluster())) {
            try {
                CrossDialogMessage cdm = (CrossDialogMessage)JAXBManager.unmarshal(message, CrossDialogMessage.class);
                if (this.checkIfDoubleProcessingForClusterMessage(cdm)) {
                    return;
                }
                CLog.L.log(CLog.LL_INF, "DialogMessageBus: received cluster message");
                boolean processThisMessage = false;
                if (this.m_explicitClusterClientId != null && ValueManager.checkIfStringsAreEqual(this.m_explicitClusterClientId, cdm.getSendingHttpSessionId())) {
                    processThisMessage = true;
                }
                if (!processThisMessage && ValueManager.checkIfStringsAreEqual(cdm.getSendingClientId(), this.m_clientId)) {
                    processThisMessage = true;
                }
                if (!processThisMessage) {
                    CLog.L.log(CLog.LL_INF, "DialogMessageBus: cluster message is not relevant - neither explicit clusterClientId nor clientId are matching");
                    return;
                }
                cdm.initializeForPublishing(s_nodeId, this.m_clientId, this.m_dialogSessionId, this.m_httpSessionId);
                CLog.L.log(CLog.LL_INF, "DialogMessageBus: cluster message relevant");
                this.publishMessageForAsynchronousPickup(cdm);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Could not process cluster message: " + message, t);
            }
        }
    }

    private boolean checkIfDoubleProcessingForClusterMessage(CrossDialogMessage cdm) {
        if (ValueManager.checkIfStringsAreEqual(s_nodeId, cdm.getSendingNodeId())) {
            return true;
        }
        return ValueManager.checkIfStringsAreEqual(this.m_dialogSessionId, cdm.getSendingDialogSessionId());
    }

    public class MyClusterMessageQueueListener
    implements IClusterMessageQueueListener {
        @Override
        public void processMessage(String topic, String message) {
            DialogMessageBus.this.processClusterMessage(topic, message);
        }
    }
}

