/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.pagebean.util;

import java.util.Hashtable;
import java.util.Map;
import org.eclnt.jsfserver.managedbean.DefaultHotDeployListener;
import org.eclnt.jsfserver.managedbean.HotDeployNotifier;
import org.eclnt.jsfserver.util.PageReader;
import org.eclnt.util.log.CLog;

public class FindPageBeanExpressionInPageXml {
    static final Map<String, RootExpressionResult> s_resultBuffer = new Hashtable<String, RootExpressionResult>();

    public static void clearBuffer() {
        s_resultBuffer.clear();
    }

    public static RootExpressionResult findRootExpressionInJSP(String pageName) {
        if (pageName == null) {
            return new RootExpressionResult(null, null, false);
        }
        RootExpressionResult mresult = s_resultBuffer.get(pageName);
        if (mresult != null) {
            return mresult;
        }
        try {
            int index;
            String jsp = PageReader.readXMLForAbsolutePageName(pageName);
            String expressionPrefix = "#{d.";
            int currentIndex = 0;
            String result = null;
            while ((index = jsp.indexOf(expressionPrefix, currentIndex)) > 0) {
                int nextIndex1 = jsp.indexOf(".", index + expressionPrefix.length());
                int nextIndex2 = jsp.indexOf("}", index + expressionPrefix.length());
                int nextIndex = nextIndex2;
                if (nextIndex < 0) {
                    return null;
                }
                String name = null;
                name = nextIndex1 >= 0 && nextIndex1 < nextIndex2 ? jsp.substring(index + expressionPrefix.length(), nextIndex1) : jsp.substring(index + expressionPrefix.length(), nextIndex2);
                if (name.length() > 0 && Character.isUpperCase(name.charAt(0))) {
                    if (result != null && !result.equals(name)) {
                        return new RootExpressionResult(null, null, true);
                    }
                    result = name;
                }
                currentIndex = nextIndex2;
            }
            mresult = result != null ? new RootExpressionResult(result, "#{d." + result + "}", false) : new RootExpressionResult(null, null, false);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Could not find root expression by analyzing page layout", t);
            mresult = new RootExpressionResult(null, null, false);
        }
        s_resultBuffer.put(pageName, mresult);
        return mresult;
    }

    static {
        HotDeployNotifier.addListener(new DefaultHotDeployListener(){

            @Override
            public void onClassLoaderUpdate(ClassLoader newClassLoader) {
                FindPageBeanExpressionInPageXml.clearBuffer();
            }
        });
    }

    public static class RootExpressionResult {
        String i_pageBeanName;
        String i_rootExpression;
        boolean i_moreThan2Expressions;

        public RootExpressionResult(String pageBeanName, String rootExpression, boolean moreThan2Expressions) {
            this.i_pageBeanName = pageBeanName;
            this.i_rootExpression = rootExpression;
            this.i_moreThan2Expressions = moreThan2Expressions;
        }

        public String getRootExpression() {
            return this.i_rootExpression;
        }

        public boolean getMoreThan2Expressions() {
            return this.i_moreThan2Expressions;
        }
    }
}

