/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.streamstore;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclnt.jsfserver.streamstore.IJDBCConnectionProvider;
import org.eclnt.jsfserver.streamstore.IJDBCConnectionProvider2;
import org.eclnt.jsfserver.streamstore.IJDBCConnectionProviderTenantValueTransform;
import org.eclnt.jsfserver.streamstore.IStreamStore;
import org.eclnt.jsfserver.streamstore.JDBCConnectionProviderFactory;
import org.eclnt.jsfserver.streamstore.StreamStoreConfigPath;
import org.eclnt.jsfserver.util.useraccess.TenantAccessMgr;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class StreamStoreJDBC
implements IStreamStore {
    static boolean s_initialized = false;
    static Object SYNCHER = new Object();
    public static final String NULLOBJECT = new String();
    StreamStoreConfigPath m_streamStoreConfigPath = new StreamStoreConfigPath();
    IJDBCConnectionProvider2 m_connectionProvider;

    public void setConnectionProvider(IJDBCConnectionProvider2 connectionProvider) {
        this.m_connectionProvider = connectionProvider;
    }

    public IJDBCConnectionProvider2 getConnectionProvider() {
        return this.m_connectionProvider;
    }

    @Override
    public List<String> getContainedStreams(String path, boolean withError) {
        Connection c = null;
        Statement ps = null;
        try {
            IJDBCConnectionProvider2 provider = this.retrieveConnectionProvider();
            c = provider.createConnection();
            c.setAutoCommit(false);
            this.init(c, provider);
            String tenant = this.currentTenantValue(provider);
            path = ValueManager.encodeIntoValidStreamStorePath(path, true);
            String sql = "SELECT C_NAME FROM " + this.tableName("CCSTREAMSTORE", provider) + " WHERE C_TENANT=?   AND C_DIRECTORY=? ";
            CLog.L.log(CLog.LL_INF, "Streamstore: " + sql);
            ps = c.prepareStatement(sql);
            ps.clearParameters();
            ps.setString(1, tenant);
            ps.setString(2, path);
            ResultSet rs = ps.executeQuery();
            ArrayList<String> result = new ArrayList<String>();
            while (rs.next()) {
                result.add(rs.getString(1));
            }
            this.m_streamStoreConfigPath.addContainedStreams(result, path, true);
            Collections.sort(result);
            ps.close();
            c.close();
            return result;
        }
        catch (Throwable t) {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Throwable tt) {
                CLog.L.log(CLog.LL_ERR, "Problem when closing statement", tt);
            }
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable tt) {
                CLog.L.log(CLog.LL_ERR, "Problem when closing connection", tt);
            }
            if (withError) {
                throw new Error(t);
            }
            return new ArrayList<String>();
        }
    }

    @Override
    public List<String> getContainedFolders(String path, boolean withError) {
        Connection c = null;
        Statement ps = null;
        try {
            IJDBCConnectionProvider2 provider = this.retrieveConnectionProvider();
            c = provider.createConnection();
            c.setAutoCommit(false);
            this.init(c, provider);
            String tenant = this.currentTenantValue(provider);
            path = ValueManager.encodeIntoValidStreamStorePath(path, true);
            String sql = "SELECT C_DIRECTORY FROM " + this.tableName("CCSTREAMSTORE", provider) + " WHERE C_TENANT=?   AND C_DIRECTORY LIKE ? ";
            CLog.L.log(CLog.LL_INF, "Streamstore: " + sql);
            ps = c.prepareStatement(sql);
            ps.clearParameters();
            ps.setString(1, tenant);
            ps.setString(2, path + "%");
            ResultSet rs = ps.executeQuery();
            HashSet<String> directorySet = new HashSet<String>();
            while (rs.next()) {
                directorySet.add(rs.getString(1));
            }
            HashSet<String> resultMap = new HashSet<String>();
            int pathLength = path.length();
            for (String directory : directorySet) {
                String remaining = directory.substring(pathLength);
                if (remaining.length() == 0) continue;
                int index = (remaining = remaining.substring(0, remaining.length() - 1)).indexOf(47);
                if (index < 0) {
                    resultMap.add(remaining);
                    continue;
                }
                resultMap.add(remaining.substring(0, index));
            }
            ArrayList<String> resultList = new ArrayList<String>();
            resultList.addAll(resultMap);
            Collections.sort(resultList);
            ps.close();
            c.close();
            return resultList;
        }
        catch (Throwable t) {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Throwable tt) {
                CLog.L.log(CLog.LL_ERR, "Problem when closing statement", tt);
            }
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable tt) {
                CLog.L.log(CLog.LL_ERR, "Problem when closing connection", tt);
            }
            if (withError) {
                throw new Error(t);
            }
            return new ArrayList<String>();
        }
    }

    @Override
    public String readUTF8(String path, boolean withError) {
        return this.readUTF8(path, withError, false);
    }

    public String readUTF8(String path, boolean withError, boolean returnContentNullAsObject) {
        Connection c = null;
        Statement ps = null;
        try {
            IJDBCConnectionProvider2 provider = this.retrieveConnectionProvider();
            c = provider.createConnection();
            c.setAutoCommit(false);
            this.init(c, provider);
            String tenant = this.currentTenantValue(provider);
            path = ValueManager.encodeIntoValidStreamStorePath(path, false);
            CLog.L.log(CLog.LL_INF, "StreamstoreJDBC: readUTF8 path: " + path + ", tenant: " + tenant);
            int lastSlashIndex = path.lastIndexOf(47);
            String directory = path.substring(0, lastSlashIndex + 1);
            String name = path.substring(lastSlashIndex + 1);
            String sql = "SELECT C_CONTENT FROM " + this.tableName("CCSTREAMSTORE", provider) + " WHERE C_TENANT=?   AND C_DIRECTORY=?   AND C_NAME=? ";
            CLog.L.log(CLog.LL_INF, "Streamstore: " + sql);
            ps = c.prepareStatement(sql);
            ps.clearParameters();
            ps.setString(1, tenant);
            ps.setString(2, directory);
            ps.setString(3, name);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String result = rs.getString(1);
                ps.close();
                c.close();
                if (result == null && returnContentNullAsObject) {
                    result = NULLOBJECT;
                }
                return result;
            }
            ps.close();
            c.close();
            return this.m_streamStoreConfigPath.readUTF8(path, withError);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem during JDBC Streamstore access: " + t.getMessage());
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Throwable tt) {
                CLog.L.log(CLog.LL_ERR, "Problem when closing statement", tt);
            }
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable tt) {
                CLog.L.log(CLog.LL_ERR, "Problem when closing connection", tt);
            }
            if (withError) {
                throw new Error("Problem occurred when reading stream store content: " + path, t);
            }
            return null;
        }
    }

    @Override
    public void writeUTF8(String path, String xml, boolean withError) {
        block13: {
            Connection c = null;
            Statement ps = null;
            try {
                IJDBCConnectionProvider2 provider = this.retrieveConnectionProvider();
                c = provider.createConnection();
                c.setAutoCommit(false);
                this.init(c, provider);
                String tenant = this.currentTenantValue(provider);
                path = ValueManager.encodeIntoValidStreamStorePath(path, false);
                CLog.L.log(CLog.LL_INF, "StreamstoreJDBC: writeUTF8 path: " + path + ", tenant: " + tenant);
                int lastSlashIndex = path.lastIndexOf(47);
                String directory = path.substring(0, lastSlashIndex + 1);
                String name = path.substring(lastSlashIndex + 1);
                boolean alreadyExists = this.checkIfStreamExists(path, false);
                if (!alreadyExists) {
                    String sql = "INSERT INTO " + this.tableName("CCSTREAMSTORE", provider) + " (C_TENANT, C_DIRECTORY, C_NAME, C_CONTENT) VALUES (?,?,?,?)";
                    CLog.L.log(CLog.LL_INF, "Streamstore: " + sql);
                    ps = c.prepareStatement(sql);
                    ps.clearParameters();
                    ps.setString(1, tenant);
                    ps.setString(2, directory);
                    ps.setString(3, name);
                    ps.setString(4, xml);
                    ps.execute();
                } else {
                    String sql = "UPDATE " + this.tableName("CCSTREAMSTORE", provider) + " SET C_CONTENT=? WHERE C_TENANT=?   AND C_DIRECTORY=?   AND C_NAME=? ";
                    CLog.L.log(CLog.LL_INF, "Streamstore: " + sql);
                    ps = c.prepareStatement(sql);
                    ps.clearParameters();
                    ps.setString(1, xml);
                    ps.setString(2, tenant);
                    ps.setString(3, directory);
                    ps.setString(4, name);
                    ps.execute();
                }
                c.commit();
                ps.close();
                c.close();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Problem when writing string to streamstore", t);
                try {
                    if (c != null) {
                        c.rollback();
                    }
                }
                catch (Throwable tt) {
                    CLog.L.log(CLog.LL_ERR, "Problem when rolling back connection", tt);
                }
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (Throwable tt) {
                    CLog.L.log(CLog.LL_ERR, "Problem when closing statement", tt);
                }
                try {
                    if (c != null) {
                        c.close();
                    }
                }
                catch (Throwable tt) {
                    CLog.L.log(CLog.LL_ERR, "Problem when closing connection", tt);
                }
                if (!withError) break block13;
                throw new Error(t);
            }
        }
    }

    @Override
    public void removeStream(String path, boolean withError) {
        block12: {
            Connection c = null;
            Statement ps = null;
            try {
                IJDBCConnectionProvider2 provider = this.retrieveConnectionProvider();
                c = provider.createConnection();
                c.setAutoCommit(false);
                this.init(c, provider);
                String tenant = this.currentTenantValue(provider);
                path = ValueManager.encodeIntoValidStreamStorePath(path, false);
                CLog.L.log(CLog.LL_INF, "StreamstoreJDBC: removeStream path: " + path + ", tenant: " + tenant);
                int lastSlashIndex = path.lastIndexOf(47);
                String directory = path.substring(0, lastSlashIndex + 1);
                String name = path.substring(lastSlashIndex + 1);
                boolean alreadyExists = this.checkIfStreamExists(path, withError);
                if (alreadyExists) {
                    String sql = "DELETE FROM " + this.tableName("CCSTREAMSTORE", provider) + " WHERE C_TENANT=?   AND C_DIRECTORY=?   AND C_NAME=? ";
                    CLog.L.log(CLog.LL_INF, "Streamstore: " + sql);
                    ps = c.prepareStatement(sql);
                    ps.clearParameters();
                    ps.setString(1, tenant);
                    ps.setString(2, directory);
                    ps.setString(3, name);
                    ps.executeUpdate();
                    c.commit();
                    ps.close();
                }
                c.close();
            }
            catch (Throwable t) {
                try {
                    if (c != null) {
                        c.rollback();
                    }
                }
                catch (Throwable tt) {
                    CLog.L.log(CLog.LL_ERR, "Problem when rolling back connection", tt);
                }
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (Throwable tt) {
                    CLog.L.log(CLog.LL_ERR, "Problem when closing statement", tt);
                }
                try {
                    if (c != null) {
                        c.close();
                    }
                }
                catch (Throwable tt) {
                    CLog.L.log(CLog.LL_ERR, "Problem when closing connection", tt);
                }
                if (!withError) break block12;
                throw new Error(t);
            }
        }
    }

    @Override
    public boolean checkIfStreamExists(String path, boolean withError) {
        try {
            String content = this.readUTF8(path, true, true);
            return content != null;
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error(t);
            }
            return false;
        }
    }

    private void createTables(Connection c, IJDBCConnectionProvider2 provider) {
        try {
            CLog.L.log(CLog.LL_INF, "Creating tables with datatype CLOB");
            this.createTables(c, provider, "CLOB");
        }
        catch (Throwable t1) {
            CLog.L.log(CLog.LL_INF, "Creating tables with datatype CLOB failed", t1);
            try {
                CLog.L.log(CLog.LL_INF, "Creating tables with datatype TEXT");
                this.createTables(c, provider, "TEXT");
            }
            catch (Throwable t2) {
                CLog.L.log(CLog.LL_INF, "Creating tables with datatype TEXT failed", t2);
                try {
                    CLog.L.log(CLog.LL_INF, "Creating tables with datatype LONGVARCAHR");
                    this.createTables(c, provider, "LONGVARCHAR");
                }
                catch (Throwable t3) {
                    CLog.L.log(CLog.LL_INF, "Creating tables with datatype LONGVARCHAR failed", t3);
                    throw new Error(t3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTables(Connection c, IJDBCConnectionProvider2 provider, String longvarcharDataTypeName) {
        boolean createPing = true;
        boolean createStore = true;
        Statement s = null;
        try {
            CLog.L.log(CLog.LL_INF, "Checking if to create CCSTREAMSTOREPING...");
            s = c.createStatement();
            s.executeQuery("SELECT * FROM " + this.tableName("CCSTREAMSTOREPING", provider));
            CLog.L.log(CLog.LL_INF, "... is already available!");
            createPing = false;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "... must be created!");
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Throwable tt) {
                CLog.L.log(CLog.LL_ERR, "Problem when closing statement", tt);
            }
        }
        s = null;
        try {
            CLog.L.log(CLog.LL_INF, "Checking if to create CCSTREAMSTORE...");
            s = c.createStatement();
            s.executeQuery("SELECT * FROM " + this.tableName("CCSTREAMSTORE", provider));
            CLog.L.log(CLog.LL_INF, "... is already available!");
            createStore = false;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "... must be created!");
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Throwable tt) {
                CLog.L.log(CLog.LL_ERR, "Problem when closing statement", tt);
            }
        }
        s = null;
        try {
            String sql;
            CLog.L.log(CLog.LL_INF, "Creating tables...");
            c.rollback();
            if (createStore) {
                CLog.L.log(CLog.LL_INF, "...CCSTREAMSTORE");
                s = c.createStatement();
                sql = "CREATE TABLE " + this.tableName("CCSTREAMSTORE", provider) + " ( C_TENANT VARCHAR(100) NOT NULL, C_DIRECTORY VARCHAR(250) NOT NULL, C_NAME VARCHAR(250) NOT NULL, C_CONTENT " + longvarcharDataTypeName + ", PRIMARY KEY (C_TENANT, C_DIRECTORY, C_NAME) )";
                CLog.L.log(CLog.LL_INF, "Streamstore: " + sql);
                s.executeUpdate(sql);
                s.close();
            }
            if (createPing) {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Throwable tt) {
                    CLog.L.log(CLog.LL_ERR, "Problem when closing statement", tt);
                }
                CLog.L.log(CLog.LL_INF, "...CCSTREAMSTOREPING");
                s = c.createStatement();
                sql = "CREATE TABLE " + this.tableName("CCSTREAMSTOREPING", provider) + " ( C_ID VARCHAR(10) NOT NULL, PRIMARY KEY (C_ID))";
                CLog.L.log(CLog.LL_INF, "Streamstore: " + sql);
                s.executeUpdate(sql);
                s.close();
            }
            c.commit();
        }
        catch (Throwable t) {
            try {
                c.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            CLog.L.log(CLog.LL_ERR, "Error when creating tables", t);
            throw new Error(t);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Throwable tt) {
                CLog.L.log(CLog.LL_ERR, "Problem when closing statement", tt);
            }
        }
    }

    protected IJDBCConnectionProvider2 retrieveConnectionProvider() {
        if (this.m_connectionProvider != null) {
            return this.m_connectionProvider;
        }
        IJDBCConnectionProvider2 provider = JDBCConnectionProviderFactory.getProvider2();
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Connection c, IJDBCConnectionProvider2 provider) {
        String tenant = this.currentTenantValue(provider);
        if (!s_initialized) {
            Object object = SYNCHER;
            synchronized (object) {
                if (!s_initialized) {
                    CLog.L.log(CLog.LL_INF, "Initialization of StreamStoreJDBC for tenant: " + tenant);
                    if (c == null) {
                        throw new Error("Connection returned by JDBCConnection Provider is null");
                    }
                    Statement s = null;
                    try {
                        s = c.createStatement();
                        CLog.L.log(CLog.LL_INF, "Pinging for table CCSTREAMSTOREPING");
                        s.executeQuery("SELECT * FROM " + this.tableName("CCSTREAMSTOREPING", provider));
                        s.close();
                    }
                    catch (Throwable t) {
                        try {
                            if (s != null) {
                                s.close();
                            }
                        }
                        catch (Throwable tt) {
                            CLog.L.log(CLog.LL_ERR, "Problem when closing statement", tt);
                        }
                        CLog.L.log(CLog.LL_INF, "Error when pinging for table CCSTREAMSTOREPING: " + t.toString());
                        this.createTables(c, provider);
                    }
                    s_initialized = true;
                }
            }
        }
    }

    private String tableName(String tableName, IJDBCConnectionProvider2 provider) {
        String result = null;
        String schema = provider.getDatabaseSchemaName();
        result = schema == null ? tableName : schema + "." + tableName;
        StreamStoreJDBC.sanitizeTableName(result);
        return result;
    }

    public static void JUNIT_sanitizeTableName(String tableName) {
        StreamStoreJDBC.sanitizeTableName(tableName);
    }

    private static void sanitizeTableName(String tableName) {
        if (!tableName.matches("^[a-zA-Z0-9_.]+$")) {
            throw new IllegalArgumentException("Invalid table name format");
        }
    }

    private String currentTenantValue(IJDBCConnectionProvider provider) {
        String result = null;
        if (provider instanceof IJDBCConnectionProviderTenantValueTransform) {
            result = ((IJDBCConnectionProviderTenantValueTransform)((Object)provider)).getFixPersistentValueOfTenant();
            if (result == null) {
                result = TenantAccessMgr.getCurrentTenant();
                result = ((IJDBCConnectionProviderTenantValueTransform)((Object)provider)).getPersistentValueOfTenant(result);
            }
        } else {
            result = TenantAccessMgr.getCurrentTenant();
        }
        return result;
    }
}

