/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.eclnt.jsfserver.util.CompressionResponseStream;

class CompressionResponseWrapper
extends HttpServletResponseWrapper {
    protected HttpServletResponse m_origResponse = null;
    protected ServletOutputStream m_stream = null;
    protected PrintWriter m_writer = null;

    public CompressionResponseWrapper(HttpServletResponse httpservletresponse) {
        super(httpservletresponse);
        this.m_origResponse = httpservletresponse;
    }

    public ServletOutputStream createOutputStream() throws IOException {
        return new CompressionResponseStream(this.m_origResponse);
    }

    public void finishResponse() {
        try {
            if (this.m_writer != null) {
                this.m_writer.close();
            } else if (this.m_stream != null) {
                this.m_stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flushBuffer() throws IOException {
        if (this.m_stream != null) {
            this.m_stream.flush();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.m_writer != null) {
            throw new IllegalStateException("getWriter() has already been called!");
        }
        if (this.m_stream == null) {
            this.m_stream = this.createOutputStream();
        }
        return this.m_stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.m_writer != null) {
            return this.m_writer;
        }
        if (this.m_stream != null) {
            throw new IllegalStateException("getOutputStream() has already been called!");
        }
        this.m_stream = this.createOutputStream();
        this.m_writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.m_stream, "UTF-8"));
        return this.m_writer;
    }

    public void setContentLength(int i) {
    }
}

