/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import jakarta.el.ELContext;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclnt.jsfserver.base.faces.application.Application;
import org.eclnt.jsfserver.base.faces.context.ExternalContext;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.elements.ComponentDump;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.session.SessionInfo;
import org.eclnt.jsfserver.session.UsageWithoutSessionContext;
import org.eclnt.jsfserver.util.ClientDeviceInfo;
import org.eclnt.jsfserver.util.DialogSessionListenerMgmt;
import org.eclnt.jsfserver.util.HttpSessionListenerDelegator;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.IDialogSessionListener;
import org.eclnt.jsfserver.util.IHttpSessionClosedReactor;
import org.eclnt.jsfserver.util.IHttpSessionListener;
import org.eclnt.jsfserver.util.IMethodBindingListener;
import org.eclnt.jsfserver.util.ISessionAbstraction;
import org.eclnt.jsfserver.util.ISessionAbstractionListener;
import org.eclnt.jsfserver.util.ISessionContextProvider;
import org.eclnt.jsfserver.util.IValueBindingListener;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.SessionAbstractionHttpSession;
import org.eclnt.jsfserver.util.SessionAbstractionSubpageContext;
import org.eclnt.jsfserver.util.SubpageContext;
import org.eclnt.jsfserver.util.TypeOfSessionMgmt;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;

public class HttpSessionAccess
implements ICCServerConstants {
    static ServletContext s_servletContext;

    public static void initialize(ServletContext servletContext) {
        s_servletContext = servletContext;
    }

    public static FacesContext getCurrentFacesContext() {
        FacesContext result = null;
        try {
            result = FacesContext.getCurrentInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (result == null) {
            result = (FacesContext)HttpSessionAccess.getCurrentDialogSession().getAttribute("ccfacescontext");
        }
        return result;
    }

    public static Application getCurrentFacesApplication(FacesContext context) {
        Application result = null;
        try {
            result = context.getApplication();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (result == null) {
            result = (Application)HttpSessionAccess.getCurrentDialogSession().getAttribute("ccapplication");
        }
        return result;
    }

    public static ELContext getCurrentELContext(FacesContext context) {
        ELContext result = null;
        try {
            result = context.getELContext();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (result == null) {
            result = (ELContext)HttpSessionAccess.getCurrentDialogSession().getAttribute("ccelcontext");
        }
        return result;
    }

    public static HttpSession getCurrentHttpSession() {
        try {
            ThreadData td = ThreadData.getInstance(false);
            if (td != null && td.getHttpSession() != null) {
                return td.getHttpSession();
            }
            FacesContext fc = FacesContext.getCurrentInstance();
            if (fc == null) {
                throw new RuntimeException("FacesContext is not available");
            }
            HttpSession result = HttpSessionAccess.getCurrentHttpSession(fc);
            if (result == null) {
                throw new RuntimeException("Session in faces context is not available.");
            }
            return result;
        }
        catch (Throwable t) {
            if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
                return UsageWithoutSessionContext.getDummyHttpSession(true);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new Error(t);
        }
    }

    public static HttpSession getCurrentHttpSessionIfAvailable(FacesContext context) {
        if (context == null && UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return UsageWithoutSessionContext.getDummyHttpSession(false);
        }
        ExternalContext extContext = context.getExternalContext();
        HttpSession session = (HttpSession)extContext.getSession(false);
        return session;
    }

    public static HttpSession getCurrentHttpSessionIfAvailable(ISessionContextProvider context) {
        if (context == null && UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return UsageWithoutSessionContext.getDummyHttpSession(false);
        }
        return context.getHttpSession();
    }

    public static HttpSession getCurrentHttpSession(FacesContext context) {
        if (context == null && UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return UsageWithoutSessionContext.getDummyHttpSession(true);
        }
        ExternalContext extContext = context.getExternalContext();
        HttpSession session = (HttpSession)extContext.getSession(true);
        return session;
    }

    public static HttpSession getCurrentHttpSession(ISessionContextProvider context) {
        if (context == null && UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return UsageWithoutSessionContext.getDummyHttpSession(true);
        }
        return context.getHttpSession();
    }

    public static ComponentDump getCurrentComponentDump(FacesContext context) {
        ThreadData threadData = ThreadData.getInstance();
        String subpageId = threadData.getSubpageId();
        HttpSession session = HttpSessionAccess.getCurrentHttpSession(context);
        return (ComponentDump)session.getAttribute(subpageId + "/" + "org.eclnt.jsfserver/currentDump");
    }

    public static ComponentDump getCurrentComponentDump(ISessionContextProvider context) {
        ThreadData threadData = ThreadData.getInstance();
        String subpageId = threadData.getSubpageId();
        HttpSession session = HttpSessionAccess.getCurrentHttpSession(context);
        return (ComponentDump)session.getAttribute(subpageId + "/" + "org.eclnt.jsfserver/currentDump");
    }

    public static ComponentDump getCurrentComponentDump(ISessionAbstraction httpSession, String subpageId) {
        return (ComponentDump)httpSession.getAttribute(subpageId + "/" + "org.eclnt.jsfserver/currentDump");
    }

    public static void addGlobalHttpSessionListener(IHttpSessionListener listener) {
        if (UsageWithoutSessionContext.isUsedWithSessionContext()) {
            HttpSessionListenerDelegator hsld = (HttpSessionListenerDelegator)s_servletContext.getAttribute("CCLISTENER_" + HttpSessionListenerDelegator.class.getName());
            if (hsld == null) {
                throw new Error("No instance of HttpSessionListenerDelegator found in s_servletContext.getAttributes. Should have been added by CCInitializeServlets.");
            }
            hsld.addGlobalSessionListener(listener);
        }
    }

    public static void removeGlobalHttpSessionListener(IHttpSessionListener listener) {
        if (UsageWithoutSessionContext.isUsedWithSessionContext()) {
            HttpSessionListenerDelegator hsld = (HttpSessionListenerDelegator)s_servletContext.getAttribute("CCLISTENER_" + HttpSessionListenerDelegator.class.getName());
            if (hsld == null) {
                throw new Error("No instance of HttpSessionListenerDelegator found in s_servletContext.getAttributes. Should have been added by CCInitializeServlets.");
            }
            hsld.removeGlobalSessionListener(listener);
        }
    }

    public static void addHttpSessionCloseReactorForCurrentSession(String id, IHttpSessionClosedReactor reactor) {
        if (UsageWithoutSessionContext.isUsedWithSessionContext()) {
            HttpSessionListenerDelegator hsld = HttpSessionAccess.getCurrentHttpSessionListenerDelegator();
            hsld.addReactor(id, reactor);
        }
    }

    public static void removeHttpSessionCloseReactorForCurrentSession(String id) {
        if (UsageWithoutSessionContext.isUsedWithSessionContext()) {
            HttpSessionListenerDelegator hsld = HttpSessionAccess.getCurrentHttpSessionListenerDelegator();
            hsld.removeReactor(id);
        }
    }

    public static void addGlobalDialogSessionListener(IDialogSessionListener listener) {
        if (UsageWithoutSessionContext.isUsedWithSessionContext()) {
            DialogSessionListenerMgmt.addListener(listener);
        }
    }

    public static void removeGlobalDialogSessionListener(IDialogSessionListener listener) {
        if (UsageWithoutSessionContext.isUsedWithSessionContext()) {
            DialogSessionListenerMgmt.removeListener(listener);
        }
    }

    public static void addDialogSessionClosedReactorForCurrentSession(ISessionAbstractionListener listener) {
        if (UsageWithoutSessionContext.isUsedWithSessionContext()) {
            ISessionAbstraction session = HttpSessionAccess.getCurrentDialogSession();
            session.addListener(listener);
        }
    }

    public static void removeDialogSessionClosedReactorForCurrentSession(ISessionAbstractionListener listener) {
        if (UsageWithoutSessionContext.isUsedWithSessionContext()) {
            ISessionAbstraction session = HttpSessionAccess.getCurrentDialogSession();
            session.removeListener(listener);
        }
    }

    public static HttpSessionListenerDelegator getCurrentHttpSessionListenerDelegator() {
        HttpSession session = HttpSessionAccess.getCurrentHttpSession();
        return HttpSessionAccess.getCurrentHttpSessionListenerDelegator(session);
    }

    public static HttpSessionListenerDelegator getCurrentHttpSessionListenerDelegator(HttpSession session) {
        HttpSessionListenerDelegator sessionInstance = (HttpSessionListenerDelegator)session.getAttribute(HttpSessionListenerDelegator.class.getName());
        if (sessionInstance == null && !UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            CLog.L.log(CLog.LL_WAR, "Could not find session instance of HttpSessionListenerDelegator.");
            CLog.L.log(CLog.LL_WAR, "Check you web.xml against web.xml_template if it contains a corresponding listener item.");
        }
        return sessionInstance;
    }

    public static ServletContext getServletContext() {
        return s_servletContext;
    }

    public static String getWebApplicationName() {
        if (s_servletContext == null) {
            if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
                return "undefined";
            }
            throw new Error("Application is not running in a servlet context.If calling this method from e.g. JUnit test processing, then use UsageWithoutSessionContext-API to switch to some default behavior.");
        }
        String result = s_servletContext.getContextPath();
        if ((result = result.replace("/", "")).equals("")) {
            result = "root";
        }
        return result;
    }

    public static String getServletTempDirectory() {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return UsageWithoutSessionContext.getServletTempDirectory();
        }
        return HttpSessionAccess.getServletTempDirectory(s_servletContext);
    }

    public static String getServletTempDirectory(ServletContext servletContext) {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return UsageWithoutSessionContext.getServletTempDirectory();
        }
        try {
            File f = (File)servletContext.getAttribute("jakarta.servlet.context.tempdir");
            String result = f.getAbsolutePath();
            result = ValueManager.encodeIntoValidFileName(result, true);
            return result;
        }
        catch (Throwable t) {
            if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
                String s = FileManager.getTempFileDirectory().getAbsolutePath();
                s = s + "/usagewithoutsessioncontext";
                s = ValueManager.encodeIntoValidFileName(s, true);
                return s;
            }
            CLog.L.log(CLog.LL_ERR, "Problem when accessing servlet temp directory", t);
            return "tempDirectoryNotAvailable";
        }
    }

    public static int getCurrentClientTimeZoneOffset() {
        try {
            return SessionInfo.getSessionInstance().getClientTimeZoneOffset();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem reading client time zone offset", t);
            return 0;
        }
    }

    public static Locale getCurrentClientLocale() {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return Locale.getDefault();
        }
        try {
            ISessionAbstraction dialogSession = HttpSessionAccess.getCurrentDialogSession();
            String language = (String)dialogSession.getAttribute("ccclientlanguage");
            String country = (String)dialogSession.getAttribute("ccclientcountry");
            return new Locale(language, country);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem detting currentClientLocale", t);
            return Locale.getDefault();
        }
    }

    public static HttpServletRequest getCurrentRequest() {
        try {
            ThreadData td = ThreadData.getInstance(false);
            if (td != null) {
                return td.getHttpRequest();
            }
            HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
            return request;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String getCurrentLocationHref() {
        try {
            return HttpSessionAccess.getCurrentRequest().getHeader("eclnt-locationhref");
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static HttpServletResponse getCurrentResponse() {
        try {
            ThreadData td = ThreadData.getInstance(false);
            if (td != null) {
                return td.getHttpResponse();
            }
            HttpServletResponse response = (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
            return response;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static void setValueBindingListener(IValueBindingListener vbl) {
        HttpSessionAccess.getCurrentHttpSession().setAttribute(IValueBindingListener.class.getName(), (Object)vbl);
    }

    public static IValueBindingListener getValueBindingListener() {
        return (IValueBindingListener)HttpSessionAccess.getCurrentHttpSession().getAttribute(IValueBindingListener.class.getName());
    }

    public static void setMethodBindingListener(IMethodBindingListener mbl) {
        HttpSessionAccess.getCurrentHttpSession().setAttribute(IMethodBindingListener.class.getName(), (Object)mbl);
    }

    public static IMethodBindingListener getMethodBindingListener() {
        return (IMethodBindingListener)HttpSessionAccess.getCurrentHttpSession().getAttribute(IMethodBindingListener.class.getName());
    }

    public static boolean checkIfInLayoutEditorPreview() {
        try {
            if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
                return false;
            }
            ISessionAbstraction session = HttpSessionAccess.getCurrentDialogSession();
            String ccpreview = (String)session.getAttribute("cc_preview");
            boolean result = ValueManager.decodeBoolean(ccpreview, false);
            return result;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static int getNumberDialogSessionsInHttpSession(HttpSession session) {
        return SubpageContext.getNumberOfSubContextsInHttpSession(session);
    }

    public static boolean checkIfDialogSessionInLayoutEditorPreview() {
        try {
            if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
                return false;
            }
            ISessionAbstraction session = HttpSessionAccess.getCurrentDialogSession();
            String ccpreview = (String)session.getAttribute("cc_preview_session");
            boolean result = ValueManager.decodeBoolean(ccpreview, false);
            return result;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String getCurrentRequestId() {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return UniqueIdCreator.createUUID();
        }
        if (!TypeOfSessionMgmt.getSessionMgmtViaCookie()) {
            return (String)HttpSessionAccess.getCurrentHttpSession().getAttribute("cc_requestid");
        }
        return (String)HttpSessionAccess.getCurrentSubpageContext().getAttribute("cc_requestid");
    }

    public static boolean checkIfCurrentHttpSessionWasDestroyedDuringInvokePhase() {
        try {
            if (HttpSessionAccess.getCurrentRequestId() != null) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static boolean checkIfCurrentHttpSessionWasDestroyedDuringInvokePhase(HttpSession session) {
        if (session == null) {
            return true;
        }
        try {
            SubpageContext spc;
            if (!TypeOfSessionMgmt.getSessionMgmtViaCookie() ? session.getAttribute("cc_requestid") != null : (spc = SubpageContext.getSubpageContext(session, ThreadData.getInstance().getSubpageId())).getAttribute("cc_requestid") != null) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static boolean checkIfCurrentHttpSessionWasDestroyedDuringInvokePhase(ISessionAbstraction session) {
        if (session == null) {
            return true;
        }
        try {
            SubpageContext spc;
            if (!TypeOfSessionMgmt.getSessionMgmtViaCookie() ? session.getAttribute("cc_requestid") != null : (spc = SubpageContext.getSubpageContext(session, ThreadData.getInstance().getSubpageId())).getAttribute("cc_requestid") != null) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static boolean checkIfRunningInEmbeddedMode() {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return false;
        }
        String url = HttpSessionAccess.getCurrentRequest().getRequestURL().toString();
        return url.startsWith("http://embedded/");
    }

    public static boolean checkIfRunningInMiniServerMode() {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return false;
        }
        try {
            String url = HttpSessionAccess.getCurrentRequest().getRequestURL().toString();
            return url.startsWith("mini://");
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "", t);
            return false;
        }
    }

    public static boolean checkIfJustProcessingRequest() {
        ThreadData td = ThreadData.getInstance(false);
        return td != null;
    }

    public static boolean checkIfCurrentSessionWasStartedByHttps() {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return false;
        }
        try {
            String startUrl = SessionInfo.getSessionInstance().getClientStartURL();
            if (startUrl == null) {
                return false;
            }
            return startUrl.startsWith("https://");
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String getCurrentClientType() {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return "risc";
        }
        HttpServletRequest request = HttpSessionAccess.getCurrentRequest();
        return HttpSessionAccess.getCurrentClientType(request);
    }

    public static String getCurrentClientType(HttpServletRequest request) {
        String result = request.getHeader("eclnt-client");
        if (result == null) {
            if (request.getRequestURI().contains("/faces/")) {
                String userAgent = request.getHeader("user-agent");
                if (userAgent != null && userAgent.contains("Mozilla")) {
                    result = "browser";
                }
            } else {
                if (request.getRequestURI().contains(".risc")) {
                    return "risc";
                }
                try {
                    HttpSession session = request.getSession(false);
                    if (session != null) {
                        return (String)session.getAttribute("ccclienttype");
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public static boolean checkIfCurrentClientTypeIsUI5(HttpServletRequest request) {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return false;
        }
        String s = HttpSessionAccess.getCurrentClientType(request);
        return "ui5".equals(s);
    }

    public static boolean checkIfCurrentClientTypeIsRisc() {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return true;
        }
        return HttpSessionAccess.checkIfCurrentClientTypeIsRisc(HttpSessionAccess.getCurrentRequest());
    }

    public static boolean checkIfCurrentClientTypeIsRisc(HttpServletRequest request) {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return true;
        }
        String s = HttpSessionAccess.getCurrentClientType(request);
        return "risc".equals(s);
    }

    public static boolean checkIfCurrentClientTypeIsRisc(HttpSession session) {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return true;
        }
        if (session == null) {
            session = HttpSessionAccess.getCurrentHttpSession();
        }
        String s = (String)session.getAttribute("ccclienttype");
        return "risc".equals(s);
    }

    public static String getCurrentClientJavaType() {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return "risc";
        }
        HttpServletRequest request = HttpSessionAccess.getCurrentRequest();
        if (request != null) {
            return HttpSessionAccess.getCurrentClientJavaType(request);
        }
        return "risc";
    }

    public static String getCurrentClientJavaType(HttpServletRequest request) {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return "risc";
        }
        String result = request.getHeader("eclnt-clientjavatype");
        return result;
    }

    public static boolean checkIfCurrentClientJavaTypeIsFX() {
        String javaType = HttpSessionAccess.getCurrentClientJavaType();
        return "fx".equals(javaType);
    }

    @Deprecated
    public static boolean checkIfCurrentClientJavaTypeIsRisc() {
        String clientType = HttpSessionAccess.getCurrentClientType();
        return "risc".equals(clientType);
    }

    public static boolean checkIfCurrentClientJavaTypeIsSwing() {
        String javaType = HttpSessionAccess.getCurrentClientJavaType();
        return "swing".equals(javaType);
    }

    public static int getCurrentClientScreenPixelWidth() {
        String v = HttpSessionAccess.getCurrentRequest().getHeader("eclnt-devicescreenwidth");
        return ValueManager.decodeInt(v, -1);
    }

    public static int getCurrentClientScreenPixelHeight() {
        String v = HttpSessionAccess.getCurrentRequest().getHeader("eclnt-devicescreenheight");
        return ValueManager.decodeInt(v, -1);
    }

    public static String getCurrentClientDeviceType() {
        return HttpSessionAccess.getCurrentRequest().getHeader("eclnt-devicetype");
    }

    public static String getCurrentClientId() {
        return HttpSessionAccess.getCurrentClientId(true);
    }

    public static String getCurrentClientId(boolean createClientIdIfNotExists) {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return "dummy(testwithoutsessionaccess)";
        }
        HttpServletRequest request = HttpSessionAccess.getCurrentRequest();
        String result = null;
        try {
            if (HttpSessionAccess.checkIfCurrentClientTypeIsRisc()) {
                Cookie[] cookies;
                result = ThreadData.getInstance().getNewClientId();
                if (result == null) {
                    result = SessionInfo.getSessionInstance().getBufferedClientId();
                }
                if (result == null && (cookies = request.getCookies()) != null) {
                    for (Cookie cookie : cookies) {
                        String cName = cookie.getName();
                        String cValue = cookie.getValue();
                        if (!"eclnt-id".equals(cName)) continue;
                        result = cValue;
                        break;
                    }
                }
                if (result == null && createClientIdIfNotExists) {
                    result = UniqueIdCreator.createUUID();
                    HttpSessionAccess.setCurrentClientId(result);
                }
            } else {
                result = request.getHeader("eclnt-id");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public static void setCurrentClientId(String clientId) {
        ThreadData.getInstance().setNewClientId(clientId);
        ServletUtil.writeEclntIdCookie(HttpSessionAccess.getCurrentResponse(), clientId);
    }

    public static Locale getCurrentLocale() {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return Locale.getDefault();
        }
        try {
            FacesContext fc = HttpSessionAccess.getCurrentFacesContext();
            try {
                return fc.getViewRoot().getLocale();
            }
            catch (Throwable t) {
                HttpSession session = HttpSessionAccess.getCurrentHttpSession();
                return (Locale)session.getAttribute("ccLastUsedLocale");
            }
        }
        catch (Throwable tt) {
            return Locale.getDefault();
        }
    }

    public static void setCurrentLocale(Locale l) {
        if (l == null) {
            return;
        }
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            Locale.setDefault(l);
            return;
        }
        FacesContext fc = HttpSessionAccess.getCurrentFacesContext();
        try {
            fc.getViewRoot().setLocale(l);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        HttpSession session = HttpSessionAccess.getCurrentHttpSession();
        session.setAttribute("ccLastUsedLocale", (Object)l);
    }

    public static void setCurrentStyle(String style) {
        String currentSessionStyle = SessionInfo.getSessionInstance().getStyle();
        if (ValueManager.checkIfStringsAreEqual(style, currentSessionStyle)) {
            return;
        }
        SessionInfo.getSessionInstance().setStyleAndReloadClient(style);
    }

    public static String getCurrentStyle() {
        return SessionInfo.getSessionInstance().getStyle();
    }

    public static void reloadClient() {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return;
        }
        HttpSessionAccess.reloadClient(HttpSessionAccess.getCurrentResponse());
    }

    public static void reloadClient(HttpServletResponse response) {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return;
        }
        ServletUtil.setResponseHeader(response, "eclnt-reload", "true");
    }

    public static SubpageContext getCurrentSubpageContext() {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return UsageWithoutSessionContext.getDummySubpageContext();
        }
        return HttpSessionAccess.getCurrentSubpageContext(HttpSessionAccess.getCurrentHttpSession(), ThreadData.getInstance().getSubpageId(), true);
    }

    public static SubpageContext getCurrentSubpageContext(HttpSession session) {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return UsageWithoutSessionContext.getDummySubpageContext();
        }
        return HttpSessionAccess.getCurrentSubpageContext(session, ThreadData.getInstance().getSubpageId(), true);
    }

    public static ISessionAbstraction getCurrentDialogSession() {
        if (!TypeOfSessionMgmt.getSessionMgmtViaCookie()) {
            return new SessionAbstractionHttpSession(HttpSessionAccess.getCurrentHttpSession());
        }
        return new SessionAbstractionSubpageContext(HttpSessionAccess.getCurrentSubpageContext());
    }

    public static ISessionAbstraction getCurrentDialogSession(HttpSession session) {
        if (!TypeOfSessionMgmt.getSessionMgmtViaCookie(session)) {
            return new SessionAbstractionHttpSession(session);
        }
        return new SessionAbstractionSubpageContext(HttpSessionAccess.getCurrentSubpageContext(session));
    }

    public static ISessionAbstraction getCurrentDialogSession(HttpSession session, String subpageId) {
        return new SessionAbstractionSubpageContext(HttpSessionAccess.getCurrentSubpageContext(session, subpageId, true));
    }

    static SubpageContext getCurrentSubpageContext(HttpSession session, String subpageId, boolean createIfNotExists) {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return UsageWithoutSessionContext.getDummySubpageContext();
        }
        if (createIfNotExists) {
            return SubpageContext.pickOrCreateSubpageContext(session, subpageId);
        }
        return SubpageContext.getSubpageContext(session, subpageId);
    }

    public static void switchProfileModeOnForCurrentSession() {
        SessionInfo si = SessionInfo.getSessionInstance();
        si.setProfileMode(true);
    }

    public static void switchProfileModeOffForCurrentSession() {
        SessionInfo si = SessionInfo.getSessionInstance();
        si.setProfileMode(false);
    }

    public static Map<String, String> getInitialRequestParameters() {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return new HashMap<String, String>();
        }
        SessionInfo si = SessionInfo.getSessionInstance();
        return si.getInitialURLParameters();
    }

    public static List<ClientDeviceInfo> getClientDeviceInfos(HttpServletRequest postRequest) {
        ArrayList<ClientDeviceInfo> result = new ArrayList<ClientDeviceInfo>();
        String json = postRequest.getHeader("eclnt-mediadevices");
        if (json == null) {
            return result;
        }
        try {
            Gson gson = new GsonBuilder().create();
            List os = (List)gson.fromJson(json, Object.class);
            for (Object o : os) {
                Map m = (Map)o;
                ClientDeviceInfo cdi = new ClientDeviceInfo((String)m.get("deviceId"), (String)m.get("label"), (String)m.get("kind"));
                result.add(cdi);
            }
            return result;
        }
        catch (Throwable t) {
            return result;
        }
    }

    public static boolean checkIfRunningInUIThread() {
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return true;
        }
        try {
            ThreadData td = ThreadData.getInstance(false);
            if (td != null) {
                return td.checkIfUIThread();
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void ensureToRunInUIThread() {
        if (!HttpSessionAccess.checkIfRunningInUIThread()) {
            throw new Error("The current operation is NOT running in the context of processing a UI request.");
        }
    }
}

