/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclnt.jsfserver.util.CCServletBase;
import org.eclnt.jsfserver.util.ENUMFileMode;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.jsfserver.util.security.ResourceSecurity;
import org.eclnt.util.file.StreamUtil;
import org.eclnt.util.log.CLog;

public class ResourceAccessServlet
extends CCServletBase {
    static final Map<String, ENUMFileMode> s_accessModes = new HashMap<String, ENUMFileMode>();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getMethod();
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String resource = null;
        try {
            resource = ServletUtil.isolateResourcePath(req);
            resource = ServletUtil.updateResource(req, resource);
            ResourceSecurity.checkResourcePathForOutsideUsage(resource);
            int lastDotIndex = resource.lastIndexOf(".");
            String extension = resource.substring(lastDotIndex + 1);
            String contentType = this.proposeContentType(extension);
            ServletUtil.setResponseContentType(resp, contentType);
            InputStream is = WebResourceClassloaderReader.readFileIntoInputStream(resource);
            if (is == null) {
                throw new Exception("No resource available: " + resource);
            }
            ServletOutputStream out = resp.getOutputStream();
            StreamUtil.transferStreamContent(is, (OutputStream)out);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_DBG, "Problem reading resource " + resource, t);
            CLog.L.log(CLog.LL_INF, "Problem reading resource" + resource);
            resp.sendError(404);
        }
    }
}

