/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.valuemgmt.ValueManager;

public class SameOriginFilterForHtml
implements Filter,
ICCServerConstants {
    public void doFilter(ServletRequest servletrequest, ServletResponse servletresponse, FilterChain filterchain) throws IOException, ServletException {
        if (servletrequest instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)servletrequest;
            String uri = request.getRequestURI();
            int ind = uri.indexOf(";");
            if (ind >= 0) {
                uri = uri.substring(0, ind);
            }
            if ((uri = uri.trim()).endsWith(".html")) {
                HttpServletRequest httpservletrequest = request;
                HttpServletResponse httpservletresponse = (HttpServletResponse)servletresponse;
                MyResponseWrapper responsewrapper = new MyResponseWrapper(httpservletresponse);
                filterchain.doFilter(servletrequest, (ServletResponse)responsewrapper);
                return;
            }
        }
        filterchain.doFilter(servletrequest, servletresponse);
    }

    public void init(FilterConfig filterconfig) {
    }

    public void destroy() {
    }

    class MyResponseWrapper
    extends HttpServletResponseWrapper {
        HttpServletResponse i_response;

        public MyResponseWrapper(HttpServletResponse response) {
            super(response);
            this.i_response = response;
        }

        public void setContentType(String contentType) {
            String s = SystemXml.getRiscStarter().getEmbedableasiframe();
            if (!"true".equals(s = ValueManager.toLowerCaseId(s))) {
                ServletUtil.setResponseHeader(this.i_response, "X-Frame-Options", SystemXml.getCcembeddedcontentBridgepagesXframeoptions());
            }
            ServletUtil.setResponseContentType(this.i_response, contentType);
        }
    }
}

