/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.util.HashMap;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.base.faces.el.EvaluationException;
import org.eclnt.jsfserver.base.faces.el.VariableResolver;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.util.FacesConfigReader;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.log.CLog;

public class VariableResolverByDelegation
extends VariableResolver {
    static String ATTRIBUTENAME = "VariableResolverByDelegation";
    static boolean s_usedByAppliaction = false;
    static boolean s_usedByHotDeploy = false;
    VariableResolver m_delegateTo;
    boolean m_firstResolving = true;

    public VariableResolverByDelegation(VariableResolver delegateTo) {
        this.m_delegateTo = delegateTo;
    }

    public static void defineInstanceToBeUsed(String name, Object instance) {
        HashMap<String, Object> map = (HashMap<String, Object>)HttpSessionAccess.getCurrentHttpSession().getAttribute(ATTRIBUTENAME);
        if (map == null) {
            map = new HashMap<String, Object>();
            HttpSessionAccess.getCurrentHttpSession().setAttribute(ATTRIBUTENAME, map);
        }
        map.put(name, instance);
        s_usedByAppliaction = true;
    }

    @Override
    public Object resolveVariable(FacesContext context, String name) throws EvaluationException {
        Object result;
        if (this.m_firstResolving) {
            this.m_firstResolving = false;
            if (this.getClass().getClassLoader() != HotDeployManager.currentClassLoader()) {
                s_usedByHotDeploy = true;
                CLog.L.log(CLog.LL_INF, "Hot Deployment is used within the VairableResolverManagement");
            }
        }
        if (!s_usedByAppliaction && !s_usedByHotDeploy) {
            return this.m_delegateTo.resolveVariable(context, name);
        }
        HashMap map = (HashMap)HttpSessionAccess.getCurrentHttpSession(context).getAttribute(ATTRIBUTENAME);
        if (s_usedByAppliaction && map != null && (result = map.get(name)) != null) {
            return result;
        }
        if (s_usedByHotDeploy) {
            if (map == null) {
                map = new HashMap();
                HttpSessionAccess.getCurrentHttpSession().setAttribute(ATTRIBUTENAME, map);
            }
            if ((result = map.get(name)) != null) {
                return result;
            }
            try {
                FacesConfigReader.ManagedBean mb = FacesConfigReader.getManagedBean(name);
                if (mb == null) {
                    return this.m_delegateTo.resolveVariable(context, name);
                }
                String className = mb.getClassName();
                Class cl = CCClassResolver.resolveClass(className, ENUMCallerType.EXPRESSIONRESOLUTION);
                result = cl.newInstance();
                map.put(name, result);
                return result;
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_WAR, "Exception when accessing: " + name, t);
            }
        }
        return this.m_delegateTo.resolveVariable(context, name);
    }
}

