/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.io.IOException;
import java.io.Writer;
import org.eclnt.jsfserver.base.faces.FacesException;
import org.eclnt.jsfserver.base.faces.component.UIComponent;
import org.eclnt.jsfserver.base.faces.context.ResponseWriter;

public class XMLResponseWriter
extends ResponseWriter {
    private String m_contentType = "text/html";
    private String m_encoding = "UTF-8";
    private Writer m_writer = null;
    private boolean m_closeStart;

    public XMLResponseWriter(Writer writer) throws FacesException {
        this.m_writer = writer;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public String getCharacterEncoding() {
        return this.m_encoding;
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
        this.m_writer.flush();
    }

    @Override
    public void flush() throws IOException {
        this.closeStartIfNecessary();
    }

    public void startElement(String name, UIComponent componentForElement) throws IOException {
        this.closeStartIfNecessary();
        this.m_writer.write("<");
        this.m_writer.write(name);
        this.m_closeStart = true;
    }

    public void endElement(String name) throws IOException {
        if (this.m_closeStart) {
            this.m_writer.write(">");
            this.m_closeStart = false;
        }
        this.m_writer.write("</");
        this.m_writer.write(name);
        this.m_writer.write(">");
    }

    public void writeAttribute(String name, Object value, String componentPropertyName) throws IOException {
        Class<?> valueClass = value.getClass();
        this.m_writer.write(" ");
        this.m_writer.write(name);
        this.m_writer.write("=\"");
        this.m_writer.write(value.toString());
        this.m_writer.write("\"");
    }

    public void writeURIAttribute(String name, Object value, String componentPropertyName) throws IOException {
        this.m_writer.write(" ");
        this.m_writer.write(name);
        this.m_writer.write("=\"");
        String stringValue = value.toString();
        this.m_writer.write(value.toString());
        this.m_writer.write("\"");
    }

    public void writeComment(Object comment) throws IOException {
        this.closeStartIfNecessary();
        this.m_writer.write("<!-- ");
        this.m_writer.write(comment.toString());
        this.m_writer.write(" -->");
    }

    public void writeText(Object text, String componentPropertyName) throws IOException {
        this.closeStartIfNecessary();
        this.m_writer.write(text.toString());
    }

    public void writeText(char text) throws IOException {
        this.closeStartIfNecessary();
        this.m_writer.write(text);
    }

    public void writeText(char[] text) throws IOException {
        this.closeStartIfNecessary();
        this.m_writer.write(text);
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        if (off < 0 || off > text.length || len < 0 || len > text.length) {
            throw new IndexOutOfBoundsException();
        }
        this.closeStartIfNecessary();
        this.m_writer.write(text, off, len);
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        throw new Error("Not implemented.");
    }

    private void closeStartIfNecessary() throws IOException {
        if (this.m_closeStart) {
            this.m_writer.write(">");
            this.m_closeStart = false;
        }
    }

    @Override
    public void close() throws IOException {
        this.closeStartIfNecessary();
        this.m_writer.close();
    }

    public void write(char cbuf) throws IOException {
        this.closeStartIfNecessary();
        this.m_writer.write(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.closeStartIfNecessary();
        this.m_writer.write(cbuf, off, len);
    }

    @Override
    public void write(int c) throws IOException {
        this.closeStartIfNecessary();
        this.m_writer.write(c);
    }

    @Override
    public void write(String str) throws IOException {
        this.closeStartIfNecessary();
        this.m_writer.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.closeStartIfNecessary();
        this.m_writer.write(str, off, len);
    }
}

