/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.tool;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.tool.CSSStyleClass;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class CSSStyle
implements Serializable {
    public static final String PREFIX_EXTENDED_CLASS = "EXTENDED_";
    Map<String, CSSStyleClass> m_styleClasses = new HashMap<String, CSSStyleClass>();
    Map<String, String> m_variableValues = new HashMap<String, String>();
    Map<String, String> m_variableCategories = new HashMap<String, String>();

    public CSSStyle createClone() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(this);
            oos.flush();
            oos.close();
            bos.close();
            byte[] bytes = bos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            return (CSSStyle)new ObjectInputStream(bais).readObject();
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public Map<String, CSSStyleClass> getStyleClasses() {
        return this.m_styleClasses;
    }

    public Map<String, String> getVariableValues() {
        return this.m_variableValues;
    }

    public void addVariableValue(String name, String value) {
        this.m_variableValues.put(name, value);
    }

    public void addVariableCategory(String name, String category) {
        this.m_variableCategories.put(name, category);
    }

    public String getVariableCategory(String name) {
        return this.m_variableCategories.get(name);
    }

    public Map<String, String> getVariableCategories() {
        return this.m_variableCategories;
    }

    public void removeVariableValue(String name) {
        this.m_variableValues.remove(name);
    }

    public void addStyleClass(CSSStyleClass sc) {
        CSSStyleClass ex = this.m_styleClasses.get(sc.getName());
        this.m_styleClasses.put(sc.getName(), sc);
        if (ex != null) {
            String exName = this.findInternalExtensioStyleClassName(ex.getName());
            ex.setName(exName);
            ex.setInternal(true);
            sc.setExtends(ex.getName());
            this.m_styleClasses.put(ex.getName(), ex);
        }
    }

    private String findInternalExtensioStyleClassName(String styleClassName) {
        int counter = 1;
        String candidate;
        while (this.m_styleClasses.containsKey(candidate = PREFIX_EXTENDED_CLASS + styleClassName + "_" + counter)) {
            ++counter;
        }
        return candidate;
    }

    public void remoceStyleClass(String name) {
        this.m_styleClasses.remove(name);
    }

    public void outputXML(StringBuffer sb) {
        sb.append("<stylesheet>\n");
        ArrayList<String> varNames = new ArrayList<String>(this.m_variableValues.keySet());
        Collections.sort(varNames);
        for (String varName : varNames) {
            String value = ValueManager.encodeIntoValidXMLString(this.m_variableValues.get(varName));
            varName = ValueManager.encodeIntoValidXMLString(varName);
            sb.append("    <var n=\"" + varName + "\" v=\"" + value + "\"/>\n");
        }
        List<CSSStyleClass> l = this.getSortedClassList();
        for (CSSStyleClass sc : l) {
            sc.outputXML(sb, 1);
        }
        sb.append("</stylesheet>\n");
    }

    public void outputCSS(StringBuffer sb, List<CSSStyleClass> cssStyleClasses) {
        CLog.L.log(CLog.LL_INF, "STYLEMGMT: Creating CSS output");
        List<CSSStyleClass> scs = this.getSortedClassList();
        for (CSSStyleClass sc : scs) {
            sc.outputCSS(sb, new ArrayList<CSSStyleClass>(), this.m_variableValues);
            if (cssStyleClasses == null || sc.getName().startsWith(PREFIX_EXTENDED_CLASS)) continue;
            cssStyleClasses.add(sc);
        }
        CLog.L.log(CLog.LL_INF, "STYLEMGMT: Creating CSS output - finished");
    }

    public void outputJsonMap(Map<String, Object> map) {
        CLog.L.log(CLog.LL_INF, "STYLEMGMT: Creating JSON output");
        CLog.L.log(CLog.LL_INF, "STYLEMGMT: JSON: Adding variables");
        HashMap<String, String> variables = new HashMap<String, String>();
        map.put("variables", variables);
        for (String variable : this.m_variableValues.keySet()) {
            String value = this.m_variableValues.get(variable);
            value = CSSStyleClass.resolveValue(value, this.m_variableValues, 0);
            variables.put(variable, CSSStyle.updateJSValueContent(value));
        }
        HashMap<String, Object> globals = new HashMap<String, Object>();
        map.put("globals", globals);
        CLog.L.log(CLog.LL_INF, "STYLEMGMT: JSON: Adding style classes");
        HashMap<String, Object> classes = new HashMap<String, Object>();
        map.put("classes", classes);
        List<CSSStyleClass> l = this.getSortedClassList();
        for (CSSStyleClass sc : l) {
            sc.outputJsonMap(globals, classes, new ArrayList<CSSStyleClass>(), this.m_variableValues);
        }
        CLog.L.log(CLog.LL_INF, "STYLEMGMT: Creating JSON output - finished");
    }

    public static String updateJSValueContent(String value) {
        if (value != null) {
            value = value.replace("\"", "\\\"");
            value = value.replace("'", "\\'");
        }
        return value;
    }

    private List<CSSStyleClass> getSortedClassList() {
        ArrayList<CSSStyleClass> l = new ArrayList<CSSStyleClass>(this.m_styleClasses.values());
        Collections.sort(l);
        return l;
    }
}

