/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.file;

import java.util.ArrayList;
import java.util.List;

public class FileInfo {
    private String m_absoluteName;
    private String m_name;
    private List<FileInfo> m_subDirectories = new ArrayList<FileInfo>();
    private List<FileInfo> m_subFiles = new ArrayList<FileInfo>();

    public FileInfo(String absoluteName) {
        this.m_name = this.m_absoluteName = absoluteName;
        if (this.m_name.endsWith("/")) {
            this.m_name = this.m_name.substring(0, this.m_name.length() - 1);
        }
        int index = this.m_name.lastIndexOf("/");
        this.m_name = this.m_name.substring(index + 1);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.toString(sb, 0);
        return sb.toString();
    }

    public String getAbsoluteName() {
        return this.m_absoluteName;
    }

    public String getName() {
        return this.m_name;
    }

    public List<FileInfo> getSubDirectories() {
        return this.m_subDirectories;
    }

    public List<FileInfo> getSubFiles() {
        return this.m_subFiles;
    }

    public FileInfo getSubFile(String name) {
        for (FileInfo fi : this.m_subFiles) {
            if (!name.equals(fi.getName())) continue;
            return fi;
        }
        return null;
    }

    public FileInfo getSubDirectory(String name) {
        for (FileInfo fi : this.m_subDirectories) {
            if (!name.equals(fi.getName())) continue;
            return fi;
        }
        return null;
    }

    public void merge(FileInfo fi) {
        FileInfo existingSubFi;
        for (FileInfo subFi : fi.getSubDirectories()) {
            existingSubFi = this.getSubDirectory(subFi.getName());
            if (existingSubFi == null) {
                this.getSubDirectories().add(subFi);
                continue;
            }
            existingSubFi.merge(subFi);
        }
        for (FileInfo subFi : fi.getSubFiles()) {
            existingSubFi = this.getSubFile(subFi.getName());
            if (existingSubFi != null) continue;
            this.getSubFiles().add(subFi);
        }
    }

    private void toString(StringBuffer sb, int level) {
        for (int i = 0; i < level; ++i) {
            sb.append("  ");
        }
        sb.append(this.m_name + "\n");
        for (FileInfo ci : this.m_subDirectories) {
            ci.toString(sb, level + 1);
        }
        for (FileInfo ci : this.m_subFiles) {
            ci.toString(sb, level + 1);
        }
    }
}

