/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.image;

import java.util.HashSet;
import java.util.Set;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.ccee.simplexml.SimpleXMLParser;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.util.image.ISVGImageUpdate;
import org.eclnt.util.image.SVGImageUpdateLibStreamline;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class SVGImageManager {
    private static Set<ISVGSourceReader> s_svgSourceReader = new HashSet<ISVGSourceReader>();
    private static Set<ISVGImageUpdate> s_svgImageUpdates = new HashSet<ISVGImageUpdate>();

    public static synchronized void addSVGSourceReader(ISVGSourceReader svgSourceReader) {
        s_svgSourceReader.add(svgSourceReader);
    }

    public static synchronized void removeSVGSourceReader(ISVGSourceReader svgSourceReader) {
        s_svgSourceReader.remove(svgSourceReader);
    }

    public static synchronized void addSVGImageUpdate(ISVGImageUpdate svgImageUpdate) {
        s_svgImageUpdates.add(svgImageUpdate);
    }

    public static synchronized void removeSVGImageUpdate(ISVGImageUpdate svgImageUpdate) {
        s_svgImageUpdates.remove(svgImageUpdate);
    }

    public byte[] findImage(String dynImage) {
        try {
            int width;
            String color;
            if (dynImage == null) {
                return null;
            }
            if (!dynImage.startsWith("/svg(")) {
                throw new Error("Image name does not start with \"svg(\"");
            }
            String[] values = ValueManager.decodeMethodParams(dynImage);
            if (values.length < 3) {
                throw new Error("Image name does only contain " + values.length + " parameters, format: /svg(resourcePath,color,width[,height])");
            }
            if (values.length > 4) {
                throw new Error("Image name does only contain " + values.length + " parameters, format: /svg(resourcePath,color,width[,height])");
            }
            String svgResource = values[0];
            if (!svgResource.startsWith("/")) {
                svgResource = "/" + svgResource;
            }
            if (!(color = values[1]).startsWith("#")) {
                color = "#" + color;
            }
            int height = width = ValueManager.decodeInt(values[2], 16);
            if (values.length == 4) {
                height = ValueManager.decodeInt(values[3], width);
            }
            String svg = this.createSVGImage(svgResource, null, color, width, height);
            byte[] result = svg.getBytes("UTF-8");
            return result;
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public byte[] createImageCCSVG(String path) {
        int width = -1;
        int height = -1;
        int indexlastDot = path.lastIndexOf(".");
        String size = path.substring(indexlastDot + 1);
        int indexX = size.indexOf(120);
        width = ValueManager.decodeInt(size.substring(0, indexX), 16);
        height = ValueManager.decodeInt(size.substring(indexX + 1), 16);
        path = path.substring(0, indexlastDot);
        String backgroundColor = null;
        String color = null;
        int indexHash1 = -1;
        int indexHash2 = -1;
        indexHash2 = path.lastIndexOf(".#");
        if (indexHash2 > 0) {
            indexHash1 = path.lastIndexOf(".#", indexHash2 - 2);
        } else {
            indexHash2 = path.lastIndexOf("._");
            if (indexHash2 > 0) {
                indexHash1 = path.lastIndexOf("._", indexHash2 - 2);
            }
        }
        String color1 = null;
        String color2 = null;
        if (indexHash2 > 0) {
            color2 = path.substring(indexHash2 + 1);
            color2 = color2.replace("_", "#");
            path = path.substring(0, indexHash2);
        }
        if (indexHash1 > 0) {
            color1 = path.substring(indexHash1 + 1);
            color1 = color1.replace("_", "#");
            path = path.substring(0, indexHash1);
        }
        backgroundColor = color1;
        color = color2;
        String svgResource = path.replace(".", "/") + ".svg";
        return this.createSVGImageBytes(svgResource, backgroundColor, color, width, height);
    }

    public byte[] createSVGImageBytes(String svgResource, String backgroundColor, String color, int width, int height) {
        try {
            String svg = this.createSVGImage(svgResource, backgroundColor, color, width, height);
            return svg.getBytes("UTF-8");
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public String createSVGImage(String svgResource, String backgroundColor, String color, int width, int height) {
        String svg = this.readSVG(svgResource);
        if (svg == null) {
            return null;
        }
        svg = SVGImageManager.updateSVG(svg, backgroundColor, color, width, height);
        return svg;
    }

    public static String updateSVG(String svg, String backgroundColor, String color, int width, int height) {
        if (svg == null) {
            throw new Error("SVG that was passed for conversion is null");
        }
        String expr = "^#[0-9a-fA-F]{8}$|#[0-9a-fA-F]{6}$";
        if (!ValueManager.checkIfStringMatchesRegularExpression(backgroundColor, expr)) {
            throw new Error("Color definition does not follow: #rrggbb / #rrggbbtt: " + backgroundColor);
        }
        if (!ValueManager.checkIfStringMatchesRegularExpression(color, expr)) {
            throw new Error("Color definition does not follow: #rrggbb / #rrggbbtt: " + color);
        }
        svg = SVGImageManager.cleanSvgForParsing(svg);
        SimpleXMLElement top = null;
        try {
            top = SimpleXMLParser.parseXML(svg, false);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "SVG image cannot be parsed, dynamic replacement of colors/sizes might not properly work" + svg, t);
        }
        for (ISVGImageUpdate imageUpdate : s_svgImageUpdates) {
            try {
                ISVGImageUpdate.SVGImageUpdateResult result;
                if (imageUpdate == null || (result = imageUpdate.updateSVG(top, backgroundColor, color, width, height)) == null || !result.getWasUpdated() || result.getUpdatedSvg() == null) continue;
                return result.getUpdatedSvg();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem during SVG image update with: " + imageUpdate.getClass().getName(), t);
            }
        }
        if (color != null) {
            String topFill;
            svg = SVGImageManager.removeAllFills(svg);
            int firstSVGIndex = svg.indexOf("<svg");
            String string = topFill = top == null ? null : top.getValue("fill");
            if (topFill == null || !"none".equals(topFill) && !"transparent".equals(topFill)) {
                svg = SVGImageManager.addStringAfterSVG(svg, " fill=\"" + color + "\"");
            }
            svg = svg.replace("stroke:#000000", "stroke:" + color);
            svg = svg.replace("stroke:#000", "stroke:" + color);
            svg = svg.replace("fill:", "fillSwitchedOff:");
        }
        svg = SVGImageManager.updateWidthHeight(svg, width, height);
        svg = SVGImageManager.updateBackgroundColor(svg, backgroundColor);
        return svg;
    }

    public static String cleanSvgForParsing(String svg) {
        int index2;
        int index1 = (svg = svg.replace("xmlns:xlink=\"http://www.w3.org/1999/xlink\"", "")).indexOf("<!DOCTYPE ");
        if (index1 > 0 && (index2 = svg.indexOf(">", index1)) > 0) {
            svg = svg.substring(0, index1) + svg.substring(index2 + 1);
        }
        return svg;
    }

    public static String updateBackgroundColor(String svg, String backgroundColor) {
        if (backgroundColor != null) {
            int firstSVGIndex = svg.indexOf("<svg");
            int index = svg.indexOf(">", firstSVGIndex + 1);
            svg = svg.substring(0, index + 1) + "<rect width=\"100%\" height=\"100%\" fill=\"" + backgroundColor + "\"/>" + svg.substring(index + 1);
        }
        return svg;
    }

    public static String updateWidthHeight(String svg, int width, int height) {
        int firstSVGIndex;
        if (width > 0) {
            svg = SVGImageManager.removeSVGAttribute(svg, "width");
            firstSVGIndex = svg.indexOf("<svg");
            svg = SVGImageManager.addStringAfterSVG(svg, " width=\"" + width + "\" ");
        }
        if (height > 0) {
            svg = SVGImageManager.removeSVGAttribute(svg, "height");
            firstSVGIndex = svg.indexOf("<svg");
            svg = SVGImageManager.addStringAfterSVG(svg, " height=\"" + height + "\" ");
        }
        return svg;
    }

    private static String addStringAfterSVG(String svg, String s) {
        int firstSVGIndex = svg.indexOf("<svg");
        svg = svg.substring(0, firstSVGIndex + 4) + s + svg.substring(firstSVGIndex + 4);
        return svg;
    }

    private static String removeAllFills(String svg) {
        int endIndex;
        int index;
        if (svg == null) {
            return svg;
        }
        int fromIndex = 0;
        while ((index = svg.indexOf("fill=\"", fromIndex)) >= 0 && (endIndex = svg.indexOf("\"", index + 6)) >= 0) {
            String fillValue = svg.substring(index + 6, endIndex);
            if (!"none".equals(fillValue) && !"transparent".equals(fillValue)) {
                svg = svg.substring(0, index) + svg.substring(endIndex + 1);
                fromIndex = index;
                continue;
            }
            fromIndex = endIndex;
        }
        return svg;
    }

    protected String readSVG(String svgResource) {
        try {
            String result = WebResourceClassloaderReader.readUTF8FileIntoStringForExternalUsage(svgResource, true);
            if (result != null && result.length() > 0) {
                return result;
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Could not read svgResource: " + svgResource + ", " + t.toString());
        }
        for (ISVGSourceReader ssr : s_svgSourceReader) {
            try {
                String svg = ssr.readSVG(svgResource);
                if (svg == null) continue;
                return svg;
            }
            catch (Throwable throwable) {
            }
        }
        CLog.L.log(CLog.LL_INF, "Tried to load resource: " + svgResource + ". The resource is not available.");
        return null;
    }

    private static String removeSVGAttribute(String svg, String attribute) {
        try {
            int indexSVGBegin = svg.indexOf("<svg ");
            int indexSVGEnd = svg.indexOf(">", indexSVGBegin);
            String attSearchString = " " + attribute + "=\"";
            int indexAttBegin = svg.indexOf(attSearchString, indexSVGBegin);
            if (indexAttBegin < 0 || indexAttBegin > indexSVGEnd) {
                return svg;
            }
            int indexAttEnd = svg.indexOf("\"", indexAttBegin + attSearchString.length()) + 1;
            svg = svg.substring(0, indexAttBegin) + svg.substring(indexAttEnd);
            return svg;
        }
        catch (Throwable t) {
            return svg;
        }
    }

    static {
        SVGImageManager.addSVGImageUpdate(new SVGImageUpdateLibStreamline());
    }

    public static interface ISVGSourceReader {
        public String readSVG(String var1);
    }
}

