/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.valuemgmt;

import java.util.Locale;
import java.util.Map;
import org.eclnt.jsfserver.util.useraccess.LanguageAccessMgr;
import org.eclnt.util.valuemgmt.ValueManager;

public class MLTextParser {
    String m_fallbackLanguage = Locale.getDefault().getLanguage();
    private static MLTextParser s_instance = new MLTextParser();

    public static MLTextParser instance() {
        return s_instance;
    }

    public static void initialize(MLTextParser instance) {
        s_instance = instance;
    }

    public String getFallbackLanguage() {
        return this.m_fallbackLanguage;
    }

    public void setFallbackLanguage(String fallbackLanguage) {
        this.m_fallbackLanguage = fallbackLanguage;
    }

    public String getText(String mlText) {
        if (this.checkIfTextIsMultiLanguageText(mlText)) {
            String language = LanguageAccessMgr.getInstance().getCurrentLanguage();
            return this.findTextForLanguage(mlText, language, true);
        }
        return mlText;
    }

    public String getTextForLanguage(String mlText, String language) {
        return this.findTextForLanguage(mlText, language, false);
    }

    protected String findTextForLanguage(String mlText, String language, boolean checkIfTextIsMultiLanguageTextAlreadyDone) {
        if (mlText != null && language != null) {
            if (!checkIfTextIsMultiLanguageTextAlreadyDone && !this.checkIfTextIsMultiLanguageText(mlText)) {
                return mlText;
            }
            Map<String, String> map = ValueManager.decodeComplexValue(mlText);
            String text = map.get(language);
            if (text == null) {
                text = map.get(this.m_fallbackLanguage);
            }
            if (text != null) {
                return text;
            }
        }
        return mlText;
    }

    protected boolean checkIfTextIsMultiLanguageText(String mlText) {
        if (mlText == null) {
            return false;
        }
        if (mlText.length() < 3) {
            return false;
        }
        if (mlText.charAt(2) != ':') {
            return false;
        }
        if (!Character.isLetter(mlText.charAt(0)) || Character.isUpperCase(mlText.charAt(0))) {
            return false;
        }
        return Character.isLetter(mlText.charAt(1)) && !Character.isUpperCase(mlText.charAt(1));
    }
}

