/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclnt.jsfserver.defaultscreens.ModalPopup;
import org.eclnt.jsfserver.defaultscreens.ModelessPopup;
import org.eclnt.jsfserver.pagebean.IPageBean;
import org.eclnt.jsfserver.resources.ResourceManager;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.IMultiWorkplaceWorkpageProcessingEventListener;
import org.eclnt.workplace.IWorkpage;
import org.eclnt.workplace.IWorkpageContainer;
import org.eclnt.workplace.IWorkpageDispatcher;
import org.eclnt.workplace.IWorkpageLifecycleListener;
import org.eclnt.workplace.IWorkpageProcessingEventListener;
import org.eclnt.workplace.IWorkpageStartInfo;
import org.eclnt.workplace.WorkpageProcessingEvent;

public class Workpage
implements Serializable,
IWorkpage {
    String m_uuid = UniqueIdCreator.createUUID();
    IWorkpageDispatcher m_dispatcher;
    String m_title;
    String m_selectorTitle;
    String m_comment;
    String m_jspPage;
    String m_iconURL;
    String m_id;
    boolean m_isDecorated;
    boolean m_popupSupported = true;
    boolean m_popupDecorated = true;
    boolean m_closeSupported = true;
    boolean m_wpDragSupported = true;
    Map<String, String> m_params = new HashMap<String, String>();
    Set<IWorkpageLifecycleListener> m_listeners = new HashSet<IWorkpageLifecycleListener>();
    Set<IWorkpageProcessingEventListener> m_listenersProcessing = new HashSet<IWorkpageProcessingEventListener>();
    Set<ModelessPopup> m_modelessPopups = new HashSet<ModelessPopup>();
    Map<String, ModelessPopup> m_modelessPopupsById = new HashMap<String, ModelessPopup>();
    ModelessPopup m_modelessPopup;
    String m_startSubWorkpageContainerId = null;
    String m_uniqueTechnicalId = UniqueIdCreator.createRandomId() + "";
    IWorkpageStartInfo m_workpageStartInfo;
    boolean m_excludeFromSavePerspective = false;
    String m_selectorBgpaint = null;
    String m_clientName = null;
    List<SemiModalPopupInfo> m_semiModalPopups = new ArrayList<SemiModalPopupInfo>();
    boolean m_semiModalPopupsAreHidden = false;

    public Workpage(IWorkpageDispatcher dispatcher, String jspPage, String id, String title, String iconURL, boolean isDecorated) {
        try {
            dispatcher = (IWorkpageDispatcher)dispatcher.getTopOwner();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_dispatcher = (IWorkpageDispatcher)dispatcher.createSubDispatcherInstance();
        this.m_title = title;
        this.m_jspPage = jspPage;
        this.m_iconURL = iconURL;
        this.m_id = id;
        this.m_isDecorated = isDecorated;
        this.m_dispatcher.setWorkpage(this);
    }

    public String getDragsend() {
        IWorkpageContainer wpc = this.m_dispatcher.getWorkpageContainer();
        if (wpc.getWithWorkpageDragDrop()) {
            return "CCWORKPAGE:" + this.m_uniqueTechnicalId;
        }
        return null;
    }

    public String getMwpDragsend() {
        IWorkpageContainer wpc = this.m_dispatcher.getWorkpageContainer();
        if (wpc.getWithWorkpageDragDrop()) {
            return "cchtml5_workpage:" + this.m_uniqueTechnicalId;
        }
        return null;
    }

    @Override
    public void setWorkpageStartInfo(IWorkpageStartInfo workpageStartInfo) {
        this.m_workpageStartInfo = workpageStartInfo;
    }

    @Override
    public IWorkpageStartInfo getWorkpageStartInfo() {
        return this.m_workpageStartInfo;
    }

    @Override
    public IWorkpageDispatcher getDispatcher() {
        return this.m_dispatcher;
    }

    public String getUuid() {
        return this.m_uuid;
    }

    @Override
    public void setId(String value) {
        this.m_id = value;
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public void setTitle(String value) {
        if (ValueManager.checkIfStringsAreEqual(this.m_title, this.m_selectorTitle)) {
            this.m_title = value;
            this.m_selectorTitle = value;
        } else {
            this.m_title = value;
        }
        if (this.m_modelessPopup != null) {
            this.m_modelessPopup.setTitle(this.m_title);
        }
    }

    @Override
    public String getTitle() {
        return ResourceManager.findText(this.m_title);
    }

    @Override
    public String getSelectorBgpaint() {
        if (this.m_selectorBgpaint != null) {
            return this.m_selectorBgpaint;
        }
        if (this.m_workpageStartInfo != null) {
            return this.m_workpageStartInfo.getSelectorBgpaint();
        }
        return null;
    }

    public void setSelectorBgpaint(String selectorBgpaint) {
        this.m_selectorBgpaint = selectorBgpaint;
    }

    @Override
    public void setSelectorTitle(String value) {
        this.m_selectorTitle = value;
    }

    @Override
    public String getSelectorTitle() {
        return ResourceManager.findText(this.getSelectorTitleOriginal());
    }

    public String getSelectorTitleOriginal() {
        if (this.m_selectorTitle != null) {
            return this.m_selectorTitle;
        }
        return this.m_title;
    }

    public void setJspPage(String value) {
        this.m_jspPage = value;
    }

    @Override
    public String getJspPage() {
        return this.m_jspPage;
    }

    @Override
    public void setIconURL(String value) {
        this.m_iconURL = value;
    }

    @Override
    public String getIconURL() {
        return this.m_iconURL;
    }

    public void setDecorated(boolean value) {
        this.m_isDecorated = value;
    }

    @Override
    public boolean isDecorated() {
        return this.m_isDecorated;
    }

    @Override
    public boolean isWpDragSupported() {
        if (SystemXml.getWorkplaceMultiScreen()) {
            return this.m_wpDragSupported;
        }
        return false;
    }

    public void setWpDragSupported(boolean wpDragSupported) {
        this.m_wpDragSupported = wpDragSupported;
    }

    @Override
    public String getStartSubWorkpageContainerId() {
        return this.m_startSubWorkpageContainerId;
    }

    public void setStartSubWorkpageContainerId(String startSubWorkpageContainerId) {
        this.m_startSubWorkpageContainerId = startSubWorkpageContainerId;
    }

    @Override
    public boolean close() {
        IWorkpageLifecycleListener[] listeners = new IWorkpageLifecycleListener[this.m_listeners.size()];
        this.m_listeners.toArray(listeners);
        for (IWorkpageLifecycleListener listener : listeners) {
            listener.setCloseContinueOperation(null);
            boolean result = listener.close();
            if (result) continue;
            return false;
        }
        this.closeForced();
        return true;
    }

    @Override
    public boolean closeAndContinue(Runnable continueOperation) {
        IWorkpageLifecycleListener[] listeners = new IWorkpageLifecycleListener[this.m_listeners.size()];
        this.m_listeners.toArray(listeners);
        for (IWorkpageLifecycleListener listener : listeners) {
            listener.setCloseContinueOperation(continueOperation);
            boolean result = listener.close();
            if (result) continue;
            return false;
        }
        this.closeForced();
        return true;
    }

    @Override
    public void closeForced() {
        IWorkpageLifecycleListener[] listeners = new IWorkpageLifecycleListener[this.m_listeners.size()];
        this.m_listeners.toArray(listeners);
        for (IWorkpageLifecycleListener listener : listeners) {
            listener.closeForced();
        }
        ModelessPopup[] modelessPopups = new ModelessPopup[this.m_modelessPopups.size()];
        this.m_modelessPopups.toArray(modelessPopups);
        for (ModelessPopup popup : modelessPopups) {
            popup.close();
        }
        this.m_dispatcher.destroy();
        this.m_dispatcher = null;
        for (SemiModalPopupInfo smpi : this.m_semiModalPopups) {
            try {
                smpi.i_callingPageBean.closePopup(smpi.i_popupPageBean);
            }
            catch (Throwable throwable) {}
        }
        this.m_semiModalPopups.clear();
    }

    @Override
    public IWorkpageContainer getWorkpageContainer() {
        return this.m_dispatcher.getWorkpageContainer();
    }

    public void setPopupSupported(boolean value) {
        this.m_popupSupported = value;
    }

    @Override
    public boolean isPopupSupported() {
        return this.m_popupSupported;
    }

    @Override
    public void setPopupDecorated(boolean popupDecorated) {
        this.m_popupDecorated = popupDecorated;
    }

    @Override
    public boolean isPopupDecorated() {
        return this.m_popupDecorated;
    }

    public void setCloseSupported(boolean closeSupported) {
        this.m_closeSupported = closeSupported;
    }

    @Override
    public boolean isCloseSupported() {
        return this.m_closeSupported;
    }

    @Override
    public void reactOnDisplay() {
    }

    @Override
    public void setParam(String paramName, String paramValue) {
        this.m_params.put(paramName, paramValue);
    }

    @Override
    public String getParam(String paramName) {
        return this.m_params.get(paramName);
    }

    @Override
    public Map<String, String> getParamMap() {
        return this.m_params;
    }

    @Override
    public void addLifecycleListener(IWorkpageLifecycleListener listener) {
        this.m_listeners.add(listener);
    }

    @Override
    public void removeLifecycleListener(IWorkpageLifecycleListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    public Set<IWorkpageLifecycleListener> getLifecycleListeners() {
        return this.m_listeners;
    }

    public String toString() {
        return "Workpage for " + this.getDispatcher();
    }

    @Override
    public void reactOnReselectedInContentArea() {
        IWorkpageLifecycleListener[] listeners = new IWorkpageLifecycleListener[this.m_listeners.size()];
        this.m_listeners.toArray(listeners);
        for (IWorkpageLifecycleListener listener : listeners) {
            try {
                listener.reactOnReselectedInContentArea();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void reactOnSwitchToPage() {
        IWorkpageLifecycleListener[] listeners = new IWorkpageLifecycleListener[this.m_listeners.size()];
        this.m_listeners.toArray(listeners);
        for (IWorkpageLifecycleListener listener : listeners) {
            try {
                listener.reactOnSwitchToPage();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void reactOnShownInContentArea() {
        IWorkpageLifecycleListener[] listeners = new IWorkpageLifecycleListener[this.m_listeners.size()];
        this.m_listeners.toArray(listeners);
        for (IWorkpageLifecycleListener listener : listeners) {
            try {
                listener.reactOnShownInContentArea();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.showSemiModalPopups();
    }

    @Override
    public void reactOnHide() {
        IWorkpageLifecycleListener[] listeners = new IWorkpageLifecycleListener[this.m_listeners.size()];
        this.m_listeners.toArray(listeners);
        for (IWorkpageLifecycleListener listener : listeners) {
            try {
                listener.reactOnHiddenInContentArea();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.hideSemiModalPopups();
    }

    @Override
    public boolean reactOnBeforeHide() {
        boolean allResult = true;
        IWorkpageLifecycleListener[] listeners = new IWorkpageLifecycleListener[this.m_listeners.size()];
        this.m_listeners.toArray(listeners);
        for (IWorkpageLifecycleListener listener : listeners) {
            try {
                boolean thisResult = listener.reactOnBeforeHiddenInContentArea();
                if (thisResult) continue;
                allResult = false;
                break;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return allResult;
    }

    @Override
    public void reactOnShownInPopup() {
        IWorkpageLifecycleListener[] listeners = new IWorkpageLifecycleListener[this.m_listeners.size()];
        this.m_listeners.toArray(listeners);
        for (IWorkpageLifecycleListener listener : listeners) {
            try {
                listener.reactOnShownInPopup();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void throwWorkpageProcessingEvent(WorkpageProcessingEvent event) {
        if (event == null) {
            return;
        }
        event.passUuids(this.getWorkpageContainer().getUniqueId(), this.getUniqueTechnicalId());
        this.getWorkpageContainer().throwWorkpageProcessingEvent(event);
    }

    @Override
    public void processWorkpageProcessingEvent(WorkpageProcessingEvent event) {
        IWorkpageProcessingEventListener[] listeners = new IWorkpageProcessingEventListener[this.m_listenersProcessing.size()];
        this.m_listenersProcessing.toArray(listeners);
        for (IWorkpageProcessingEventListener listener : listeners) {
            try {
                boolean relevant;
                if (listener instanceof IMultiWorkplaceWorkpageProcessingEventListener && !(relevant = ((IMultiWorkplaceWorkpageProcessingEventListener)listener).checkIfEventIsRelevant(event))) continue;
                CLog.L.log(CLog.LL_INF, "Calling workpage event listener: " + listener);
                listener.processEvent(event);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Problems when calling workpage processor", t);
            }
        }
    }

    @Override
    public boolean checkIfWorkpageProcessingEventIsRelevant(WorkpageProcessingEvent event) {
        IWorkpageProcessingEventListener[] listeners = new IWorkpageProcessingEventListener[this.m_listenersProcessing.size()];
        this.m_listenersProcessing.toArray(listeners);
        for (IWorkpageProcessingEventListener listener : listeners) {
            try {
                boolean relevant;
                if (!(listener instanceof IMultiWorkplaceWorkpageProcessingEventListener) || !(relevant = ((IMultiWorkplaceWorkpageProcessingEventListener)listener).checkIfEventIsRelevant(event))) continue;
                return true;
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Problems when checking workpage processor for relevance", t);
            }
        }
        return false;
    }

    @Override
    public void addWorkpageProcessingEventListener(IWorkpageProcessingEventListener listener) {
        this.m_listenersProcessing.add(listener);
    }

    @Override
    public void removeWorkpageProcessingEventListener(IWorkpageProcessingEventListener listener) {
        this.m_listenersProcessing.remove(listener);
    }

    @Override
    public ModalPopup createModalPopupInWorkpageContext() {
        ModalPopup result = ModalPopup.createInstance();
        result.setContentReplaceDrillDown(this.getDispatcher().getContentReplace());
        result.setStartfromrootwindow(false);
        result.setOwner(this.getModelessPopupOfWorkpage());
        return result;
    }

    @Override
    public ModelessPopup createModelessPopupInWorkpageContext() {
        ModelessPopup result = ModelessPopup.createInstance();
        result.setContentReplaceDrillDown(this.getDispatcher().getContentReplace());
        result.setStartfromrootwindow(false);
        result.setOwner(this.getModelessPopupOfWorkpage());
        this.m_modelessPopups.add(result);
        result.addClosedListener(new ModelessPopup.IModelessPopupClosedListener(){

            @Override
            public void reactOnClosed(ModelessPopup popup) {
                try {
                    Workpage.this.m_modelessPopups.remove(popup);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                for (String assignedId : Workpage.this.m_modelessPopupsById.keySet()) {
                    ModelessPopup mp = Workpage.this.m_modelessPopupsById.get(assignedId);
                    if (mp != popup) continue;
                    Workpage.this.m_modelessPopupsById.remove(assignedId);
                    break;
                }
            }
        });
        return result;
    }

    @Override
    public void assignIdToModelessPopup(ModelessPopup popup, String id) {
        this.m_modelessPopupsById.put(id, popup);
    }

    @Override
    public ModelessPopup getModelesspopup(String assignedId) {
        return this.m_modelessPopupsById.get(assignedId);
    }

    @Override
    public ModelessPopup getModelessPopupOfWorkpage() {
        return this.m_modelessPopup;
    }

    @Override
    public void setModelessPopupOfWorkpage(ModelessPopup popup) {
        this.m_modelessPopup = popup;
    }

    @Override
    public String getUniqueTechnicalId() {
        return this.m_uniqueTechnicalId;
    }

    public void setExcludeFromSavePerspective(boolean excludeFromSavePerspective) {
        this.m_excludeFromSavePerspective = excludeFromSavePerspective;
    }

    @Override
    public boolean getExcludeFromSavePerspective() {
        return this.m_excludeFromSavePerspective;
    }

    @Override
    public String getComment() {
        return ResourceManager.findText(this.m_comment);
    }

    public void setComment(String comment) {
        this.m_comment = comment;
    }

    @Override
    public boolean isBlocked() {
        return false;
    }

    @Override
    public ModelessPopup openSemiModalPopup(IPageBean callingPageBean, IPageBean popupPageBean, String title, int width, int height, ModelessPopup.IModelessPopupListener popupListener) {
        CLog.L.log(CLog.LL_INF, "Opening semi modal popup");
        if (this.indexOfSemiModalPopup(popupPageBean) < 0) {
            SemiModalPopupInfo smpi = new SemiModalPopupInfo();
            smpi.i_callingPageBean = callingPageBean;
            smpi.i_popupPageBean = popupPageBean;
            smpi.i_lastWidth = width;
            smpi.i_lastHeight = height;
            smpi.i_lastLeft = -1;
            smpi.i_lastTop = -1;
            smpi.i_title = title;
            smpi.i_popupListener = popupListener;
            if (!this.m_semiModalPopupsAreHidden) {
                ModelessPopup result;
                smpi.i_popup = result = callingPageBean.openModelessPopup(popupPageBean, title, width, height, popupListener);
                this.m_semiModalPopups.add(smpi);
                return result;
            }
            smpi.i_popup = null;
            this.m_semiModalPopups.add(smpi);
            return null;
        }
        CLog.L.log(CLog.LL_INF, "Semi modal popup was not opened, because popup for bean already exists!");
        return null;
    }

    @Override
    public void closeSemiModalPopup(IPageBean callingPageBean, IPageBean popupPageBean) {
        callingPageBean.closePopup(popupPageBean);
        int index = this.indexOfSemiModalPopup(popupPageBean);
        if (index >= 0) {
            this.m_semiModalPopups.remove(index);
        }
    }

    private int indexOfSemiModalPopup(IPageBean pageBean) {
        int index = -1;
        for (SemiModalPopupInfo smp : this.m_semiModalPopups) {
            ++index;
            if (smp.i_popupPageBean != pageBean) continue;
            return index;
        }
        return -1;
    }

    private void hideSemiModalPopups() {
        if (this.m_semiModalPopupsAreHidden) {
            return;
        }
        for (SemiModalPopupInfo smpi : this.m_semiModalPopups) {
            smpi.i_lastLeft = smpi.i_popup.getLeft();
            smpi.i_lastTop = smpi.i_popup.getTop();
            smpi.i_lastWidth = smpi.i_popup.getWidth();
            smpi.i_lastHeight = smpi.i_popup.getHeight();
            smpi.i_undecorated = smpi.i_popup.getUndecorated();
            smpi.i_avoidfocussingofopener = smpi.i_popup.getAvoidfocussingofopener();
            smpi.i_avoidfocussingofpopup = smpi.i_popup.getAvoidfocussingofpopup();
            smpi.i_closeonclickoutside = smpi.i_popup.getCloseonclickoutside();
            smpi.i_closeonmouseexit = smpi.i_popup.getCloseonmouseexit();
            smpi.i_closeonmouseactivity = smpi.i_popup.getCloseonmouseactivity();
            smpi.i_animationtype = smpi.i_popup.getAnimationtype();
            smpi.i_sizeAnimationtype = smpi.i_popup.getSizeAnimationtype();
            smpi.i_clientname = smpi.i_popup.getClientname();
            smpi.i_styleseq = smpi.i_popup.getStyleseq();
            smpi.i_styleseqdecoration = smpi.i_popup.getStyleseqdecoration();
            smpi.i_skipBlockingOnClose = smpi.i_popup.getSkipBlockingOnClose();
            smpi.i_withcloseicon = smpi.i_popup.getWithcloseicon();
            smpi.i_withmaximizeicon = smpi.i_popup.getWithmaximizeicon();
            smpi.i_parentHotkeysActive = smpi.i_popup.getParentHotkeysActive();
            smpi.i_callingPageBean.closePopup(smpi.i_popupPageBean);
            smpi.i_popup = null;
        }
        this.m_semiModalPopupsAreHidden = true;
    }

    private void showSemiModalPopups() {
        if (!this.m_semiModalPopupsAreHidden) {
            return;
        }
        for (SemiModalPopupInfo smpi : this.m_semiModalPopups) {
            ModelessPopup mp = smpi.i_callingPageBean.openModelessPopup(smpi.i_popupPageBean, smpi.i_title, smpi.i_lastWidth, smpi.i_lastHeight, smpi.i_popupListener);
            mp.setLeft(smpi.i_lastLeft);
            mp.setTop(smpi.i_lastTop);
            mp.setWidth(smpi.i_lastWidth);
            mp.setHeight(smpi.i_lastHeight);
            mp.setUndecorated(smpi.i_undecorated);
            mp.setAvoidfocussingofopener(smpi.i_avoidfocussingofopener);
            mp.setAvoidfocussingofpopup(smpi.i_avoidfocussingofpopup);
            mp.setCloseonclickoutside(smpi.i_closeonclickoutside);
            mp.setCloseonmouseexit(smpi.i_closeonmouseexit);
            mp.setCloseonmouseactivity(smpi.i_closeonmouseactivity);
            mp.setAnimationtype(smpi.i_animationtype);
            mp.setSizeAnimationtype(smpi.i_sizeAnimationtype);
            mp.setClientname(smpi.i_clientname);
            mp.setStyleseq(smpi.i_styleseq);
            mp.setStyleseqdecoration(smpi.i_styleseqdecoration);
            mp.setSkipBlockingOnClose(smpi.i_skipBlockingOnClose);
            mp.setWithcloseicon(smpi.i_withcloseicon);
            mp.setWithmaximizeicon(smpi.i_withmaximizeicon);
            mp.setParentHotkeysActive(smpi.i_parentHotkeysActive);
            smpi.i_popup = mp;
        }
        this.m_semiModalPopupsAreHidden = false;
    }

    @Override
    public boolean isShown() {
        IWorkpageContainer wpc = this.getWorkpageContainer();
        if (wpc.getCurrentWorkpage() == this) {
            return true;
        }
        return wpc.checkIfWorkpageIsOpenedInPopup(this);
    }

    @Override
    public String getClientName() {
        if (this.m_workpageStartInfo != null) {
            return this.m_workpageStartInfo.getClientName();
        }
        return null;
    }

    @Override
    public int getSortIndex() {
        if (this.m_workpageStartInfo != null) {
            return this.m_workpageStartInfo.getSortIndex();
        }
        return -1;
    }

    class SemiModalPopupInfo {
        IPageBean i_callingPageBean;
        IPageBean i_popupPageBean;
        ModelessPopup i_popup;
        int i_lastWidth = -1;
        int i_lastHeight = -1;
        int i_lastLeft = -1;
        int i_lastTop = -1;
        String i_title;
        boolean i_undecorated = false;
        boolean i_avoidfocussingofopener = false;
        boolean i_avoidfocussingofpopup = false;
        ModelessPopup.IModelessPopupListener i_popupListener;
        boolean i_closeonclickoutside = false;
        boolean i_closeonmouseexit = false;
        boolean i_closeonmouseactivity = false;
        String i_animationtype;
        String i_sizeAnimationtype;
        String i_clientname = null;
        String i_styleseq = null;
        String i_styleseqdecoration = null;
        boolean i_skipBlockingOnClose = false;
        boolean i_withcloseicon = true;
        boolean i_withmaximizeicon = true;
        boolean i_parentHotkeysActive = false;

        SemiModalPopupInfo() {
        }
    }
}

