/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.io.Serializable;
import org.eclnt.jsfserver.pagebean.IPageBean;
import org.eclnt.util.log.CLog;
import org.eclnt.workplace.ICreatePageBeanInstance;
import org.eclnt.workplace.IWorkpageAwarePageBean;
import org.eclnt.workplace.IWorkpageDispatcher;
import org.eclnt.workplace.Workpage;
import org.eclnt.workplace.WorkpageDispatchedPageBean;
import org.eclnt.workplace.WorkpageStartInfo;
import org.eclnt.workplace.eximport.WorkplacePageBeanStateExtractor;

public class WorkpageByPageBean
extends Workpage
implements Serializable {
    IPageBean m_pageBean;

    public WorkpageByPageBean(IWorkpageDispatcher dispatcher, IPageBean pageBean, String id, String title, String iconURL, boolean isDecorated) {
        super(dispatcher, pageBean.getPageName(), id, title, iconURL, isDecorated);
        this.m_pageBean = pageBean;
        if (this.m_pageBean instanceof WorkpageDispatchedPageBean) {
            ((WorkpageDispatchedPageBean)this.m_pageBean).setDispatcher(this.getDispatcher());
        }
        this.registerPageBeanInDispatcher();
    }

    public WorkpageByPageBean(IWorkpageDispatcher dispatcher, String title, WorkpageStartInfo wpsi) {
        super(dispatcher, null, wpsi.getId(), title, wpsi.getImage(), wpsi.isDecorated());
        this.setWorkpageStartInfo(wpsi);
        for (String paramName : wpsi.getParamMap().keySet()) {
            this.setParam(paramName, wpsi.getParamMap().get(paramName));
        }
        this.m_pageBean = (IPageBean)this.getDispatcher().get(wpsi.getPageBeanName());
        if (this.m_pageBean != null) {
            this.setJspPage(this.m_pageBean.getPageName());
            this.registerPageBeanInDispatcher();
            WorkplacePageBeanStateExtractor.instance().applyStateIntoPageBean(this.m_pageBean, wpsi);
        } else {
            CLog.L.log(CLog.LL_WAR, "Could not create pagebean instance for name: " + wpsi.getPageBeanName());
            CLog.L.log(CLog.LL_WAR, "Result: empty workpage will be opened");
        }
    }

    public WorkpageByPageBean(IWorkpageDispatcher dispatcher, String title, WorkpageStartInfo wpsi, ICreatePageBeanInstance beanCreator) {
        super(dispatcher, null, wpsi.getId(), title, wpsi.getImage(), wpsi.isDecorated());
        if (beanCreator == null) {
            throw new Error("Pagebean must not be null");
        }
        this.setWorkpageStartInfo(wpsi);
        for (String paramName : wpsi.getParamMap().keySet()) {
            this.setParam(paramName, wpsi.getParamMap().get(paramName));
        }
        this.m_pageBean = beanCreator.createInstance(wpsi.getPageBeanName(), this.getDispatcher());
        this.setJspPage(this.m_pageBean.getPageName());
        this.registerPageBeanInDispatcher();
    }

    public IPageBean getPageBean() {
        return this.m_pageBean;
    }

    @Override
    public boolean isBlocked() {
        return this.m_semiModalPopups.size() > 0;
    }

    @Override
    public void reactOnDisplay() {
        super.reactOnDisplay();
    }

    @Override
    public void reactOnShownInContentArea() {
        super.reactOnShownInContentArea();
    }

    @Override
    public void reactOnHide() {
        super.reactOnHide();
    }

    @Override
    public void reactOnShownInPopup() {
        super.reactOnShownInPopup();
    }

    @Override
    public void closeForced() {
        super.closeForced();
    }

    protected void registerPageBeanInDispatcher() {
        int indexDot;
        CLog.L.log(CLog.LL_INF, "Registering page bean in dispatcher - begin");
        String rootExpression = this.m_pageBean.getRootExpressionUsedInPage();
        String topDispatcherRootExpression = this.getDispatcher().getTopOwner().getExpressionBase();
        CLog.L.log(CLog.LL_INF, ".....page bean's expression: " + rootExpression);
        CLog.L.log(CLog.LL_INF, ".....top dispatcher's expression: " + topDispatcherRootExpression);
        String topDispatcherRootExpressionWithoutBracket = topDispatcherRootExpression.substring(0, topDispatcherRootExpression.length() - 1);
        String key = null;
        key = rootExpression.startsWith(topDispatcherRootExpressionWithoutBracket + ".") ? rootExpression.substring(topDispatcherRootExpressionWithoutBracket.length() + 1, rootExpression.length() - 1) : ((indexDot = rootExpression.indexOf(46)) < 0 ? rootExpression.substring(2, rootExpression.length() - 1) : rootExpression.substring(indexDot + 1, rootExpression.length() - 1));
        CLog.L.log(CLog.LL_INF, ".....adding object to dispatcher with key: " + key);
        this.m_dispatcher.put(key, this.m_pageBean);
        String dispatcherRootExpression = this.m_dispatcher.getExpressionBase();
        String dispatcherRootExpressionWithoutBracket = dispatcherRootExpression.substring(0, dispatcherRootExpression.length() - 1);
        String actualRootExpression = dispatcherRootExpressionWithoutBracket + "." + key + "}";
        CLog.L.log(CLog.LL_INF, ".....assigning root expression: " + actualRootExpression);
        this.m_pageBean.setActualRootExpression(actualRootExpression);
        if (this.m_pageBean instanceof IWorkpageAwarePageBean) {
            ((IWorkpageAwarePageBean)this.m_pageBean).setWorkpageDispatcher(this.m_dispatcher);
        }
        CLog.L.log(CLog.LL_INF, "Registering page bean in dispatcher - end");
    }
}

