/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclnt.jsfserver.elements.ICCComponentProperties;
import org.eclnt.jsfserver.elements.componentnodes.OUTLOOKBARCONTENTNode;
import org.eclnt.jsfserver.elements.componentnodes.OUTLOOKBARITEMNode;
import org.eclnt.jsfserver.elements.componentnodes.OUTLOOKBARNode;
import org.eclnt.jsfserver.elements.componentnodes.ROWINCLUDENode;
import org.eclnt.jsfserver.elements.componentnodes.ROWPAGEBEANINCLUDENode;
import org.eclnt.jsfserver.elements.componentnodes.ROWWORKPLACEFUNCTIONTREENode;
import org.eclnt.jsfserver.elements.impl.ROWDYNAMICCONTENTBinding;
import org.eclnt.jsfserver.managedbean.IDispatcher;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.useraccess.IUserAccess;
import org.eclnt.jsfserver.util.useraccess.UserAccessMgr;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.IWorkpageDispatcher;
import org.eclnt.workplace.WorkpageStartInfo;
import org.eclnt.workplace.WorkplaceFunctionTree;
import org.eclnt.workplace.WorkplaceFunctionTreeFromInfoNode;
import org.eclnt.workplace.WorkplaceFunctionTreeInfoManager;
import org.eclnt.workplace.WorkplaceFunctionTreeInfoNode;
import org.eclnt.workplace.WorkplaceUserInfo;
import org.eclnt.workplace.WorkplaceUserInfoManager;

public class WorkplaceFunctionsManager
implements Serializable,
ICCComponentProperties {
    static Class s_functionTreeClass = FunctionTree.class;
    static Class s_checkIfToRenderNodeClass = null;
    IWorkpageDispatcher m_owningDispatcher;
    WorkplaceFunctionTreeInfoNode m_rootNode;
    ROWDYNAMICCONTENTBinding m_content = new ROWDYNAMICCONTENTBinding();
    List<FunctionTree> m_trees = new ArrayList<FunctionTree>();
    int m_obIndex = 0;
    ObrenderedMap m_obRenderedMap = new ObrenderedMap();
    String m_expressionBase;
    String m_functionTreeStyleVariant = null;
    ICheckIfToRenderNode m_checkIfToRenderNodeInstance = null;
    WorkplaceFunctionTree.IFunctionNodeActionListener m_functionNodeActionListener = null;
    String m_functionNodeDefaultDropReceive = null;

    public WorkplaceFunctionsManager(IWorkpageDispatcher owningDispatcher) {
        this.m_owningDispatcher = owningDispatcher;
        this.m_expressionBase = owningDispatcher.getExpressionBase();
        try {
            if (s_checkIfToRenderNodeClass != null) {
                this.m_checkIfToRenderNodeInstance = (ICheckIfToRenderNode)s_checkIfToRenderNodeClass.newInstance();
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when creating instance of checkIfToRenderNode-interface", t);
        }
    }

    public static void initFunctionTreeClass(Class clazz) {
        s_functionTreeClass = clazz;
    }

    public static void initCheckIfToRenderNodeClass(Class clazz) {
        s_checkIfToRenderNodeClass = clazz;
    }

    public void prepare() {
        try {
            CLog.L.log(CLog.LL_WAR, "Loading workplace functions (user specific)");
            IUserAccess ua = UserAccessMgr.getInstance();
            String user = ua.getCurrentUser();
            CLog.L.log(CLog.LL_WAR, "Loading workplace functions (use specific) - current user: " + user);
            WorkplaceUserInfo wui = WorkplaceUserInfoManager.loadUserInfo(user);
            this.importWorkplaceFunctionTreeInfoNode(wui.getFunctionTree());
        }
        catch (Throwable t) {
            try {
                CLog.L.log(CLog.LL_WAR, "Loading workplace functions (default)");
                this.importWorkplaceFunctionTreeInfoNode("default");
            }
            catch (Throwable th) {
                CLog.L.log(CLog.LL_WAR, "Problems occurred when preparing the workplace functions manager");
            }
        }
    }

    public void importWorkplaceFunctionTreeInfoNode(WorkplaceFunctionTreeInfoNode nodeToImport) {
        this.m_trees.clear();
        this.m_rootNode = nodeToImport;
        OUTLOOKBARNode ob = new OUTLOOKBARNode().setWidth("100%").setHeight("100%").setStylevariant("WP_OUTLOOKBAR").setValue(this.m_expressionBase.replace("}", ".workpageContainer.functionsManager.obIndex}"));
        OUTLOOKBARCONTENTNode obc = new OUTLOOKBARCONTENTNode().setStylevariant("WP_OUTLOOKBARCONTENT");
        int counter = 0;
        int treeCounter = 0;
        for (WorkplaceFunctionTreeInfoNode node : this.m_rootNode.getSubNodes()) {
            boolean renderNode = this.checkIfToRenderNode(node);
            if (!renderNode) continue;
            OUTLOOKBARITEMNode obi = new OUTLOOKBARITEMNode().setText(node.getText()).setStylevariant("WP_OUTLOOKBARITEM").setBgpaintaddon(node.getNodeBgpaint()).setClientname(node.getNodeClientname());
            ob.addSubNode(obi);
            if (node.getNodeComment() != null) {
                obi.setTooltip(node.getNodeComment());
            }
            if (node.getNodeImage() != null) {
                obi.setImage(node.getNodeImage());
            }
            if (node.getWorkpageStartInfo() == null) {
                FunctionTree tree = this.createFunctionTree(this.m_owningDispatcher, node);
                this.m_trees.add(tree);
                ROWWORKPLACEFUNCTIONTREENode wft = new ROWWORKPLACEFUNCTIONTREENode();
                obc.addSubNode(wft);
                if (this.m_functionTreeStyleVariant == null) {
                    wft.setStylevariant("WP_WORKPLACEFUNCTIONTREE");
                } else {
                    wft.setStylevariant(this.m_functionTreeStyleVariant);
                }
                wft.setRendered(this.m_expressionBase.replace("}", ".workpageContainer.functionsManager.obRenderedMap." + counter + "}"));
                wft.setObjectbinding(this.m_expressionBase.replace("}", ".workpageContainer.functionsManager.trees[" + treeCounter + "]}"));
                if (SystemXml.getWorkplaceMultiScreen()) {
                    wft.setPage("/eclntjsfserver/includes/wp_workplacefunctiontree_multiworkplace.jsp");
                }
                ++treeCounter;
            } else {
                WorkpageStartInfo wpsi = node.getWorkpageStartInfo();
                if (wpsi.getJspPage() != null) {
                    ROWINCLUDENode ri = new ROWINCLUDENode().setPage(wpsi.getJspPage()).setRendered(this.m_expressionBase.replace("}", ".workpageContainer.functionsManager.obRenderedMap." + counter + "}"));
                    obc.addSubNode(ri);
                } else if (wpsi.getPageBeanName() != null) {
                    ROWPAGEBEANINCLUDENode rpbin = new ROWPAGEBEANINCLUDENode().setPagebeanbinding("#{d." + wpsi.getPageBeanName() + "}").setRendered(this.m_expressionBase.replace("}", ".workpageContainer.functionsManager.obRenderedMap." + counter + "}"));
                    obc.addSubNode(rpbin);
                }
            }
            ++counter;
        }
        ob.addSubNode(obc);
        this.m_content.setContentNode(ob);
    }

    public void setFunctionNodeActionListener(WorkplaceFunctionTree.IFunctionNodeActionListener functionNodeActionListener) {
        this.m_functionNodeActionListener = functionNodeActionListener;
        for (FunctionTree tree : this.m_trees) {
            tree.setFunctionNodeActionListener(functionNodeActionListener);
        }
    }

    public WorkplaceFunctionTree.IFunctionNodeActionListener getFunctionNodeActionListener() {
        return this.m_functionNodeActionListener;
    }

    public String getFunctionNodeDefaultDropReceive() {
        return this.m_functionNodeDefaultDropReceive;
    }

    public void setFunctionNodeDefaultDropReceive(String functionNodeDefaultDropReceive) {
        this.m_functionNodeDefaultDropReceive = functionNodeDefaultDropReceive;
        for (FunctionTree tree : this.m_trees) {
            tree.setFunctionNodeDefaultDropReceive(functionNodeDefaultDropReceive);
        }
    }

    private boolean checkIfToRenderNode(WorkplaceFunctionTreeInfoNode node) {
        if (this.m_checkIfToRenderNodeInstance != null) {
            return this.m_checkIfToRenderNodeInstance.checkIfToRenderNode(node);
        }
        return true;
    }

    private FunctionTree createFunctionTree(IWorkpageDispatcher owner, WorkplaceFunctionTreeInfoNode infoNode) {
        FunctionTree tree = null;
        try {
            Constructor con = s_functionTreeClass.getConstructor(IDispatcher.class, WorkplaceFunctionTreeInfoNode.class);
            return (FunctionTree)con.newInstance(owner, infoNode);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem creating FunctionTree with class: " + s_functionTreeClass.getName(), t);
            tree = new FunctionTree(owner, infoNode);
            tree.setFunctionNodeActionListener(this.m_functionNodeActionListener);
            tree.setFunctionNodeDefaultDropReceive(this.m_functionNodeDefaultDropReceive);
            return tree;
        }
    }

    public void importWorkplaceFunctionTreeInfoNode(String treeName) {
        WorkplaceFunctionTreeInfoNode node = WorkplaceFunctionTreeInfoManager.loadFunctionTreeInfo(treeName);
        this.importWorkplaceFunctionTreeInfoNode(node);
    }

    public List<FunctionTree> getTrees() {
        return this.m_trees;
    }

    public int getObIndex() {
        return this.m_obIndex;
    }

    public void setObIndex(int obIndex) {
        this.m_obIndex = obIndex;
    }

    public ObrenderedMap getObRenderedMap() {
        return this.m_obRenderedMap;
    }

    public ROWDYNAMICCONTENTBinding getContent() {
        return this.m_content;
    }

    public String getFunctionTreeStyleVariant() {
        return this.m_functionTreeStyleVariant;
    }

    public void setFunctionTreeStyleVariant(String functionTreeStyleVariant) {
        this.m_functionTreeStyleVariant = functionTreeStyleVariant;
    }

    public void preselectTopNodeId(String topNodeId) {
        try {
            if (topNodeId == null) {
                return;
            }
            int counter = 0;
            for (FunctionTree tree : this.m_trees) {
                if (topNodeId.equals(tree.getRootNode().getNodeId())) {
                    if (counter < this.m_trees.size()) {
                        this.m_obIndex = counter;
                    }
                    return;
                }
                ++counter;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getCurrentTopNodeId() {
        try {
            String result = this.m_trees.get(this.m_obIndex).getRootNode().getNodeId();
            return result;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public WorkplaceFunctionTreeInfoNode getRootNode() {
        return this.m_rootNode;
    }

    public class ObrenderedMap
    extends HashMap<String, Boolean> {
        @Override
        public Boolean get(Object key) {
            int keyInt = ValueManager.decodeInt(key.toString(), 0);
            if (keyInt == WorkplaceFunctionsManager.this.m_obIndex) {
                return true;
            }
            return false;
        }
    }

    public static interface ICheckIfToRenderNode {
        public boolean checkIfToRenderNode(WorkplaceFunctionTreeInfoNode var1);
    }

    public static class FunctionTree
    extends WorkplaceFunctionTreeFromInfoNode
    implements Serializable {
        public FunctionTree(IDispatcher owner, WorkplaceFunctionTreeInfoNode rootNode) {
            super(owner, rootNode);
        }
    }
}

