/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.zzzzz.test;

import java.net.URL;
import java.util.List;
import org.eclnt.util.file.ClassloaderReader;
import org.junit.Assert;
import org.junit.Test;

public class ClassLoaderReaderTest {
    @Test
    public void testResourcesBytes() {
        List<byte[]> files = new ClassloaderReader().readFiles("META-INF/MANIFEST.MF", true);
        Assert.assertTrue((files.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testResourcesString() {
        List<String> files = new ClassloaderReader().readUTF8Files("META-INF/MANIFEST.MF", true);
        System.out.println("Number of files found: " + files.size());
        int counter = 0;
        for (String s : files) {
            ++counter;
            System.out.println("------------------------------------------------");
            if (s.length() > 100) {
                System.out.println(s.substring(0, 100));
                continue;
            }
            System.out.println(s);
        }
        Assert.assertTrue((files.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testResourcesPaths() {
        List<URL> files = new ClassloaderReader().readResourcePaths("META-INF/MANIFEST.MF", true);
        System.out.println("Number of files found: " + files.size());
        int counter = 0;
        for (URL s : files) {
            ++counter;
            System.out.println(s.toString());
        }
        Assert.assertTrue((files.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPackageDirs() {
        ClassloaderReader clr = new ClassloaderReader();
        List<URL> urls = clr.readResourcePaths("org", true);
        System.out.println("Number of files found: " + urls.size());
        int counter = 0;
        for (URL url : urls) {
            ++counter;
            System.out.println("---------------------------------------------------");
            System.out.println(url.toString());
            String contentString = clr.readURLContentAsUTF8(url, false);
            System.out.println(contentString);
        }
        Assert.assertTrue((urls.size() > 0 ? 1 : 0) != 0);
    }
}

