/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.zzzzz.test;

import java.io.File;
import org.eclnt.util.file.FileManager;
import org.junit.Assert;
import org.junit.Test;

public class TestFileManager {
    @Test
    public void testCopyDirectory() {
        try {
            String tempDir = TestFileManager.writeTempDir();
            FileManager.copyDirectory(tempDir, tempDir + "copy", null, true);
            Assert.assertTrue((boolean)FileManager.checkIfFileExists(tempDir + "copy/dir1/file1.txt"));
            Assert.assertTrue((boolean)FileManager.checkIfFileExists(tempDir + "copy/dir2/file1.txt"));
            System.out.println("Finished!");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)("Problem: " + t.toString()));
        }
    }

    @Test
    public void testCopyDirectoryWithIgnore() {
        try {
            String tempDir = TestFileManager.writeTempDir();
            String[] ignore = new String[]{"file1.txt"};
            FileManager.copyDirectory(tempDir, tempDir + "copy", ignore, true);
            Assert.assertFalse((boolean)FileManager.checkIfFileExists(tempDir + "copy/dir1/file1.txt"));
            Assert.assertTrue((boolean)FileManager.checkIfFileExists(tempDir + "copy/dir1/file2.txt"));
            Assert.assertFalse((boolean)FileManager.checkIfFileExists(tempDir + "copy/dir2/file1.txt"));
            System.out.println("Finished!");
            this.deleteTempDir();
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)("Problem: " + t.toString()));
        }
    }

    @Test
    public void testCopyDirectoryWithIgnoreAndExclude() {
        try {
            String tempDir = TestFileManager.writeTempDir();
            String[] ignore = new String[]{"file1.txt", "!dir2/file1.txt"};
            FileManager.copyDirectory(tempDir, tempDir + "copy", ignore, true);
            Assert.assertFalse((boolean)FileManager.checkIfFileExists(tempDir + "copy/dir1/file1.txt"));
            Assert.assertTrue((boolean)FileManager.checkIfFileExists(tempDir + "copy/dir1/file2.txt"));
            Assert.assertTrue((boolean)FileManager.checkIfFileExists(tempDir + "copy/dir2/file1.txt"));
            System.out.println("Finished!");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)("Problem: " + t.toString()));
        }
    }

    @Test
    public void testCopyDirectoryWithIgnoreAndExcludeSubdir() {
        try {
            String tempDir = TestFileManager.writeTempDir();
            String[] ignore = new String[]{"/dir1", "!/dir1/subdir"};
            FileManager.copyDirectory(tempDir, tempDir + "copy", ignore, true);
            Assert.assertFalse((boolean)FileManager.checkIfFileExists(tempDir + "copy/dir1/file1.txt"));
            Assert.assertTrue((boolean)FileManager.checkIfFileExists(tempDir + "copy/dir1/subdir/file1.txt"));
            System.out.println("Finished!");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)("Problem: " + t.toString()));
        }
    }

    @Test
    public void testWriteFileIfContentChanged() {
        try {
            String tempDir = FileManager.getTempFileDirectory().getAbsolutePath() + "/cctestfilemanager";
            String fileName = tempDir + "/contentChanged.txt";
            FileManager.ensureDirectoryExists(tempDir);
            FileManager.writeUTF8File(fileName, "abcde".repeat(100), true);
            long fRef = new File(fileName).lastModified();
            System.out.println(fRef);
            Thread.sleep(150L);
            FileManager.writeUTF8FileIfContentChanged(fileName, "abcde".repeat(100), true);
            File f = new File(fileName);
            System.out.println(f.lastModified());
            Assert.assertEquals((long)fRef, (long)f.lastModified());
            Thread.sleep(150L);
            FileManager.writeUTF8FileIfContentChanged(fileName, "abcde".repeat(99), true);
            f = new File(fileName);
            System.out.println(f.lastModified());
            Assert.assertNotEquals((long)fRef, (long)f.lastModified());
            FileManager.deleteDirectory(tempDir);
            System.out.println("Finished!");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)("Problem: " + t.toString()));
        }
    }

    private void deleteTempDir() {
        String tempDir = FileManager.getTempFileDirectory().getAbsolutePath() + "/cctestfilemanager";
        String tempDirCopy = FileManager.getTempFileDirectory().getAbsolutePath() + "/cctestfilemanagercopy";
        try {
            FileManager.deleteDirectory(tempDir);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            FileManager.deleteDirectory(tempDirCopy);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String writeTempDir() {
        String tempDir = FileManager.getTempFileDirectory().getAbsolutePath() + "/cctestfilemanager";
        String tempDirCopy = FileManager.getTempFileDirectory().getAbsolutePath() + "/cctestfilemanagercopy";
        FileManager.addAllowedRootDirectoryReadWrite(FileManager.getTempFileDirectory().getAbsolutePath());
        FileManager.ensureDirectoryExists(tempDir);
        FileManager.deleteDirectoryContent(tempDir);
        FileManager.ensureDirectoryExists(tempDirCopy);
        FileManager.deleteDirectoryContent(tempDirCopy);
        FileManager.ensureDirectoryExists(tempDir + "/dir1");
        FileManager.ensureDirectoryExists(tempDir + "/dir1/subdir");
        FileManager.writeUTF8File(tempDir + "/dir1/file1.txt", "TEST", true);
        FileManager.writeUTF8File(tempDir + "/dir1/file2.txt", "TEST", true);
        FileManager.writeUTF8File(tempDir + "/dir1/subdir/file1.txt", "TEST", true);
        FileManager.writeUTF8File(tempDir + "/dir1/subdir/file2.txt", "TEST", true);
        FileManager.ensureDirectoryExists(tempDir + "/dir2");
        FileManager.writeUTF8File(tempDir + "/dir2/file1.txt", "TEST", true);
        FileManager.writeUTF8File(tempDir + "/dir2/file2.txt", "TEST", true);
        return tempDir;
    }
}

