/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.zzzzz.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import org.eclnt.util.valuemgmt.PojoManager;
import org.junit.Assert;
import org.junit.Test;

public class TestPojoManager {
    @Test
    public void testStringMap2Pojo() {
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("firstName", "AA");
            m.put("lastName", "BB");
            Person p = new Person();
            PojoManager.transferStringMapDataIntoPojo(m, p, true);
            Assert.assertEquals((Object)"AA", (Object)p.getFirstName());
            Assert.assertEquals((Object)"BB", (Object)p.getLastName());
            System.out.println("OK!");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }

    @Test
    public void testStringMap2PojoChangesOnly() {
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            String aa1 = new String("AA");
            String aa2 = new String("AA");
            m.put("firstName", aa1);
            m.put("lastName", "BB");
            Person p = new Person();
            p.setFirstName(aa2);
            p.setLastName("AA");
            PojoManager.transferStringMapDataIntoPojoChangesOnly(m, p, true);
            Assert.assertTrue((p.getFirstName() == aa2 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"BB", (Object)p.getLastName());
            System.out.println("OK!");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }

    @Test
    public void testStringMap2PojoNotMatching() {
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("firstName", "AA");
            m.put("lastName", "BB");
            m.put("street", "CC");
            Person p = new Person();
            PojoManager.transferStringMapDataIntoPojo(m, p, false);
            Assert.assertEquals((Object)"AA", (Object)p.getFirstName());
            Assert.assertEquals((Object)"BB", (Object)p.getLastName());
            System.out.println("OK!");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }

    @Test
    public void testStringMap2PojoDataTypes() {
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("firstName", "AA");
            m.put("lastName", "BB");
            m.put("height", "100");
            Person p = new Person();
            PojoManager.transferStringMapDataIntoPojo(m, p, false);
            Assert.assertEquals((Object)"AA", (Object)p.getFirstName());
            Assert.assertEquals((Object)"BB", (Object)p.getLastName());
            Assert.assertEquals((long)100L, (long)p.getHeight());
            System.out.println("OK!");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }

    @Test
    public void testCreatePojoFromObjectMap() {
        try {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("firstName", "AA");
            m.put("lastName", "BB");
            m.put("height", 100);
            Person p = PojoManager.createPojoFromMapData(Person.class, m, true);
            Assert.assertEquals((Object)"AA", (Object)p.getFirstName());
            Assert.assertEquals((Object)"BB", (Object)p.getLastName());
            Assert.assertEquals((long)100L, (long)p.getHeight());
            System.out.println("OK!");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }

    @Test
    public void testCreatePojoFromStringMap() {
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("firstName", "AA");
            m.put("lastName", "BB");
            m.put("height", "100");
            Person p = PojoManager.createPojoFromStringMapData(Person.class, m, true);
            Assert.assertEquals((Object)"AA", (Object)p.getFirstName());
            Assert.assertEquals((Object)"BB", (Object)p.getLastName());
            Assert.assertEquals((long)100L, (long)p.getHeight());
            System.out.println("OK!");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }

    @Test
    public void testPojo2Pojo() {
        try {
            Person p1 = new Person();
            p1.setFirstName("AA");
            p1.setLastName("BB");
            p1.setHeight(100);
            Person p2 = new Person();
            PojoManager.transferPojoIntoPojo(p1, p2, true);
            Assert.assertEquals((Object)"AA", (Object)p2.getFirstName());
            Assert.assertEquals((Object)"BB", (Object)p2.getLastName());
            Assert.assertEquals((long)100L, (long)p2.getHeight());
            System.out.println("OK!");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }

    @Test
    public void testPojo2PojoNotNullOnly() {
        try {
            Person p1 = new Person();
            p1.setFirstName("AA");
            p1.setHeight(100);
            Person p2 = new Person();
            p2.setFirstName("DD");
            p2.setLastName("CC");
            PojoManager.transferPojoIntoPojo((Object)p1, (Object)p2, false, true, true);
            Assert.assertEquals((Object)"AA", (Object)p2.getFirstName());
            Assert.assertEquals((Object)"CC", (Object)p2.getLastName());
            Assert.assertEquals((long)100L, (long)p2.getHeight());
            System.out.println("OK!");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }

    @Test
    public void testHashcodeForPojo() {
        try {
            System.out.println("AAA".hashCode());
            System.out.println("AAB".hashCode());
            System.out.println("ABA".hashCode());
            Person p1 = new Person();
            p1.setFirstName("AAB");
            p1.setLastName("CC");
            p1.setHeight(100);
            Person p2 = new Person();
            p2.setFirstName("AAB");
            p2.setLastName("CC");
            p2.setHeight(100);
            Person p3 = new Person();
            p3.setFirstName("ABA");
            p3.setLastName("CC");
            p3.setHeight(100);
            Person p4 = new Person();
            p4.setFirstName("AAB");
            p4.setLastName("CC");
            p4.setHeight(101);
            String hashcode1 = PojoManager.calculateHashForPojo(p1);
            String hashcode2 = PojoManager.calculateHashForPojo(p2);
            String hashcode3 = PojoManager.calculateHashForPojo(p3);
            String hashcode4 = PojoManager.calculateHashForPojo(p4);
            System.out.println(hashcode1 + "/" + hashcode2 + "/" + hashcode3 + "/" + hashcode4);
            Assert.assertEquals((Object)hashcode1, (Object)hashcode2);
            Assert.assertNotEquals((Object)hashcode1, (Object)hashcode3);
            Assert.assertNotEquals((Object)hashcode1, (Object)hashcode4);
            Assert.assertNotEquals((Object)hashcode3, (Object)hashcode4);
            ArrayList<Person> ps = new ArrayList<Person>();
            ps.add(p1);
            ps.add(p2);
            ps.add(p3);
            ps.add(p4);
            String listHashcode1 = PojoManager.calculateHashForListOfPojos(ps);
            ps.remove(p1);
            String listHashcode2 = PojoManager.calculateHashForListOfPojos(ps);
            System.out.println(listHashcode1 + "/" + listHashcode2);
            Assert.assertNotEquals((Object)listHashcode1, (Object)listHashcode2);
            System.out.println("FINISHED!");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }

    @Test
    public void testHashcodeForPojoWithByteArry() {
        try {
            System.out.println(Objects.hash(new Object[]{new byte[]{1, 2, 3, 4, 5, 6}}));
            System.out.println(Objects.hash(new Object[]{new byte[]{1, 2, 3, 4, 5, 6}}));
            System.out.println(Arrays.hashCode(new byte[]{1, 2, 3, 4, 5, 6}));
            System.out.println(Arrays.hashCode(new byte[]{1, 2, 3, 4, 5, 6}));
            PersonWithImage p1 = new PersonWithImage();
            p1.setFirstName("AAB");
            p1.setLastName("CC");
            p1.setHeight(100);
            p1.setImage(new byte[]{1, 2, 3, 4, 5, 6});
            PersonWithImage p2 = new PersonWithImage();
            p2.setFirstName("AAB");
            p2.setLastName("CC");
            p2.setHeight(100);
            p2.setImage(new byte[]{1, 2, 3, 4, 5, 6});
            PersonWithImage p3 = new PersonWithImage();
            p3.setFirstName("AAB");
            p3.setLastName("CC");
            p3.setHeight(100);
            p3.setImage(new byte[]{1, 2, 3, 4, 6, 5});
            String hashcode1 = PojoManager.calculateHashForPojo(p1);
            String hashcode2 = PojoManager.calculateHashForPojo(p2);
            String hashcode3 = PojoManager.calculateHashForPojo(p3);
            System.out.println(hashcode1 + "/" + hashcode2 + "/" + hashcode3);
            Assert.assertEquals((Object)hashcode1, (Object)hashcode2);
            Assert.assertNotEquals((Object)hashcode1, (Object)hashcode3);
            System.out.println("FINISHED!");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }

    public static class Person {
        String firstName;
        String lastName;
        int m_height;

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public int getHeight() {
            return this.m_height;
        }

        public void setHeight(int height) {
            this.m_height = height;
        }
    }

    public static class PersonWithImage {
        String firstName;
        String lastName;
        int m_height;
        byte[] m_image;

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public int getHeight() {
            return this.m_height;
        }

        public void setHeight(int height) {
            this.m_height = height;
        }

        public byte[] getImage() {
            return this.m_image;
        }

        public void setImage(byte[] image) {
            this.m_image = image;
        }
    }
}

