/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.zzzzz.test;

import java.util.List;
import org.eclnt.jsfserver.util.ExpressionUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestSvgImageManger {
    @Test
    public void test() {
        try {
            String s = "name1:#{d.xxx.yyy}";
            List<String> exprs = ExpressionUtil.isolateExpressionsFromString(s);
            Assert.assertEquals((long)1L, (long)exprs.size());
            Assert.assertEquals((Object)"#{d.xxx.yyy}", (Object)exprs.get(0));
            System.out.println(exprs);
            s = "name1:#{d.xxx.yyy};name2:#{d.yyy.zzz == false}";
            exprs = ExpressionUtil.isolateExpressionsFromString(s);
            Assert.assertEquals((long)2L, (long)exprs.size());
            Assert.assertEquals((Object)"#{d.xxx.yyy}", (Object)exprs.get(0));
            Assert.assertEquals((Object)"#{d.yyy.zzz == false}", (Object)exprs.get(1));
            System.out.println(exprs);
            System.out.println("OK");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }

    @Test
    public void testRelative() {
        try {
            String s = ".{xxx}";
            String e = ExpressionUtil.buildAbsoluteExpressionFromRelativeExpression(s, "d.grid.row[0]");
            System.out.println(e);
            Assert.assertEquals((Object)"#{d.grid.row[0].xxx}", (Object)e);
            s = ".{xxx} AAA";
            e = ExpressionUtil.buildAbsoluteExpressionFromRelativeExpression(s, "d.grid.row[0]");
            System.out.println(e);
            Assert.assertEquals((Object)"#{d.grid.row[0].xxx} AAA", (Object)e);
            s = ".{xxx} AAA .{yyy.zzz}";
            e = ExpressionUtil.buildAbsoluteExpressionFromRelativeExpression(s, "d.grid.row[0]");
            System.out.println(e);
            Assert.assertEquals((Object)"#{d.grid.row[0].xxx} AAA #{d.grid.row[0].yyy.zzz}", (Object)e);
            s = ".{xxx != 0}";
            e = ExpressionUtil.buildAbsoluteExpressionFromRelativeExpression(s, "d.grid.row[0]");
            System.out.println(e);
            Assert.assertEquals((Object)"#{d.grid.row[0].xxx != 0}", (Object)e);
            System.out.println("OK");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }

    @Test
    public void testRelativeDirect() {
        try {
            String s = ".{}";
            String e = ExpressionUtil.buildAbsoluteExpressionFromRelativeExpression(s, "d.grid.row[0]");
            System.out.println(e);
            Assert.assertEquals((Object)"#{d.grid.row[0]}", (Object)e);
            s = ".{} AAA";
            e = ExpressionUtil.buildAbsoluteExpressionFromRelativeExpression(s, "d.grid.row[0]");
            System.out.println(e);
            Assert.assertEquals((Object)"#{d.grid.row[0]} AAA", (Object)e);
            s = ".{} AAA .{yyy.zzz}";
            e = ExpressionUtil.buildAbsoluteExpressionFromRelativeExpression(s, "d.grid.row[0]");
            System.out.println(e);
            Assert.assertEquals((Object)"#{d.grid.row[0]} AAA #{d.grid.row[0].yyy.zzz}", (Object)e);
            System.out.println("Finished");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }

    @Test
    public void testRelativeRepeat() {
        try {
            String s = ".{xx}";
            String e = ExpressionUtil.buildAbsoluteExpressionFromRelativeExpression(s, "d.grid.row[0]");
            System.out.println(e);
            Assert.assertEquals((Object)"#{d.grid.row[0].xx}", (Object)e);
            s = ".{x}";
            e = ExpressionUtil.buildAbsoluteExpressionFromRelativeExpression(s, "d.grid.row[0]");
            System.out.println(e);
            Assert.assertEquals((Object)"#{d.grid.row[0].x}", (Object)e);
            System.out.println("Finished");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.toString());
        }
    }
}

