/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.editor.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclnt.jsfserver.elements.ComponentRepository;
import org.eclnt.jsfserver.session.SessionInfo;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.StyleDesignTimeCopier;
import org.eclnt.jsfserver.util.StyleManager;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class ProjectInfo {
    String m_name;
    String m_projectdirectory;
    String m_webcontentdirectory;
    String m_webappaddonsdirectory;
    String m_webcontentdeployfromdirectory;
    String m_webcontentdeploydirectory;
    String m_webcontextroot;
    String m_webhostport;
    String m_webprotocol = "http";
    String m_javasourcedirectory;
    String m_javasourcewebinfdirectory;
    String m_javaclassdirectory;
    String m_javaclasswebinfdirectory;
    String m_copywebapp = "false";
    String m_reloadwebapp = "false";
    String m_projectFileName;
    String m_javaSourceEncoding = null;
    String m_classPathExtension = null;
    String m_propertyfilesdirectory = null;
    List<DesignTimeTLDInfo> m_libraries = new ArrayList<DesignTimeTLDInfo>();
    List<TemplateInfo> m_templates = new ArrayList<TemplateInfo>();
    String m_axis2Home = null;
    String[] m_copywebappIgnore = new String[]{".svn", ".git"};
    String m_previewbgpaint = null;
    String m_xml;
    List<AdditionalResourceInfo> m_additionalResources = new ArrayList<AdditionalResourceInfo>();
    String m_checkForUpdatedFiles = "true";
    String m_expressionmanager = null;
    String m_commandlinefilenotwriteable;
    String m_uitestcasedirectory = null;
    String m_htstylepath = "eclntjsfserver/htstyle/htstyle.css";
    String m_htpdastylepath = "eclntjsfserver/htstyle/pda/htstyle.css";
    String m_dispatchername = "d";
    String m_codegeneratorMemberprefix = "m_";
    String m_codegeneratorUIClassSuffix = "UI";
    int m_codegeneratorIndent = 4;
    String m_codegeneratorMembervisibility = "";
    List<ManagedBeanInfoDT> m_additionalManagedBeans = new ArrayList<ManagedBeanInfoDT>();
    boolean m_keepGeneratedIds = true;
    List<AdditionalDeployCopyInfo> m_additionalDeployInfos = new ArrayList<AdditionalDeployCopyInfo>();
    boolean m_allowclean = true;
    boolean m_allowversionupdatebytoolset = true;
    boolean m_projectfileStoredInProjectDirectory = false;
    String m_beanBrowserClassLoader = null;
    List<PackageAbbreviation> m_packageAbbreviations = new ArrayList<PackageAbbreviation>();
    List<HotDeploymentPackage> m_hotDeploymentPackages = new ArrayList<HotDeploymentPackage>();
    List<HotDeploymentPackage> m_hotDeploymentPackagesExclude = new ArrayList<HotDeploymentPackage>();
    boolean m_managedByCCToolSet = true;
    List<EditorPageBeanComponentInfo> m_pbcinfos = new ArrayList<EditorPageBeanComponentInfo>();
    boolean m_resourcesInWebContent = true;
    boolean m_resourcesInSource = true;
    boolean m_propertyFilesUTF8 = false;
    String m_bufferedRuntimePort;
    String m_bufferedRuntimeWebappsDirectory;
    String m_deployinfofilename;
    ClassLoader m_currentDesignTimeClassLoader;
    ClassLoader m_currentDesignTimeIndependentClassLoader;
    StyleDesignTimeCopier m_styleCopier = new StyleDesignTimeCopier(this);
    boolean m_layoutDefinitionsSavedAsXml = false;
    String m_runtimeServletTempDirectory = null;
    List<EmbeddedFunctions> m_embeddedFunctions = new ArrayList<EmbeddedFunctions>();
    String m_deeplAPIKey = null;
    String m_deeplTranslationContext = null;
    TextToLiteralIdInfo m_textToLiteralIdInfo = new TextToLiteralIdInfo();
    String m_currentPageName;
    Set<IProjectReloadListener> m_reloadListeners = new HashSet<IProjectReloadListener>();
    Set<IProjectPageLoadListener> m_pageLoadListeners = new HashSet<IProjectPageLoadListener>();
    String m_projectStyleName;
    List<StyleManager.Style> m_projectStyleInheritanceSequence = new ArrayList<StyleManager.Style>();
    List<String> m_styles = null;

    public ProjectInfo() {
        this.m_bufferedRuntimePort = this.findRuntimeTomcatPort();
        this.m_bufferedRuntimeWebappsDirectory = this.findRuntimeTomcatWebappsDirectory();
    }

    public void updateCurrentDesignTimeClassLoaders(ClassLoader cl, ClassLoader independentCl) {
        this.m_currentDesignTimeClassLoader = cl;
        this.m_currentDesignTimeIndependentClassLoader = independentCl;
    }

    public List<EmbeddedFunctions> getEmbeddedFunctions() {
        return this.m_embeddedFunctions;
    }

    public TextToLiteralIdInfo getTextToLiteralIdInfo() {
        return this.m_textToLiteralIdInfo;
    }

    public ClassLoader getCurrentDesignTimeClassLoader() {
        return this.m_currentDesignTimeClassLoader;
    }

    public ClassLoader getCurrentDesignTimeIndependentClassLoader() {
        return this.m_currentDesignTimeIndependentClassLoader;
    }

    public boolean getLayoutDefinitionsSavedAsXml() {
        return this.m_layoutDefinitionsSavedAsXml;
    }

    public void setLayoutDefinitionsSavedAsXml(boolean layoutDefinitionsSavedAsXml) {
        this.m_layoutDefinitionsSavedAsXml = layoutDefinitionsSavedAsXml;
    }

    public boolean getPropertyFilesUTF8() {
        return this.m_propertyFilesUTF8;
    }

    public void setPropertyFilesUTF8(boolean propertyFilesUTF8) {
        this.m_propertyFilesUTF8 = propertyFilesUTF8;
    }

    public String getName() {
        return this.m_name;
    }

    public String getBeanBrowserClassLoader() {
        return this.m_beanBrowserClassLoader;
    }

    public void setBeanBrowserClassLoader(String beanBrowserClassLoader) {
        this.m_beanBrowserClassLoader = beanBrowserClassLoader;
    }

    public boolean isProjectfileStoredInProjectDirectory() {
        return this.m_projectfileStoredInProjectDirectory;
    }

    public void setProjectfileStoredInProjectDirectory(boolean projectfileStoredInProjectDirectory) {
        this.m_projectfileStoredInProjectDirectory = projectfileStoredInProjectDirectory;
    }

    public String getDeeplAPIKey() {
        return this.m_deeplAPIKey;
    }

    public void setDeeplAPIKey(String deeplAPIKey) {
        this.m_deeplAPIKey = deeplAPIKey;
    }

    public String getDeeplTranslationContext() {
        return this.m_deeplTranslationContext;
    }

    public void setDeeplTranslationContext(String deeplTranslationContext) {
        this.m_deeplTranslationContext = deeplTranslationContext;
    }

    public String getProjectdirectory() {
        if (this.m_projectdirectory != null) {
            try {
                File f = FileManager.createFileInstance(this.resolveAttributeValue(this.m_projectdirectory));
                String result = f.getCanonicalPath();
                result = ValueManager.encodeIntoValidFileName(this.resolveAttributeValue(result), true);
                return result;
            }
            catch (Throwable t) {
                return ValueManager.encodeIntoValidFileName(this.resolveAttributeValue(this.m_projectdirectory), true);
            }
        }
        String result = this.m_webcontentdirectory + "/..";
        try {
            File f = FileManager.createFileInstance(result);
            result = f.getCanonicalPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ValueManager.encodeIntoValidFileName(this.resolveAttributeValue(result), true);
    }

    public String getWebcontentdirectory() {
        if (this.m_webcontentdirectory != null) {
            return this.resolveFileName(this.m_webcontentdirectory, true);
        }
        return this.resolveFileName("${project}/webcontent/", true);
    }

    public String getWebcontentdeployfromdirectory() {
        if (this.m_webcontentdeployfromdirectory != null) {
            return this.resolveFileName(this.m_webcontentdeployfromdirectory, true);
        }
        return this.getWebcontentdirectory();
    }

    public String getWebcontentdeploydirectory() {
        return this.resolveFileName(this.m_webcontentdeploydirectory, true);
    }

    public String getWebcontextroot() {
        return this.resolveAttributeValue(this.m_webcontextroot);
    }

    public String getWebhostport() {
        return this.resolveAttributeValue(this.m_webhostport);
    }

    public String getJavasourcedirectory() {
        if (this.m_javasourcedirectory != null) {
            return this.resolveFileName(this.m_javasourcedirectory, true);
        }
        return this.resolveFileName("${project}/src", true);
    }

    public String getWebappaddonsdirectory(boolean withDefaulting) {
        if (this.m_webappaddonsdirectory == null && withDefaulting) {
            return this.getWebcontentdirectory();
        }
        return this.resolveFileName(this.m_webappaddonsdirectory, true);
    }

    public void setWebappaddonsdirectory(String webappaddonsdirectory) {
        this.m_webappaddonsdirectory = webappaddonsdirectory;
    }

    public String getJavasourcewebinfdirectory() {
        if (this.m_javasourcewebinfdirectory != null) {
            return this.resolveFileName(this.m_javasourcewebinfdirectory, true);
        }
        if (this.getSupportsHotDeploy()) {
            return this.resolveFileName("${project}/src_webinf/", true);
        }
        return this.getJavasourcedirectory();
    }

    public String getJavaclassdirectory() {
        if (this.m_javaclassdirectory != null) {
            return this.resolveFileName(this.m_javaclassdirectory, true);
        }
        return ValueManager.encodeIntoValidFileName(this.getWebcontentdeployfromdirectory(), true) + "WEB-INF/classes/";
    }

    public void setJavaclassdirectory(String javaclassdirectory) {
        this.m_javaclassdirectory = javaclassdirectory;
    }

    public String getJavaclasswebinfdirectory() {
        if (this.m_javaclasswebinfdirectory != null) {
            return this.resolveFileName(this.m_javaclasswebinfdirectory, true);
        }
        return this.getWebcontentdeployfromdirectory() + "WEB-INF/classes/";
    }

    public void setJavaclasswebinfdirectory(String javaclasswebinfdirectory) {
        this.m_javaclasswebinfdirectory = javaclasswebinfdirectory;
    }

    public String getClassPathExtension() {
        return this.resolveAttributeValue(this.m_classPathExtension);
    }

    public boolean isCopywebapp() {
        return ValueManager.decodeBoolean(this.resolveAttributeValue(this.m_copywebapp), true);
    }

    public String[] getCopywebappIgnore() {
        return this.m_copywebappIgnore;
    }

    public List<DesignTimeTLDInfo> getLibrariesForReadAccess() {
        return this.m_libraries;
    }

    public void clearLibraries() {
        this.m_libraries.clear();
    }

    public void addLibrary(DesignTimeTLDInfo library) {
        this.m_libraries.add(library);
        library.setProjectInfo(this);
    }

    public void setWebcontentdirectory(String webcontentdirectory) {
        this.m_webcontentdirectory = webcontentdirectory;
    }

    public void setJavasourcedirectory(String javasourcedirectory) {
        this.m_javasourcedirectory = javasourcedirectory;
    }

    public String getProjectFileName() {
        return this.m_projectFileName;
    }

    public String getJavaSourceEncoding() {
        return this.resolveAttributeValue(this.m_javaSourceEncoding);
    }

    public boolean getSupportsHotDeploy() {
        String hotDeployFileName = this.getWebcontentdirectory() + "/eclntjsfserver/config/hotdeploy.xml";
        hotDeployFileName = ValueManager.encodeIntoValidFileName(hotDeployFileName, false);
        return FileManager.checkIfFileExists(hotDeployFileName);
    }

    public String getHotDeployFileName() {
        String hotDeployFileName = this.getWebcontentdirectory() + "/eclntjsfserver/config/hotdeploy.xml";
        hotDeployFileName = ValueManager.encodeIntoValidFileName(hotDeployFileName, false);
        return hotDeployFileName;
    }

    public String getAxis2Home() {
        return this.resolveAttributeValue(this.m_axis2Home);
    }

    public List<TemplateInfo> getTemplates() {
        return this.m_templates;
    }

    public String getPreviewbgpaint() {
        return this.resolveAttributeValue(this.m_previewbgpaint);
    }

    public String getXml() {
        return this.m_xml;
    }

    public boolean getReloadwebapp() {
        return ValueManager.decodeBoolean(this.resolveAttributeValue(this.m_reloadwebapp), true);
    }

    public List<AdditionalResourceInfo> getAdditionalResources() {
        return this.m_additionalResources;
    }

    public boolean getCheckForUpdatedFiles() {
        return ValueManager.decodeBoolean(this.resolveAttributeValue(this.m_checkForUpdatedFiles), true);
    }

    public String getExpressionManager() {
        return this.resolveAttributeValue(this.m_expressionmanager);
    }

    public String getCommandlinefilenotwriteable() {
        return this.resolveAttributeValue(this.m_commandlinefilenotwriteable);
    }

    public String getUitestcasedirectory() {
        if (this.m_uitestcasedirectory != null) {
            return this.resolveFileName(this.m_uitestcasedirectory, true);
        }
        return this.resolveFileName("${project}/uitest", true);
    }

    public boolean getAllowversionupdatebytoolset() {
        return this.m_allowversionupdatebytoolset;
    }

    public void setAllowversionupdatebytoolset(boolean allowversionupdate) {
        this.m_allowversionupdatebytoolset = allowversionupdate;
    }

    public String getPropertyfilesdirectory() {
        if (this.m_propertyfilesdirectory != null) {
            return this.resolveFileName(this.m_propertyfilesdirectory, true);
        }
        return this.getJavasourcedirectory();
    }

    public void setHtStylePath(String htStylePath) {
        if (htStylePath == null) {
            return;
        }
        if (htStylePath.startsWith("/")) {
            htStylePath = htStylePath.substring(1);
        }
        this.m_htstylepath = htStylePath;
    }

    public String getHtStylePath() {
        return this.resolveAttributeValue(this.m_htstylepath);
    }

    public void setHtPdaStylePath(String htPdaStylePath) {
        if (htPdaStylePath == null) {
            return;
        }
        if (htPdaStylePath.startsWith("/")) {
            htPdaStylePath = htPdaStylePath.substring(1);
        }
        this.m_htpdastylepath = htPdaStylePath;
    }

    public String getHtPdaStylePath() {
        return this.resolveAttributeValue(this.m_htpdastylepath);
    }

    public void addProjectReloadListener(IProjectReloadListener prl) {
        this.m_reloadListeners.add(prl);
    }

    public void removeProjectReloadListener(IProjectReloadListener prl) {
        this.m_reloadListeners.remove(prl);
    }

    public void addProjectPageLoadListener(IProjectPageLoadListener ppll) {
        this.m_pageLoadListeners.add(ppll);
    }

    public void removeProjectPageLoadListener(IProjectPageLoadListener ppll) {
        this.m_pageLoadListeners.remove(ppll);
    }

    public void setCurrentPageName(String value) {
        this.m_currentPageName = value;
    }

    public String getCurrentPageName() {
        return this.m_currentPageName;
    }

    public void setDispatchername(String value) {
        this.m_dispatchername = value;
    }

    public String getDispatchername() {
        return this.resolveAttributeValue(this.m_dispatchername);
    }

    public List<ManagedBeanInfoDT> getAdditionalManagedBeans() {
        return this.m_additionalManagedBeans;
    }

    public EditorPageBeanComponentInfo addPageBeanCopyInfo(String jspDirectory, String javaPackage) {
        EditorPageBeanComponentInfo epbci = new EditorPageBeanComponentInfo();
        epbci.setJspDirectory(jspDirectory);
        epbci.setJavaPackage(javaPackage);
        this.m_pbcinfos.add(epbci);
        return epbci;
    }

    public AdditionalResourceInfo addAdditionalResourceInfo(String package1, String name, String expressionprefix) {
        AdditionalResourceInfo result = new AdditionalResourceInfo(package1, name, expressionprefix);
        this.m_additionalResources.add(result);
        return result;
    }

    public void addEmbeddedFunctions(String className, boolean errorIfNotAvailable) {
        if (className == null) {
            return;
        }
        EmbeddedFunctions ef = new EmbeddedFunctions();
        ef.setClassName(className);
        ef.setErrorIfNotAvailable(errorIfNotAvailable);
        this.m_embeddedFunctions.add(ef);
    }

    public ManagedBeanInfoDT addManagedBeanInfoDT(String name, String className) {
        ManagedBeanInfoDT result = new ManagedBeanInfoDT(name, className);
        this.m_additionalManagedBeans.add(result);
        return result;
    }

    public TemplateInfo addTemplateInfo(String resource, String image) {
        TemplateInfo result = new TemplateInfo(resource, image);
        this.m_templates.add(result);
        return result;
    }

    public List<AdditionalDeployCopyInfo> getAdditionalDeployInfos() {
        return this.m_additionalDeployInfos;
    }

    public void createAdditionalDeployInfo(String fromdir, String fromzip, String todir, String ignorecsv, boolean ignoreDuringHotDeployment) {
        this.m_additionalDeployInfos.add(new AdditionalDeployCopyInfo(fromdir, fromzip, todir, ignorecsv, ignoreDuringHotDeployment));
    }

    public boolean getAllowclean() {
        return this.m_allowclean;
    }

    public void setAllowclean(boolean allowclean) {
        this.m_allowclean = allowclean;
    }

    public void pageLoaded(String pageName) {
        this.m_currentPageName = pageName;
        for (IProjectPageLoadListener ppll : this.m_pageLoadListeners) {
            try {
                ppll.reactOnPageLoad(this, pageName);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Invoking reacOnPageLoad: " + t);
            }
        }
    }

    public void reloadProject(Object trigger) {
        this.m_styles = null;
        this.m_projectStyleName = null;
        this.m_projectStyleInheritanceSequence.clear();
        IProjectReloadListener[] prls = new IProjectReloadListener[this.m_reloadListeners.size()];
        this.m_reloadListeners.toArray(prls);
        for (IProjectReloadListener prl : prls) {
            try {
                prl.reactOnReload(this, trigger);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_WAR, "Problem occurred when processing reload listener " + prl, t);
            }
        }
    }

    public void clear() {
        this.m_name = null;
        this.m_webcontentdirectory = null;
        this.m_webcontentdeploydirectory = null;
        this.m_webcontextroot = null;
        this.m_webhostport = null;
        this.m_javasourcedirectory = null;
        this.m_copywebapp = "false";
        this.m_reloadwebapp = "false";
        this.m_projectFileName = null;
        this.m_javaSourceEncoding = null;
        this.m_classPathExtension = null;
        this.m_libraries = new ArrayList<DesignTimeTLDInfo>();
        this.m_templates = new ArrayList<TemplateInfo>();
        this.m_axis2Home = null;
        this.m_copywebappIgnore = new String[0];
        this.m_previewbgpaint = null;
        this.m_xml = null;
        this.m_additionalResources.clear();
        this.m_checkForUpdatedFiles = "true";
        this.m_commandlinefilenotwriteable = null;
        this.m_keepGeneratedIds = true;
        this.m_additionalManagedBeans = new ArrayList<ManagedBeanInfoDT>();
        this.m_additionalDeployInfos = new ArrayList<AdditionalDeployCopyInfo>();
        this.m_packageAbbreviations.clear();
        this.m_hotDeploymentPackages.clear();
        this.m_hotDeploymentPackagesExclude.clear();
        this.m_pbcinfos.clear();
        this.m_managedByCCToolSet = false;
        this.m_pbcinfos.clear();
        this.m_beanBrowserClassLoader = null;
        this.m_projectfileStoredInProjectDirectory = false;
        this.m_deeplAPIKey = null;
        this.m_deeplTranslationContext = null;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setProjectdirectory(String value) {
        this.m_projectdirectory = value;
    }

    public void setWebcontentdeployfromdirectory(String webcontentdeployfromdirectory) {
        this.m_webcontentdeployfromdirectory = webcontentdeployfromdirectory;
    }

    public void setWebcontentdeploydirectory(String webcontentdeploydirectory) {
        this.m_webcontentdeploydirectory = webcontentdeploydirectory;
    }

    public void setWebcontextroot(String webcontextroot) {
        this.m_webcontextroot = webcontextroot;
    }

    public void setWebhostport(String webhostport) {
        this.m_webhostport = webhostport;
    }

    public void setCopywebapp(String copywebapp) {
        this.m_copywebapp = copywebapp;
    }

    public void setReloadwebapp(String reloadwebapp) {
        this.m_reloadwebapp = reloadwebapp;
    }

    public void setProjectFileName(String projectFileName) {
        this.m_projectFileName = projectFileName;
    }

    public void setJavaSourceEncoding(String javaSourceEncoding) {
        this.m_javaSourceEncoding = javaSourceEncoding;
    }

    public void setJavasourcewebinfdirectory(String javasourcewebinfdirectory) {
        this.m_javasourcewebinfdirectory = javasourcewebinfdirectory;
    }

    public void setClassPathExtension(String classPathExtension) {
        this.m_classPathExtension = classPathExtension;
    }

    public void setLibraries(List<DesignTimeTLDInfo> libraries) {
        this.m_libraries = libraries;
    }

    public void setTemplates(List<TemplateInfo> templates) {
        this.m_templates = templates;
    }

    public void setAxis2Home(String axis2Home) {
        this.m_axis2Home = axis2Home;
    }

    public void setCopywebappIgnore(String[] copywebappIgnore) {
        this.m_copywebappIgnore = copywebappIgnore;
    }

    public void setPreviewbgpaint(String previewbgpaint) {
        this.m_previewbgpaint = previewbgpaint;
    }

    public void setXml(String xml) {
        this.m_xml = xml;
    }

    public void setCheckForUpdateFiles(String value) {
        this.m_checkForUpdatedFiles = value;
    }

    public void setExpressionManager(String value) {
        this.m_expressionmanager = value;
    }

    public void setCommandlinefilenotwriteable(String value) {
        this.m_commandlinefilenotwriteable = value;
    }

    public void setUitestcasedirectory(String value) {
        this.m_uitestcasedirectory = value;
    }

    public void setPropertyfilesdirectory(String propertyfilesdirectory) {
        this.m_propertyfilesdirectory = propertyfilesdirectory;
    }

    public String getCodegeneratorMemberprefix() {
        return this.m_codegeneratorMemberprefix;
    }

    public void setCodegeneratorMemberprefix(String codegeneratorPropertyprefix) {
        this.m_codegeneratorMemberprefix = codegeneratorPropertyprefix;
    }

    public String getCodegeneratorUIClassSuffix() {
        return this.m_codegeneratorUIClassSuffix;
    }

    public void setCodegeneratorUIClassSuffix(String codegeneratorUIClassSuffix) {
        this.m_codegeneratorUIClassSuffix = codegeneratorUIClassSuffix;
    }

    public int getCodegeneratorIndent() {
        return this.m_codegeneratorIndent;
    }

    public void setCodegeneratorIndent(int codegeneratorIndent) {
        this.m_codegeneratorIndent = codegeneratorIndent;
    }

    public String getCodegeneratorMembervisibility() {
        return this.m_codegeneratorMembervisibility;
    }

    public void setCodegeneratorMembervisibility(String codegeneratorMembervisibility) {
        this.m_codegeneratorMembervisibility = codegeneratorMembervisibility;
    }

    public void setKeepGeneratedIds(boolean value) {
        this.m_keepGeneratedIds = value;
    }

    public boolean getKeepGeneratedIds() {
        return this.m_keepGeneratedIds;
    }

    public boolean getManagedByCCToolSet() {
        return this.m_managedByCCToolSet;
    }

    public void setManagedByCCToolSet(boolean projectIsManagedByCCToolSet) {
        this.m_managedByCCToolSet = projectIsManagedByCCToolSet;
    }

    public String getWebprotocol() {
        return this.m_webprotocol;
    }

    public void setWebprotocol(String webprotocol) {
        this.m_webprotocol = webprotocol;
    }

    public boolean getResourcesInWebContent() {
        if (!this.m_resourcesInWebContent && !this.m_resourcesInSource) {
            return true;
        }
        return this.m_resourcesInWebContent;
    }

    public void setResourcesInWebContent(boolean resourcesInWebContent) {
        this.m_resourcesInWebContent = resourcesInWebContent;
    }

    public boolean getResourcesInSource() {
        return this.m_resourcesInSource;
    }

    public void setResourcesInSource(boolean resourcesInSource) {
        this.m_resourcesInSource = resourcesInSource;
    }

    public List<EditorPageBeanComponentInfo> getPbcinfos() {
        return this.m_pbcinfos;
    }

    public void setPbcinfos(List<EditorPageBeanComponentInfo> pbcinfos) {
        this.m_pbcinfos = pbcinfos;
    }

    public String getRuntimeServletTempDirectory() {
        return this.resolveFileName(this.m_runtimeServletTempDirectory, true);
    }

    public void setRuntimeServletTempDirectory(String runtimeServletTempDirectory) {
        this.m_runtimeServletTempDirectory = runtimeServletTempDirectory;
    }

    public void triggerSrcUpdateInEclipse() {
        try {
            if (this.getJavasourcedirectory() == null) {
                return;
            }
            String fileName = this.getProjectdirectory();
            if (!fileName.endsWith("/")) {
                fileName = fileName + "/";
            }
            fileName = fileName + ".ccEclipseSynch";
            FileManager.writeUTF8File(fileName, "Src changed", false);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "No source update file (eclipse) could be written. " + t.toString());
        }
    }

    public List<HotDeploymentPackage> getHotDeploymentPackages() {
        return this.m_hotDeploymentPackages;
    }

    public List<HotDeploymentPackage> getHotDeploymentPackagesExclude() {
        return this.m_hotDeploymentPackagesExclude;
    }

    public List<HotDeploymentPackage> readHotDeploymentPackagesCombined() {
        ArrayList<HotDeploymentPackage> result = new ArrayList<HotDeploymentPackage>();
        for (HotDeploymentPackage hdp : this.m_hotDeploymentPackages) {
            if (hdp == null || ValueManager.isEmpty(hdp.getName())) continue;
            result.add(hdp);
        }
        for (HotDeploymentPackage hdp : this.m_hotDeploymentPackagesExclude) {
            if (hdp == null || ValueManager.isEmpty(hdp.getName())) continue;
            if (!(hdp = hdp.createClone()).getName().startsWith("!")) {
                hdp.setName("!" + hdp.getName());
            }
            result.add(hdp);
        }
        return result;
    }

    public List<String> getStyles() {
        if (this.m_styles == null) {
            HashSet<String> styleNames = new HashSet<String>();
            try {
                List<File> dirs = FileManager.getDirectoriesOfDirectory(this.getWebcontentdirectory() + "eclntjsfserver/styles/");
                for (File dir : dirs) {
                    styleNames.add(dir.getName());
                }
                if (this.m_webappaddonsdirectory != null) {
                    dirs = FileManager.getDirectoriesOfDirectory(this.getWebappaddonsdirectory(false) + "eclntjsfserver/styles/");
                    for (File dir : dirs) {
                        styleNames.add(dir.getName());
                    }
                }
                if (this.m_currentDesignTimeIndependentClassLoader != null) {
                    styleNames.addAll(this.m_styleCopier.getCopiedStyleNames());
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_WAR, "Problems when reading styles of project: " + this.getWebcontentdirectory());
            }
            this.m_styles = new ArrayList<String>();
            this.m_styles.clear();
            this.m_styles.addAll(styleNames);
            Collections.sort(this.m_styles);
        }
        return this.m_styles;
    }

    public String getStyleDirectoryName(String styleName) {
        String result = ValueManager.encodeIntoValidFileName(this.getWebcontentdirectory() + "/eclntjsfserver/styles/" + styleName, true);
        if (!(FileManager.checkIfFileExists(result + "style.xml") || FileManager.checkIfFileExists((result = ValueManager.encodeIntoValidFileName(this.getWebappaddonsdirectory(true) + "/eclntjsfserver/styles/" + styleName, true)) + "style.xml") || FileManager.checkIfFileExists((result = this.m_styleCopier.getStyleDirectoryName(styleName)) + "style.xml"))) {
            throw new Error("Problems reading file: " + styleName);
        }
        return result;
    }

    public String getProjectStyle() {
        this.initProjectStyle();
        return this.m_projectStyleName;
    }

    public List<String> getStyleVariantsForComponent(String componentName) {
        this.initProjectStyle();
        ArrayList<String> result = new ArrayList<String>();
        for (StyleManager.Style style : this.m_projectStyleInheritanceSequence) {
            Map<String, StyleManager.StyleVariant> variants = style.getVariants();
            for (StyleManager.StyleVariant variant : variants.values()) {
                StyleManager.StyleTagInfo sti = variant.getStyleTagInfo(componentName);
                if (sti == null) continue;
                result.add(variant.getVariantName());
            }
        }
        Collections.sort(result);
        return result;
    }

    public List<StyleManager.StyleValue> getStyleValues() {
        this.initProjectStyle();
        ArrayList<StyleManager.StyleValue> result = new ArrayList<StyleManager.StyleValue>();
        if (this.m_projectStyleInheritanceSequence.size() >= 0) {
            try {
                HashMap<String, StyleManager.StyleValue> svs = new HashMap<String, StyleManager.StyleValue>();
                for (StyleManager.Style style : this.m_projectStyleInheritanceSequence) {
                    style.addStyleValues(svs);
                }
                result.addAll(svs.values());
                Collections.sort(result);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean checkIfAttributeIsManagedByStyle(String componentName, String attributeName, String stylevariantName) {
        this.initProjectStyle();
        if (stylevariantName == null) {
            stylevariantName = "default";
        }
        if (this.m_projectStyleInheritanceSequence.size() >= 0) {
            try {
                for (StyleManager.Style style : this.m_projectStyleInheritanceSequence) {
                    StyleManager.StyleTagInfo sti;
                    StyleManager.StyleVariant sv = style.getVariants().get(stylevariantName);
                    if (sv == null || (sti = sv.getStyleTagInfo(componentName)) == null) continue;
                    return sti.getAttributes().containsKey(attributeName);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public List<PackageAbbreviation> getPackageAbbreviations() {
        return this.m_packageAbbreviations;
    }

    public String getDeployinfofilename() {
        return this.m_deployinfofilename;
    }

    public void setDeployinfofilename(String deployinfofilename) {
        this.m_deployinfofilename = this.resolveFileName(deployinfofilename, false);
    }

    public void addPackageAbbreviation(String packageName, String abbreviation) {
        PackageAbbreviation pa = new PackageAbbreviation();
        pa.setPackageName(packageName);
        pa.setAbbreviation(abbreviation);
        this.m_packageAbbreviations.add(pa);
    }

    public String getBcigenResourcePath() {
        return "bcigen/" + this.m_name + "/";
    }

    public String getBcigenResourceDirectory() {
        String result = this.getPropertyfilesdirectory() + "/" + this.getBcigenResourcePath() + "/";
        result = ValueManager.encodeIntoValidFileName(result, true);
        return result;
    }

    private void initProjectStyle() {
        if (this.m_projectStyleName == null) {
            try {
                String defaultStyle = "default";
                if ("fx".equals(HttpSessionAccess.getCurrentClientJavaType())) {
                    defaultStyle = "defaultfx";
                }
                if (HttpSessionAccess.checkIfCurrentClientTypeIsRisc()) {
                    defaultStyle = "defaultrisc";
                }
                String sessionDefaultFileName = this.findBestFileName("eclntjsfserver/config/sessiondefaults.xml");
                SessionInfo sessionInfo = SessionInfo.readSessionInfoFromFile(sessionDefaultFileName, defaultStyle);
                this.m_projectStyleName = sessionInfo.getStyle();
                try {
                    String styleFileName = this.findBestFileName("eclntjsfserver/styles/" + this.m_projectStyleName + "/style.xml");
                    StyleManager.Style projectStyle = StyleManager.readDesignTimeStyle(this.m_projectStyleName, styleFileName, this.m_currentDesignTimeIndependentClassLoader);
                    StyleManager.addCSSGlobalVariablesToDeignTimeStyle(projectStyle, styleFileName);
                    this.m_projectStyleInheritanceSequence.add(projectStyle);
                    StyleManager.Style currentStyle = projectStyle;
                    int counter = 0;
                    while (currentStyle.getExtends() != null) {
                        CLog.L.log(CLog.LL_INF, "Adding parent style: " + currentStyle.getExtends());
                        String inheritedStyleFileName = this.findBestFileName("eclntjsfserver/styles/" + currentStyle.getExtends() + "/style.xml");
                        StyleManager.Style parentStyle = StyleManager.readDesignTimeStyle(currentStyle.getExtends(), inheritedStyleFileName, this.m_currentDesignTimeIndependentClassLoader);
                        StyleManager.addCSSGlobalVariablesToDeignTimeStyle(parentStyle, inheritedStyleFileName);
                        this.m_projectStyleInheritanceSequence.add(parentStyle);
                        currentStyle = parentStyle;
                        if (++counter <= 25) continue;
                        throw new Error("Recursive stlye definition: please check your style configuration");
                    }
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_WAR, "Problem occurred when reading project's style content: " + this.m_name, t);
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_WAR, "Problem occurred when reading project's style: " + this.m_name, t);
                this.m_projectStyleName = null;
            }
        }
    }

    private String findBestFileName(String relFileName) {
        String result = this.getWebcontentdirectory() + "/" + relFileName;
        if (!FileManager.checkIfFileExists(result = ValueManager.encodeIntoValidFileName(result, false))) {
            if (this.m_webappaddonsdirectory != null) {
                result = this.getWebappaddonsdirectory(false) + "/" + relFileName;
                result = ValueManager.encodeIntoValidFileName(result, false);
            }
            if (!FileManager.checkIfFileExists(result)) {
                for (AdditionalDeployCopyInfo adci : this.m_additionalDeployInfos) {
                    String adciStyleFileName = adci.getFromdir() + "/" + relFileName;
                    if (!FileManager.checkIfFileExists(adciStyleFileName = ValueManager.encodeIntoValidFileName(adciStyleFileName, false))) continue;
                    result = adciStyleFileName;
                    break;
                }
                if (!FileManager.checkIfFileExists(result) && relFileName.startsWith("eclntjsfserver/styles/")) {
                    result = this.m_styleCopier.getBaseDirectoryName() + relFileName.substring("eclntjsfserver/styles/".length());
                }
            }
        }
        return result;
    }

    private String resolveFileName(String fileName, boolean asDirectory) {
        if (fileName == null) {
            return null;
        }
        fileName = this.resolveAttributeValue(fileName);
        fileName = ValueManager.encodeIntoValidFileName(fileName, asDirectory);
        try {
            File f = FileManager.createFileInstance(fileName);
            fileName = f.getCanonicalPath();
            fileName = ValueManager.encodeIntoValidFileName(fileName, asDirectory);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return fileName;
    }

    private String findRuntimeTomcatWebappsDirectory() {
        try {
            String realPath = HttpSessionAccess.getServletContext().getRealPath("/");
            realPath = ValueManager.encodeIntoValidFileName(realPath, true);
            if (realPath.endsWith("/server/tomcattools/webapps/editor/")) {
                realPath = realPath.replace("/server/tomcattools/webapps/editor/", "/server/tomcat/webapps/");
            } else if (realPath.endsWith("/webapps/editor/")) {
                realPath = realPath.replace("/webapps/editor/", "/webapps/");
            } else {
                throw new Error("Could not find runtime tomcat directory");
            }
            return realPath;
        }
        catch (Throwable t) {
            return "<noRutimeDirectoryFound>";
        }
    }

    private String findRuntimeTomcatPort() {
        try {
            String result = null;
            int port = HttpSessionAccess.getCurrentRequest().getLocalPort();
            result = port == 51000 ? "50000" : "" + port;
            return result;
        }
        catch (Throwable t) {
            return "50000";
        }
    }

    private String resolveAttributeValue(String s) {
        if (s == null) {
            return null;
        }
        if (s.contains("${project}")) {
            s = s.replace("${project}", this.getProjectdirectory());
        }
        if (s.contains("${projectdeploy}")) {
            s = s.replace("${projectdeploy}", this.getWebcontentdeploydirectory());
        }
        if (s.contains("${projectname}")) {
            s = s.replace("${projectname}", this.getName());
        }
        if (s.contains("${deploytomcatwebappsdir}")) {
            s = s.replace("${deploytomcatwebappsdir}", this.m_bufferedRuntimeWebappsDirectory);
        }
        if (s.contains("${deploytomcatport}")) {
            s = s.replace("${deploytomcatport}", this.m_bufferedRuntimePort);
        }
        return s;
    }

    public static class TextToLiteralIdInfo {
        Set<String> i_attributeIgnore = new HashSet<String>();
        Set<String> i_attributeInclude = new HashSet<String>();
        String i_textPrefix;
        String i_tooltipPrefix;
        String i_titlePrefix;
        String i_userhintPrefix;
        String i_otherPrefix;

        public Set<String> getAttributeIgnore() {
            return this.i_attributeIgnore;
        }

        public Set<String> getAttributeInclude() {
            return this.i_attributeInclude;
        }

        public String getTextPrefix() {
            return this.i_textPrefix;
        }

        public void setTextPrefix(String textPrefix) {
            this.i_textPrefix = textPrefix;
        }

        public String getTooltipPrefix() {
            return this.i_tooltipPrefix;
        }

        public void setTooltipPrefix(String tooltipPrefix) {
            this.i_tooltipPrefix = tooltipPrefix;
        }

        public String getTitlePrefix() {
            return this.i_titlePrefix;
        }

        public void setTitlePrefix(String titlePrefix) {
            this.i_titlePrefix = titlePrefix;
        }

        public String getUserhintPrefix() {
            return this.i_userhintPrefix;
        }

        public void setUserhintPrefix(String userhintPrefix) {
            this.i_userhintPrefix = userhintPrefix;
        }

        public String getOtherPrefix() {
            return this.i_otherPrefix;
        }

        public void setOtherPrefix(String otherPrefix) {
            this.i_otherPrefix = otherPrefix;
        }
    }

    public static class DesignTimeTLDInfo
    extends ComponentRepository.TLDInfo {
        String i_controlsarrangementFileName;
        ProjectInfo i_projectInfo;
        ClassLoader i_designTimeClassLoader;

        public DesignTimeTLDInfo(String prefix, String tldFileName, String packageName, String uri, String controlsarrangementFileName, ProjectInfo projectInfo, ClassLoader designTimeClassLoader) {
            super(prefix, tldFileName, packageName, uri);
            this.i_controlsarrangementFileName = controlsarrangementFileName;
            this.i_designTimeClassLoader = designTimeClassLoader;
            this.i_projectInfo = projectInfo;
        }

        public DesignTimeTLDInfo(String prefix, String packageName, String ccControlLibraryXml, String controlsarrangementFileName, ProjectInfo projectInfo, ClassLoader designTimeClassLoader) {
            super(prefix, packageName, ccControlLibraryXml);
            this.i_controlsarrangementFileName = controlsarrangementFileName;
            this.i_designTimeClassLoader = designTimeClassLoader;
            this.i_projectInfo = projectInfo;
        }

        private void setProjectInfo(ProjectInfo value) {
            this.i_projectInfo = value;
        }

        public String getControlsarrangementFileName() {
            if (this.i_controlsarrangementFileName != null) {
                String result = this.i_projectInfo.getProjectdirectory() + "/" + this.i_controlsarrangementFileName;
                if (FileManager.checkIfFileExists(result = ValueManager.encodeIntoValidFileName(result, false))) {
                    return result;
                }
            }
            return this.i_controlsarrangementFileName;
        }

        public ClassLoader getDesignTimeClassLoader() {
            return this.i_designTimeClassLoader;
        }
    }

    public static class EditorPageBeanComponentInfo {
        String i_jspDirectory;
        String i_javaPackage;

        public String getJspDirectory() {
            return this.i_jspDirectory;
        }

        public void setJspDirectory(String jspDirectory) {
            this.i_jspDirectory = jspDirectory;
        }

        public String getJavaPackage() {
            return this.i_javaPackage;
        }

        public void setJavaPackage(String javaPackage) {
            this.i_javaPackage = javaPackage;
        }
    }

    public class AdditionalResourceInfo {
        String i_package;
        String i_name;
        String i_expressionprefix;

        public AdditionalResourceInfo(String package1, String name, String expressionprefix) {
            this.i_package = package1;
            this.i_name = name;
            this.i_expressionprefix = expressionprefix;
        }

        public String getPackage() {
            return ProjectInfo.this.resolveAttributeValue(this.i_package);
        }

        public String getName() {
            return ProjectInfo.this.resolveAttributeValue(this.i_name);
        }

        public String getExpressionprefix() {
            return ProjectInfo.this.resolveAttributeValue(this.i_expressionprefix);
        }
    }

    public static class EmbeddedFunctions {
        String i_className;
        boolean i_errorIfNotAvailable = false;

        public String getClassName() {
            return this.i_className;
        }

        public void setClassName(String className) {
            this.i_className = className;
        }

        public boolean getErrorIfNotAvailable() {
            return this.i_errorIfNotAvailable;
        }

        public void setErrorIfNotAvailable(boolean errorWhenNotAvailable) {
            this.i_errorIfNotAvailable = errorWhenNotAvailable;
        }
    }

    public class ManagedBeanInfoDT {
        String i_name;
        String i_className;

        public ManagedBeanInfoDT(String name, String className) {
            this.i_name = name;
            this.i_className = className;
        }

        public String getName() {
            return ProjectInfo.this.resolveAttributeValue(this.i_name);
        }

        public void setName(String name) {
            this.i_name = name;
        }

        public String getClassName() {
            return ProjectInfo.this.resolveAttributeValue(this.i_className);
        }

        public void setClassName(String className) {
            this.i_className = className;
        }
    }

    public class TemplateInfo {
        String i_resource;
        String i_image;
        String i_ignorecsv;

        public TemplateInfo(String resource, String image) {
            this.i_resource = resource;
            this.i_image = image;
        }

        public void setResource(String value) {
            this.i_resource = value;
        }

        public String getResource() {
            return ProjectInfo.this.resolveAttributeValue(this.i_resource);
        }

        public void setImage(String value) {
            this.i_image = value;
        }

        public String getImage() {
            return ProjectInfo.this.resolveAttributeValue(this.i_image);
        }

        public String getIgnorecsv() {
            return ProjectInfo.this.resolveAttributeValue(this.i_ignorecsv);
        }

        public void setIgnorecsv(String ignorecsv) {
            this.i_ignorecsv = ignorecsv;
        }
    }

    public class AdditionalDeployCopyInfo {
        String i_fromdir;
        String i_fromzip;
        String i_todir;
        String i_ignorecsv;
        boolean i_ignoreDuringHotDeployment = false;

        public AdditionalDeployCopyInfo(String fromdir, String fromzip, String todir, String ignorecsv, boolean ignoreDuringHotDeployment) {
            this.i_fromdir = fromdir;
            this.i_fromzip = fromzip;
            this.i_todir = todir;
            this.i_ignorecsv = ignorecsv;
            this.i_ignoreDuringHotDeployment = ignoreDuringHotDeployment;
        }

        public String getFromdir() {
            return ProjectInfo.this.resolveFileName(this.i_fromdir, true);
        }

        public String getFromzip() {
            return ProjectInfo.this.resolveFileName(this.i_fromzip, false);
        }

        public String getTodir() {
            return ProjectInfo.this.resolveFileName(this.i_todir, true);
        }

        public String getIgnorecsv() {
            return ProjectInfo.this.resolveAttributeValue(this.i_ignorecsv);
        }

        public void setIgnorecsv(String ignorecsv) {
            this.i_ignorecsv = ignorecsv;
        }

        public boolean isIgnoreDuringHotDeployment() {
            return this.i_ignoreDuringHotDeployment;
        }
    }

    public static interface IProjectPageLoadListener {
        public void reactOnPageLoad(ProjectInfo var1, String var2);
    }

    public static interface IProjectReloadListener {
        public void reactOnReload(ProjectInfo var1, Object var2);
    }

    public static class HotDeploymentPackage {
        String i_name;

        public String getName() {
            return this.i_name;
        }

        public void setName(String name) {
            this.i_name = name;
        }

        public HotDeploymentPackage createClone() {
            HotDeploymentPackage result = new HotDeploymentPackage();
            result.i_name = this.i_name;
            return result;
        }
    }

    public class PackageAbbreviation {
        String i_packageName;
        String i_abbreviation;

        public String getPackageName() {
            return this.i_packageName;
        }

        public void setPackageName(String packageName) {
            this.i_packageName = packageName;
        }

        public String getAbbreviation() {
            return this.i_abbreviation;
        }

        public void setAbbreviation(String abbreviation) {
            this.i_abbreviation = abbreviation;
        }
    }
}

