/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.calendar;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.eclnt.jsfserver.calendar.ExtCalendar;
import org.eclnt.jsfserver.calendar.IExtCalendarMgr;
import org.eclnt.jsfserver.configuration.CCConfigurationObject;
import org.eclnt.jsfserver.streamstore.StreamStore;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;

public class ExtCalendarMgr
implements IExtCalendarMgr {
    static final Object s_syncher = new Object();
    static final Object s_syncherGetCalendar = new Object();
    static CCConfigurationObject<IExtCalendarMgr> s_instance;
    Map<String, ExtCalendar> m_calendars = new HashMap<String, ExtCalendar>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IExtCalendarMgr getInstance() {
        if (s_instance == null) {
            Object object = s_syncher;
            synchronized (object) {
                if (s_instance == null) {
                    try {
                        String className = SystemXml.getExtCalendarMgr();
                        s_instance = new CCConfigurationObject(className, null);
                    }
                    catch (Throwable t) {
                        CLog.L.log(CLog.LL_INF, "Error when initializing extended calendar manager: " + t.toString());
                        s_instance = new CCConfigurationObject<Object>(null);
                    }
                }
            }
        }
        return s_instance.instance();
    }

    @Override
    public void clearBuffer() {
    }

    @Override
    public List<String> getAvailableCalendarIds() {
        List<String> fileNames = StreamStore.getInstance().getContainedStreams("ccextcalendar/", true);
        ArrayList<String> result = new ArrayList<String>();
        for (String fileName : fileNames) {
            result.add(fileName.substring(0, fileName.length() - 4));
        }
        return result;
    }

    @Override
    public IExtCalendarMgr.ExtCalendarInfo getCalendarInfoForDay(String calendarId, Date d, String timeZone) {
        if (timeZone == null) {
            timeZone = TimeZone.getDefault().getID();
        }
        ExtCalendar cal = this.getExtCalendar(calendarId);
        IExtCalendarMgr.ExtCalendarInfo result = cal.getCalendarInfoForDay(d, timeZone);
        return result;
    }

    @Override
    public List<IExtCalendarMgr.ExtCalendarInfo> getCalendarInfoForMonth(String calendarId, Date d, String timeZone) {
        if (timeZone == null) {
            timeZone = TimeZone.getDefault().getID();
        }
        ExtCalendar cal = this.getExtCalendar(calendarId);
        return cal.getCalendarInfoForMonth(d, timeZone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExtCalendar getExtCalendar(String calendarId) {
        ExtCalendar result = this.m_calendars.get(calendarId);
        if (result == null) {
            Object object = s_syncherGetCalendar;
            synchronized (object) {
                result = this.m_calendars.get(calendarId);
                if (result == null) {
                    result = new ExtCalendar(calendarId, this);
                    this.m_calendars.put(calendarId, result);
                }
            }
        }
        return result;
    }
}

