/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.defaultscreens;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.Clipboard;
import org.eclnt.jsfserver.elements.events.BaseActionEventDrop;
import org.eclnt.jsfserver.elements.impl.FIXGRIDBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDComponent;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDListBinding;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDColumnInfo;
import org.eclnt.jsfserver.elements.util.FIXGRIDENUMExportType;
import org.eclnt.jsfserver.pagebean.PageBean;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class GridDetails
extends PageBean
implements Serializable {
    private static IGridDetailExtension s_extension;
    public static String PAGENAME_FUNCTIONS;
    public static String PAGENAME_EXPORTFUNCTIONS;
    public static String PAGENAME_COLUMNSDETAILS;
    public static boolean RENDERED_revertChanges;
    public static boolean RENDERED_backToDefault;
    protected FIXGRIDBinding m_grid;
    static Boolean s_xlsxAvailable;
    static Boolean s_odsAvailable;
    static boolean s_rowFunctionsAvailable;
    protected FIXGRIDListBinding<ColumnItem> m_lefts = new FIXGRIDListBinding();
    protected FIXGRIDListBinding<ColumnItem> m_rights = new FIXGRIDListBinding();
    protected List<IFIXGRIDColumnInfo> m_columnInfos = new ArrayList<IFIXGRIDColumnInfo>();
    protected Map<IFIXGRIDColumnInfo, Integer> m_columnInfosOriginalIndices = new HashMap<IFIXGRIDColumnInfo, Integer>();
    protected Map<Integer, IFIXGRIDColumnInfo> m_columnInfosOriginalIndicesReverse = new HashMap<Integer, IFIXGRIDColumnInfo>();
    protected List<Integer> m_columnWidths = new ArrayList<Integer>();
    protected List<Integer> m_columnSequence = new ArrayList<Integer>();
    protected IGridDetailsListener m_listener;
    protected boolean m_cellFunctionsAvailable = false;
    protected boolean m_rowFunctionsAvailable = false;
    protected String m_pageName = PAGENAME_FUNCTIONS;
    protected int m_numberOfFixColumns = 0;

    public GridDetails() {
        if (s_xlsxAvailable == null) {
            s_xlsxAvailable = CCClassResolver.checkIfClassIsAvailable("org.apache.poi.ss.usermodel.Workbook");
        }
        if (s_odsAvailable == null) {
            s_odsAvailable = CCClassResolver.checkIfClassIsAvailable("org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument");
        }
    }

    public static void initializeExtension(IGridDetailExtension extension) {
        s_extension = extension;
    }

    @Override
    public String getPageName() {
        return this.m_pageName;
    }

    @Override
    public String getRootExpressionUsedInPage() {
        return "#{eclntdefscr.gridDetails}";
    }

    public static void initRowFunctionsAvailable(boolean value) {
        s_rowFunctionsAvailable = value;
    }

    public void prepare(FIXGRIDBinding grid, IGridDetailsListener listener, boolean cellFunctionsAvailable, String pageName) {
        this.m_pageName = pageName;
        this.m_grid = grid;
        this.m_numberOfFixColumns = grid.getNumberOfFixColumns();
        this.m_grid.getTextSearcher().clearSearchResult();
        this.readColumnInfos();
        this.m_listener = listener;
        this.m_lefts.getItems().clear();
        this.m_rights.getItems().clear();
        String sequence = grid.getColumnsequence();
        if (sequence == null) {
            for (int i = 0; i < this.m_columnInfos.size(); ++i) {
                IFIXGRIDColumnInfo columnInfo = this.m_columnInfos.get(i);
                if (!columnInfo.isRenderable()) continue;
                int index = this.m_columnInfosOriginalIndices.get(columnInfo);
                this.m_rights.getItems().add(new ColumnItem(this.m_columnInfos.get(i), index));
            }
        } else {
            IFIXGRIDColumnInfo columnInfo;
            int i;
            HashSet<Integer> rightIndices = new HashSet<Integer>();
            int[] sequenceInts = ValueManager.decodeStraightIntCSV(sequence);
            for (i = 0; i < sequenceInts.length; ++i) {
                try {
                    columnInfo = this.m_columnInfosOriginalIndicesReverse.get(sequenceInts[i]);
                    if (!columnInfo.isRenderable()) continue;
                    this.m_rights.getItems().add(new ColumnItem(columnInfo, sequenceInts[i]));
                    rightIndices.add(sequenceInts[i]);
                    continue;
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_WAR, "Weird data passed: " + sequence);
                }
            }
            for (i = 0; i < this.m_columnInfos.size(); ++i) {
                try {
                    int index;
                    columnInfo = this.m_columnInfos.get(i);
                    if (!columnInfo.isRenderable() || rightIndices.contains(index = this.m_columnInfosOriginalIndices.get(columnInfo).intValue())) continue;
                    this.m_lefts.getItems().add(new ColumnItem(columnInfo, index));
                    continue;
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_WAR, "Weird data passed: " + sequence);
                }
            }
        }
        this.m_cellFunctionsAvailable = cellFunctionsAvailable;
        if (this.m_cellFunctionsAvailable) {
            this.m_cellFunctionsAvailable = this.m_grid.checkIfCellsAreHighlighted();
        }
        this.m_rowFunctionsAvailable = false;
        if (this.m_grid.getSelectedItems().size() > 1) {
            this.m_rowFunctionsAvailable = true;
        }
        this.sortColumnItems(this.m_lefts.getItems());
    }

    public boolean getAvailableNumberOfFixColumns() {
        return this.m_grid.getWithFixColumnsByUserConfiguration();
    }

    public int getNumberOfFixColumns() {
        return this.m_numberOfFixColumns;
    }

    public void setNumberOfFixColumns(int numberOfFixColumns) {
        this.m_numberOfFixColumns = numberOfFixColumns;
    }

    public boolean getRenderedRevertChanges() {
        return RENDERED_revertChanges;
    }

    public boolean getRenderedBackToDefault() {
        return RENDERED_backToDefault;
    }

    public FIXGRIDListBinding<ColumnItem> getLefts() {
        return this.m_lefts;
    }

    public FIXGRIDListBinding<ColumnItem> getRights() {
        return this.m_rights;
    }

    public boolean getCellFunctionsAvailable() {
        if (!s_rowFunctionsAvailable) {
            return false;
        }
        if (HttpSessionAccess.checkIfCurrentClientTypeIsRisc()) {
            return false;
        }
        return this.m_cellFunctionsAvailable;
    }

    public boolean getRowFunctionsAvailable() {
        if (!s_rowFunctionsAvailable) {
            return false;
        }
        return this.m_rowFunctionsAvailable;
    }

    public Boolean getXlsxAvailable() {
        return s_xlsxAvailable;
    }

    public Boolean getOdsAvailable() {
        return s_odsAvailable;
    }

    public String getSearchResult() {
        return this.m_grid.getTextSearcher().getSearchResult();
    }

    public String getDownloadFilenameCSV() {
        return this.m_grid.getExporter().getExportFilePrefix() + ".csv";
    }

    public String getDownloadFilenameXLSX() {
        return this.m_grid.getExporter().getExportFilePrefix() + ".xlsx";
    }

    public String getDownloadFilenameXML() {
        return this.m_grid.getExporter().getExportFilePrefix() + ".xml";
    }

    public String getDownloadFilenamePDF() {
        return this.m_grid.getExporter().getExportFilePrefix() + ".pdf";
    }

    public String getDownloadFilenameHTML() {
        return this.m_grid.getExporter().getExportFilePrefix() + ".html";
    }

    public String getDownloadFilenameODS() {
        return this.m_grid.getExporter().getExportFilePrefix() + ".ods";
    }

    public void onLeft(ActionEvent event) {
        for (ColumnItem item : this.m_rights.getSelectedItems()) {
            this.m_rights.deselectItem(item);
            this.m_rights.getItems().remove(item);
            this.m_lefts.getItems().add(item);
        }
        this.sortColumnItems(this.m_lefts.getItems());
    }

    public void onRight(ActionEvent event) {
        this.moveLeftsToRight(-1);
    }

    public void onUp(ActionEvent event) {
        if (!this.m_grid.checkIfFreeColumnSequenceUpdateIsSupported()) {
            return;
        }
        if (this.m_rights.getItems().size() == 0) {
            return;
        }
        if (this.m_rights.getItems().get(this.m_rights.getItems().size() - 1).getSelected()) {
            return;
        }
        for (int i = this.m_rights.getItems().size() - 2; i >= 0; --i) {
            ColumnItem ci = this.m_rights.getItems().get(i);
            if (!ci.getSelected()) continue;
            ColumnItem ciPlus1 = this.m_rights.getItems().get(i + 1);
            this.m_rights.getItems().set(i + 1, ci);
            this.m_rights.getItems().set(i, ciPlus1);
        }
    }

    public void onDown(ActionEvent event) {
        if (!this.m_grid.checkIfFreeColumnSequenceUpdateIsSupported()) {
            return;
        }
        if (this.m_rights.getItems().size() == 0) {
            return;
        }
        if (this.m_rights.getItems().get(0).getSelected()) {
            return;
        }
        for (int i = 1; i < this.m_rights.getItems().size(); ++i) {
            ColumnItem ci = this.m_rights.getItems().get(i);
            if (!ci.getSelected()) continue;
            ColumnItem ciMinus1 = this.m_rights.getItems().get(i - 1);
            if (!ciMinus1.i_columnInfo.getColumnMovingEnabled()) break;
            this.m_rights.getItems().set(i - 1, ci);
            this.m_rights.getItems().set(i, ciMinus1);
        }
    }

    public boolean getAvailableColumSequenceChange() {
        return this.m_grid.checkIfFreeColumnSequenceUpdateIsSupported();
    }

    public void onApply(ActionEvent event) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.m_rights.getItems().size(); ++i) {
            if (i != 0) {
                sb.append(";");
            }
            sb.append(this.m_rights.getItems().get((int)i).i_index);
        }
        this.m_grid.setColumnsequence(sb.toString());
        if (this.m_numberOfFixColumns >= this.m_rights.getItems().size()) {
            this.m_numberOfFixColumns = 0;
        }
        this.m_grid.setNumberOfFixColumns(this.m_numberOfFixColumns);
        if (s_extension != null) {
            s_extension.processColumnSequenceApply(this, this.m_grid);
        }
        if (this.m_listener != null) {
            this.m_listener.reactOnApplied();
        }
    }

    public void onRevertChanges(ActionEvent event) {
        this.prepare(this.m_grid, this.m_listener, this.m_cellFunctionsAvailable, this.m_pageName);
        if (s_extension != null) {
            s_extension.processColumnSequenceRevertChanges(this, this.m_grid);
        }
    }

    public void onBackToDefault(ActionEvent event) {
        this.m_grid.setColumnsequence(this.m_grid.getDefaultColumnsequence());
        this.m_grid.setModcolumnwidths(null);
        this.m_grid.setNumberOfFixColumns(0);
        if (s_extension != null) {
            s_extension.processColumnSequenceBackToDefault(this, this.m_grid);
        }
        if (this.m_listener != null) {
            this.m_listener.reactOnClose();
        }
    }

    public String getExportURLPdfWholeGrid() {
        return this.m_grid.getExporter().getExportURLPDFWholeGrid();
    }

    public String getExportURLPdfRows() {
        return this.m_grid.getExporter().getExportURLPDFSelectedRows();
    }

    public String getExportURLXLSXWholeGrid() {
        return this.m_grid.getExporter().getExportURLXLSXWholeGrid();
    }

    public String getExportURLXLSXRows() {
        return this.m_grid.getExporter().getExportURLXLSXSelectedRows();
    }

    public String getExportURLODSWholeGrid() {
        return this.m_grid.getExporter().getExportURLODSWholeGrid();
    }

    public String getExportURLODSRows() {
        return this.m_grid.getExporter().getExportURLODSSelectedRows();
    }

    public String getExportURLCsvWholeGrid() {
        return this.m_grid.getExporter().getExportURLCsvWholeGrid();
    }

    public String getExportURLCsvRows() {
        return this.m_grid.getExporter().getExportURLCsvSelectedRows();
    }

    public String getExportURLXMLWholeGrid() {
        return this.m_grid.getExporter().getExportURLXMLWholeGrid();
    }

    public String getExportURLXMLRows() {
        return this.m_grid.getExporter().getExportURLXMLSelectedRows();
    }

    public String getExportURLHTMLWholeGrid() {
        return this.m_grid.getExporter().getExportURLHTMLWholeGrid();
    }

    public String getExportURLHTMLRows() {
        return this.m_grid.getExporter().getExportURLHTMLSelectedRows();
    }

    public String getExportURLCsvRange() {
        return this.m_grid.getExporter().getExportURLCsvRange();
    }

    public String getExportURLXMLRange() {
        return this.m_grid.getExporter().getExportURLXMLRange();
    }

    public void onExportToClipboardWholeGrid(ActionEvent event) {
        String content = this.m_grid.getExporter().exportToTabSeparatedStringWholeGrid(false);
        Clipboard.copyToClientClipboard(content);
        if (this.m_listener != null) {
            this.m_listener.reactOnClose();
        }
    }

    public void onExportToClipboardRows(ActionEvent event) {
        String content = this.m_grid.getExporter().exportToTabSeparatedStringWholeGrid(true);
        Clipboard.copyToClientClipboard(content);
        if (this.m_listener != null) {
            this.m_listener.reactOnClose();
        }
    }

    public void onExportToClipboardRange(ActionEvent event) {
        String content = this.m_grid.getExporter().exportToTabSeparatedStringRange();
        Clipboard.copyToClientClipboard(content);
        if (this.m_listener != null) {
            this.m_listener.reactOnClose();
        }
    }

    public void setSearchText(String value) {
        this.m_grid.getTextSearcher().setText(value);
    }

    public String getSearchText() {
        return this.m_grid.getTextSearcher().getText();
    }

    public boolean getCaseSensitive() {
        return this.m_grid.getTextSearcher().getCaseSensitive();
    }

    public void setCaseSensitive(boolean value) {
        this.m_grid.getTextSearcher().setCaseSensitive(value);
    }

    public void onSearchNext(ActionEvent event) {
        this.m_grid.getTextSearcher().onNext(event);
    }

    public void onSearchPrevious(ActionEvent event) {
        this.m_grid.getTextSearcher().onPrevious(event);
    }

    public void onDownloadPdfWholeGrid(ActionEvent event) {
        this.processDownload(FIXGRIDENUMExportType.PDF, true);
    }

    public void onDownloadCsvWholeGridAction(ActionEvent event) {
        this.processDownload(FIXGRIDENUMExportType.CSV, true);
    }

    public void onDownloadXMLWholeGridAction(ActionEvent event) {
        this.processDownload(FIXGRIDENUMExportType.XML, true);
    }

    public void onDownloadHTMLWholeGridAction(ActionEvent event) {
        this.processDownload(FIXGRIDENUMExportType.HTML, true);
    }

    public void onDownloadXLSXWholeGridAction(ActionEvent event) {
        this.processDownload(FIXGRIDENUMExportType.XLSX, true);
    }

    public void onDownloadODSWholeGridAction(ActionEvent event) {
        this.processDownload(FIXGRIDENUMExportType.ODS, true);
    }

    public void onDownloadPdfPartialGridAction(ActionEvent event) {
        this.processDownload(FIXGRIDENUMExportType.PDF, false);
    }

    public void onDownloadCsvPartialGridAction(ActionEvent event) {
        this.processDownload(FIXGRIDENUMExportType.CSV, false);
    }

    public void onDownloadXMLPartialGridAction(ActionEvent event) {
        this.processDownload(FIXGRIDENUMExportType.XML, false);
    }

    public void onDownloadHTMLPartialGridAction(ActionEvent event) {
        this.processDownload(FIXGRIDENUMExportType.HTML, false);
    }

    public void onDownloadXLSXPartialGridAction(ActionEvent event) {
        this.processDownload(FIXGRIDENUMExportType.XLSX, false);
    }

    public void onDownloadODSPartialGridAction(ActionEvent event) {
        this.processDownload(FIXGRIDENUMExportType.ODS, false);
    }

    private void storeColumnInfosOriginalIndices(List<IFIXGRIDColumnInfo> columnInfos) {
        this.m_columnInfosOriginalIndices.clear();
        int counter = 0;
        for (IFIXGRIDColumnInfo ci : columnInfos) {
            this.m_columnInfosOriginalIndices.put(ci, counter);
            this.m_columnInfosOriginalIndicesReverse.put(counter, ci);
            ++counter;
        }
    }

    protected void readColumnInfos() {
        List<IFIXGRIDColumnInfo> result = this.m_grid.getColumnInfos();
        this.storeColumnInfosOriginalIndices(result);
        this.m_columnInfos = result;
    }

    private void sortColumnItems(List<ColumnItem> result) {
        if ("text".equals(SystemXml.getFixgridGridDetailSortingOfColumns())) {
            this.sortColumnItemsByText(result);
        } else {
            this.sortColumnItemsByIndex(result);
        }
    }

    protected void sortColumnItemsByText(List<ColumnItem> result) {
        Collections.sort(result, new Comparator<ColumnItem>(){

            @Override
            public int compare(ColumnItem col1, ColumnItem col2) {
                String text1 = col1.getText();
                String text2 = col2.getText();
                if (text1 == null) {
                    text1 = "";
                }
                if (text2 == null) {
                    text2 = "";
                }
                return text1.compareTo(text2);
            }
        });
    }

    protected void sortColumnItemsByIndex(List<ColumnItem> result) {
        Collections.sort(result, new Comparator<ColumnItem>(){

            @Override
            public int compare(ColumnItem col1, ColumnItem col2) {
                return col1.i_index - col2.i_index;
            }
        });
    }

    private void moveRightNodes(ColumnItem node, boolean inFront) {
        int index = this.m_rights.getItems().indexOf(node);
        if (!inFront) {
            ++index;
        }
        FIXGRIDItem inFrontOfNode = null;
        if (index < this.m_rights.getItems().size()) {
            inFrontOfNode = this.m_rights.getItems().get(index);
        }
        if (inFrontOfNode != null && inFrontOfNode.getSelected()) {
            return;
        }
        ArrayList<ColumnItem> selectedRights = new ArrayList<ColumnItem>();
        for (ColumnItem right : this.m_rights.getItems()) {
            if (!right.getSelected()) continue;
            selectedRights.add(right);
        }
        for (int i = this.m_rights.getItems().size() - 1; i >= 0; --i) {
            if (!this.m_rights.getItems().get(i).getSelected()) continue;
            this.m_rights.getItems().remove(i);
        }
        if (inFrontOfNode == null) {
            for (ColumnItem selectedRight : selectedRights) {
                this.m_rights.getItems().add(selectedRight);
            }
        } else {
            index = this.m_rights.getItems().indexOf(inFrontOfNode);
            int counter = 0;
            for (ColumnItem selectedRight : selectedRights) {
                this.m_rights.getItems().add(index + counter, selectedRight);
                ++counter;
            }
        }
    }

    private void moveLeftNodes(ColumnItem node, boolean inFront) {
        int index = this.m_rights.getItems().indexOf(node);
        if (!inFront) {
            ++index;
        }
        if (index < this.m_rights.getItems().size()) {
            this.moveLeftsToRight(index);
        } else {
            this.moveLeftsToRight(-1);
        }
    }

    private void moveLeftsToRight(int index) {
        int counter = 0;
        for (ColumnItem item : this.m_lefts.getSelectedItems()) {
            this.m_lefts.deselectItem(item);
            this.m_lefts.getItems().remove(item);
            if (index < 0) {
                this.m_rights.getItems().add(item);
            } else {
                this.m_rights.getItems().add(index + counter, item);
            }
            ++counter;
        }
        this.sortRightsDueToGrouping();
    }

    private void sortRightsDueToGrouping() {
        if (this.m_rights.getItems().size() <= 1) {
            return;
        }
        if (this.m_rights.getItems().get((int)0).i_columnInfo.getGroupId() == null) {
            return;
        }
        try {
            List<FIXGRIDComponent.ColumnInfo> cis = this.m_grid.getColumnInfos();
            int numberOfColumns = cis.size();
            String[] colGroupIds = new String[numberOfColumns];
            for (int i = 0; i < numberOfColumns; ++i) {
                colGroupIds[i] = cis.get(i).getGroupId();
                if (colGroupIds[i] != null) continue;
                throw new Exception("Missing groupId in column: " + i);
            }
            List<Integer> allSequence = GridDetails.createFilledUpColumnSequence(numberOfColumns, colGroupIds, this.m_grid.getColumnsequence());
            int currentSbValue = this.m_rights.getSbvalue();
            Set currentSelectedItems = this.m_rights.getSelectedItems();
            HashMap<Integer, ColumnItem> m = new HashMap<Integer, ColumnItem>();
            for (ColumnItem columnItem : this.m_rights.getItems()) {
                m.put(columnItem.i_index, columnItem);
            }
            this.m_rights.getItems().clear();
            for (Integer seqIndex : allSequence) {
                ColumnItem columnItem = (ColumnItem)m.get(seqIndex);
                if (columnItem == null) continue;
                this.m_rights.getItems().add(columnItem);
            }
            this.m_rights.setSbvalue(currentSbValue);
            for (ColumnItem columnItem : currentSelectedItems) {
                this.m_rights.selectItem(columnItem);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem when sorting column infos", t);
        }
    }

    private static List<Integer> createFilledUpColumnSequence(int numberOfColumns, String[] colGroupIds, String columnSequence) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (columnSequence == null) {
            for (int i = 0; i < numberOfColumns; ++i) {
                result.add(i);
            }
        } else {
            int i;
            int[] csValues = ValueManager.decodeStraightIntCSV(columnSequence);
            for (i = 0; i < csValues.length; ++i) {
                result.add(csValues[i]);
            }
            for (i = 0; i < numberOfColumns; ++i) {
                if (result.contains(i)) continue;
                int insertIndex = -1;
                for (int j = result.size() - 1; j >= 0; --j) {
                    if (!ValueManager.checkIfStringsAreEqual(colGroupIds[i], colGroupIds[(Integer)result.get(j)])) continue;
                    insertIndex = j + 1;
                    break;
                }
                if (insertIndex == -1) {
                    insertIndex = result.size();
                }
                result.add(insertIndex, i);
            }
        }
        return result;
    }

    public static String JUNIT_createFilledUpColumnSequence(int numberOfColumns, String colGroupIdsCSV, String columnSequence) {
        String[] colGroupIds = ValueManager.decodeCSV(colGroupIdsCSV);
        List<Integer> l = GridDetails.createFilledUpColumnSequence(numberOfColumns, colGroupIds, columnSequence);
        ArrayList<String> sl = new ArrayList<String>();
        for (Integer il : l) {
            sl.add("" + il);
        }
        String result = ValueManager.encodeCSV(sl);
        return result;
    }

    private void processDownload(FIXGRIDENUMExportType exportType, boolean fullGrid) {
        this.m_grid.notifyDownloadWasTriggered(exportType, fullGrid);
    }

    static {
        PAGENAME_FUNCTIONS = "/eclntjsfserver/popups/gridfunctions.jsp";
        PAGENAME_EXPORTFUNCTIONS = "/eclntjsfserver/popups/gridexportfunctions.jsp";
        PAGENAME_COLUMNSDETAILS = "/eclntjsfserver/popups/griddetails.jsp";
        RENDERED_revertChanges = true;
        RENDERED_backToDefault = true;
        s_xlsxAvailable = null;
        s_odsAvailable = null;
        s_rowFunctionsAvailable = true;
    }

    public class ColumnItem
    extends FIXGRIDItem
    implements Serializable,
    Comparable<ColumnItem> {
        protected int i_index;
        protected IFIXGRIDColumnInfo i_columnInfo;

        public ColumnItem(IFIXGRIDColumnInfo columnInfo, int index) {
            this.i_columnInfo = columnInfo;
            this.i_index = index;
        }

        public String getFont() {
            if (!this.i_columnInfo.getColumnMovingEnabled()) {
                return "posture:italic;weight:bold";
            }
            return null;
        }

        public String getBackground() {
            if (!this.i_columnInfo.getColumnMovingEnabled()) {
                return "#00000008";
            }
            return null;
        }

        public String getText() {
            String text = this.i_columnInfo.getText();
            if (text == null) {
                text = "";
            }
            String tooltip = this.i_columnInfo.getTooltip();
            if (text.length() < 5 && tooltip != null && !tooltip.startsWith("server")) {
                text = text + " (" + tooltip + ")";
            }
            return text;
        }

        public String getTooltip() {
            return this.i_columnInfo.getTooltip();
        }

        @Override
        public int compareTo(ColumnItem o) {
            String sThis = this.i_columnInfo.getText();
            String sO = o.i_columnInfo.getText();
            if (sThis == null) {
                sThis = "";
            }
            if (sO == null) {
                sO = "";
            }
            return sThis.compareToIgnoreCase(sO);
        }

        @Override
        public void onRowSelect() {
            super.onRowSelect();
            if (!this.i_columnInfo.getColumnMovingEnabled()) {
                GridDetails.this.m_rights.deselectItem(this);
            }
        }

        @Override
        public void onRowExecute() {
            if (GridDetails.this.m_lefts.getItems().contains(this)) {
                GridDetails.this.onRight(null);
            } else {
                GridDetails.this.onLeft(null);
            }
        }

        public String getDragSendRight() {
            if (this.i_columnInfo.getColumnMovingEnabled()) {
                return "rights:rights";
            }
            return null;
        }

        public String getDropReceiveRight() {
            if (this.i_columnInfo.getColumnMovingEnabled() && GridDetails.this.m_grid.checkIfFreeColumnSequenceUpdateIsSupported()) {
                return "rights:verticalsplit;lefts:verticalsplit";
            }
            return null;
        }

        public String getDragSendLeft() {
            return "lefts:lefts";
        }

        public void onDropRights(ActionEvent ae) {
            try {
                boolean inFront;
                BaseActionEventDrop baed = (BaseActionEventDrop)ae;
                boolean bl = inFront = baed.getPercentageVertical() < 50;
                if (baed.getDragInfo().startsWith("rights:")) {
                    GridDetails.this.moveRightNodes(this, inFront);
                }
                if (baed.getDragInfo().startsWith("lefts:")) {
                    GridDetails.this.moveLeftNodes(this, inFront);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public IFIXGRIDColumnInfo getColumnInfo() {
            return this.i_columnInfo;
        }
    }

    public static interface IGridDetailExtension {
        public void processColumnSequenceBackToDefault(GridDetails var1, FIXGRIDBinding var2);

        public void processColumnSequenceRevertChanges(GridDetails var1, FIXGRIDBinding var2);

        public void processColumnSequenceApply(GridDetails var1, FIXGRIDBinding var2);
    }

    public static interface IGridDetailsListener {
        public void reactOnApplied();

        public void reactOnClose();
    }

    public static class DefaultGridDetailExtension
    implements IGridDetailExtension {
        @Override
        public void processColumnSequenceBackToDefault(GridDetails gridDetails, FIXGRIDBinding grid) {
        }

        @Override
        public void processColumnSequenceRevertChanges(GridDetails gridDetails, FIXGRIDBinding grid) {
        }

        @Override
        public void processColumnSequenceApply(GridDetails gridDetails, FIXGRIDBinding grid) {
        }
    }
}

