/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.defaultscreens;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.DefaultScreens;
import org.eclnt.jsfserver.defaultscreens.ISetId;
import org.eclnt.jsfserver.defaultscreens.ISetIdAndClose;
import org.eclnt.jsfserver.defaultscreens.ISetIdText;
import org.eclnt.jsfserver.defaultscreens.ModalPopup;
import org.eclnt.jsfserver.defaultscreens.ModelessPopup;
import org.eclnt.jsfserver.elements.BaseActionEvent;
import org.eclnt.jsfserver.elements.componentnodes.HTBUTTONNode;
import org.eclnt.jsfserver.elements.componentnodes.HTCOLDISTANCENode;
import org.eclnt.jsfserver.elements.componentnodes.HTLABELNode;
import org.eclnt.jsfserver.elements.componentnodes.HTROWNode;
import org.eclnt.jsfserver.elements.componentnodes.HTSCROLLPANENode;
import org.eclnt.jsfserver.elements.events.BaseActionEventInvoke;
import org.eclnt.jsfserver.elements.events.BaseActionEventKeySequence;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDListBinding;
import org.eclnt.jsfserver.elements.impl.ROWDYNAMICCONTENTBinding;
import org.eclnt.jsfserver.i18n.I18N;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.IListWithChangeIndex;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class IdTextSelection
implements Serializable,
ModalPopup.IModalPopupListener {
    static String PAGENAME_DEFAULT = "/eclntjsfserver/popups/idvalueselection.jsp";
    static String PAGENAME_WITHEXPLANATION = "/eclntjsfserver/popups/idvalueselectionwithexplanation.jsp";
    static String PAGENAME_IMAGESELECTION = "/eclntjsfserver/popups/idvalueimageselection.jsp";
    static String PAGENAME_LIST = "/eclntjsfserver/popups/idvalueselectionlist.jsp";
    static String PAGENAME_HT = "/eclntjsfserver/popups/idvalueselectionht.jsp";
    static boolean s_parentHotkeysActive = true;
    IdTextLineGrid m_lines = new IdTextLineGrid();
    List<IdTextLine> m_allLines = new ArrayList<IdTextLine>();
    public String m_explanation;
    ISetId m_setIdCallBack;
    ISetIdText m_setIdTextCallBack;
    ModelessPopup m_popup;
    boolean m_withHeader = true;
    boolean m_suppressHeadline = false;
    boolean m_renderIdColumn = true;
    boolean m_renderTextColumn = true;
    String m_requestFocus = "creation";
    String m_filterRequestFocus = null;
    String m_filterText;
    String m_lastFilterText;
    boolean m_renderFilterText = false;
    boolean m_filterIsUsed = true;
    String m_titleId = I18N.getString("IDTEXTSELECTION_titleId");
    String m_titleText = I18N.getString("IDTEXTSELECTION_titleText");
    int i_lastListChangeIndex = -1;
    String m_listValues;
    String m_listSelection;
    ROWDYNAMICCONTENTBinding m_htContent = null;

    IdTextSelection() {
    }

    public static void initialize() {
        if (SystemXml.getDefaultPopups().getIdtextselection() != null) {
            PAGENAME_DEFAULT = SystemXml.getDefaultPopups().getIdtextselection();
        }
        if (SystemXml.getDefaultPopups().getIdtextselectionwithexplanation() != null) {
            PAGENAME_WITHEXPLANATION = SystemXml.getDefaultPopups().getIdtextselectionwithexplanation();
        }
        if (SystemXml.getDefaultPopups().getIdvalueimageselection() != null) {
            PAGENAME_IMAGESELECTION = SystemXml.getDefaultPopups().getIdvalueimageselection();
        }
    }

    public static void initializeParentHotkeysActive(boolean value) {
        s_parentHotkeysActive = value;
    }

    public ModelessPopup getPopup() {
        return this.m_popup;
    }

    public String getRequestFocus() {
        return this.m_requestFocus;
    }

    public String getFilterRequestFocus() {
        return this.m_filterRequestFocus;
    }

    public void requestFocusInFilterField() {
        this.m_filterRequestFocus = "creation";
        this.m_requestFocus = null;
    }

    public void setTitleId(String titleId) {
        this.m_titleId = titleId;
    }

    public String getTitleId() {
        return this.m_titleId;
    }

    public void setTitleText(String titleText) {
        this.m_titleText = titleText;
    }

    public String getTitleText() {
        return this.m_titleText;
    }

    public static IdTextSelection createInstance() {
        if ("browser".equals(HttpSessionAccess.getCurrentClientType())) {
            return IdTextSelection.createInstanceHt();
        }
        IdTextSelection result = IdTextSelection.closeAndCreateExistingInstance();
        result.m_popup = ModelessPopup.createInstance();
        result.m_popup.setClientname(IdTextSelection.class.getSimpleName());
        result.m_popup.setCloseonclickoutside(true);
        result.m_popup.open(PAGENAME_DEFAULT, "Value Selection", 300, 250, result);
        result.m_popup.setUndecorated(true);
        result.m_popup.setStartfromrootwindow(false);
        result.m_popup.setContentReplace("$i$:" + result.m_popup.getIndex());
        result.m_popup.setUpdateIsolation(true);
        result.m_popup.setSizeableIfUndecorated(true);
        result.m_popup.setParentHotkeysActive(s_parentHotkeysActive);
        return result;
    }

    private static IdTextSelection closeAndCreateExistingInstance() {
        DefaultScreens.SessionAccess sessionAccess = DefaultScreens.getSessionAccess();
        IdTextSelection existingIdTextSelection = sessionAccess.getPopupIdTextSelection();
        if (existingIdTextSelection != null) {
            try {
                if (existingIdTextSelection.m_popup != null) {
                    existingIdTextSelection.m_setIdCallBack = null;
                    existingIdTextSelection.m_setIdTextCallBack = null;
                    existingIdTextSelection.reactOnPopupClosedByUser();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        IdTextSelection result = new IdTextSelection();
        sessionAccess.setPopupIdTextSelection(result);
        result.init();
        return result;
    }

    protected static IdTextSelection createInstanceHt() {
        DefaultScreens.SessionAccess sessionAccess = DefaultScreens.getSessionAccess();
        IdTextSelection existingIdTextSelection = sessionAccess.getPopupIdTextSelection();
        if (existingIdTextSelection != null) {
            try {
                if (existingIdTextSelection.m_popup != null) {
                    existingIdTextSelection.reactOnPopupClosedByUser();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        IdTextSelection result = new IdTextSelection();
        sessionAccess.setPopupIdTextSelection(result);
        result.init();
        result.m_popup = ModelessPopup.createInstance();
        result.m_popup.setClientname(IdTextSelection.class.getSimpleName());
        result.m_popup.setCloseonclickoutside(true);
        result.m_popup.open(PAGENAME_HT, "Value Selection", 400, 250, result);
        result.m_popup.setUndecorated(true);
        result.m_popup.setStartfromrootwindow(false);
        result.m_popup.setContentReplace("$i$:" + result.m_popup.getIndex());
        result.m_popup.setUpdateIsolation(true);
        return result;
    }

    public static IdTextSelection createInstanceWithExplanation(String explanation) {
        if ("browser".equals(HttpSessionAccess.getCurrentClientType())) {
            return IdTextSelection.createInstanceHt();
        }
        IdTextSelection result = IdTextSelection.closeAndCreateExistingInstance();
        result.m_explanation = explanation;
        result.m_popup = ModelessPopup.createInstance();
        result.m_popup.setClientname(IdTextSelection.class.getSimpleName());
        result.m_popup.setCloseonclickoutside(true);
        result.m_popup.open(PAGENAME_WITHEXPLANATION, "Value Selection", 400, 450, result);
        result.m_popup.setUndecorated(true);
        result.m_popup.setStartfromrootwindow(false);
        result.m_popup.setContentReplace("$i$:" + result.m_popup.getIndex());
        result.m_popup.setUpdateIsolation(true);
        return result;
    }

    public static IdTextSelection createInstanceWithImageLine() {
        IdTextSelection result = IdTextSelection.closeAndCreateExistingInstance();
        result.m_popup = ModelessPopup.createInstance();
        result.m_popup.setClientname(IdTextSelection.class.getSimpleName());
        result.m_popup.setCloseonclickoutside(true);
        result.m_popup.open(PAGENAME_IMAGESELECTION, "Value Selection", 300, 350, result);
        result.m_popup.setUndecorated(true);
        result.m_popup.setStartfromrootwindow(false);
        result.m_popup.setContentReplace("$i$:" + result.m_popup.getIndex());
        result.m_popup.setUpdateIsolation(true);
        return result;
    }

    public static IdTextSelection createListInstance() {
        if ("browser".equals(HttpSessionAccess.getCurrentClientType())) {
            return IdTextSelection.createInstanceHt();
        }
        IdTextSelection result = IdTextSelection.closeAndCreateExistingInstance();
        result.m_popup = ModelessPopup.createInstance();
        result.m_popup.setClientname(IdTextSelection.class.getSimpleName());
        result.m_popup.setCloseonclickoutside(true);
        result.m_popup.open(PAGENAME_LIST, "Value Selection", 200, 200, result);
        result.m_popup.setUndecorated(true);
        result.m_popup.setStartfromrootwindow(false);
        result.m_popup.setContentReplace("$i$:" + result.m_popup.getIndex());
        result.m_popup.setUpdateIsolation(true);
        return result;
    }

    public void clear() {
        this.m_lines.getItems().clear();
        this.m_allLines.clear();
    }

    public IdTextLine addLine(String id, String name) {
        IdTextSelection idts = DefaultScreens.getSessionAccess().getPopupIdTextSelection();
        IdTextLine itl = new IdTextLine(idts, id, name);
        idts.m_lines.getItems().add(itl);
        this.m_allLines.add(itl);
        this.m_lastFilterText = null;
        return itl;
    }

    public IdTextLine addLine(String id, String name, String image) {
        IdTextSelection idts = DefaultScreens.getSessionAccess().getPopupIdTextSelection();
        IdTextLine itl = new IdTextLine(idts, id, name, image);
        idts.m_lines.getItems().add(itl);
        this.m_allLines.add(itl);
        this.m_lastFilterText = null;
        return itl;
    }

    public void setCallBack(ISetId callBack) {
        this.m_setIdCallBack = callBack;
    }

    public void setCallBack(ISetIdText callBack) {
        this.m_setIdTextCallBack = callBack;
    }

    public void onPopupClosedByUser(ActionEvent ae) {
        this.reactOnPopupClosedByUser();
    }

    public FIXGRIDListBinding<IdTextLine> getLines() {
        return this.m_lines;
    }

    public String getExplanation() {
        return this.m_explanation;
    }

    public void processSelectLine(IdTextLine line) {
        if (!line.m_selectable) {
            return;
        }
        if (this.m_setIdCallBack != null) {
            this.m_setIdCallBack.setId(line.getId());
            if (this.m_setIdCallBack instanceof ISetIdAndClose) {
                ((ISetIdAndClose)this.m_setIdCallBack).reactOnSelectionClosed();
            }
        }
        if (this.m_setIdTextCallBack != null) {
            this.m_setIdTextCallBack.setIdText(line.getId(), line.getText());
        }
        this.m_popup.close();
    }

    @Override
    public void reactOnPopupClosedByUser() {
        if (this.m_setIdCallBack != null && this.m_setIdCallBack instanceof ISetIdAndClose) {
            ((ISetIdAndClose)this.m_setIdCallBack).reactOnSelectionClosed();
        }
        this.m_popup.close();
        this.m_setIdCallBack = null;
        this.m_setIdTextCallBack = null;
    }

    public void setWithHeader(boolean value) {
        this.m_withHeader = value;
    }

    public boolean getWithHeader() {
        return this.m_withHeader;
    }

    public void setSuppressHeadline(boolean value) {
        this.m_suppressHeadline = value;
    }

    public boolean getSuppressHeadline() {
        return this.m_suppressHeadline;
    }

    public void setRenderIdColumn(boolean renderIdColumn) {
        this.m_renderIdColumn = renderIdColumn;
    }

    public boolean getRenderIdColumn() {
        return this.m_renderIdColumn;
    }

    public void setRenderTextColumn(boolean renderTextColumn) {
        this.m_renderTextColumn = renderTextColumn;
    }

    public boolean getRenderTextColumn() {
        return this.m_renderTextColumn;
    }

    public void setFilterText(String filterText) {
        this.m_filterText = filterText;
        this.m_filterIsUsed = true;
    }

    public String getFilterText() {
        return this.m_filterText;
    }

    public void onRenderBeginAction(ActionEvent event) {
        this.filterItems();
    }

    public void onFilterTextAction() {
        this.filterItems();
    }

    public String getFilterResultText() {
        int numberOfFilteredItems = this.m_allLines.size() - this.m_lines.getItems().size();
        if (numberOfFilteredItems == 0) {
            return null;
        }
        String s = new I18N().get("IDTEXTSEL_filterResult", "Number of filtered items: $1$");
        s = s.replace("$1$", "" + numberOfFilteredItems);
        return s;
    }

    public void filterItems() {
        if (!this.m_filterIsUsed) {
            return;
        }
        if (ValueManager.checkIfStringsAreEqual(this.m_filterText, this.m_lastFilterText)) {
            return;
        }
        this.m_lastFilterText = this.m_filterText;
        this.m_lines.getItems().clear();
        this.m_lines.deselectCurrentSelection();
        boolean numberOfFilteredItems = false;
        for (IdTextLine idtl : this.m_allLines) {
            if (!idtl.getSelectable() || (!this.getRenderTextColumn() || !this.checkIfTextFitsToFilter(idtl.getText(), this.m_filterText)) && (!this.getRenderIdColumn() || !this.checkIfTextFitsToFilter(idtl.getId(), this.m_filterText))) continue;
            this.m_lines.getItems().add(idtl);
        }
    }

    public List<Comparable> getCurrentSelectableIds() {
        ArrayList<Comparable> result = new ArrayList<Comparable>();
        for (IdTextLine itl : this.m_lines.getItems()) {
            result.add((Comparable)((Object)itl.getId()));
        }
        return result;
    }

    protected boolean checkIfTextFitsToFilter(String text, String filter) {
        if (text == null) {
            return false;
        }
        if (filter == null) {
            return true;
        }
        return ValueManager.checkIfStringMatchesSearchStringAND(text, filter, false);
    }

    public void setRenderFilterText(boolean renderFilterText) {
        this.m_renderFilterText = renderFilterText;
        if (renderFilterText) {
            this.m_filterIsUsed = true;
        }
    }

    public boolean getRenderFilterText() {
        return this.m_renderFilterText;
    }

    public void onOK(ActionEvent event) {
        IdTextLine selLine = (IdTextLine)this.m_lines.getSelectedItem();
        if (selLine != null) {
            this.processSelectLine(selLine);
        }
    }

    public void onCancel(ActionEvent event) {
        if (this.m_setIdCallBack != null && this.m_setIdCallBack instanceof ISetIdAndClose) {
            ((ISetIdAndClose)this.m_setIdCallBack).reactOnSelectionClosed();
        }
        this.m_popup.close();
        this.m_setIdCallBack = null;
        this.m_setIdTextCallBack = null;
    }

    public void filterByInputId(String inputId) {
        IdTextLine tl;
        int i;
        if (inputId == null) {
            return;
        }
        int matchingIndex = -1;
        IdTextLine matchingLine = null;
        int startsWithCounter = 0;
        for (i = 0; i < this.m_lines.getItems().size(); ++i) {
            tl = (IdTextLine)this.m_lines.getItems().get(i);
            if (!tl.m_selectable || tl.m_id == null) continue;
            if (tl.m_id.equals(inputId)) {
                matchingIndex = i;
                matchingLine = tl;
                break;
            }
            if (!tl.m_id.startsWith(inputId)) continue;
            ++startsWithCounter;
        }
        if (matchingIndex >= 0) {
            this.m_lines.deselectCurrentSelection();
            this.m_lines.selectAndFocusItem(matchingLine);
        } else if (startsWithCounter > 0) {
            for (i = this.m_lines.getItems().size() - 1; i >= 0; --i) {
                tl = (IdTextLine)this.m_lines.getItems().get(i);
                if (tl.m_id == null) {
                    this.m_lines.getItems().remove(i);
                    continue;
                }
                if (tl.m_id.startsWith(inputId)) continue;
                this.m_lines.getItems().remove(i);
            }
        }
    }

    public void filterByInputText(String inputText) {
        IdTextLine tl;
        int i;
        if (inputText == null) {
            return;
        }
        int matchingIndex = -1;
        IdTextLine matchingLine = null;
        int startsWithCounter = 0;
        for (i = 0; i < this.m_lines.getItems().size(); ++i) {
            tl = (IdTextLine)this.m_lines.getItems().get(i);
            if (!tl.m_selectable || tl.m_text == null) continue;
            if (tl.m_text.equals(inputText)) {
                matchingIndex = i;
                matchingLine = tl;
                break;
            }
            if (!tl.m_text.startsWith(inputText)) continue;
            ++startsWithCounter;
        }
        if (matchingIndex >= 0) {
            this.m_lines.deselectCurrentSelection();
            this.m_lines.selectItem(matchingLine);
            this.m_lines.ensureItemToBeDisplayed(matchingIndex);
        } else if (startsWithCounter > 0) {
            for (i = this.m_lines.getItems().size() - 1; i >= 0; --i) {
                tl = (IdTextLine)this.m_lines.getItems().get(i);
                if (tl.m_text == null) {
                    this.m_lines.getItems().remove(i);
                    continue;
                }
                if (tl.m_text.startsWith(inputText)) continue;
                this.m_lines.getItems().remove(i);
            }
        }
    }

    public void setPopupWidth(int width) {
        this.m_popup.setWidth(width);
    }

    public void setPopupHeight(int height) {
        this.m_popup.setHeight(height);
    }

    public void preselect(String id) {
        this.m_lines.deselectCurrentSelection();
        for (IdTextLine itl : this.m_lines.getItems()) {
            if (!itl.m_selectable) continue;
            boolean isSelected = false;
            if (id == null && itl.getId() == null) {
                isSelected = true;
            }
            if (id != null && id.equals(itl.getId())) {
                isSelected = true;
            }
            if (!isSelected) continue;
            this.m_lines.deselectCurrentSelection();
            if (this.m_filterRequestFocus == null) {
                this.m_lines.selectAndFocusItem(itl);
                this.m_requestFocus = null;
                this.m_filterRequestFocus = null;
                break;
            }
            this.m_lines.selectItem(itl);
            this.m_lines.ensureItemToBeDisplayed(itl);
            break;
        }
        this.m_listSelection = id;
    }

    public String getListValues() {
        int currentChangeIndex = ((IListWithChangeIndex)this.m_lines.getItems()).getChangeIndex();
        if (currentChangeIndex != this.i_lastListChangeIndex) {
            this.i_lastListChangeIndex = currentChangeIndex;
            ArrayList<String> ls = new ArrayList<String>();
            for (IdTextLine itl : this.m_lines.getItems()) {
                ls.add(itl.getId());
                ls.add(itl.getText());
            }
            this.m_listValues = ValueManager.encodeCSV(ls);
        }
        return this.m_listValues;
    }

    public String getListSelection() {
        return this.m_listSelection;
    }

    public void setListSelection(String listSelection) {
        this.m_listSelection = listSelection;
    }

    public void onListAction(ActionEvent ae) {
        if (ae instanceof BaseActionEventInvoke) {
            try {
                if (this.m_listSelection == null || this.m_listSelection.length() == 0) {
                    return;
                }
                for (IdTextLine itl : this.m_lines.getItems()) {
                    if (!ValueManager.checkIfStringsAreEqual(this.m_listSelection, itl.getId())) continue;
                    this.processSelectLine(itl);
                    return;
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem in onListAction", t);
            }
        }
    }

    public void sortItemsById() {
        Comparator<IdTextLine> comp = new Comparator<IdTextLine>(){

            @Override
            public int compare(IdTextLine o1, IdTextLine o2) {
                String text1 = o1.getId();
                String text2 = o2.getId();
                if (text1 == null) {
                    text1 = "";
                }
                if (text2 == null) {
                    text2 = "";
                }
                return text1.compareToIgnoreCase(text2);
            }
        };
        Collections.sort(this.m_allLines, comp);
        Collections.sort(this.m_lines.getItems(), comp);
    }

    public void sortItemsByText() {
        Comparator<IdTextLine> comp = new Comparator<IdTextLine>(){

            @Override
            public int compare(IdTextLine o1, IdTextLine o2) {
                String text1 = o1.getText();
                String text2 = o2.getText();
                if (text1 == null) {
                    text1 = "";
                }
                if (text2 == null) {
                    text2 = "";
                }
                return text1.compareToIgnoreCase(text2);
            }
        };
        Collections.sort(this.m_allLines, comp);
        Collections.sort(this.m_lines.getItems(), comp);
    }

    public ROWDYNAMICCONTENTBinding getHtContent() {
        if (this.m_htContent == null) {
            this.m_htContent = new ROWDYNAMICCONTENTBinding();
            HTSCROLLPANENode sp = new HTSCROLLPANENode();
            sp.setWidth("100%");
            sp.setHeight("100%");
            sp.setRowdistance(2);
            int counter = 0;
            for (IdTextLine itl : this.m_lines.getItems()) {
                HTROWNode rn = new HTROWNode();
                sp.addSubNode(rn);
                HTBUTTONNode bn = new HTBUTTONNode();
                rn.addSubNode(bn);
                bn.setStyleClass("classbuttonidtextselection");
                bn.setReference("" + counter);
                bn.setActionListener("#{eclntdefscr.popupIdTextSelection.onHtButtonAction}");
                HTCOLDISTANCENode cn = new HTCOLDISTANCENode();
                rn.addSubNode(cn);
                cn.setWidth("10");
                HTLABELNode l1 = new HTLABELNode();
                rn.addSubNode(l1);
                l1.setText(itl.getId());
                l1.setWidth("100");
                HTLABELNode l2 = new HTLABELNode();
                rn.addSubNode(l2);
                l2.setText(itl.getText());
                ++counter;
            }
            this.m_htContent.setContentNode(sp);
        }
        return this.m_htContent;
    }

    public void onHtButtonAction(ActionEvent event) {
        int index;
        String ref = ((BaseActionEvent)event).getSourceReference();
        if (ref != null && (index = ValueManager.decodeInt(ref, -1)) >= 0) {
            IdTextLine itl = (IdTextLine)this.m_lines.getItems().get(index);
            this.processSelectLine(itl);
        }
    }

    protected void processKeySequence(String ks) {
        String kslc = ValueManager.toLowerCaseText(ks);
        for (IdTextLine itl : this.m_lines.getItems()) {
            String telc;
            if (!itl.m_selectable) continue;
            String idlc = itl.getId();
            if (idlc != null) {
                idlc = ValueManager.toLowerCaseText(idlc);
            }
            if ((telc = itl.getText()) != null) {
                telc = ValueManager.toLowerCaseText(telc);
            }
            if (idlc == null) {
                idlc = "";
            }
            if (telc == null) {
                telc = "";
            }
            if (!this.m_renderIdColumn) {
                idlc = "";
            }
            if (!this.m_renderTextColumn) {
                telc = "";
            }
            if (!idlc.startsWith(kslc) && !telc.startsWith(kslc)) continue;
            this.m_lines.deselectCurrentSelection();
            this.m_lines.selectAndFocusItem(itl);
            return;
        }
    }

    private void init() {
        this.clear();
        this.m_setIdCallBack = null;
        this.m_setIdTextCallBack = null;
        this.m_explanation = null;
        this.m_renderIdColumn = true;
        this.m_renderTextColumn = true;
        this.m_suppressHeadline = false;
        this.m_withHeader = true;
    }

    public class IdTextLineGrid
    extends FIXGRIDListBinding<IdTextLine> {
        @Override
        public void onGridAction(ActionEvent event) {
            super.onGridAction(event);
            if (event instanceof BaseActionEventKeySequence) {
                IdTextSelection.this.processKeySequence(((BaseActionEventKeySequence)event).getKeySequence());
            }
        }

        @Override
        public void initialize() {
            super.initialize();
            try {
                if (this.getSelectedItem() == null && this.getItems().size() > 0 && IdTextSelection.this.m_filterRequestFocus == null) {
                    this.selectAndFocusItem((FIXGRIDItem)this.getItems().get(0));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class IdTextLine
    extends FIXGRIDItem
    implements Serializable {
        IdTextSelection m_idTextSelection;
        String m_id;
        String m_text;
        String m_image;
        String m_bgpaint;
        boolean m_selectable = true;

        public IdTextLine(IdTextSelection idts, String id, String text) {
            this.m_idTextSelection = idts;
            this.m_id = id;
            this.m_text = text;
        }

        public IdTextLine(IdTextSelection idts, String id, String text, String image) {
            this(idts, id, text);
            this.m_image = image;
        }

        public String getId() {
            return this.m_id;
        }

        public String getText() {
            return this.m_text;
        }

        public String getImage() {
            return this.m_image;
        }

        public void setBgpaint(String value) {
            this.m_bgpaint = value;
        }

        public String getBgpaint() {
            return this.m_bgpaint;
        }

        public boolean getSelectable() {
            return this.m_selectable;
        }

        public void setSelectable(boolean selectable) {
            this.m_selectable = selectable;
        }

        @Override
        public void onRowExecute() {
            this.m_idTextSelection.processSelectLine(this);
        }
    }
}

