/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclnt.jsfserver.base.faces.component.UIComponent;
import org.eclnt.jsfserver.elements.XMLNode;
import org.eclnt.jsfserver.elements.XMLNodeContainingXML;

public class ComponentDump
implements Serializable {
    public static Set<String> URL_SPECIAL_PROTOCOLS = new HashSet<String>();
    public static final String ATTR_CURRENT = "org.eclnt.jsfserver/currentDump";
    public static final String ATTR_PREVIOUS = "org.eclnt.jsfserver/previousDump";
    private long m_requestSequenceId = 0L;
    boolean m_requestWasSkipped = false;
    Map<String, Map> m_cdump = new HashMap<String, Map>();
    transient Map<String, String> m_changedControls = new HashMap<String, String>();
    transient Stack<String> m_includePageStack = new Stack();
    transient Stack<String> m_includePageRootStack = new Stack();
    transient Stack<String> m_includeContentReplaceWithDrillDownStack = new Stack();
    transient Stack<String> m_includeContentReplaceStack = new Stack();
    transient Stack<String> m_includeClientNameStack = new Stack();
    String m_currentClientNamePrefix = null;
    transient Stack<String> m_gridStack = new Stack();
    transient boolean m_isAutoTriggered = false;
    transient XMLNode m_topXMLNode;
    transient XMLNode m_peekXMLNode;
    transient Stack<XMLNode> m_xmlNodeStack;
    transient Map<String, UIComponent> m_encodedComponents = new HashMap<String, UIComponent>();

    public void currentRequestIsAutoTriggered() {
        this.m_isAutoTriggered = true;
    }

    public boolean isAutoTriggered() {
        return this.m_isAutoTriggered;
    }

    public void registerChangeInControlDuringDecode(String id, String attribute, String value) {
        this.m_changedControls.put(id, value);
        this.m_changedControls.put(id + "/" + attribute, value);
    }

    public boolean checkIfControlWasChangedDuringDecode(String id) {
        return this.m_changedControls.containsKey(id);
    }

    public boolean checkIfControlAttributeWasChangedDuringDecode(String id, String attribute) {
        return this.m_changedControls.containsKey(id + "/" + attribute);
    }

    public String getDecodedValue(String id, String attribute) {
        return this.m_changedControls.get(id + "/" + attribute);
    }

    public long getRequestSequenceId() {
        return this.m_requestSequenceId;
    }

    public void setRequestSequenceId(long requestId) {
        this.m_requestSequenceId = requestId;
    }

    public boolean getRequestWasSkipped() {
        return this.m_requestWasSkipped;
    }

    public void setRequestWasSkipped(boolean requestWasSkipped) {
        this.m_requestWasSkipped = requestWasSkipped;
    }

    public void pushIncludePage(String page, String contentReplaceWithDrillDown, String contentReplace, String clientName) {
        if (page == null) {
            page = "";
        }
        this.m_includePageStack.push(page);
        int indexSlash = page.lastIndexOf(47);
        page = page.substring(0, indexSlash + 1);
        String prevPageRoot = this.getCurrentPageRoot();
        if (!page.startsWith("/") && prevPageRoot != null) {
            page = prevPageRoot + page;
        }
        this.m_includePageRootStack.push(page);
        if (contentReplaceWithDrillDown == null) {
            contentReplaceWithDrillDown = "";
        }
        this.m_includeContentReplaceWithDrillDownStack.push(contentReplaceWithDrillDown);
        if (contentReplace == null) {
            contentReplace = "";
        }
        this.m_includeContentReplaceStack.push(contentReplace);
        this.m_includeClientNameStack.push(clientName);
        this.calculateCurrentClientNamePrefix();
    }

    public String getCurrentPageRoot() {
        if (this.m_includePageRootStack.isEmpty()) {
            return null;
        }
        return this.m_includePageRootStack.peek();
    }

    public String getCurrentPage() {
        if (this.m_includePageStack.isEmpty()) {
            return null;
        }
        return this.m_includePageStack.peek();
    }

    public String getCurrentContentReplaceWithDrillDown() {
        if (this.m_includeContentReplaceWithDrillDownStack.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.m_includeContentReplaceWithDrillDownStack.size(); ++i) {
            String s = (String)this.m_includeContentReplaceWithDrillDownStack.get(i);
            if (s == null || s.equals("")) continue;
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public String getCurrentContentReplace() {
        if (this.m_includeContentReplaceStack.size() == 0) {
            return null;
        }
        String result = this.m_includeContentReplaceStack.peek();
        if (result == null) {
            return null;
        }
        if (result.length() == 0) {
            return null;
        }
        return result;
    }

    public void popIncludePage() {
        this.m_includePageStack.pop();
        this.m_includePageRootStack.pop();
        this.m_includeContentReplaceWithDrillDownStack.pop();
        this.m_includeContentReplaceStack.pop();
        this.m_includeClientNameStack.pop();
        this.calculateCurrentClientNamePrefix();
    }

    public String updateIncludedReference(String reference) {
        if (reference == null) {
            return null;
        }
        if ("".equals(reference)) {
            return "";
        }
        if (this.getCurrentPageRoot() == null) {
            return reference;
        }
        if (reference.startsWith("/")) {
            return reference;
        }
        if (reference.contains(":/")) {
            return reference;
        }
        for (String protocol : URL_SPECIAL_PROTOCOLS) {
            if (!reference.startsWith(protocol)) continue;
            return reference;
        }
        return this.getCurrentPageRoot() + reference;
    }

    public XMLNode getCurrentXMLNode() {
        this.initXMLNodes();
        return this.m_peekXMLNode;
    }

    public void addNewXMLNode(String name) {
        this.addNewXMLNode(name, false);
    }

    public void addPreparedXML(String xml) {
        XMLNodeContainingXML node = new XMLNodeContainingXML(true, this.m_peekXMLNode, xml);
    }

    public void addNewXMLNode(String name, boolean isNewNode) {
        this.initXMLNodes();
        XMLNode node = new XMLNode(name, isNewNode, this.m_peekXMLNode);
        this.m_xmlNodeStack.push(node);
        this.m_peekXMLNode = node;
    }

    public void addNewXMLNodeAttribute(String name, String value) {
        this.m_peekXMLNode.addAttributeValue(name, value);
    }

    public void addNewXMLNodeText(String text) {
        this.m_peekXMLNode.addText(text);
    }

    public void closeXMLNode() {
        this.m_xmlNodeStack.pop();
        this.m_peekXMLNode = this.m_xmlNodeStack.size() > 0 ? this.m_xmlNodeStack.peek() : null;
    }

    public XMLNode getCurrentTopXMLNode() {
        XMLNode topXMLNode = (XMLNode)this.m_xmlNodeStack.firstElement();
        return topXMLNode;
    }

    public void writeXMLNodeToWriter(Writer writer) throws IOException {
        this.initXMLNodes();
        XMLNode topXMLNode = this.getCurrentTopXMLNode();
        topXMLNode.writeSubNodesToWriter(writer);
        this.m_xmlNodeStack = null;
        this.m_peekXMLNode = null;
        this.m_topXMLNode = null;
    }

    public void writeXMLNodeChangedMarker() {
        this.initXMLNodes();
        this.m_peekXMLNode.markAsChanged(false);
    }

    public void writeSubXMLNodesChangedMarker() {
        this.initXMLNodes();
        List<XMLNode> children = this.m_peekXMLNode.m_children;
        for (XMLNode child : children) {
            child.markAsChanged(false);
        }
    }

    public String getCurrentClientNamePrefix() {
        return this.m_currentClientNamePrefix;
    }

    public void addEncodedComponent(String id, UIComponent component) {
        this.m_encodedComponents.put(id, component);
    }

    private void calculateCurrentClientNamePrefix() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.m_includeClientNameStack.size(); ++i) {
            String clientName = (String)this.m_includeClientNameStack.get(i);
            if (clientName == null) continue;
            sb.append(clientName);
            sb.append(".");
        }
        this.m_currentClientNamePrefix = null;
        if (sb.length() > 0) {
            this.m_currentClientNamePrefix = sb.toString();
        }
    }

    private void initXMLNodes() {
        if (this.m_xmlNodeStack == null) {
            this.m_topXMLNode = new XMLNode("TOP");
            this.m_peekXMLNode = null;
            this.m_xmlNodeStack = new Stack();
            this.m_xmlNodeStack.push(this.m_topXMLNode);
            this.m_peekXMLNode = this.m_topXMLNode;
        }
    }

    static {
        URL_SPECIAL_PROTOCOLS.add("tel:");
        URL_SPECIAL_PROTOCOLS.add("mailto:");
        URL_SPECIAL_PROTOCOLS.add("about:");
        URL_SPECIAL_PROTOCOLS.add("data:");
        URL_SPECIAL_PROTOCOLS.add("callto:");
        URL_SPECIAL_PROTOCOLS.add("file:");
        URL_SPECIAL_PROTOCOLS.add("ftp:");
        URL_SPECIAL_PROTOCOLS.add("sms:");
        URL_SPECIAL_PROTOCOLS.add("app:");
        URL_SPECIAL_PROTOCOLS.add("market:");
        URL_SPECIAL_PROTOCOLS.add("play:");
        URL_SPECIAL_PROTOCOLS.add("itms:");
        URL_SPECIAL_PROTOCOLS.add("itms-apps:");
        URL_SPECIAL_PROTOCOLS.add("facetime:");
        URL_SPECIAL_PROTOCOLS.add("skype:");
        URL_SPECIAL_PROTOCOLS.add("magnet:");
        URL_SPECIAL_PROTOCOLS.add("spotify:");
        URL_SPECIAL_PROTOCOLS.add("youtube:");
        URL_SPECIAL_PROTOCOLS.add("chrome:");
        URL_SPECIAL_PROTOCOLS.add("moz-extension:");
        URL_SPECIAL_PROTOCOLS.add("geo:");
        URL_SPECIAL_PROTOCOLS.add("news:");
        URL_SPECIAL_PROTOCOLS.add("irc:");
    }
}

