/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclnt.jsfserver.base.faces.application.Application;
import org.eclnt.jsfserver.base.faces.component.UIComponent;
import org.eclnt.jsfserver.base.faces.component.UIForm;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.base.faces.context.ResponseWriter;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.BaseComponentTag;
import org.eclnt.jsfserver.elements.BaseHTMLActionComponent;
import org.eclnt.jsfserver.elements.ComponentRepository;
import org.eclnt.jsfserver.elements.impl.ARRAYGRIDItem;
import org.eclnt.jsfserver.elements.impl.ARRAYGRIDListBinding;
import org.eclnt.jsfserver.elements.impl.DUMMYComponent;
import org.eclnt.jsfserver.elements.impl.DUMMYComponentTag;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDListBinding;
import org.eclnt.jsfserver.elements.impl.HTARRAYGRIDComponent;
import org.eclnt.jsfserver.elements.impl.HTGRIDCOLComponent;
import org.eclnt.jsfserver.elements.impl.HTGRIDCOLComponentTag;
import org.eclnt.jsfserver.elements.impl.HTGRIDFOOTERComponent;
import org.eclnt.jsfserver.elements.impl.HTGRIDHEADERComponent;
import org.eclnt.jsfserver.elements.impl.HTGRIDHEADERComponentTag;
import org.eclnt.jsfserver.elements.impl.HTLABELComponent;
import org.eclnt.jsfserver.elements.impl.HTLABELComponentTag;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDBinding;
import org.eclnt.jsfserver.util.ExpressionManagerV;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.log.CLog;
import org.eclnt.util.log.CLogConstants;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.util.valuemgmt.XMLWriter;

public class HTFIXGRIDComponent
extends BaseHTMLActionComponent
implements CLogConstants {
    int m_sbvisibleamount = 10;
    String m_objectbindingString = null;
    boolean m_jspAnalyzed = false;
    List m_jspChildren;
    List<HTGRIDCOLComponent> m_gridCols = new ArrayList<HTGRIDCOLComponent>();
    List<UIComponent> m_gridControls = new ArrayList<UIComponent>();
    int m_idCounter = 0;
    IFIXGRIDBinding m_dummyBinding = null;
    long[] m_bufferedChangeIndices;
    boolean m_doNotProcessNoChange = false;
    transient int m_contentRowCount;
    int m_arrayGridStructureChangeIndex = -1;
    transient int m_selectorcolumn = 0;

    @Override
    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), new Integer(this.m_sbvisibleamount), this.m_objectbindingString, new Boolean(this.m_jspAnalyzed), this.m_gridCols, this.m_gridControls, new Integer(this.m_idCounter), this.m_bufferedChangeIndices, new Boolean(this.m_doNotProcessNoChange), this.m_arrayGridStructureChangeIndex, this.m_selectorcolumn};
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.m_sbvisibleamount = (Integer)values[1];
        this.m_objectbindingString = (String)values[2];
        this.m_jspAnalyzed = (Boolean)values[3];
        this.m_gridCols = (List)values[4];
        this.m_gridControls = (List)values[5];
        this.m_idCounter = (Integer)values[6];
        this.m_bufferedChangeIndices = (long[])values[7];
        this.m_doNotProcessNoChange = (Boolean)values[8];
        this.m_arrayGridStructureChangeIndex = (Integer)values[9];
        this.m_selectorcolumn = (Integer)values[10];
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        HttpSession session = HttpSessionAccess.getCurrentHttpSession(context);
        try {
            ARRAYGRIDListBinding agb;
            int currentArrayGridStructureChangeIndex;
            if (this.m_arrayGridStructureChangeIndex != -1 && (currentArrayGridStructureChangeIndex = (agb = (ARRAYGRIDListBinding)this.readBindingObject(context)).getStructureChangeIndex()) != this.m_arrayGridStructureChangeIndex) {
                this.m_arrayGridStructureChangeIndex = currentArrayGridStructureChangeIndex;
                this.m_jspAnalyzed = false;
                this.getChildren().clear();
                this.m_gridCols.clear();
                this.m_gridControls.clear();
                this.m_previousDump = null;
                this.m_bufferedChangeIndices = null;
            }
        }
        catch (Throwable agb) {
            // empty catch block
        }
        this.m_selectorcolumn = ValueManager.decodeInt(this.getAttributeValueAsString("selectorcolumn"), 0);
        if (!this.m_jspAnalyzed) {
            Object o = this.getAttributesGet("objectbinding");
            if (o instanceof String) {
                this.m_objectbindingString = (String)o;
            } else if (ExpressionManagerV.checkIfObjectIsAnExpression(o)) {
                this.m_objectbindingString = ExpressionManagerV.getExpressionString(o);
            }
            if (this.m_objectbindingString != null) {
                String sbvisibleamount;
                if (this.m_objectbindingString.startsWith("#{")) {
                    this.m_objectbindingString = this.m_objectbindingString.substring(2);
                }
                if (this.m_objectbindingString.endsWith("}")) {
                    this.m_objectbindingString = this.m_objectbindingString.substring(0, this.m_objectbindingString.length() - 1);
                }
                if ((sbvisibleamount = (String)this.getAttributesGet("sbvisibleamount")) != null) {
                    this.m_sbvisibleamount = ValueManager.decodeInt(sbvisibleamount, this.m_sbvisibleamount);
                    this.m_bufferedChangeIndices = new long[this.m_sbvisibleamount];
                }
                this.buildInternalComponentTree(context);
                IFIXGRIDBinding bindingObject = this.readBindingObject(context);
                bindingObject.passComponentData(this.m_objectbindingString, null);
            }
            this.m_jspAnalyzed = true;
        }
        IFIXGRIDBinding bindingObject = this.readBindingObject(context);
        if (this instanceof HTARRAYGRIDComponent && bindingObject instanceof ARRAYGRIDListBinding) {
            this.m_arrayGridStructureChangeIndex = ((ARRAYGRIDListBinding)bindingObject).getStructureChangeIndex();
        }
        ResponseWriter writer = context.getResponseWriter();
        XMLWriter.writer_writeFormattedText(writer, null, "\n\n<!-- HTFIXGRID begin -->\n");
        String id = this.getClientId(context);
        String width = this.getAttributeValueAsString("width");
        bindingObject.setSbvisibleamount(this.m_sbvisibleamount);
        int indextobevisible = -1;
        if (bindingObject.getIndextobevisibleOfItems() >= 0) {
            int index = bindingObject.getIndextobevisibleOfItems();
            if (index >= 0) {
                int numberOfClientRows = bindingObject.getClientvisibleamount();
                if (numberOfClientRows <= 0) {
                    numberOfClientRows = this.m_sbvisibleamount;
                }
                if (index != bindingObject.getSbvalue()) {
                    if (index < bindingObject.getSbvalue()) {
                        bindingObject.setSbvalue(index + "");
                    } else if (index >= bindingObject.getSbvalue() + numberOfClientRows) {
                        int sbIndex = index;
                        if (sbIndex + numberOfClientRows >= bindingObject.getSbmaximum()) {
                            sbIndex = index - numberOfClientRows + 1;
                        }
                        bindingObject.setSbvalue(sbIndex + "");
                    }
                }
            }
            bindingObject.setIndextobevisibleOfItems(-1);
            bindingObject.setObjecttobevisibleOfItems(null);
        }
        XMLWriter.writer_startElement(writer, null, "td");
        XMLWriter.writer_closeStartElement(writer, null);
        XMLWriter.writer_startElement(writer, null, "table");
        String styleClass = this.getCurrentStyleClass("classfixgrid");
        XMLWriter.writer_writeAttribute(writer, null, "class", styleClass);
        String style = this.getAttributeValueAsString("style");
        if (style != null) {
            XMLWriter.writer_writeAttribute(writer, null, "style", style);
        }
        String cellspacing = this.getAttributeValueAsString("cellspacing");
        String cellpadding = this.getAttributeValueAsString("cellpadding");
        String gridborder = this.getAttributeValueAsString("gridborder");
        if (cellspacing == null) {
            cellspacing = "0";
        }
        if (cellpadding == null) {
            cellpadding = "0";
        }
        if (gridborder == null) {
            gridborder = "1";
        }
        XMLWriter.writer_writeAttribute(writer, null, "cellspacing", cellspacing);
        XMLWriter.writer_writeAttribute(writer, null, "cellpadding", cellpadding);
        XMLWriter.writer_writeAttribute(writer, null, "border", gridborder);
        if (width != null) {
            XMLWriter.writer_writeAttribute(writer, null, "width", width);
        }
        XMLWriter.writer_closeStartElement(writer, null);
    }

    private void writeAttribute(ResponseWriter writer, String attributeName, Object attributeValue) throws IOException {
        if (attributeValue == null) {
            return;
        }
        String avs = ValueManager.convertObject2ValueString(attributeValue);
        XMLWriter.writer_writeAttribute(writer, null, attributeName, attributeValue);
    }

    @Override
    public void encodeChildren(FacesContext context) throws IOException {
        int i;
        ArrayList<UIComponent> headerrows = new ArrayList<UIComponent>();
        ArrayList<UIComponent> gridrows = new ArrayList<UIComponent>();
        ArrayList<UIComponent> footerrows = new ArrayList<UIComponent>();
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            UIComponent c = this.getChildren().get(i2);
            if (c instanceof HTGRIDHEADERComponent) {
                headerrows.add(c);
                continue;
            }
            if (c instanceof DUMMYComponent) {
                gridrows.add(c);
                continue;
            }
            if (!(c instanceof HTGRIDFOOTERComponent)) continue;
            footerrows.add(c);
        }
        Application fapp = context.getApplication();
        ResponseWriter writer = context.getResponseWriter();
        IFIXGRIDBinding bindingObject = this.readBindingObject(context);
        bindingObject.renderingBegins();
        for (int i3 = 0; i3 < headerrows.size(); ++i3) {
            UIComponent headerrow = (UIComponent)headerrows.get(i3);
            if (!headerrow.isRendered()) continue;
            XMLWriter.writer_startElement(writer, null, "tr");
            XMLWriter.writer_closeStartElement(writer, null);
            if (this.m_selectorcolumn != 0) {
                writer.write("<td><div class='classgridcolselectorlabel'>&nbsp;</div></td>");
            }
            for (int j = 0; j < headerrow.getChildCount(); ++j) {
                if (!this.checkIfColumnIsRendered(j)) continue;
                this.encodeSubComponent(context, headerrow.getChildren().get(j), false, false);
            }
            XMLWriter.writer_endElement(writer, null, "tr");
        }
        int bindingObjectRowSize = bindingObject.getRows().size();
        for (i = 0; i < gridrows.size(); ++i) {
            boolean disableComponents = false;
            if (i >= bindingObject.getRows().size()) {
                disableComponents = true;
            }
            if (disableComponents && !this.checkIfToShowEmptyRow()) continue;
            boolean currentItemIsSelected = false;
            if (i < bindingObject.getRows().size()) {
                currentItemIsSelected = ((FIXGRIDItem)bindingObject.getRows().get(i)).getSelected();
            }
            UIComponent gridrow = (UIComponent)gridrows.get(i);
            XMLWriter.writer_startElement(writer, null, "tr");
            XMLWriter.writer_closeStartElement(writer, null);
            if (i < bindingObject.getRows().size()) {
                int rowIndex = bindingObject.getSbvalue() + i + 1;
                if (this.m_selectorcolumn != 0) {
                    this.renderSelectorButton(context, i, bindingObject.getSbvalue() + i, currentItemIsSelected);
                }
            } else if (this.m_selectorcolumn != 0) {
                writer.write("<td>&nbsp;</td>");
            }
            for (int j = 0; j < gridrow.getChildCount(); ++j) {
                if (!this.checkIfColumnIsRendered(j)) continue;
                this.encodeSubComponent(context, gridrow.getChildren().get(j), currentItemIsSelected, disableComponents);
            }
            if (this instanceof HTARRAYGRIDComponent && bindingObject instanceof ARRAYGRIDListBinding) {
                ARRAYGRIDListBinding agb = (ARRAYGRIDListBinding)bindingObject;
                if (i < agb.getRows().size()) {
                    ARRAYGRIDItem agi = (ARRAYGRIDItem)agb.getRows().get(i);
                    if (agb.getTitles() == null) {
                        throw new Error("No titles available for grid.");
                    }
                    for (int arrayIndex = 0; arrayIndex < agb.getTitles().length; ++arrayIndex) {
                        if (agi.getValues() == null) {
                            throw new Error("No values available for grid item.");
                        }
                        String valueStr = this.deriveStringValueForArrayGridCell(agb, agi, arrayIndex);
                        HTLABELComponentTag lct = new HTLABELComponentTag();
                        lct.setText(valueStr);
                        lct.setStyleClass("classarraygridcelllabel");
                        lct.setStyle(this.deriveStyleForArrayGridCell(agb, agi, arrayIndex));
                        if (currentItemIsSelected) {
                            lct.setStyleClass("classarraygridcelllabel_selected");
                        }
                        HTLABELComponent lc = (HTLABELComponent)lct.createBaseComponent();
                        this.encodeSubComponent(context, lc, currentItemIsSelected, disableComponents);
                    }
                } else {
                    if (agb.getTitles() == null) {
                        throw new Error("No titles available for grid.");
                    }
                    for (int arrayIndex = 0; arrayIndex < agb.getTitles().length; ++arrayIndex) {
                        writer.write("<td>&nbsp;</td>");
                    }
                }
            }
            XMLWriter.writer_endElement(writer, null, "tr");
        }
        this.m_contentRowCount = gridrows.size();
        for (i = 0; i < footerrows.size(); ++i) {
            UIComponent footerrow = (UIComponent)footerrows.get(i);
            if (!footerrow.isRendered()) continue;
            XMLWriter.writer_startElement(writer, null, "tr");
            XMLWriter.writer_closeStartElement(writer, null);
            if (this.m_selectorcolumn != 0) {
                writer.write("<td>&nbsp;</td>");
            }
            for (int j = 0; j < footerrow.getChildCount(); ++j) {
                if (!this.checkIfColumnIsRendered(j)) continue;
                this.encodeSubComponent(context, footerrow.getChildren().get(j), false, false);
            }
            XMLWriter.writer_endElement(writer, null, "tr");
        }
    }

    private IFIXGRIDBinding readBindingObject(FacesContext context) {
        try {
            IFIXGRIDBinding bindingObject = null;
            bindingObject = (IFIXGRIDBinding)ExpressionManagerV.getValueForExpressionString(context, "#{" + this.m_objectbindingString + "}");
            if (bindingObject == null) {
                throw new Exception("The binding object #{" + this.m_objectbindingString + "} for the FIXGRID is null");
            }
            return bindingObject;
        }
        catch (Throwable exc) {
            CLog.L.log(CLog.LL_ERR, "Binding execption: " + exc.toString());
            if (this.m_dummyBinding == null) {
                this.m_dummyBinding = new FIXGRIDListBinding();
            }
            return this.m_dummyBinding;
        }
    }

    private void encodeSubComponent(FacesContext context, UIComponent component, boolean itemSelected, boolean disableComponents) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        component.getAttributes().put("ccselected", itemSelected + "");
        component.getAttributes().put("ccenabled", !disableComponents + "");
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            List<UIComponent> children = component.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                this.encodeSubComponent(context, children.get(i), itemSelected, disableComponents);
            }
        }
        component.encodeEnd(context);
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        XMLWriter.writer_writeFormattedText(writer, null, "\n\n<!-- HTFIXGRID end -->\n");
        IFIXGRIDBinding bindingObject = this.readBindingObject(context);
        if (this.checkIfToShowEmptyRow() || bindingObject.getSbmaximum() > this.m_contentRowCount) {
            UIForm parentForm = this.getParentForm();
            String parentFormClientId = parentForm.getClientId(context);
            String clientId = this.getClientId(context);
            XMLWriter.writer_startElement(writer, null, "tr");
            XMLWriter.writer_closeStartElement(writer, null);
            XMLWriter.writer_startElement(writer, null, "td");
            XMLWriter.writer_writeAttribute(writer, null, "align", "right");
            XMLWriter.writer_writeAttribute(writer, null, "colspan", "50");
            XMLWriter.writer_writeAttribute(writer, null, "class", "classfixgridbottomcell");
            XMLWriter.writer_closeStartElement(writer, null);
            IFIXGRIDBinding fgb = this.readBindingObject(context);
            int toValue = fgb.getSbvalue() + fgb.getSbvisibleamount();
            if (toValue > fgb.getSbmaximum()) {
                toValue = fgb.getSbmaximum();
            }
            int currentFirst = fgb.getSbvalue() + 1;
            if (fgb.getSbmaximum() == 0) {
                currentFirst = 0;
            }
            XMLWriter.writer_writeFormattedText(writer, null, "<span class='classfixgridbottomindex'>");
            XMLWriter.writer_writeText(writer, null, currentFirst + "\u00a0-\u00a0" + toValue);
            XMLWriter.writer_writeText(writer, null, "\u00a0\u00a0/\u00a0\u00a0" + fgb.getSbmaximum());
            XMLWriter.writer_writeFormattedText(writer, null, "\u00a0\u00a0\u00a0\u00a0\u00a0");
            XMLWriter.writer_writeFormattedText(writer, null, "</span>");
            StringBuffer jscriptSB = new StringBuffer();
            jscriptSB.append("document.forms['");
            jscriptSB.append(parentFormClientId);
            jscriptSB.append("']['");
            jscriptSB.append(clientId + ".PPREVIOUS");
            jscriptSB.append("'].value='");
            jscriptSB.append(clientId + ".PPREVIOUS");
            jscriptSB.append("';document.forms['");
            jscriptSB.append(parentFormClientId);
            jscriptSB.append("'].submit();");
            jscriptSB.append("ccOnSubmit();");
            jscriptSB.append("return false;");
            XMLWriter.writer_startElement(writer, null, "input");
            XMLWriter.writer_writeAttribute(writer, null, "type", "hidden");
            XMLWriter.writer_writeAttribute(writer, null, "name", clientId + ".PPREVIOUS");
            XMLWriter.writer_closeStartAndEndElement(writer, null);
            XMLWriter.writer_startElement(writer, null, "button");
            XMLWriter.writer_writeAttributeWithFormattedValue(writer, null, "onclick", jscriptSB.toString());
            XMLWriter.writer_writeAttributeWithFormattedValue(writer, null, "ondblclick", "");
            if (fgb.getSbvalue() > 0) {
                XMLWriter.writer_writeAttribute(writer, null, "class", "classfixgridbuttonpprevious");
            } else {
                XMLWriter.writer_writeAttributeWithFormattedValue(writer, null, "disabled", "true");
                XMLWriter.writer_writeAttribute(writer, null, "class", "classfixgridbuttonpprevious_disabled");
            }
            XMLWriter.writer_closeStartElement(writer, null);
            XMLWriter.writer_writeFormattedText(writer, null, "&nbsp;");
            XMLWriter.writer_endElement(writer, null, "button");
            jscriptSB = new StringBuffer();
            jscriptSB.append("document.forms['");
            jscriptSB.append(parentFormClientId);
            jscriptSB.append("']['");
            jscriptSB.append(clientId + ".PREVIOUS");
            jscriptSB.append("'].value='");
            jscriptSB.append(clientId + ".PREVIOUS");
            jscriptSB.append("';document.forms['");
            jscriptSB.append(parentFormClientId);
            jscriptSB.append("'].submit();");
            jscriptSB.append("ccOnSubmit();");
            jscriptSB.append("return false;");
            XMLWriter.writer_startElement(writer, null, "input");
            XMLWriter.writer_writeAttribute(writer, null, "type", "hidden");
            XMLWriter.writer_writeAttribute(writer, null, "name", clientId + ".PREVIOUS");
            XMLWriter.writer_closeStartAndEndElement(writer, null);
            XMLWriter.writer_startElement(writer, null, "button");
            if (fgb.getSbvalue() > 0) {
                XMLWriter.writer_writeAttribute(writer, null, "class", "classfixgridbuttonprevious");
            } else {
                XMLWriter.writer_writeAttributeWithFormattedValue(writer, null, "disabled", "true");
                XMLWriter.writer_writeAttribute(writer, null, "class", "classfixgridbuttonprevious_disabled");
            }
            XMLWriter.writer_writeAttributeWithFormattedValue(writer, null, "onclick", jscriptSB.toString());
            XMLWriter.writer_writeAttributeWithFormattedValue(writer, null, "ondblclick", "");
            XMLWriter.writer_closeStartElement(writer, null);
            XMLWriter.writer_writeFormattedText(writer, null, "&nbsp;");
            XMLWriter.writer_endElement(writer, null, "button");
            jscriptSB = new StringBuffer();
            jscriptSB.append("document.forms['");
            jscriptSB.append(parentFormClientId);
            jscriptSB.append("']['");
            jscriptSB.append(clientId + ".NEXT");
            jscriptSB.append("'].value='");
            jscriptSB.append(clientId + ".NEXT");
            jscriptSB.append("';document.forms['");
            jscriptSB.append(parentFormClientId);
            jscriptSB.append("'].submit();");
            jscriptSB.append("ccOnSubmit();");
            jscriptSB.append("return false;");
            XMLWriter.writer_startElement(writer, null, "input");
            XMLWriter.writer_writeAttribute(writer, null, "type", "hidden");
            XMLWriter.writer_writeAttribute(writer, null, "name", clientId + ".NEXT");
            XMLWriter.writer_closeStartAndEndElement(writer, null);
            XMLWriter.writer_startElement(writer, null, "button");
            if (fgb.getSbvalue() + fgb.getSbvisibleamount() < fgb.getSbmaximum()) {
                XMLWriter.writer_writeAttribute(writer, null, "class", "classfixgridbuttonnext");
            } else {
                XMLWriter.writer_writeAttributeWithFormattedValue(writer, null, "disabled", "true");
                XMLWriter.writer_writeAttribute(writer, null, "class", "classfixgridbuttonnext_disabled");
            }
            XMLWriter.writer_writeAttributeWithFormattedValue(writer, null, "onclick", jscriptSB.toString());
            XMLWriter.writer_writeAttributeWithFormattedValue(writer, null, "ondblclick", "");
            XMLWriter.writer_closeStartElement(writer, null);
            XMLWriter.writer_writeFormattedText(writer, null, "&nbsp;");
            XMLWriter.writer_endElement(writer, null, "button");
            jscriptSB = new StringBuffer();
            jscriptSB.append("document.forms['");
            jscriptSB.append(parentFormClientId);
            jscriptSB.append("']['");
            jscriptSB.append(clientId + ".NNEXT");
            jscriptSB.append("'].value='");
            jscriptSB.append(clientId + ".NNEXT");
            jscriptSB.append("';document.forms['");
            jscriptSB.append(parentFormClientId);
            jscriptSB.append("'].submit();");
            jscriptSB.append("ccOnSubmit();");
            jscriptSB.append("return false;");
            XMLWriter.writer_startElement(writer, null, "input");
            XMLWriter.writer_writeAttribute(writer, null, "type", "hidden");
            XMLWriter.writer_writeAttribute(writer, null, "name", clientId + ".NNEXT");
            XMLWriter.writer_closeStartAndEndElement(writer, null);
            XMLWriter.writer_startElement(writer, null, "button");
            if (fgb.getSbvalue() + fgb.getSbvisibleamount() < fgb.getSbmaximum()) {
                XMLWriter.writer_writeAttribute(writer, null, "class", "classfixgridbuttonnnext");
            } else {
                XMLWriter.writer_writeAttributeWithFormattedValue(writer, null, "disabled", "true");
                XMLWriter.writer_writeAttribute(writer, null, "class", "classfixgridbuttonnnext_disabled");
            }
            XMLWriter.writer_writeAttributeWithFormattedValue(writer, null, "onclick", jscriptSB.toString());
            XMLWriter.writer_writeAttributeWithFormattedValue(writer, null, "ondblclick", "");
            XMLWriter.writer_closeStartElement(writer, null);
            XMLWriter.writer_writeFormattedText(writer, null, "&nbsp;");
            XMLWriter.writer_endElement(writer, null, "button");
            XMLWriter.writer_endElement(writer, null, "td");
            XMLWriter.writer_endElement(writer, null, "tr");
        }
        XMLWriter.writer_endElement(writer, null, "table");
        XMLWriter.writer_endElement(writer, null, "td");
    }

    private void renderSelectorButton(FacesContext context, int rowIndex, int itemIndex, boolean rowIsSelected) {
        try {
            ResponseWriter writer = context.getResponseWriter();
            UIForm parentForm = this.getParentForm();
            String parentFormClientId = parentForm.getClientId(context);
            String clientId = this.getClientId(context);
            StringBuffer jscriptSB = new StringBuffer();
            jscriptSB.append("document.forms['");
            jscriptSB.append(parentFormClientId);
            jscriptSB.append("']['");
            jscriptSB.append(clientId + ".SELECTOR");
            jscriptSB.append("'].value='");
            jscriptSB.append("" + rowIndex);
            jscriptSB.append("';document.forms['");
            jscriptSB.append(parentFormClientId);
            jscriptSB.append("'].submit();");
            jscriptSB.append("ccOnSubmit();");
            jscriptSB.append("return false;");
            if (rowIndex == 0) {
                XMLWriter.writer_startElement(writer, null, "input");
                XMLWriter.writer_writeAttribute(writer, null, "type", "hidden");
                XMLWriter.writer_writeAttribute(writer, null, "name", clientId + ".SELECTOR");
                XMLWriter.writer_closeStartAndEndElement(writer, null);
            }
            XMLWriter.writer_startElement(writer, null, "td");
            if (rowIsSelected) {
                XMLWriter.writer_writeAttribute(writer, null, "class", "classtd_selected");
            }
            XMLWriter.writer_closeStartElement(writer, null);
            XMLWriter.writer_startElement(writer, null, "button");
            if (!rowIsSelected) {
                XMLWriter.writer_writeAttribute(writer, null, "class", "classarraygridcellselector");
            } else {
                XMLWriter.writer_writeAttribute(writer, null, "class", "classarraygridcellselector_selected");
            }
            XMLWriter.writer_writeAttributeWithFormattedValue(writer, null, "onclick", jscriptSB.toString());
            XMLWriter.writer_writeAttributeWithFormattedValue(writer, null, "ondblclick", "");
            XMLWriter.writer_closeStartElement(writer, null);
            XMLWriter.writer_writeFormattedText(writer, null, "" + (itemIndex + 1));
            XMLWriter.writer_endElement(writer, null, "button");
            XMLWriter.writer_endElement(writer, null, "td");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void decode(FacesContext context) {
        int currentIndex;
        IFIXGRIDBinding bindingObject;
        String clientId = this.getClientId(context);
        Map<String, String> rpm = context.getExternalContext().getRequestParameterMap();
        String value = rpm.get(clientId + ".PREVIOUS");
        if (value != null && value.toString().length() > 0) {
            bindingObject = this.readBindingObject(context);
            currentIndex = bindingObject.getSbvalue();
            if (--currentIndex < 0) {
                return;
            }
            this.triggerActionEvent(context, "scroll", "scroll(" + currentIndex + ")", false);
        }
        if ((value = rpm.get(clientId + ".PPREVIOUS")) != null && value.toString().length() > 0) {
            bindingObject = this.readBindingObject(context);
            currentIndex = bindingObject.getSbvalue();
            if ((currentIndex -= bindingObject.getSbvisibleamount()) < 0) {
                currentIndex = 0;
            }
            this.triggerActionEvent(context, "scroll", "scroll(" + currentIndex + ")", false);
        }
        if ((value = rpm.get(clientId + ".NEXT")) != null && value.toString().length() > 0) {
            bindingObject = this.readBindingObject(context);
            currentIndex = bindingObject.getSbvalue();
            if (++currentIndex > bindingObject.getSbmaximum() - bindingObject.getSbvisibleamount()) {
                return;
            }
            this.triggerActionEvent(context, "scroll", "scroll(" + currentIndex + ")", false);
        }
        if ((value = rpm.get(clientId + ".NNEXT")) != null && value.toString().length() > 0) {
            bindingObject = this.readBindingObject(context);
            currentIndex = bindingObject.getSbvalue();
            if ((currentIndex += bindingObject.getSbvisibleamount()) >= bindingObject.getSbmaximum() - bindingObject.getSbvisibleamount()) {
                currentIndex = bindingObject.getSbmaximum() - bindingObject.getSbvisibleamount();
            }
            this.triggerActionEvent(context, "scroll", "scroll(" + currentIndex + ")", false);
        }
        if ((value = rpm.get(clientId + ".SELECTOR")) != null && value.toString().length() > 0) {
            System.out.println((Object)value);
            System.out.println((Object)value);
            System.out.println((Object)value);
            System.out.println((Object)value);
            System.out.println((Object)value);
            System.out.println((Object)value);
            bindingObject = this.readBindingObject(context);
            int selectorIndex = ValueManager.decodeInt("" + value, 0);
            this.triggerActionEvent(context, "rowselect", "rowselect(" + selectorIndex + ",0,false)", false);
        }
    }

    public String getObjectBindingString() {
        return this.m_objectbindingString;
    }

    @Override
    protected boolean checkIfToTakeOverAttribute(String attributeName) {
        if (attributeName.equals("objectbinding")) {
            return false;
        }
        return super.checkIfToTakeOverAttribute(attributeName);
    }

    protected void buildInternalComponentTree(FacesContext context) {
        try {
            int i;
            this.m_gridCols = new ArrayList<HTGRIDCOLComponent>();
            Application fapp = HttpSessionAccess.getCurrentFacesContext().getApplication();
            ArrayList<UIComponent> jspChildren = new ArrayList<UIComponent>();
            Iterator<UIComponent> children = this.getChildren().iterator();
            while (children.hasNext()) {
                jspChildren.add(children.next());
            }
            children = jspChildren.iterator();
            this.m_gridCols.clear();
            ArrayList<HTGRIDHEADERComponent> headerRows = new ArrayList<HTGRIDHEADERComponent>();
            ArrayList<HTGRIDFOOTERComponent> footerRows = new ArrayList<HTGRIDFOOTERComponent>();
            while (children.hasNext()) {
                UIComponent o = children.next();
                if (o instanceof HTGRIDCOLComponent) {
                    this.m_gridCols.add((HTGRIDCOLComponent)o);
                    if (((HTGRIDCOLComponent)o).getChildCount() <= 0) continue;
                    this.m_gridControls.add(((HTGRIDCOLComponent)o).getChildren().get(0));
                    continue;
                }
                if (o instanceof HTGRIDHEADERComponent) {
                    headerRows.add((HTGRIDHEADERComponent)o);
                    continue;
                }
                if (!(o instanceof HTGRIDFOOTERComponent)) continue;
                footerRows.add((HTGRIDFOOTERComponent)o);
            }
            IFIXGRIDBinding gridBinding = this.readBindingObject(context);
            if (this instanceof HTARRAYGRIDComponent && gridBinding instanceof ARRAYGRIDListBinding) {
                ARRAYGRIDListBinding agb = (ARRAYGRIDListBinding)gridBinding;
                if (agb.getTitles() == null) {
                    throw new Error("No titles available for grid.");
                }
                if (agb.getWidths() == null) {
                    throw new Error("No widths available for grid.");
                }
                for (int i2 = 0; i2 < agb.getTitles().length; ++i2) {
                    HTGRIDCOLComponentTag gt = new HTGRIDCOLComponentTag();
                    gt.setText(agb.getTitles()[i2]);
                    gt.setWidth(agb.getWidths()[i2]);
                    gt.setStyle(this.deriveStyleForArrayGridColumn(agb, i2));
                    HTGRIDCOLComponent gc = (HTGRIDCOLComponent)gt.createBaseComponent();
                    this.m_gridCols.add(gc);
                }
            }
            HTGRIDHEADERComponentTag labelrowCT = new HTGRIDHEADERComponentTag();
            HTGRIDHEADERComponent labelrowC = (HTGRIDHEADERComponent)labelrowCT.createBaseComponent();
            int counter = 0;
            for (HTGRIDCOLComponent gridcol : this.m_gridCols) {
                HTLABELComponent ghlc = (HTLABELComponent)fapp.createComponent(HTLABELComponent.class.getName());
                String labelText = (String)gridcol.getAttributesGet("text");
                if (labelText == null) {
                    labelText = "";
                }
                ghlc.setId(gridcol.createSubId("label" + counter));
                ghlc.getAttributes().put("text", labelText);
                if (gridcol.getAttributesGet("width") != null) {
                    ghlc.getAttributes().put("width", gridcol.getAttributesGet("width"));
                }
                ghlc.getAttributes().put("styleClass", this.getCurrentStyleClass("classfixgridheaderlabel"));
                String style = (String)gridcol.getAttributesGet("style");
                if (style != null) {
                    ghlc.getAttributes().put("style", style);
                }
                labelrowC.getChildren().add(ghlc);
                ++counter;
            }
            String ssh = (String)this.getAttributesGet("suppressheadline");
            if (ssh == null || !ssh.equals("true")) {
                this.getChildren().add(labelrowC);
            }
            for (i = 0; i < headerRows.size(); ++i) {
                this.getChildren().add((UIComponent)headerRows.get(i));
            }
            for (i = 0; i < this.m_sbvisibleamount; ++i) {
                DUMMYComponentTag gridrowCT = new DUMMYComponentTag();
                DUMMYComponent gridrowC = (DUMMYComponent)gridrowCT.createBaseComponent();
                this.getChildren().add(gridrowC);
                Iterator<UIComponent> iter = this.m_gridControls.iterator();
                counter = 0;
                while (iter.hasNext()) {
                    UIComponent colControl = iter.next();
                    UIComponent cellComponent = this.createControlInstance((BaseComponent)colControl, i, counter);
                    gridrowC.getChildren().add(cellComponent);
                    ++counter;
                }
            }
            for (i = 0; i < footerRows.size(); ++i) {
                this.getChildren().add((UIComponent)footerRows.get(i));
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Could not process buildInternalComponentTree", t);
            throw new Error(t);
        }
    }

    private BaseComponentTag createComponentTag(BaseComponent template) {
        try {
            return ComponentRepository.createComponentTagInstsanceForComponentClass(template.getClass());
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Could not create tage instance for " + template, t);
            throw new Error(t);
        }
    }

    private UIComponent createControlInstance(BaseComponent template, int rowIndex, int colIndex) {
        Application fapp = HttpSessionAccess.getCurrentFacesContext().getApplication();
        BaseComponentTag componentTag = this.createComponentTag(template);
        ++this.m_idCounter;
        componentTag.setId(template.createSubId("" + this.createNewIdCounter()));
        HashSet<String> processedAttributes = new HashSet<String>();
        for (String key : template.getAttributes().keySet()) {
            Object oValue = template.getAttributesGet(key);
            Object vBinding = template.getExpressionFromComponentAttribute(key);
            if (vBinding == null) {
                if (!(oValue instanceof String)) continue;
                String value = (String)oValue;
                processedAttributes.add(key);
                if (value.startsWith(".{") && value.endsWith("}")) {
                    String vbs;
                    if (key.equals("_action")) {
                        vbs = value.substring(2, value.length() - 1);
                        vbs = "#{" + this.m_objectbindingString + ".rows[" + rowIndex + "]." + vbs + "}";
                        componentTag.setAction(vbs);
                        continue;
                    }
                    if (key.equals(ATT_gp_actionListener)) {
                        vbs = value.substring(2, value.length() - 1);
                        vbs = "#{" + this.m_objectbindingString + ".rows[" + rowIndex + "]." + vbs + "}";
                        componentTag.setActionListener(vbs);
                        continue;
                    }
                    if (key.equals("componentbinding")) {
                        vbs = value.substring(2, value.length() - 1);
                        vbs = "#{" + this.m_objectbindingString + ".rows[" + rowIndex + "]." + vbs + "}";
                        componentTag.setComponentbinding(vbs);
                        continue;
                    }
                    if (key.equals(ATT_gp_rendered)) {
                        vbs = value.substring(2, value.length() - 1);
                        vbs = "#{" + this.m_objectbindingString + ".rows[" + rowIndex + "]." + vbs + "}";
                        componentTag.setRendered(vbs);
                        continue;
                    }
                    vbs = value.substring(2, value.length() - 1);
                    vbs = "#{" + this.m_objectbindingString + ".rows[" + rowIndex + "]." + vbs + "}";
                    componentTag.invokeSetter(key, vbs);
                    continue;
                }
                componentTag.invokeSetter(key, value);
                continue;
            }
            processedAttributes.add(key);
            componentTag.invokeSetter(key, ExpressionManagerV.getExpressionString(vBinding));
        }
        List<String> tagAttributes = template.getTagAttributes();
        for (int i = 0; i < tagAttributes.size(); ++i) {
            Object vb;
            String attribute = tagAttributes.get(i);
            if (processedAttributes.contains(attribute) || (vb = template.getExpressionFromComponentAttribute(attribute)) == null) continue;
            componentTag.invokeSetter(attribute, ExpressionManagerV.getExpressionString(vb));
        }
        BaseComponent result = componentTag.createBaseComponent();
        List<UIComponent> children = template.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            UIComponent childComp = this.createControlInstance((BaseComponent)children.get(i), rowIndex, colIndex);
            result.getChildren().add(childComp);
        }
        return result;
    }

    @Override
    public void reactOnSetPropertiesByTagFinished() {
        super.reactOnSetPropertiesByTagFinished();
    }

    private boolean checkIfColumnIsRendered(int columnIndex) {
        HTGRIDCOLComponent gcc = this.m_gridCols.get(columnIndex);
        return gcc.isRendered();
    }

    private boolean checkIfToShowEmptyRow() {
        String showEmptyRows = this.getAttributeValueAsString("showemptyrows");
        return ValueManager.decodeBoolean(showEmptyRows, true);
    }

    private String deriveStyleForArrayGridColumn(ARRAYGRIDListBinding agb, int index) {
        StringBuffer result = new StringBuffer();
        if (agb.getAligns() != null && agb.getAligns().length > index && agb.getAligns()[index] != null) {
            String align = agb.getAligns()[index];
            if (align.endsWith("!")) {
                align = align.substring(0, align.length() - 1);
            }
            result.append("text-align:" + align);
        }
        return result.toString();
    }

    private String deriveStyleForArrayGridCell(ARRAYGRIDListBinding agb, ARRAYGRIDItem agi, int index) {
        String color;
        StringBuffer result = new StringBuffer();
        if (agb.getAligns() != null && agb.getAligns().length > index && agb.getAligns()[index] != null) {
            String align = agb.getAligns()[index];
            if (align.endsWith("!")) {
                align = align.substring(0, align.length() - 1);
            }
            result.append("text-align:" + align + ";");
        }
        if (agi.getBackgrounds() != null && agi.getBackgrounds().length > index && agi.getBackgrounds()[index] != null) {
            color = agi.getBackgrounds()[index];
            result.append("background-color:" + color + ";");
        }
        if (agi.getForegrounds() != null && agi.getForegrounds().length > index && agi.getForegrounds()[index] != null) {
            color = agi.getForegrounds()[index];
            result.append("color:" + color + ";");
        }
        return result.toString();
    }

    private String deriveStringValueForArrayGridCell(ARRAYGRIDListBinding agb, ARRAYGRIDItem agi, int cellIndex) {
        String format = null;
        String formatmask = null;
        String timezone = null;
        Object value = null;
        if (agb.getFormats() != null && agb.getFormats().length > cellIndex) {
            format = agb.getFormats()[cellIndex];
        }
        if (agb.getFormatmasks() != null && agb.getFormatmasks().length > cellIndex) {
            formatmask = agb.getFormatmasks()[cellIndex];
        }
        if (agb.getTimezones() != null && agb.getTimezones().length > cellIndex) {
            timezone = agb.getTimezones()[cellIndex];
        }
        if (agi.getValues() != null && agi.getValues().length > cellIndex) {
            value = agi.getValues()[cellIndex];
        }
        String result = ValueManager.convertObject2DisplayString(value, format, formatmask, timezone, false);
        return result;
    }
}

