/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.elements.util.Trigger;
import org.eclnt.jsfserver.util.valuemgmt.IDynamicContentBindingObject;
import org.eclnt.util.valuemgmt.ValueManager;

public class IMAGESHAKERBinding
implements Serializable,
IDynamicContentBindingObject {
    IMAGESHAKERBinding m_this = this;
    int m_selectedIndex = 0;
    int m_imagewidth = 180;
    int m_imageheight = 120;
    int m_changeIndex = 0;
    boolean m_withShearing = false;
    ImageInfoMap m_imageInfomap = new ImageInfoMap();
    Trigger m_trigger = new Trigger();
    List<String> m_images = new ArrayList<String>();
    List<String> m_tooltips = new ArrayList<String>();
    String m_selectionBorderColor = "#FF8000";
    int m_offsetX = 20;
    int m_offsetY = 20;

    public void setSelectionBorderColor(String value) {
        this.m_selectionBorderColor = value;
    }

    public String getSelectionBorderColor() {
        return this.m_selectionBorderColor;
    }

    public int getOffsetX() {
        return this.m_offsetX;
    }

    public void setOffsetX(int offsetX) {
        this.m_offsetX = offsetX;
    }

    public int getOffsetY() {
        return this.m_offsetY;
    }

    public void setOffsetY(int offsetY) {
        this.m_offsetY = offsetY;
    }

    public ImageInfoMap getImageInfoMap() {
        return this.m_imageInfomap;
    }

    public Trigger getTrigger() {
        return this.m_trigger;
    }

    public boolean getWithShearing() {
        return this.m_withShearing;
    }

    public void setWithShearing(boolean withShearing) {
        this.m_withShearing = withShearing;
    }

    public List<String> getImages() {
        return this.m_images;
    }

    public List<String> getTooltips() {
        return this.m_tooltips;
    }

    public void setImagewidth(int imagewidth) {
        this.m_imagewidth = imagewidth;
    }

    public void setImageheight(int imageheight) {
        this.m_imageheight = imageheight;
    }

    public void clearImages() {
        this.m_images.clear();
        this.m_tooltips.clear();
        this.updateChangeIndex();
    }

    public void addImage(String image) {
        this.m_images.add(image);
        this.m_tooltips.add(null);
        this.updateChangeIndex();
    }

    public void addImage(String image, String tooltip) {
        this.m_images.add(image);
        this.m_tooltips.add(tooltip);
        this.updateChangeIndex();
    }

    public int getChangeIndex() {
        return this.m_changeIndex;
    }

    public void onNext(ActionEvent event) {
        if (this.m_selectedIndex < this.m_images.size() - 1) {
            this.selectIndex(this.m_selectedIndex + 1);
        }
    }

    public void onPrevious(ActionEvent event) {
        if (this.m_selectedIndex > 0) {
            this.selectIndex(this.m_selectedIndex - 1);
        }
    }

    public int getSelectedIndex() {
        return this.m_selectedIndex;
    }

    public void setSelectedIndex(int index, boolean withApplicationCallback) {
        this.m_selectedIndex = index;
        this.selectIndex(index, withApplicationCallback);
    }

    protected void reactOnImageSelect(int selectedIndex) {
    }

    protected Rectangle getBounds(int index) {
        int x = this.m_offsetX;
        for (int i = 0; i < index; ++i) {
            int width = this.getWidth(i);
            if (i < this.m_selectedIndex) {
                x += width - width / 3;
                continue;
            }
            int widthNext = this.getWidth(i + 1);
            x += width - widthNext / 3;
        }
        int width = this.getWidth(index);
        int height = this.getHeight(index);
        int y = this.m_imageheight / 2 + this.m_offsetY - height / 2;
        return new Rectangle(x, y, width, height);
    }

    protected int getZIndex(int index) {
        int result = 1000 - Math.abs(index - this.m_selectedIndex);
        return result;
    }

    protected void selectIndex(int index) {
        this.selectIndex(index, true);
    }

    protected void selectIndex(int index, boolean withApplicationCallBack) {
        this.m_selectedIndex = index;
        this.m_trigger.trigger();
        if (withApplicationCallBack) {
            this.reactOnImageSelect(index);
        }
    }

    protected int getWidth(int index) {
        if (!this.m_withShearing) {
            if (index == this.m_selectedIndex) {
                return this.m_imagewidth;
            }
            if (index == this.m_selectedIndex - 1) {
                return this.m_imagewidth * 2 / 3;
            }
            if (index == this.m_selectedIndex + 1) {
                return this.m_imagewidth * 2 / 3;
            }
            int delta = Math.abs(index - this.m_selectedIndex);
            int result = this.m_imagewidth / 3 - delta * 2;
            if (result < 10) {
                result = 10;
            }
            return result;
        }
        if (index == this.m_selectedIndex) {
            return this.m_imagewidth;
        }
        if (index == this.m_selectedIndex - 1) {
            return this.m_imagewidth / 2;
        }
        if (index == this.m_selectedIndex + 1) {
            return this.m_imagewidth / 2;
        }
        int delta = Math.abs(index - this.m_selectedIndex);
        int result = this.m_imagewidth / 4 - delta * 2;
        if (result < 10) {
            result = 10;
        }
        return result;
    }

    protected int getHeight(int index) {
        if (index == this.m_selectedIndex) {
            return this.m_imageheight;
        }
        if (index == this.m_selectedIndex - 1) {
            return this.m_imageheight * 2 / 3;
        }
        if (index == this.m_selectedIndex + 1) {
            return this.m_imageheight * 2 / 3;
        }
        int delta = Math.abs(index - this.m_selectedIndex);
        return this.m_imageheight / 3 - delta * 2;
    }

    protected void updateChangeIndex() {
        ++this.m_changeIndex;
    }

    protected String buildBgpaintForSelectedTab(String image) {
        String result = ValueManager.encodeCSV(new String[]{"rectangle(0,0,100%,100%,#A08080,#804040,vertical)", ValueManager.encodeMethod("image", new String[]{"5", "5", "100%-10", "100%-10", image, "lefttop"})});
        return result;
    }

    protected String buildBgpaintForUnselectedTab(String image) {
        String result = ValueManager.encodeCSV(new String[]{"rectangle(0,0,100%,100%,#808080,#404040,vertical)", ValueManager.encodeMethod("image", new String[]{"5", "5", "100%-10", "100%-10", image, "lefttop"})});
        return result;
    }

    protected String buildBgpaintForUnselectedTabWithShearingLeftSide(String image) {
        return "image(0,0,100%,100%,/shear(0\\x2C15%\\x2C100%\\x2C0\\x2C100%\\x2C100%\\x2C0\\x2C85%):" + image + ",lefttop)";
    }

    protected String buildBgpaintForUnselectedTabWithShearingRightSide(String image) {
        return "image(0,0,100%,100%,/shear(0\\x2C0\\x2C100%\\x2C15%\\x2C100%\\x2C85%\\x2C0\\x2C100%):" + image + ",lefttop)";
    }

    public class ImageInfoMap
    extends HashMap<String, ImageInfo> {
        @Override
        public ImageInfo get(Object key) {
            String k = (String)key;
            int kindex = ValueManager.decodeInt(k, 0);
            return new ImageInfo(kindex);
        }
    }

    public class ImageInfo
    implements Serializable {
        int i_index;
        int i_zindex;

        public ImageInfo(int index) {
            this.i_index = index;
        }

        public void onAction(ActionEvent event) {
            IMAGESHAKERBinding.this.selectIndex(this.i_index);
        }

        public String getBounds() {
            String result = ValueManager.encodeRectangle(IMAGESHAKERBinding.this.m_this.getBounds(this.i_index));
            result = result + ";" + IMAGESHAKERBinding.this.m_this.getZIndex(this.i_index);
            return result;
        }

        public String getTooltip() {
            return IMAGESHAKERBinding.this.m_tooltips.get(this.i_index);
        }

        public String getImage() {
            String image = IMAGESHAKERBinding.this.getImages().get(this.i_index);
            return image;
        }

        public String getBorder() {
            if (this.i_index == IMAGESHAKERBinding.this.m_selectedIndex) {
                return "left:3;top:3;bottom:3;right:3;color:#FF8000" + IMAGESHAKERBinding.this.m_selectionBorderColor;
            }
            return "left:0;top:0;bottom:0;top:0";
        }

        public String getBgpaint() {
            String image = IMAGESHAKERBinding.this.getImages().get(this.i_index);
            if (this.i_index == IMAGESHAKERBinding.this.m_selectedIndex) {
                return IMAGESHAKERBinding.this.buildBgpaintForSelectedTab(image);
            }
            if (!IMAGESHAKERBinding.this.m_withShearing) {
                return IMAGESHAKERBinding.this.buildBgpaintForUnselectedTab(image);
            }
            if (this.i_index < IMAGESHAKERBinding.this.m_selectedIndex) {
                return IMAGESHAKERBinding.this.buildBgpaintForUnselectedTabWithShearingLeftSide(image);
            }
            return IMAGESHAKERBinding.this.buildBgpaintForUnselectedTabWithShearingRightSide(image);
        }
    }
}

