/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.managedbean;

import java.io.File;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import org.eclnt.jsfserver.defaultscreens.ModalPopup;
import org.eclnt.jsfserver.defaultscreens.ModelessPopup;
import org.eclnt.jsfserver.managedbean.DefaultDispatchedBean;
import org.eclnt.jsfserver.managedbean.DefaultDispatchedPageBean;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.managedbean.IDispatcher;
import org.eclnt.jsfserver.managedbean.IDispatcherExtension;
import org.eclnt.jsfserver.managedbean.preview.IProcessPreview;
import org.eclnt.jsfserver.managedbean.preview.ProcessPreview;
import org.eclnt.jsfserver.messages.DialogMessageBus;
import org.eclnt.jsfserver.pagebean.IDestroyable;
import org.eclnt.jsfserver.pagebean.IPageBean;
import org.eclnt.jsfserver.util.BeanIntrospector;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ISessionAbstraction;
import org.eclnt.jsfserver.util.ISessionAbstractionListener;
import org.eclnt.jsfserver.util.parse.SAXParserCreator;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.log.CLog;
import org.eclnt.util.logdt.DTLogFactory;
import org.eclnt.util.logdt.ENUMLogCategory;
import org.eclnt.util.valuemgmt.ValueManager;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DefaultDispatcher
extends HashMap<String, Object>
implements Serializable,
IDispatcher {
    static final String DIALOGSESSION_KEY = "CCDISPATCHER";
    static Set<IDispatcherExtension> s_dispatcherExtensions = new HashSet<IDispatcherExtension>();
    private static Map<Class, BufferedDispatcherInfoXML> s_bufferedDispatcherInfoXMLs = new Hashtable<Class, BufferedDispatcherInfoXML>();
    Map<String, DispatchedBeanInfo> m_registeredBeansByName = null;
    Map<Class, DispatchedBeanInfo> m_registeredBeansByClass = null;
    List<String> m_registeredPackages = null;
    transient Map<String, BeanIntrospector.PropertyIntrospectionInfo> mtransient_ownProperties;
    transient DispatcherInfo mtransient_dispatcherInfo;
    transient ClassLoader mtransient_classloader = HotDeployManager.currentClassLoader();
    int m_ownSubDispatcherCounter = 0;
    int m_subDispatcherCounterForChildren = 0;
    IDispatcher m_owner;
    Map<String, IDispatcher> m_subDispatchers = new HashMap<String, IDispatcher>();
    String m_expressionBase;
    boolean m_initProcessed = false;
    private boolean m_destroyed = false;
    ISessionAbstractionListener m_dialogSessionClosedListener;

    private ClassLoader m_classloader() {
        if (this.mtransient_classloader == null) {
            this.mtransient_classloader = HotDeployManager.currentClassLoader();
        }
        return this.mtransient_classloader;
    }

    private DispatcherInfo m_dispatcherInfo() {
        if (this.mtransient_dispatcherInfo == null) {
            this.mtransient_dispatcherInfo = new DispatcherInfo(0, this.getClass());
        }
        return this.mtransient_dispatcherInfo;
    }

    private Map<String, BeanIntrospector.PropertyIntrospectionInfo> m_ownProperties() {
        if (this.mtransient_ownProperties == null) {
            this.mtransient_ownProperties = BeanIntrospector.readProperties(this.getClass());
        }
        return this.mtransient_ownProperties;
    }

    public static IDispatcher getDialogSessionInstance() {
        return (IDispatcher)HttpSessionAccess.getCurrentDialogSession().getAttribute(DIALOGSESSION_KEY);
    }

    public static IDispatcher getDialogSessionInstance(ISessionAbstraction dialogSession) {
        return (IDispatcher)dialogSession.getAttribute(DIALOGSESSION_KEY);
    }

    public DefaultDispatcher() {
        DialogMessageBus.instance();
        this.registerFirstDispatcherInDialogSession();
        this.initDispatcherViaDispatcherInfoXML();
        this.m_expressionBase = this.getRootExpression();
        this.m_dialogSessionClosedListener = new MySessionAbstractionListener();
        HttpSessionAccess.addDialogSessionClosedReactorForCurrentSession(this.m_dialogSessionClosedListener);
    }

    protected String getRootExpression() {
        return "#{d}";
    }

    public static synchronized void addDispatcherExtension(IDispatcherExtension dispatcherExtension) {
        s_dispatcherExtensions.add(dispatcherExtension);
    }

    public static synchronized void removeDispatcherExtension(IDispatcherExtension dispatcherExtension) {
        s_dispatcherExtensions.remove(dispatcherExtension);
    }

    public static DispatcherInfo getStaticDispatcherInfo() {
        CLog.L.log(CLog.LL_ERR, "The dispatcher that you use must implement the following method");
        CLog.L.log(CLog.LL_ERR, "in order to be recognized within the tooling environment.");
        CLog.L.log(CLog.LL_ERR, "public static DispatcherInfo getStaticDispatcherInfo()");
        CLog.L.log(CLog.LL_ERR, "{");
        CLog.L.log(CLog.LL_ERR, "    return new DispatcherInfo(<YourDispatcher>.class)");
        CLog.L.log(CLog.LL_ERR, "}");
        throw new Error("Dispatcher does not provide method getStaticDispatcherInfo() - view editor log for details.");
    }

    @Override
    public int createSubDispatcherIndex() {
        ++this.m_subDispatcherCounterForChildren;
        return this.m_subDispatcherCounterForChildren;
    }

    @Override
    public void setOwner(IDispatcher owner) {
        this.m_ownSubDispatcherCounter = owner.createSubDispatcherIndex();
        this.m_owner = owner;
        if (owner != null) {
            try {
                HttpSessionAccess.removeDialogSessionClosedReactorForCurrentSession(this.m_dialogSessionClosedListener);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public Object getDispatchedBean(String dispatchedBeanName) {
        return this.get(dispatchedBeanName);
    }

    @Override
    public void removeDispatchedBean(String dispatchedBeanName) {
        Object o = super.get(dispatchedBeanName);
        if (o != null) {
            this.destroyDispatchedBean(o);
            this.remove(dispatchedBeanName);
        }
    }

    private void destroyDispatchedBean(Object o) {
        if (o == null) {
            return;
        }
        if (o instanceof DefaultDispatchedBean) {
            try {
                ((DefaultDispatchedBean)o).ccDestroy();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem when calling ccDestroy " + t, t);
            }
        }
        if (o instanceof IDestroyable) {
            try {
                ((IDestroyable)o).destroy();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem when calling destroy " + t, t);
            }
        }
    }

    @Override
    public Object get(Object key) {
        Object result = super.get(key);
        if (result == null) {
            try {
                if (this.m_ownProperties().containsKey(key)) {
                    result = this.readObjectFromOwnProperties((String)key);
                    return result;
                }
                result = this.readObject((String)key);
                if (result == null) {
                    throw new ReadObjectReturnedNullException("readObject returned null as value: " + key);
                }
                this.prepareObject(result);
                String actualKey = (String)key;
                if (this.checkIfKeyIsClassName((String)key)) {
                    actualKey = this.derivePageBeanKey(actualKey, result);
                }
                this.put(actualKey, result);
                if (result instanceof IPageBean) {
                    String resultRootExpression = this.getExpressionBase();
                    resultRootExpression = resultRootExpression.replace("}", "." + actualKey + "}");
                    ((IPageBean)result).setActualRootExpression(resultRootExpression);
                }
            }
            catch (ReadObjectReturnedNullException ronrne) {
                CLog.L.log(CLog.LL_INF, "Could not create/access managed bean for: " + key + ", readObject returned null");
                DTLogFactory.getLog().log(ENUMLogCategory.PROPERTYERROR_NULL, null, "Could not create/access managed bean for: " + key + ", readObject returned null", ronrne);
            }
            catch (Throwable t) {
                throw new Error("Could not create/access managed bean for: " + key, t);
            }
        }
        return result;
    }

    private String derivePageBeanKey(String actualKey, Object result) {
        if (result != null && result instanceof IPageBean) {
            String rootExpression = ((IPageBean)result).getRootExpressionUsedInPage();
            int dotIndex = rootExpression.lastIndexOf(".");
            int bracketIndex = rootExpression.lastIndexOf("}");
            return rootExpression.substring(dotIndex + 1, bracketIndex);
        }
        throw new Error("Deriving the page bean key is not possible for class: " + actualKey + ". Only possible for page bean implementations.");
    }

    private boolean checkIfKeyIsClassName(String key) {
        return key.contains(".");
    }

    private Object readObjectFromOwnProperties(String key) throws Exception {
        Method getter = this.m_ownProperties().get(key).getGetter();
        return getter.invoke((Object)this, null);
    }

    protected Object readObject(String key) throws Exception {
        Object result = null;
        result = this.m_subDispatchers.get(key);
        if (result != null) {
            return result;
        }
        if (key.startsWith("d_")) {
            return null;
        }
        for (IDispatcherExtension dispatcherExtension : s_dispatcherExtensions) {
            result = dispatcherExtension.readObject(this, key);
            if (result == null) continue;
            if (result == IDispatcherExtension.NULL) {
                result = null;
            }
            return result;
        }
        Class resultClass = this.resolveClass(key);
        if (resultClass == null) {
            this.outputLogInfoWhenNoClassWasResolved(key);
            throw new Error("Problem occurred when resolving the class for binding key: " + key);
        }
        IProcessPreview pp = this.createProcessPreview();
        if (pp != null) {
            pp.processBeforeCreation(key, resultClass);
        }
        result = this.createObjectInstance(resultClass);
        if (pp != null && result != null) {
            pp.processPreviewInitialization(key, result);
        }
        return result;
    }

    protected Object createObjectInstance(Class resultClass) throws Exception {
        Object result = null;
        if (DefaultDispatchedBean.class.isAssignableFrom(resultClass) || DefaultDispatchedPageBean.class.isAssignableFrom(resultClass)) {
            try {
                Class cpcac = this.getPreferredConstructorArguentClass();
                if (cpcac == null) {
                    throw new NoSuchMethodException();
                }
                Constructor c = resultClass.getConstructor(cpcac);
                result = c.newInstance(this);
            }
            catch (NoSuchMethodException nsmexc1) {
                try {
                    Constructor c = resultClass.getConstructor(IDispatcher.class);
                    result = c.newInstance(this);
                }
                catch (NoSuchMethodException nsmexc2) {
                    result = resultClass.newInstance();
                }
            }
        } else {
            result = resultClass.newInstance();
        }
        return result;
    }

    protected void prepareObject(Object object) {
    }

    protected IProcessPreview createProcessPreview() {
        if (HttpSessionAccess.checkIfInLayoutEditorPreview()) {
            IProcessPreview pp = ProcessPreview.instance();
            return pp;
        }
        return null;
    }

    protected void outputLogInfoWhenNoClassWasResolved(String key) {
        CLog.L.log(CLog.LL_ERR, "Problem occurred when resolving the class for binding key: " + key);
        CLog.L.log(CLog.LL_ERR, "Problem occurred when resolving the class for binding key: no class was found for the key");
    }

    public Class resolveClass(String key) {
        Class resultClass = null;
        if (this.checkIfKeyIsClassName(key)) {
            try {
                resultClass = CCClassResolver.resolveClass(key, ENUMCallerType.EXPRESSIONRESOLUTION);
                return resultClass;
            }
            catch (Throwable t) {
                throw new Error(t);
            }
        }
        if (this.m_registeredBeansByName.containsKey(key)) {
            String className = this.m_registeredBeansByName.get(key).getBeanClassName();
            try {
                resultClass = CCClassResolver.resolveClass(className, ENUMCallerType.EXPRESSIONRESOLUTION);
                return resultClass;
            }
            catch (Throwable t) {
                throw new Error(t);
            }
        }
        List<String> packages = this.m_registeredPackages;
        for (String packageName : packages) {
            String className = key.toString();
            if (packageName.length() == 0) continue;
            className = packageName + "." + className;
            try {
                resultClass = CCClassResolver.resolveClass(className, ENUMCallerType.EXPRESSIONRESOLUTION);
                return resultClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    @Override
    public boolean checkIfDispatchedBeanIsLoaded(Class dispatchedBeanClass) {
        String key = dispatchedBeanClass.getSimpleName();
        return this.checkIfDispatchedBeanIsLoaded(key);
    }

    @Override
    public boolean checkIfDispatchedBeanIsLoaded(String dispatchedBeanName) {
        return this.containsKey(dispatchedBeanName);
    }

    @Override
    public Object getDispatchedBean(Class dispatchedBeanClass) {
        if (this.m_registeredBeansByClass.containsKey(dispatchedBeanClass)) {
            DispatchedBeanInfo beanInfo = this.m_registeredBeansByClass.get(dispatchedBeanClass);
            return this.get(beanInfo.getName());
        }
        String key = dispatchedBeanClass.getSimpleName();
        return this.get(key);
    }

    @Override
    public void removeDispatchedBean(Class dispatchedBeanClass) {
        if (this.m_registeredBeansByClass.containsKey(dispatchedBeanClass)) {
            DispatchedBeanInfo beanInfo = this.m_registeredBeansByClass.get(dispatchedBeanClass);
            this.removeDispatchedBean(beanInfo.getName());
            return;
        }
        String key = dispatchedBeanClass.getSimpleName();
        this.removeDispatchedBean(key);
    }

    @Override
    public IDispatcher createSubDispatcherInstance() {
        return this.createSubDispatcherInstance(this.getClass());
    }

    public IDispatcher createSubDispatcherInstance(Class subDispatcherClass) {
        try {
            IDispatcher result = (IDispatcher)subDispatcherClass.newInstance();
            this.registerSubDispatcherInstance(result);
            return result;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Could not create sub dispatcher", t);
            throw new Error(t);
        }
    }

    protected void registerSubDispatcherInstance(IDispatcher subDispatcher) {
        subDispatcher.setOwner(this);
        String reb = subDispatcher.getExpressionBase();
        int lastDot = reb.lastIndexOf(46);
        reb = reb.substring(lastDot + 1, reb.length() - 1);
        this.m_subDispatchers.put(reb, subDispatcher);
    }

    @Override
    public String getExpressionBase() {
        if (this.m_owner != null) {
            String oeb = this.m_owner.getExpressionBase();
            return oeb.substring(0, oeb.length() - 1) + ".d_" + this.m_ownSubDispatcherCounter + "}";
        }
        return this.m_expressionBase;
    }

    @Override
    public void destroy() {
        if (this.m_destroyed) {
            return;
        }
        if (this.m_subDispatchers != null) {
            IDispatcher[] subDispatchers = new IDispatcher[this.m_subDispatchers.size()];
            this.m_subDispatchers.values().toArray(subDispatchers);
            for (int i = 0; i < subDispatchers.length; ++i) {
                try {
                    subDispatchers[i].destroy();
                    continue;
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_INF, "Problems when removing sub dispatcher", t);
                }
            }
        }
        if (this.m_owner != null) {
            this.m_owner.unregisterSubDispatcherInstance(this);
        }
        if (this.m_subDispatchers != null) {
            this.m_subDispatchers.clear();
        }
        this.m_subDispatchers = null;
        for (Object value : this.values()) {
            this.destroyDispatchedBean(value);
        }
        this.clear();
        this.m_owner = null;
        this.mtransient_classloader = null;
        this.mtransient_dispatcherInfo = null;
        this.mtransient_ownProperties = null;
        this.m_destroyed = true;
    }

    @Override
    public void unregisterSubDispatcherInstance(IDispatcher subDispatcher) {
        for (String key : this.m_subDispatchers.keySet()) {
            IDispatcher sd = this.m_subDispatchers.get(key);
            if (sd != subDispatcher) continue;
            this.m_subDispatchers.remove(key);
            break;
        }
        for (String key : this.keySet()) {
            Object o = this.get(key);
            if (o != subDispatcher) continue;
            this.remove(key);
            break;
        }
    }

    @Override
    public String updateExpression(String expression) {
        if (expression == null) {
            return null;
        }
        String topOwnerExpressionBase = this.getTopOwner().getExpressionBase();
        String thisExpressionBase = this.getExpressionBase();
        String topReplace = topOwnerExpressionBase.substring(0, topOwnerExpressionBase.length() - 1);
        String thisReplace = thisExpressionBase.substring(0, thisExpressionBase.length() - 1);
        expression = expression.replace(topReplace, thisReplace);
        return expression;
    }

    @Override
    public String getContentReplace() {
        String topOwnerExpressionBase = this.getTopOwner().getExpressionBase();
        String thisExpressionBase = this.getExpressionBase();
        String topReplace = topOwnerExpressionBase.substring(0, topOwnerExpressionBase.length() - 1);
        String thisReplace = thisExpressionBase.substring(0, thisExpressionBase.length() - 1);
        return topReplace + ".:" + thisReplace + ".";
    }

    @Override
    public IDispatcher getOwner() {
        return this.m_owner;
    }

    @Override
    public IDispatcher getTopOwner() {
        IDispatcher current = this;
        IDispatcher above;
        while ((above = current.getOwner()) != null) {
            current = above;
        }
        return current;
    }

    @Override
    public String getMyExpression(Object o) {
        if (o == null) {
            return null;
        }
        return this.getMyExpression(o.getClass());
    }

    @Override
    public String getMyExpression(Class cl) {
        String name = null;
        if (this.m_registeredBeansByClass.containsKey(cl)) {
            DispatchedBeanInfo beanInfo = this.m_registeredBeansByClass.get(cl);
            name = beanInfo.getName();
        } else {
            name = cl.getName();
            int index = name.lastIndexOf(46);
            name = name.substring(index + 1);
        }
        String result = this.getExpressionBase();
        result = result.replace("}", "." + name + "}");
        return result;
    }

    @Override
    @Deprecated
    public ModalPopup createModalPopup() {
        ModalPopup result = ModalPopup.createInstance();
        result.setContentReplaceDrillDown(this.getContentReplace());
        return result;
    }

    @Override
    @Deprecated
    public ModelessPopup createModelessPopup() {
        ModelessPopup result = ModelessPopup.createInstance();
        result.setContentReplaceDrillDown(this.getContentReplace());
        return result;
    }

    @Override
    public String toString() {
        try {
            return "Dispatcher " + this.getExpressionBase();
        }
        catch (Throwable t) {
            return "Dispatcher " + this.m_ownSubDispatcherCounter;
        }
    }

    @Override
    public List<IDispatcher> getChildDispatchers() {
        ArrayList<IDispatcher> result = new ArrayList<IDispatcher>();
        for (IDispatcher disp : this.m_subDispatchers.values()) {
            result.add(disp);
        }
        return result;
    }

    public boolean isDestroyed() {
        return this.m_destroyed;
    }

    private void initDispatcherViaDispatcherInfoXML() {
        BufferedDispatcherInfoXML bdixml = s_bufferedDispatcherInfoXMLs.get(this.getClass());
        if (bdixml == null) {
            this.m_registeredBeansByName = new HashMap<String, DispatchedBeanInfo>();
            this.m_registeredBeansByClass = new HashMap<Class, DispatchedBeanInfo>();
            this.m_registeredPackages = new ArrayList<String>();
            List<DispatchedBeanInfo> registeredBeans = new ArrayList<DispatchedBeanInfo>();
            String packageName = this.getClass().getPackage().getName();
            this.m_registeredPackages.add(packageName);
            String xmlResourceName = packageName.replace('.', '/') + "/dispatcherinfo.xml";
            DefaultDispatcher.addXMLRegisteredClassesFromResource(xmlResourceName, HotDeployManager.currentClassLoader(), registeredBeans, this.m_registeredPackages);
            List<String> xmls = new ClassloaderReader(HotDeployManager.currentClassLoader()).readUTF8Files("/ccdispatcherinfo.xml", false);
            if (xmls != null) {
                for (String xml : xmls) {
                    DefaultDispatcher.addXMLRegisteredClassesFromXml(xml, HotDeployManager.currentClassLoader(), registeredBeans, this.m_registeredPackages);
                }
            }
            this.m_registeredPackages = this.initRegisteredPackages(this.m_registeredPackages);
            registeredBeans = this.initRegisteredBeanInfos(registeredBeans);
            for (DispatchedBeanInfo beanInfo : registeredBeans) {
                this.m_registeredBeansByName.put(beanInfo.getName(), beanInfo);
                this.m_registeredBeansByClass.put(beanInfo.getBeanClass(), beanInfo);
            }
            bdixml = new BufferedDispatcherInfoXML(this.m_registeredBeansByName, this.m_registeredBeansByClass, this.m_registeredPackages);
            s_bufferedDispatcherInfoXMLs.put(this.getClass(), bdixml);
        } else {
            this.m_registeredBeansByClass = bdixml.getRegisteredBeansByClass();
            this.m_registeredBeansByName = bdixml.getRegisteredBeansByName();
            this.m_registeredPackages = bdixml.getRegisteredPackages();
        }
    }

    protected void initDispatcher() {
    }

    protected List<String> initRegisteredPackages(List<String> packageNames) {
        return packageNames;
    }

    protected List<DispatchedBeanInfo> initRegisteredBeanInfos(List<DispatchedBeanInfo> infos) {
        return infos;
    }

    private static void addXMLRegisteredClassesFromResource(String resourceName, ClassLoader classLoader, List<DispatchedBeanInfo> beanInfos, List<String> packageNames) {
        List<URL> paths = new ClassloaderReader(classLoader).readResourcePaths(resourceName, false);
        for (URL path : paths) {
            try {
                CLog.L.log(CLog.LL_INF, "Adding XML registered classes/pacakages: " + path.toExternalForm());
                String xml = new ClassloaderReader(classLoader).readURLContentAsUTF8(path, false);
                if (xml == null || xml.length() == 0) continue;
                DefaultDispatcher.addXMLRegisteredClassesFromXml(xml, classLoader, beanInfos, packageNames);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem reading: " + resourceName, t);
            }
        }
    }

    private static void addXMLRegisteredClassesFromXml(String xml, ClassLoader classLoader, List<DispatchedBeanInfo> beanInfos, List<String> packageNames) {
        if (xml == null || xml.length() == 0) {
            return;
        }
        try {
            SAXParser parser = SAXParserCreator.createSAXParser();
            InputSource is = new InputSource(new StringReader(xml));
            DispatcherInfoParser mp = new DispatcherInfoParser(classLoader, beanInfos, packageNames);
            parser.parse(is, (DefaultHandler)mp);
            for (String extension : mp.i_extensions) {
                DefaultDispatcher.addXMLRegisteredClassesFromResource(extension, classLoader, beanInfos, packageNames);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error when parsing file dispatcherinfo.xml: " + xml, t);
        }
    }

    private static Class[] getClasses(String packageName, ClassLoader classLoader, String dispatcherClassName) {
        try {
            String path = packageName.replace('.', '/');
            Enumeration<URL> resources = classLoader.getResources(path);
            ArrayList<File> dirs = new ArrayList<File>();
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                String resourceFile = resource.getFile();
                resourceFile = URLDecoder.decode(resourceFile, "UTF-8");
                dirs.add(new File(ValueManager.approveFileName(resourceFile)));
            }
            HashSet<Class> classes = new HashSet<Class>();
            for (File directory : dirs) {
                classes.addAll(DefaultDispatcher.findClasses(directory, packageName, classLoader, dispatcherClassName));
            }
            return classes.toArray(new Class[classes.size()]);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problems reading classes for: " + packageName, t);
            return new Class[0];
        }
    }

    private static List<Class> findClasses(File directory, String packageName, ClassLoader classLoader, String dispatcherClassName) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class> classes = new ArrayList<Class>();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (!file.getName().endsWith(".class") || file.getName().contains("$")) continue;
            String className = file.getName().substring(0, file.getName().length() - 6);
            if (packageName.length() > 0) {
                className = packageName + "." + className;
            }
            if (className.equals(dispatcherClassName)) continue;
            try {
                Class tc = CCClassResolver.resolveClass(className, true, classLoader, ENUMCallerType.TOOLS);
                classes.add(tc);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_WAR, "Problems when analyzing class " + className, t);
            }
        }
        return classes;
    }

    protected Class getPreferredConstructorArguentClass() {
        return null;
    }

    private void registerFirstDispatcherInDialogSession() {
        ISessionAbstraction dialogSession = HttpSessionAccess.getCurrentDialogSession();
        if (dialogSession != null && dialogSession.getAttribute(DIALOGSESSION_KEY) == null) {
            HttpSessionAccess.getCurrentDialogSession().setAttribute(DIALOGSESSION_KEY, this);
        }
    }

    public static class DispatcherInfo {
        String i_packageName;
        String i_dtSourceDirectory;
        String i_dtClassDirectory;
        transient ClassLoader i_classLoader;
        transient String i_className;
        transient List<String> i_extPackageNames = new ArrayList<String>();

        public String getPackageName() {
            return this.i_packageName;
        }

        private DispatcherInfo(int fromRuntime, Class dispatcherClass) {
            this.i_classLoader = HotDeployManager.currentClassLoader();
            this.i_packageName = dispatcherClass.getName();
            int lastDot = this.i_packageName.lastIndexOf(46);
            this.i_packageName = lastDot >= 0 ? this.i_packageName.substring(0, lastDot) : "";
            this.i_className = dispatcherClass.getName();
            this.readExtPackageNames();
        }

        public DispatcherInfo(Class dispatcherClass) {
            this.i_classLoader = dispatcherClass.getClassLoader();
            this.i_packageName = dispatcherClass.getName();
            int lastDot = this.i_packageName.lastIndexOf(46);
            this.i_packageName = lastDot >= 0 ? this.i_packageName.substring(0, lastDot) : "";
            this.i_className = dispatcherClass.getName();
            this.readExtPackageNames();
        }

        public void initDesignTimeProjectDirectories(String sourceDirectory, String classDirectory) {
            this.i_dtSourceDirectory = ValueManager.encodeIntoValidFileName(sourceDirectory, true);
            this.i_dtClassDirectory = ValueManager.encodeIntoValidFileName(classDirectory, true);
        }

        public List<DispatchedBeanInfo> getDispatchedBeans() {
            ArrayList<DispatchedBeanInfo> result = new ArrayList<DispatchedBeanInfo>();
            if (this.i_classLoader == null) {
                return result;
            }
            String xmlResourceName = this.i_packageName.replace('.', '/') + "/dispatcherinfo.xml";
            ArrayList<String> packageNames = new ArrayList<String>();
            packageNames.add(this.i_packageName);
            DefaultDispatcher.addXMLRegisteredClassesFromResource(xmlResourceName, this.i_classLoader, result, packageNames);
            DefaultDispatcher.addXMLRegisteredClassesFromResource("ccdispatcherinfo.xml", this.i_classLoader, result, packageNames);
            for (String packageName : packageNames) {
                HashSet<Class> packageClasses = new HashSet<Class>();
                if (this.i_dtClassDirectory == null) {
                    Class[] packageClassesArray;
                    for (Class cl : packageClassesArray = DefaultDispatcher.getClasses(packageName, this.i_classLoader, this.i_className)) {
                        packageClasses.add(cl);
                    }
                }
                if (this.i_dtClassDirectory != null) {
                    try {
                        String packageDirecotry = this.i_dtClassDirectory + packageName.replace(".", "/");
                        List directoryClasses = DefaultDispatcher.findClasses(new File(packageDirecotry), packageName, this.i_classLoader, this.i_className);
                        packageClasses.addAll(directoryClasses);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                for (Class pc : packageClasses) {
                    String name = pc.getName();
                    int index = name.lastIndexOf(46);
                    name = name.substring(index + 1);
                    result.add(new DispatchedBeanInfo(pc, name, pc.getName()));
                }
            }
            return result;
        }

        public List<String> getExtPackageNames() {
            return this.i_extPackageNames;
        }

        private void readExtPackageNames() {
            try {
                this.i_extPackageNames = new ArrayList<String>();
                String xmlResourceName = this.i_packageName.replace('.', '/') + "/dispatcherinfo.xml";
                this.readExtPacakgeNames(xmlResourceName);
                xmlResourceName = "/ccdispatcherinfo.xml";
                this.readExtPacakgeNames(xmlResourceName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void readExtPacakgeNames(String xmlResourceName) {
            try {
                ArrayList dummy = new ArrayList();
                ArrayList<String> packageNames = new ArrayList<String>();
                packageNames.add(this.i_packageName);
                DefaultDispatcher.addXMLRegisteredClassesFromResource(xmlResourceName, this.i_classLoader, dummy, this.i_extPackageNames);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class MySessionAbstractionListener
    implements ISessionAbstractionListener,
    Serializable {
        private MySessionAbstractionListener() {
        }

        @Override
        public void reactOnClosed() {
            if (DefaultDispatcher.this.getOwner() == null) {
                CLog.L.log(CLog.LL_INF, "Dispatcher reacts on closed dialog session - begin");
                DefaultDispatcher.this.destroy();
                CLog.L.log(CLog.LL_INF, "Dispatcher reacts on closed dialog session - end");
            }
        }
    }

    public static class ReadObjectReturnedNullException
    extends Exception {
        public ReadObjectReturnedNullException(String arg0) {
            super(arg0);
        }
    }

    public static class DispatchedBeanInfo
    implements Serializable {
        Class i_beanClass;
        String i_name;
        String i_beanClassName;

        public DispatchedBeanInfo(Class beanClass, String name, String beanClassName) {
            this.i_beanClass = beanClass;
            this.i_beanClassName = beanClassName;
            this.i_name = name;
        }

        public String getName() {
            return this.i_name;
        }

        public Class getBeanClass() {
            return this.i_beanClass;
        }

        public String getBeanClassName() {
            return this.i_beanClassName;
        }
    }

    private static class BufferedDispatcherInfoXML {
        Map<String, DispatchedBeanInfo> i_registeredBeansByName;
        Map<Class, DispatchedBeanInfo> i_registeredBeansByClass;
        List<String> i_registeredPackages;

        public BufferedDispatcherInfoXML(Map<String, DispatchedBeanInfo> registeredBeansByName, Map<Class, DispatchedBeanInfo> registeredBeansByClass, List<String> registeredPackages) {
            this.i_registeredBeansByName = registeredBeansByName;
            this.i_registeredBeansByClass = registeredBeansByClass;
            this.i_registeredPackages = registeredPackages;
        }

        public Map<String, DispatchedBeanInfo> getRegisteredBeansByName() {
            return this.i_registeredBeansByName;
        }

        public Map<Class, DispatchedBeanInfo> getRegisteredBeansByClass() {
            return this.i_registeredBeansByClass;
        }

        public List<String> getRegisteredPackages() {
            return this.i_registeredPackages;
        }
    }

    private static class DispatcherInfoParser
    extends DefaultHandler {
        ClassLoader i_classLoader;
        List<DispatchedBeanInfo> i_beanInfos;
        List<String> i_packages;
        List<String> i_extensions = new ArrayList<String>();

        public DispatcherInfoParser(ClassLoader classLoader, List<DispatchedBeanInfo> beanInfos, List<String> pacakges) {
            this.i_classLoader = classLoader;
            this.i_beanInfos = beanInfos;
            this.i_packages = pacakges;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            String resourceName;
            if (name.equals("managedbean")) {
                String mbName = attributes.getValue("name");
                String mbClass = attributes.getValue("class");
                try {
                    Class beanClass = CCClassResolver.resolveClass(mbClass, true, this.i_classLoader, ENUMCallerType.TOOLS);
                    DispatchedBeanInfo beanInfo = new DispatchedBeanInfo(beanClass, mbName, mbClass);
                    this.i_beanInfos.add(beanInfo);
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Problems when creating bean information for class " + mbClass, t);
                }
            } else if (name.equals("managedpackage")) {
                String packageName = attributes.getValue("name");
                if (packageName != null) {
                    this.i_packages.add(packageName);
                }
            } else if (name.equals("dispatcherinfoextension") && (resourceName = attributes.getValue("resource")) != null) {
                this.i_extensions.add(resourceName);
            }
        }
    }
}

