/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.streamstore;

import java.sql.Connection;
import org.eclnt.jsfserver.configuration.CCConfigurationObjectLoader;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.streamstore.IJDBCConnectionProvider;
import org.eclnt.jsfserver.streamstore.IJDBCConnectionProvider2;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;

public class JDBCConnectionProviderFactory {
    static IJDBCConnectionProvider s_jdbcConnectionProvider = null;
    static Object SYNCHER = new Object();
    static ClassLoader s_lastUsedClassLoader = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IJDBCConnectionProvider getProvider() {
        if (s_jdbcConnectionProvider == null || s_lastUsedClassLoader != HotDeployManager.currentClassLoader()) {
            Object object = SYNCHER;
            synchronized (object) {
                if (s_jdbcConnectionProvider == null || s_lastUsedClassLoader != HotDeployManager.currentClassLoader()) {
                    CLog.L.log(CLog.LL_INF, "Creating JDBC Connection provider instance");
                    String jdbcConnectionProviderClassName = SystemXml.getJdbcConnectionProvider();
                    if (jdbcConnectionProviderClassName == null) {
                        throw new Error("JDBC connection provider is not defined in system.xml");
                    }
                    CLog.L.log(CLog.LL_INF, "JDBC Connection provider class name is: " + jdbcConnectionProviderClassName);
                    try {
                        s_jdbcConnectionProvider = (IJDBCConnectionProvider)CCConfigurationObjectLoader.instance().loadInstance(jdbcConnectionProviderClassName, true);
                    }
                    catch (Throwable t) {
                        CLog.L.log(CLog.LL_ERR, "Problem when creating JDBC connection provider " + t.toString());
                        throw new Error(t);
                    }
                }
            }
        }
        return s_jdbcConnectionProvider;
    }

    public static IJDBCConnectionProvider2 getProvider2() {
        IJDBCConnectionProvider result = JDBCConnectionProviderFactory.getProvider();
        if (result != null) {
            if (result instanceof IJDBCConnectionProvider2) {
                return (IJDBCConnectionProvider2)result;
            }
            return new JDBCConnectionProviderWrapper2to1(result);
        }
        return null;
    }

    static class JDBCConnectionProviderWrapper2to1
    implements IJDBCConnectionProvider2 {
        IJDBCConnectionProvider i_provider1;

        public JDBCConnectionProviderWrapper2to1(IJDBCConnectionProvider provider1) {
            this.i_provider1 = provider1;
        }

        @Override
        public Connection createConnection() {
            return this.i_provider1.createConnection();
        }

        @Override
        public String getDatabaseSchemaName() {
            return null;
        }
    }
}

