/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import org.eclnt.jsfserver.util.CCESAPI;
import org.eclnt.jsfserver.util.CCServletBaseWithContextMgmt;
import org.eclnt.jsfserver.util.IAutoCompleteProvider;
import org.eclnt.jsfserver.util.IAutoCompleteProvider2;
import org.eclnt.jsfserver.util.IAutoCompleteProvider3;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.owasp.esapi.ESAPI;

public class AutoCompleteServlet
extends CCServletBaseWithContextMgmt {
    @Override
    protected boolean checkIfToAbortOnMissingHttpSession(HttpServletRequest req) {
        return true;
    }

    @Override
    public void processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setCharacterEncoding("UTF-8");
        ServletUtil.setResponseContentType(resp, "text/plain;charset=UTF-8");
        HttpSession session = req.getSession(false);
        String bufferId = req.getRequestURI();
        int index = bufferId.indexOf(".ccautocomplete");
        if (index > 0) {
            String searchString = req.getParameter("SEARCHSTRING");
            if (searchString == null) {
                searchString = "";
            }
            String reference = req.getParameter("REFERENCE");
            if (req.getCharacterEncoding() == null && SystemXml.getNonJSFRequestsExplicitUTF8Conversion()) {
                searchString = new String(searchString.getBytes("ISO-8859-1"), "UTF-8");
            }
            bufferId = bufferId.substring(0, index);
            index = bufferId.lastIndexOf(47);
            bufferId = bufferId.substring(index + 1);
            bufferId = "autoCompleteProvider_" + bufferId;
            Object autoCompleteProviderObject = session.getAttribute(bufferId);
            if (autoCompleteProviderObject == null) {
                Exception exc = new Exception();
                CLog.L.log(CLog.LL_ERR, "No buffered content found for " + bufferId, exc);
                resp.getWriter().write(ESAPI.encoder().encodeForHTML("No buffered content avialable: " + bufferId));
                return;
            }
            if (autoCompleteProviderObject instanceof IAutoCompleteProvider) {
                IAutoCompleteProvider autoCompleteProvider = (IAutoCompleteProvider)autoCompleteProviderObject;
                List<String> proposals = autoCompleteProvider.getProposals(searchString);
                PrintWriter writer = resp.getWriter();
                ((Writer)writer).write("<proposals>");
                for (String proposal : proposals) {
                    ((Writer)writer).write("<proposal ");
                    ((Writer)writer).write(CCESAPI.getXMLAttributeAssignment("text", proposal));
                    ((Writer)writer).write("/>");
                }
                ((Writer)writer).write("</proposals>");
                ((Writer)writer).close();
            } else if (autoCompleteProviderObject instanceof IAutoCompleteProvider2) {
                IAutoCompleteProvider2 autoCompleteProvider = (IAutoCompleteProvider2)autoCompleteProviderObject;
                List<IAutoCompleteProvider2.AutoCompleteItem> proposals = autoCompleteProvider.getProposals(searchString);
                PrintWriter writer = resp.getWriter();
                ((Writer)writer).write("<proposals>");
                for (IAutoCompleteProvider2.AutoCompleteItem proposal : proposals) {
                    ((Writer)writer).write("<proposal ");
                    ((Writer)writer).write(CCESAPI.getXMLAttributeAssignment("text", proposal.getText()));
                    ((Writer)writer).write(CCESAPI.getXMLAttributeAssignment("id", proposal.getId()));
                    ((Writer)writer).write(CCESAPI.getXMLAttributeAssignment("comment", proposal.getComment()));
                    ((Writer)writer).write("/>");
                }
                ((Writer)writer).write("</proposals>");
                ((Writer)writer).close();
            } else if (autoCompleteProviderObject instanceof IAutoCompleteProvider3) {
                IAutoCompleteProvider3 autoCompleteProvider = (IAutoCompleteProvider3)autoCompleteProviderObject;
                List<IAutoCompleteProvider3.AutoCompleteItem> proposals = autoCompleteProvider.getProposals(searchString, reference);
                PrintWriter writer = resp.getWriter();
                ((Writer)writer).write("<proposals>");
                for (IAutoCompleteProvider3.AutoCompleteItem proposal : proposals) {
                    ((Writer)writer).write("<proposal ");
                    ((Writer)writer).write(CCESAPI.getXMLAttributeAssignment("text", proposal.getText()));
                    ((Writer)writer).write(CCESAPI.getXMLAttributeAssignment("id", proposal.getId()));
                    ((Writer)writer).write(CCESAPI.getXMLAttributeAssignment("comment", proposal.getComment()));
                    ((Writer)writer).write(CCESAPI.getXMLAttributeAssignment("image", proposal.getImage()));
                    ((Writer)writer).write("/>");
                }
                ((Writer)writer).write("</proposals>");
                ((Writer)writer).close();
            }
        } else {
            resp.getWriter().write(ValueManager.encodeIntoValidXMLString("No buffered content avialable: " + ESAPI.encoder().encodeForHTML(bufferId)));
        }
    }
}

