/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclnt.jsfserver.util.CompressionResponseWrapper;

public class CompressionFilter
implements Filter {
    public void doFilter(ServletRequest servletrequest, ServletResponse servletresponse, FilterChain filterchain) throws IOException, ServletException {
        if (servletrequest instanceof HttpServletRequest) {
            HttpServletRequest httpservletrequest = (HttpServletRequest)servletrequest;
            HttpServletResponse httpservletresponse = (HttpServletResponse)servletresponse;
            String s = httpservletrequest.getHeader("accept-encoding");
            if (s != null && s.indexOf("gzip") != -1) {
                CompressionResponseWrapper gzipresponsewrapper = new CompressionResponseWrapper(httpservletresponse);
                filterchain.doFilter(servletrequest, (ServletResponse)gzipresponsewrapper);
                gzipresponsewrapper.finishResponse();
                return;
            }
            filterchain.doFilter(servletrequest, servletresponse);
        }
    }

    public void init(FilterConfig filterconfig) {
    }

    public void destroy() {
    }
}

