/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import org.eclnt.jsfserver.util.CCServletBase;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class FileAccessDelegationServlet
extends CCServletBase {
    static String s_URLprefix = null;
    static String s_delegatToDirectory = null;

    public static void init(String urlPrefix, String delegateToDirectory) {
        s_URLprefix = urlPrefix;
        s_delegatToDirectory = ValueManager.encodeIntoValidFileName(delegateToDirectory, true);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (s_delegatToDirectory == null || s_URLprefix == null) {
            throw new Error("Servlet is not configured properly");
        }
        String path = req.getRequestURI();
        int index = path.indexOf(";");
        if (index >= 0) {
            path = path.substring(0, index);
        }
        index = path.indexOf("/" + s_URLprefix + "/");
        path = path.substring(index + ("/" + s_URLprefix + "/").length());
        String filePath = s_delegatToDirectory + path;
        this.setContentType(path, resp);
        InputStream fis = null;
        ServletOutputStream sos = null;
        try {
            fis = FileManager.readFileInputStream(filePath, true);
            sos = resp.getOutputStream();
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = fis.read(buffer)) > 0) {
                sos.write(buffer, 0, length);
            }
        }
        catch (Throwable t) {
            throw new Error("Problem processing path: " + path, t);
        }
        finally {
            try {
                fis.close();
            }
            catch (Throwable buffer) {}
        }
    }
}

