/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import java.beans.FeatureDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.eclnt.util.java.JavaRecordsUtil;
import org.eclnt.util.java.JavaVersion;

public class RecordELResolver
extends ELResolver {
    public Object getValue(ELContext context, Object base, Object property) {
        try {
            if (!JavaVersion.isSupportingRecords()) {
                return null;
            }
            if (context == null) {
                throw new NullPointerException();
            }
            if (base == null || property == null) {
                return null;
            }
            if (!JavaRecordsUtil.checkIfObjectIsRecord(base)) {
                return null;
            }
            Method method = base.getClass().getMethod(property + "", new Class[0]);
            if (method == null) {
                return null;
            }
            Object value = method.invoke(base, null);
            context.setPropertyResolved(true);
            return value;
        }
        catch (NoSuchMethodException exc) {
            return null;
        }
        catch (ELException ex) {
            throw ex;
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
        catch (Exception ex) {
            throw new ELException((Throwable)ex);
        }
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        try {
            if (!JavaVersion.isSupportingRecords()) {
                return null;
            }
            if (context == null) {
                throw new NullPointerException();
            }
            if (!JavaRecordsUtil.checkIfObjectIsRecord(base)) {
                return null;
            }
            if (base == null || property == null) {
                return null;
            }
            Method method = base.getClass().getMethod(property + "", new Class[0]);
            context.setPropertyResolved(true);
            return method.getReturnType();
        }
        catch (NoSuchMethodException exc) {
            return null;
        }
    }

    public void setValue(ELContext context, Object var2, Object var3, Object var4) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (!JavaVersion.isSupportingRecords()) {
            return;
        }
    }

    public boolean isReadOnly(ELContext context, Object var2, Object var3) throws NullPointerException, PropertyNotFoundException, ELException {
        return true;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object var2) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        return Object.class;
    }
}

