/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.tempfile;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.jsfserver.util.DefaultSessionAbstractionListener;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.SecurityFilterGeneral;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;

public class TempFileManager {
    static String s_tempFileDirectory = null;
    public static final String CROSS_SESSION_SESSIONID = "CROSS_SESSION";
    static Map<String, List<String>> s_crossSessionTempFiles = new HashMap<String, List<String>>();
    static final Object SYNCHER = new Object();

    public static void initialize(ServletContext servletContext) {
        s_tempFileDirectory = HttpSessionAccess.getServletTempDirectory(servletContext);
    }

    public static void initTempFileDirectory(String directory) {
        s_tempFileDirectory = ValueManager.encodeIntoValidFileName(directory, true);
    }

    public static byte[] readTempFile(HttpSession session, String path) {
        String filePath = TempFileManager.calculateFilePath(session.getId(), path);
        return FileManager.readFile(filePath, false);
    }

    public static String findTempFileContentType(HttpSession session, String path) {
        return TempFileManager.findTempFileContentType(session.getId(), path);
    }

    public static String findTempFileContentType(String sessionId, String path) {
        String filePath = TempFileManager.calculateFilePath(sessionId, path) + ".contentType";
        if (FileManager.checkIfFileExists(filePath)) {
            return FileManager.readUTF8File(filePath, true);
        }
        return null;
    }

    public static String findTempFileContentType(String filePathOfSavedFile) {
        String filePath = filePathOfSavedFile + ".contentType";
        if (FileManager.checkIfFileExists(filePath)) {
            return FileManager.readUTF8File(filePath, true);
        }
        return null;
    }

    public static String findTempFilePath(HttpSession session, String path) {
        String filePath = TempFileManager.calculateFilePath(session.getId(), path);
        return filePath;
    }

    public static String findTempFilePath(String sessionId, String path) {
        String filePath = TempFileManager.calculateFilePath(sessionId, path);
        return filePath;
    }

    public static String saveTempFile(String fileName, byte[] content) {
        return TempFileManager.saveTempFile(fileName, null, content);
    }

    public static String saveTempFile(String fileName, String contentType, byte[] content) {
        HttpSession session = HttpSessionAccess.getCurrentHttpSession();
        return TempFileManager.saveTempFile(fileName, contentType, content, session.getId());
    }

    public static String saveTempFileCrossSession(String fileName, String contentType, byte[] content) {
        return TempFileManager.saveTempFile(fileName, contentType, content, CROSS_SESSION_SESSIONID);
    }

    public static String saveTempFile(String fileName, String contentType, byte[] content, String sessionId) {
        if (content == null) {
            throw new Error("No content was passed to be saved in TempFileManager " + fileName + ", " + contentType);
        }
        String filePath = null;
        String uriPath = null;
        String uuid = UniqueIdCreator.createUUID();
        if (!CROSS_SESSION_SESSIONID.equals(sessionId)) {
            filePath = "/" + uuid + "/" + fileName;
            uriPath = "/" + uuid + "/" + ValueManager.encodeURLPart(fileName);
        } else {
            filePath = "/" + uuid + "_" + CROSS_SESSION_SESSIONID + "/" + fileName;
            uriPath = "/" + uuid + "_" + CROSS_SESSION_SESSIONID + "/" + ValueManager.encodeURLPart(fileName);
        }
        filePath = TempFileManager.calculateFilePath(sessionId, filePath);
        FileManager.ensureDirectoryForFileExists(filePath);
        FileManager.writeFile(filePath, content, true);
        if (contentType != null) {
            String contentTypePath = filePath + ".contentType";
            FileManager.writeUTF8File(contentTypePath, contentType, true);
        }
        if (ValueManager.checkIfStringsAreEqual(sessionId, CROSS_SESSION_SESSIONID)) {
            HttpSession session = HttpSessionAccess.getCurrentHttpSession();
            TempFileManager.addCrossSessionFilePath(session, filePath);
        }
        final String filePathForRemoval = filePath;
        HttpSessionAccess.getCurrentDialogSession().addListener(new DefaultSessionAbstractionListener(){

            @Override
            public void reactOnClosed() {
                FileManager.deleteFile(filePathForRemoval);
            }
        });
        boolean withURLSessionIdEncoding = true;
        if (CROSS_SESSION_SESSIONID.equals(sessionId)) {
            withURLSessionIdEncoding = false;
        }
        String url = TempFileManager.calculateURL(uriPath, fileName, withURLSessionIdEncoding);
        return url;
    }

    public static void clear(HttpSession session) {
        block10: {
            try {
                String filePath = TempFileManager.calculateFilePath(session.getId(), "a.a");
                filePath = filePath.substring(0, filePath.length() - 3);
                boolean exists = FileManager.checkIfFileExists(filePath);
                if (!exists) {
                    return;
                }
                FileManager.deleteDirectoryContent(filePath);
                FileManager.deleteFile(filePath);
                List<String> filePaths = TempFileManager.getAndRemoveCrossSessionFilePaths(session);
                if (filePaths == null) break block10;
                for (String filePath2 : filePaths) {
                    try {
                        FileManager.deleteFile(filePath2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        FileManager.deleteFile(filePath2 + ".contentType");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    int index = filePath2.lastIndexOf("/");
                    String dir = filePath2.substring(0, index);
                    try {
                        FileManager.deleteFile(dir);
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Problem removing temp file content for session", t);
            }
        }
    }

    public static String calculateURL(String path, String fileName, boolean withURLSessionIdEncoding) {
        path = "cctempfileaccess/" + path;
        path = ValueManager.encodeIntoValidFileName(path, false);
        String result = null;
        result = withURLSessionIdEncoding ? ServletUtil.encodeURL(path, HttpSessionAccess.getCurrentRequest(), HttpSessionAccess.getCurrentResponse()) : ServletUtil.encodeURLWithoutURLEncoding(path, HttpSessionAccess.getCurrentRequest(), HttpSessionAccess.getCurrentResponse());
        if (!result.startsWith("/")) {
            result = "/" + result;
        }
        result = ServletUtil.addFileNameAdviceIntoURL(result, fileName);
        return result;
    }

    public static String calculateFilePath(String httpSessionId, String path) {
        String filePath = s_tempFileDirectory + "/cctempfileaccess/" + httpSessionId + "/" + path;
        filePath = ValueManager.encodeIntoValidFileName(filePath, false);
        return filePath;
    }

    public static String calculateDirectoryPath(String httpSessionId) {
        String filePath = s_tempFileDirectory + "/cctempfileaccess/" + httpSessionId + "/";
        filePath = ValueManager.encodeIntoValidFileName(filePath, true);
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCrossSessionFilePath(HttpSession session, String filePath) {
        Object object = SYNCHER;
        synchronized (object) {
            List<String> filePaths = s_crossSessionTempFiles.get(session.getId());
            if (filePaths == null) {
                filePaths = new ArrayList<String>();
                s_crossSessionTempFiles.put(session.getId(), filePaths);
            }
            filePaths.add(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getAndRemoveCrossSessionFilePaths(HttpSession session) {
        Object object = SYNCHER;
        synchronized (object) {
            List<String> filePaths = s_crossSessionTempFiles.get(session.getId());
            if (filePaths != null) {
                s_crossSessionTempFiles.remove(session.getId());
            }
            return filePaths;
        }
    }

    public static String updateFilePathToOverComeDifferentFileNames(String filePath) {
        if (FileManager.checkIfFileExists(filePath)) {
            return filePath;
        }
        String parentDir = new File(filePath).getParentFile().getAbsolutePath();
        if (FileManager.checkIfFileExists(parentDir)) {
            List<File> files = FileManager.getFilesOfDirectory(parentDir);
            for (File file : files) {
                if (file.getName().endsWith(".contentType")) continue;
                return file.getAbsolutePath();
            }
            throw new Error("Could not update filePath - no content file found: " + filePath);
        }
        throw new Error("Could not update filePath, parent directory does not exist: " + filePath);
    }

    static {
        SecurityFilterGeneral.addSecurityFilterExtension(new TFMSecurityFilterExtension());
    }

    static class TFMSecurityFilterExtension
    implements SecurityFilterGeneral.IExtension {
        TFMSecurityFilterExtension() {
        }

        @Override
        public boolean checkIfToExecuteCheck(ServletRequest servletRequest) {
            try {
                HttpServletRequest request = (HttpServletRequest)servletRequest;
                String path = ServletUtil.getPathBehindContextPath(request);
                int index1 = path.indexOf("/cctempfileaccess/");
                if (index1 != 0) {
                    return true;
                }
                int index2 = path.indexOf(47, index1 + "/cctempfileaccess/".length());
                if (index2 < 0) {
                    return true;
                }
                String filePath = path.substring(index1 + "/cctempfileaccess/".length(), index2);
                if (filePath.endsWith(TempFileManager.CROSS_SESSION_SESSIONID)) {
                    return false;
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem when checking cross session access", t);
            }
            return true;
        }
    }
}

