/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.image;

import jakarta.servlet.ServletContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import javax.swing.JLabel;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class FontImageCreator {
    public static void initialize(ServletContext context) {
        GraphicsEnvironment ge;
        Font font;
        ByteArrayInputStream in;
        byte[] bytes2;
        try {
            CLog.L.log(CLog.LL_INF, "FontImageCreator: loading awesomefont...");
            bytes2 = WebResourceClassloaderReader.readFileIntoByteArray("/eclnt/risc/fonts/awesomefont/fonts/fontawesome-webfont.ttf");
            in = new ByteArrayInputStream(bytes2);
            font = Font.createFont(0, in);
            ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(font);
            CLog.L.log(CLog.LL_INF, "FontImageCreator: loading awesomefont... font name: " + font.getName());
            CLog.L.log(CLog.LL_INF, "FontImageCreator: loading awesomefont... ...finished");
        }
        catch (Throwable bytes2) {
            // empty catch block
        }
        try {
            CLog.L.log(CLog.LL_INF, "FontImageCreator: loading SAP-Icon font...");
            bytes2 = WebResourceClassloaderReader.readFileIntoByteArray("/eclnt/risc/fonts/sapicons/fonts/SAP-icons.ttf");
            in = new ByteArrayInputStream(bytes2);
            font = Font.createFont(0, in);
            ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(font);
            CLog.L.log(CLog.LL_INF, "FontImageCreator: loading SAP-icon... font name: " + font.getName());
            CLog.L.log(CLog.LL_INF, "FontImageCreator: loading SAP-icon... ...finished");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static BufferedImage createFontImage(String imageCommand) {
        if (imageCommand == null) {
            return null;
        }
        if (imageCommand.startsWith("awesomefont(")) {
            return FontImageCreator.createAwesomeFontImage(imageCommand);
        }
        if (imageCommand.startsWith("sapicon(")) {
            return FontImageCreator.createSAPIconsFontImage(imageCommand);
        }
        throw new Error("Could not interpret image command: " + imageCommand);
    }

    public static BufferedImage createAwesomeFontImage(String imageCommand) {
        String[] ps = ValueManager.decodeMethodParams(imageCommand);
        String afHexcode = null;
        String afColor = null;
        String afSize = null;
        try {
            afHexcode = ps[0];
            afColor = ps[1];
            afSize = ps[2];
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String text = ValueManager.convertHexCodeToChar(afHexcode) + "";
        if (text.length() > 100) {
            throw new Error("Maximum length of text is limited to 100.");
        }
        Color color = ValueManager.decodeColor(afColor, "#000000");
        int fontSize = ValueManager.decodeInt(afSize, 12);
        if (fontSize > 1000) {
            throw new Error("Maximum size is limited to 1000.");
        }
        Font font = new Font("FontAwesome", 0, fontSize);
        BufferedImage image = FontImageCreator.createImageFromText(text, font, color);
        return image;
    }

    public static BufferedImage createSAPIconsFontImage(String imageCommand) {
        String[] ps = ValueManager.decodeMethodParams(imageCommand);
        String afHexcode = null;
        String afColor = null;
        String afSize = null;
        try {
            afHexcode = ps[0];
            afColor = ps[1];
            afSize = ps[2];
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String text = ValueManager.convertHexCodeToChar(afHexcode) + "";
        if (text.length() > 100) {
            throw new Error("Maximum length of text is limited to 100.");
        }
        Color color = ValueManager.decodeColor(afColor, "#000000");
        int fontSize = ValueManager.decodeInt(afSize, 12);
        if (fontSize > 1000) {
            throw new Error("Maximum size is limited to 1000.");
        }
        Font font = new Font("SAP-icons", 0, fontSize);
        BufferedImage image = FontImageCreator.createImageFromText(text, font, color);
        return image;
    }

    public static BufferedImage createImageFromText(String text, Font font, Color color) {
        JLabel l = new JLabel(text);
        l.setForeground(color);
        l.setFont(font);
        l.setVisible(true);
        Dimension d = l.getPreferredSize();
        l.setSize(d);
        BufferedImage bim = new BufferedImage(d.width, d.height, 2);
        Graphics g = bim.getGraphics();
        l.paint(g);
        return bim;
    }
}

