/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.io.Serializable;
import org.eclnt.jsfserver.streamstore.StreamStore;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.JAXBManager;
import org.eclnt.workplace.WorkplaceFunctionTreeInfoNode;

public class WorkplaceFunctionTreeInfoManager
implements Serializable {
    public static WorkplaceFunctionTreeInfoNode loadFunctionTreeInfo(String treeName) {
        WorkplaceFunctionTreeInfoNode result = null;
        if (treeName.contains("/")) {
            result = WorkplaceFunctionTreeInfoManager.loadFunctionTreeInfoFromResources(treeName);
        }
        if (result == null) {
            result = WorkplaceFunctionTreeInfoManager.loadFunctionTreeInfoFromStreamStore(treeName);
        }
        return result;
    }

    public static WorkplaceFunctionTreeInfoNode loadFunctionTreeInfoFromStreamStore(String treeName) {
        try {
            String streamStoreName = WorkplaceFunctionTreeInfoManager.buildStreamStoreName(treeName);
            String xml = StreamStore.getInstance().readUTF8(streamStoreName, true);
            return WorkplaceFunctionTreeInfoManager.unmarshalFunctionTreeInfo(xml);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Error when reading tree with name: " + treeName + ", " + t.toString());
            throw new Error("Error when reading tree: " + treeName, t);
        }
    }

    public static WorkplaceFunctionTreeInfoNode loadFunctionTreeInfo(String treeName, boolean resolveEmbeddedTrees) {
        try {
            WorkplaceFunctionTreeInfoNode result = WorkplaceFunctionTreeInfoManager.loadFunctionTreeInfo(treeName);
            if (resolveEmbeddedTrees) {
                WorkplaceFunctionTreeInfoManager.resolveEmbeddedTrees(result);
            }
            return result;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Error when reading tree with name: " + treeName + ", " + t.toString());
            throw new Error("Error when reading tree: " + treeName, t);
        }
    }

    public static WorkplaceFunctionTreeInfoNode unmarshalFunctionTreeInfo(String xml) {
        try {
            WorkplaceFunctionTreeInfoNode result = (WorkplaceFunctionTreeInfoNode)JAXBManager.unmarshal(xml, WorkplaceFunctionTreeInfoNode.class);
            return result;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error when reading tree: " + xml, t);
            throw new Error(t);
        }
    }

    public static void storeFunctionTreeInfo(String treeName, WorkplaceFunctionTreeInfoNode wfti) {
        try {
            if (treeName == null) {
                throw new Error("treeName passed as null");
            }
            if (treeName.startsWith("/")) {
                throw new Error("treeName starts with / and cann be stored - is is part of the project resources");
            }
            String xml = WorkplaceFunctionTreeInfoManager.marshalFunctionTreeInfo(wfti);
            String streamStoreName = WorkplaceFunctionTreeInfoManager.buildStreamStoreName(treeName);
            StreamStore.getInstance().writeUTF8(streamStoreName, xml, true);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error when storing tree with name: " + treeName);
            throw new Error(t);
        }
    }

    public static String marshalFunctionTreeInfo(WorkplaceFunctionTreeInfoNode wfti) {
        try {
            String xml = JAXBManager.marshal(wfti);
            return xml;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error when marshalling tree");
            throw new Error(t);
        }
    }

    private static void resolveEmbeddedTrees(WorkplaceFunctionTreeInfoNode node) {
        for (WorkplaceFunctionTreeInfoNode subNode : node.getSubNodes()) {
            if (subNode.getEmbeddedTreeName() != null) {
                WorkplaceFunctionTreeInfoNode newSubNode = WorkplaceFunctionTreeInfoManager.loadFunctionTreeInfo(subNode.getEmbeddedTreeName(), true);
                int index = node.getSubNodes().indexOf(subNode);
                node.getSubNodes().set(index, newSubNode);
                subNode = newSubNode;
            }
            WorkplaceFunctionTreeInfoManager.resolveEmbeddedTrees(subNode);
        }
    }

    private static WorkplaceFunctionTreeInfoNode loadFunctionTreeInfoFromResources(String treeName) {
        try {
            String xml = new ClassloaderReader(true).readUTF8File(treeName, true);
            return WorkplaceFunctionTreeInfoManager.unmarshalFunctionTreeInfo(xml);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "checked tree to be available at: " + treeName + ", did not find it");
            return null;
        }
    }

    private static String buildStreamStoreName(String treeName) {
        return "ccworkplace/functiontrees/" + treeName + ".xml";
    }
}

