/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.base.component;

import java.io.StringReader;
import java.util.Stack;
import javax.faces.context.FacesContext;
import javax.faces.webapp.UIComponentTag;
import javax.xml.parsers.SAXParser;
import org.eclnt.jsfserver.base.component.UIComponentFactory;
import org.eclnt.jsfserver.elements.BaseComponentTag;
import org.eclnt.jsfserver.util.parse.SAXParserCreator;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class UIComponentTagBuilderXML {
    public static UIComponentTag buildFromXML(FacesContext context, String xml) {
        try {
            SAXParser parser = SAXParserCreator.createSAXParser();
            MyParser mp = new MyParser(context);
            InputSource is = new InputSource(new StringReader(xml));
            parser.parse(is, (DefaultHandler)mp);
            return mp.i_root;
        }
        catch (Throwable t) {
            throw new Error("Could not parse XML", t);
        }
    }

    static class MyParser
    extends DefaultHandler {
        FacesContext i_context;
        UIComponentTag i_root = null;
        Stack<UIComponentTag> i_stack = new Stack();

        private MyParser(FacesContext context) {
            this.i_context = context;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            UIComponentTag ctag = UIComponentFactory.createComponentTag(name);
            for (int i = 0; i < attributes.getLength(); ++i) {
                ((BaseComponentTag)ctag).setAttributeInAttributeMap(attributes.getQName(i), attributes.getValue(i));
            }
            if (this.i_root == null) {
                this.i_root = ctag;
            } else {
                UIComponentTag currentTop = this.i_stack.peek();
                currentTop.addChild(ctag);
            }
            this.i_stack.push(ctag);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.i_stack.pop();
        }
    }
}

