/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclnt.jsfserver.base.component.UIComponentTagBuilderXML;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.elements.phases.EclntPhaseListener;
import org.eclnt.jsfserver.util.CCServletBase;
import org.eclnt.jsfserver.util.ClientToBeReloadedException;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.PageReader;
import org.eclnt.jsfserver.util.StackedValueKeeper;
import org.eclnt.util.log.CLog;

public class FacesServlet
extends CCServletBase
implements ICCServerConstants {
    public void init() throws ServletException {
        super.init();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FacesContext context = null;
        try {
            HttpSession session = request.getSession();
            String subpageId = request.getParameter("cc_subpageId");
            String requestId = request.getHeader("eclnt-requestid");
            context = FacesContext.getCurrentInstance();
            if (context == null) {
                context = FacesContext.initCurrentInstance(session, subpageId);
                context.startRequestProcessing(session, request, response);
                String pageName = this.findPageNameInURL(request);
                String pageXml = PageReader.readXMLForAbsolutePageName((String)pageName);
                if (pageXml == null) {
                    throw new Exception("Reading page returned null: " + pageName);
                }
                pageXml = pageXml.replace("f:subview", "t:page");
                UIComponentTag sct = UIComponentTagBuilderXML.buildFromXML(context, pageXml);
                UIComponent rootComponent = sct.buildUpComponentTree();
                context.setTopComponent(rootComponent);
                this.processRequestPhases(context, request, response, true);
            } else {
                context.startRequestProcessing(session, request, response);
                this.processRequestPhases(context, request, response, false);
            }
            response.setContentType("application/xml");
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem during request processing", t);
            throw new Error("Problem during request processing", t);
        }
        finally {
            if (context != null) {
                context.endRequestProcessing();
            }
        }
    }

    private void processRequestPhases(FacesContext context, HttpServletRequest request, HttpServletResponse response, boolean firstRequest) {
        EclntPhaseListener phaseListener = new EclntPhaseListener();
        UIComponent top = context.getTopComponent();
        ThreadData threadData = ThreadData.getInstance();
        if (firstRequest) {
            StackedValueKeeper.getInstance().clearStack();
            phaseListener.beforePhase(new PhaseEvent(context, PhaseId.RENDER_RESPONSE));
            top.processEncodeOfComponentTree(response, context);
            phaseListener.afterPhase(new PhaseEvent(context, PhaseId.RENDER_RESPONSE));
        } else {
            long nanoRequestStart = System.nanoTime();
            Set<String> componentsIdsToBeDecoded = this.findComponentIdsAffectedByRequest(request);
            threadData.setComponentIdsToBeDecoded(componentsIdsToBeDecoded);
            top.processDecodes(context);
            long nanoDecodeEnd = System.nanoTime();
            phaseListener.beforePhase(new PhaseEvent(context, PhaseId.UPDATE_MODEL_VALUES));
            top.processUpdates(context);
            this.processQueuedEvents(PhaseId.UPDATE_MODEL_VALUES);
            phaseListener.afterPhase(new PhaseEvent(context, PhaseId.UPDATE_MODEL_VALUES));
            long nanoUpdateEnd = System.nanoTime();
            phaseListener.beforePhase(new PhaseEvent(context, PhaseId.INVOKE_APPLICATION));
            this.processQueuedEvents(PhaseId.INVOKE_APPLICATION);
            phaseListener.afterPhase(new PhaseEvent(context, PhaseId.INVOKE_APPLICATION));
            long nanoInvokeEnd = System.nanoTime();
            this.ensureSessionIsValid(request.getSession(false));
            StackedValueKeeper.getInstance().clearStack();
            phaseListener.beforePhase(new PhaseEvent(context, PhaseId.RENDER_RESPONSE));
            top.processEncodeOfComponentTree(response, context);
            phaseListener.afterPhase(new PhaseEvent(context, PhaseId.RENDER_RESPONSE));
            long nanoRenderEnd = System.nanoTime();
            if (threadData.getProfileMode()) {
                threadData.addConsumedNanosComment("// REQUEST: decode (ms) " + (nanoDecodeEnd - nanoRequestStart), 0L);
                threadData.addConsumedNanosComment("// REQUEST: update (ms) " + (nanoUpdateEnd - nanoDecodeEnd), 0L);
                threadData.addConsumedNanosComment("// REQUEST: invoke (ms) " + (nanoInvokeEnd - nanoUpdateEnd), 0L);
                threadData.addConsumedNanosComment("// REQUEST: encode (ms) " + (nanoRenderEnd - nanoInvokeEnd), 0L);
            }
        }
    }

    private void ensureSessionIsValid(HttpSession session) {
        if (session == null || HttpSessionAccess.checkIfCurrentHttpSessionWasDestroyedDuringInvokePhase((HttpSession)session)) {
            try {
                HttpSessionAccess.getCurrentResponse().setHeader("eclnt-reload", "true");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new ClientToBeReloadedException();
        }
    }

    private void processQueuedEvents(PhaseId phaseId) {
        FacesContext fc = FacesContext.getCurrentInstance();
        List<FacesEvent> events = fc.getQueuedEventsForPhase(phaseId);
        for (FacesEvent event : events) {
            UIComponent c = event.getComponent();
            try {
                c.broadcast(event);
            }
            catch (Throwable t) {
                throw new Error("Problem during broadcast of event in phase: " + phaseId, t);
            }
        }
    }

    private String findPageNameInURL(HttpServletRequest req) {
        String uri = req.getRequestURI();
        int jsessionIdIndex = uri.indexOf(";jsessionid=");
        if (jsessionIdIndex >= 0) {
            uri = uri.substring(0, jsessionIdIndex);
        }
        int riscPageIndex = uri.indexOf("/faces/");
        String result = uri.substring(riscPageIndex + "/faces".length());
        return result;
    }

    public Set<String> findComponentIdsAffectedByRequest(HttpServletRequest request) {
        HashSet<String> result = new HashSet<String>();
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String param = (String)params.nextElement();
            int dotIndex = param.lastIndexOf(46);
            if (dotIndex > 0) {
                param = param.substring(0, dotIndex);
            }
            result.add(param);
        }
        return result;
    }
}

